/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class URLEditor
extends PropertyEditorSupport
implements XMLPropertyEditor {
    public static final String XML_URL = "Url";
    public static final String ATTR_VALUE = "value";

    public void setAsText(String string) {
        try {
            URL uRL = new URL(string);
            this.setValue(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public String getAsText() {
        URL uRL = (URL)this.getValue();
        return uRL.toString();
    }

    public String getJavaInitializationString() {
        URL uRL = (URL)this.getValue();
        return "\"" + uRL.toString() + "\"";
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_URL.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_VALUE).getNodeValue();
            this.setAsText(string);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_URL);
        element.setAttribute(ATTR_VALUE, this.getAsText());
        return element;
    }
}

