/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FontEditor
implements PropertyEditor,
XMLPropertyEditor {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$FontEditor == null ? (class$org$netbeans$beaninfo$editors$FontEditor = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor")) : class$org$netbeans$beaninfo$editors$FontEditor));
    static final String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    static final Integer[] sizes = new Integer[]{new Integer(3), new Integer(5), new Integer(8), new Integer(10), new Integer(12), new Integer(14), new Integer(18), new Integer(24), new Integer(36), new Integer(48)};
    static final String[] styles = new String[]{bundle.getString("CTL_Plain"), bundle.getString("CTL_Bold"), bundle.getString("CTL_Italic"), bundle.getString("CTL_BoldItalic")};
    private Font font;
    private String fontName;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String XML_FONT = "Font";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_SIZE = "size";
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FontEditor;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FontEditor$FontPanel;

    public Object getValue() {
        return this.font;
    }

    public void setValue(Object object) {
        this.font = !(object instanceof Font) ? new Font(fonts[0], 0, 10) : (Font)object;
        this.fontName = this.font.getName() + " " + this.font.getSize() + " " + this.getStyleName(this.font.getStyle());
        this.support.firePropertyChange("", null, null);
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) {
    }

    public String getJavaInitializationString() {
        return "new java.awt.Font(\"" + this.font.getName() + "\", " + this.font.getStyle() + ", " + this.font.getSize() + ")";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Font font = graphics.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        graphics.setFont(this.font);
        graphics.drawString(this.fontName, rectangle.x + (rectangle.width - fontMetrics.stringWidth(this.fontName)) / 2, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        graphics.setFont(font);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new FontPanel();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    String getStyleName(int n) {
        if ((n & 1) > 0) {
            if ((n & 2) > 0) {
                return bundle.getString("CTL_BoldItalic");
            }
            return bundle.getString("CTL_Bold");
        }
        if ((n & 2) > 0) {
            return bundle.getString("CTL_Italic");
        }
        return bundle.getString("CTL_Plain");
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_FONT.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_NAME).getNodeValue();
            String string2 = namedNodeMap.getNamedItem(ATTR_STYLE).getNodeValue();
            String string3 = namedNodeMap.getNamedItem(ATTR_SIZE).getNodeValue();
            this.setValue(new Font(string, Integer.parseInt(string2), Integer.parseInt(string3)));
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        if (this.font == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            errorManager.annotate((Throwable)illegalArgumentException, 4096, null, bundle.getString("MSG_FontIsNotInitialized"), null, null);
            errorManager.notify((Throwable)illegalArgumentException);
            return null;
        }
        Element element = document.createElement(XML_FONT);
        element.setAttribute(ATTR_NAME, this.font.getName());
        element.setAttribute(ATTR_STYLE, Integer.toString(this.font.getStyle()));
        element.setAttribute(ATTR_SIZE, Integer.toString(this.font.getSize()));
        return element;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FontPanel
    extends JPanel {
        JTextField tfFont;
        JTextField tfStyle;
        JTextField tfSize;
        JList lFont;
        JList lStyle;
        JList lSize;
        static final long serialVersionUID = 8377025140456676594L;

        FontPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
            this.lFont = new JList<String>(fonts);
            this.lFont.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Font"));
            this.lStyle = new JList<String>(styles);
            this.lStyle.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_FontStyle"));
            this.lSize = new JList<Integer>(sizes);
            this.lSize.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Size"));
            this.tfSize = new JTextField("" + FontEditor.this.font.getSize());
            this.tfSize.getAccessibleContext().setAccessibleDescription(this.lSize.getAccessibleContext().getAccessibleDescription());
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_FontCustomEditor"));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            JLabel jLabel = new JLabel(bundle.getString("CTL_Font"));
            jLabel.setDisplayedMnemonic(bundle.getString("CTL_Font_mnemonic").charAt(0));
            jLabel.setLabelFor(this.lFont);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jLabel = new JLabel(bundle.getString("CTL_FontStyle"));
            jLabel.setDisplayedMnemonic(bundle.getString("CTL_FontStyle_mnemonic").charAt(0));
            jLabel.setLabelFor(this.lStyle);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints.gridwidth = 0;
            jLabel = new JLabel(bundle.getString("CTL_Size"));
            jLabel.setDisplayedMnemonic(bundle.getString("CTL_Size_mnemonic").charAt(0));
            jLabel.setLabelFor(this.tfSize);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            this.add(jLabel);
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            this.tfFont = new JTextField(FontEditor.this.font.getName());
            this.tfFont.setEnabled(false);
            gridBagLayout.setConstraints(this.tfFont, gridBagConstraints);
            this.add(this.tfFont);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            this.tfStyle = new JTextField(FontEditor.this.getStyleName(FontEditor.this.font.getStyle()));
            this.tfStyle.setEnabled(false);
            gridBagLayout.setConstraints(this.tfStyle, gridBagConstraints);
            this.add(this.tfStyle);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.gridwidth = 0;
            this.tfSize.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ FontPanel this$1;
                {
                    this.this$1 = fontPanel;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$1.setValue();
                }
            });
            gridBagLayout.setConstraints(this.tfSize, gridBagConstraints);
            this.add(this.tfSize);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.lFont.setVisibleRowCount(5);
            this.lFont.setSelectedValue(FontEditor.this.font.getName(), true);
            this.lFont.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ FontPanel this$1;
                {
                    this.this$1 = fontPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!this.this$1.lFont.isSelectionEmpty()) {
                        int n = this.this$1.lFont.getSelectedIndex();
                        this.this$1.tfFont.setText(fonts[n]);
                        this.this$1.setValue();
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.lFont);
            jScrollPane.setVerticalScrollBarPolicy(22);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            this.lStyle.setVisibleRowCount(5);
            this.lStyle.setSelectedValue(FontEditor.this.getStyleName(FontEditor.this.font.getStyle()), true);
            this.lStyle.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ FontPanel this$1;
                {
                    this.this$1 = fontPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!this.this$1.lStyle.isSelectionEmpty()) {
                        int n = this.this$1.lStyle.getSelectedIndex();
                        this.this$1.tfStyle.setText(styles[n]);
                        this.this$1.setValue();
                    }
                }
            });
            jScrollPane = new JScrollPane(this.lStyle);
            jScrollPane.setVerticalScrollBarPolicy(22);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            gridBagConstraints.gridwidth = 0;
            this.lSize.getAccessibleContext().setAccessibleName(this.tfSize.getAccessibleContext().getAccessibleName());
            this.lSize.setVisibleRowCount(5);
            this.updateSizeList(FontEditor.this.font.getSize());
            this.lSize.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ FontPanel this$1;
                {
                    this.this$1 = fontPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!this.this$1.lSize.isSelectionEmpty()) {
                        int n = this.this$1.lSize.getSelectedIndex();
                        this.this$1.tfSize.setText("" + sizes[n]);
                        this.this$1.setValue();
                    }
                }
            });
            jScrollPane = new JScrollPane(this.lSize);
            jScrollPane.setVerticalScrollBarPolicy(22);
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 2.0;
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new TitledBorder(" " + bundle.getString("CTL_Preview") + " "));
            JPanel jPanel2 = new JPanel(this){
                private final /* synthetic */ FontPanel this$1;
                {
                    this.this$1 = fontPanel;
                }

                public Dimension getPreferredSize() {
                    return new Dimension(150, 60);
                }

                public void paint(Graphics graphics) {
                    FontPanel.access$100(this.this$1).paintValue(graphics, new Rectangle(0, 0, this.getSize().width - 1, this.getSize().height - 1));
                }
            };
            jPanel.add("Center", jPanel2);
            gridBagConstraints.insets = new Insets(12, 0, 0, 0);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$beaninfo$editors$FontEditor$FontPanel == null ? (class$org$netbeans$beaninfo$editors$FontEditor$FontPanel = FontEditor.class$("org.netbeans.beaninfo.editors.FontEditor$FontPanel")) : class$org$netbeans$beaninfo$editors$FontEditor$FontPanel).getName());
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 250);
        }

        private void updateSizeList(int n) {
            if (Arrays.asList(sizes).contains(new Integer(n))) {
                this.lSize.setSelectedValue(new Integer(n), true);
            } else {
                this.lSize.clearSelection();
            }
        }

        void setValue() {
            int n = 12;
            try {
                n = Integer.parseInt(this.tfSize.getText());
                this.updateSizeList(n);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            int n2 = this.lStyle.getSelectedIndex();
            int n3 = 0;
            switch (n2) {
                case 0: {
                    n3 = 0;
                    break;
                }
                case 1: {
                    n3 = 1;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 3: {
                    n3 = 3;
                }
            }
            FontEditor.this.setValue(new Font(this.tfFont.getText(), n3, n));
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }

        static /* synthetic */ FontEditor access$100(FontPanel fontPanel) {
            return fontPanel.FontEditor.this;
        }
    }
}

