/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.netbeans.beaninfo.editors.FileEditor;
import org.netbeans.beaninfo.editors.StringCustomEditor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FileArrayEditor
extends PropertyEditorSupport
implements ExPropertyEditor,
PropertyChangeListener {
    private PropertyEnv env;
    private int mode = 2;
    private boolean directories = true;
    private boolean files = true;
    private javax.swing.filechooser.FileFilter fileFilter;
    private File currentDirectory;
    private File baseDirectory;
    private JFileChooser chooser;
    private boolean editable = true;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FileEditor;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$FileArrayEditor;

    public void attachEnv(PropertyEnv propertyEnv) {
        Object object;
        Object object2;
        Object object3;
        this.env = propertyEnv;
        this.directories = true;
        this.files = true;
        this.fileFilter = null;
        Object object4 = propertyEnv.getFeatureDescriptor().getValue("directories");
        if (object4 instanceof Boolean) {
            this.directories = (Boolean)object4;
        }
        if ((object3 = propertyEnv.getFeatureDescriptor().getValue("files")) instanceof Boolean) {
            this.files = (Boolean)object3;
        }
        if ((object2 = propertyEnv.getFeatureDescriptor().getValue("filter")) instanceof FilenameFilter) {
            this.fileFilter = new FileEditor.DelegatingFilenameFilter((FilenameFilter)object2);
        } else if (object2 instanceof javax.swing.filechooser.FileFilter) {
            this.fileFilter = (javax.swing.filechooser.FileFilter)object2;
        } else if (object2 instanceof FileFilter) {
            this.fileFilter = new FileEditor.DelegatingFileFilter((FileFilter)object2);
        }
        Object object5 = propertyEnv.getFeatureDescriptor().getValue("currentDir");
        if (object5 instanceof File) {
            this.currentDirectory = (File)object5;
            if (!this.currentDirectory.isDirectory()) {
                TopManager.getDefault().getErrorManager().log(16, "java.io.File will not accept currentDir=" + this.baseDirectory);
                this.currentDirectory = null;
            }
        }
        if ((object = propertyEnv.getFeatureDescriptor().getValue("baseDir")) instanceof File) {
            this.baseDirectory = (File)object;
            if (!this.baseDirectory.isDirectory() || !this.baseDirectory.isAbsolute()) {
                TopManager.getDefault().getErrorManager().log(16, "java.io.File will not accept baseDir=" + this.baseDirectory);
                this.baseDirectory = null;
            }
        }
        if (this.files) {
            this.mode = this.directories ? 2 : 0;
        } else {
            int n = this.mode = this.directories ? 1 : 2;
        }
        if (propertyEnv.getFeatureDescriptor() instanceof Node.Property) {
            Node.Property property = (Node.Property)propertyEnv.getFeatureDescriptor();
            this.editable = property.canWrite();
        }
    }

    public String getAsText() {
        File[] fileArray = (File[])this.getValue();
        if (fileArray == null) {
            return "";
        }
        String string = "[";
        int n = 0;
        while (n < fileArray.length) {
            string = string + fileArray[n].getPath();
            ++n;
        }
        if (string.equals("[")) {
            string = "[.";
        }
        return string + "]";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("null");
        }
        if (string.equals("")) {
            this.setValue(null);
            return;
        }
    }

    public Component getCustomEditor() {
        if (!this.editable) {
            return new StringCustomEditor(this.getAsText(), false);
        }
        if (this.chooser == null) {
            File[] fileArray;
            this.chooser = FileEditor.createHackedFileChooser();
            this.chooser.setMultiSelectionEnabled(true);
            Object object = this.getValue();
            File file = null;
            if (object instanceof File[] && (fileArray = (File[])object).length > 0 && (file = fileArray[0]) != null && !file.isAbsolute() && this.baseDirectory != null) {
                file = new File(this.baseDirectory, file.getPath());
            }
            if (this.currentDirectory != null) {
                this.chooser.setCurrentDirectory(this.currentDirectory);
            } else if (file != null && file.getParentFile() != null) {
                this.chooser.setCurrentDirectory(file.getParentFile());
                this.chooser.setSelectedFile(file);
            } else if (FileEditor.lastCurrentDir != null) {
                this.chooser.setCurrentDirectory(FileEditor.lastCurrentDir);
            }
            this.chooser.setFileSelectionMode(this.mode);
            if (this.fileFilter != null) {
                this.chooser.setFileFilter(this.fileFilter);
            }
            switch (this.mode) {
                case 2: {
                    this.chooser.setDialogTitle(FileArrayEditor.getString("CTL_DialogTitleFilesAndDirs"));
                    break;
                }
                case 0: {
                    this.chooser.setDialogTitle(FileArrayEditor.getString("CTL_DialogTitleFiles"));
                    break;
                }
                case 1: {
                    this.chooser.setDialogTitle(FileArrayEditor.getString("CTL_DialogTitleDirs"));
                }
            }
            this.chooser.setControlButtonsAreShown(false);
            this.chooser.addPropertyChangeListener(this);
            HelpCtx.setHelpIDString((JComponent)this.chooser, (String)this.getHelpCtx().getHelpID());
        }
        return this.chooser;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public String getJavaInitializationString() {
        File[] fileArray = (File[])this.getValue();
        if (fileArray == null) {
            return "null";
        }
        String string = "new java.io.File[] { ";
        int n = 0;
        while (n < fileArray.length) {
            string = this.baseDirectory != null && !fileArray[n].isAbsolute() ? string + "new java.io.File(" + FileEditor.stringify(this.baseDirectory.getPath()) + ", " + FileEditor.stringify(fileArray[n].getPath()) + "), " : string + "new java.io.File(" + FileEditor.stringify(fileArray[n].getAbsolutePath()) + "), ";
            ++n;
        }
        return string + " }";
    }

    private HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$beaninfo$editors$FileEditor == null ? (class$org$netbeans$beaninfo$editors$FileEditor = FileArrayEditor.class$("org.netbeans.beaninfo.editors.FileEditor")) : class$org$netbeans$beaninfo$editors$FileEditor);
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$FileArrayEditor == null ? (class$org$netbeans$beaninfo$editors$FileArrayEditor = FileArrayEditor.class$("org.netbeans.beaninfo.editors.FileArrayEditor")) : class$org$netbeans$beaninfo$editors$FileArrayEditor)).getString(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!"SelectedFilesChangedProperty".equals(propertyChangeEvent.getPropertyName()) && !"SelectedFileChangedProperty".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (!(propertyChangeEvent.getSource() instanceof JFileChooser)) {
            return;
        }
        JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
        File[] fileArray = jFileChooser.getSelectedFiles();
        if (fileArray == null) {
            return;
        }
        if (fileArray.length == 0 && jFileChooser.getSelectedFile() != null) {
            fileArray = new File[]{jFileChooser.getSelectedFile()};
        }
        int n = 0;
        while (n < fileArray.length) {
            if (!this.files && fileArray[n].isFile()) {
                return;
            }
            if (!this.directories && fileArray[n].isDirectory()) {
                return;
            }
            ++n;
        }
        if (this.baseDirectory != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                String string = FileEditor.getChildRelativePath(this.baseDirectory, fileArray[n2]);
                if (string != null) {
                    fileArray[n2] = new File(string);
                }
                ++n2;
            }
        }
        File[] fileArray2 = new File[fileArray.length];
        int n3 = 0;
        while (n3 < fileArray.length) {
            fileArray2[n3] = new File(fileArray[n3].getAbsolutePath());
            ++n3;
        }
        this.setValue(fileArray2);
        FileEditor.lastCurrentDir = jFileChooser.getCurrentDirectory();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

