/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.beaninfo.editors.DataFolderEditor;
import org.openide.TopManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;
import org.openide.windows.TopComponent;

class DataFolderPanel
extends TopComponent
implements DocumentListener,
DataFilter,
EnhancedCustomPropertyEditor,
PropertyChangeListener,
VetoableChangeListener {
    static Dimension PREF_DIM = new Dimension(450, 250);
    private static MessageFormat defaultPackageName;
    private ChangeListener listener;
    private Reference system = new WeakReference<Object>(null);
    private Node rootNode;
    private DataFolder df;
    private DataFolderEditor editor;
    private ExplorerPanel packagesPanel;
    private BeanTreeView beanTreeView;
    private JLabel descriptionLabel;
    private JLabel packageLabel;
    private JTextField packageName;
    private JLabel dirLabel;
    private JTextField directoryName;
    private JButton createButton;
    private static final ResourceBundle bundle;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$DataFolderPanel;

    public DataFolderPanel(DataFolderEditor dataFolderEditor) {
        this();
        this.editor = dataFolderEditor;
    }

    public DataFolderPanel() {
        this.initComponents();
        this.setName(DataFolderPanel.getString("LAB_TargetLocationPanelName"));
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.rootNode = this.createPackagesNode();
        this.packagesPanel.getExplorerManager().setRootContext(this.rootNode);
        this.packagesPanel.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        this.packagesPanel.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
        this.packageName.getDocument().addDocumentListener(this);
        this.packageName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.descriptionLabel.setDisplayedMnemonic(DataFolderPanel.getString("LAB_TargetLocationDescription_mnemonic").charAt(0));
        this.packageLabel.setDisplayedMnemonic(DataFolderPanel.getString("LAB_package_mnemonic").charAt(0));
        this.dirLabel.setDisplayedMnemonic(DataFolderPanel.getString("LAB_directory_mnemonic").charAt(0));
        this.createButton.setMnemonic(DataFolderPanel.getString("CTL_Create_mnemonic").charAt(0));
        this.beanTreeView.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderTree"));
        this.packageName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_package"));
        this.directoryName.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_directory"));
        this.createButton.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_Create"));
        this.getAccessibleContext().setAccessibleDescription(DataFolderPanel.getString("ACSD_DataFolderPanel"));
    }

    public Dimension getPreferredSize() {
        return PREF_DIM;
    }

    public void requestFocus() {
    }

    private Node createPackagesNode() {
        return TopManager.getDefault().getPlaces().nodes().repository((DataFilter)this);
    }

    private void initComponents() {
        this.packagesPanel = new ExplorerPanel();
        this.beanTreeView = new BeanTreeView();
        this.descriptionLabel = new JLabel();
        this.packageLabel = new JLabel();
        this.packageName = new JTextField();
        this.dirLabel = new JLabel();
        this.directoryName = new JTextField();
        this.createButton = new JButton();
        this.setLayout(new BorderLayout());
        this.packagesPanel.setLayout((LayoutManager)new GridBagLayout());
        this.beanTreeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.packagesPanel.add((Component)this.beanTreeView, (Object)gridBagConstraints);
        this.descriptionLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_TargetLocationDescription"));
        this.descriptionLabel.setLabelFor((Component)this.beanTreeView);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        this.packagesPanel.add((Component)this.descriptionLabel, (Object)gridBagConstraints);
        this.packageLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_package"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagConstraints.anchor = 17;
        this.packagesPanel.add((Component)this.packageLabel, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.packagesPanel.add((Component)this.packageName, (Object)gridBagConstraints);
        this.dirLabel.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("LAB_directory"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.anchor = 17;
        this.packagesPanel.add((Component)this.dirLabel, (Object)gridBagConstraints);
        this.directoryName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.packagesPanel.add((Component)this.directoryName, (Object)gridBagConstraints);
        this.createButton.setText(ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle").getString("CTL_Create"));
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataFolderPanel.this.createButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 18;
        this.packagesPanel.add((Component)this.createButton, (Object)gridBagConstraints);
        this.add((Component)this.packagesPanel, "Center");
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        try {
            DataFolder dataFolder = (DataFolder)this.getPropertyValue();
            this.updateDirectory();
            this.updatePropertyEditor();
            this.enableCreateButton();
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException(illegalStateException.getMessage());
        }
    }

    public boolean acceptDataObject(DataObject dataObject) {
        return dataObject instanceof DataFolder;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 1) {
            throw new PropertyVetoException("Only single selection allowed", propertyChangeEvent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            DataFolder dataFolder;
            Node[] nodeArray = this.packagesPanel.getExplorerManager().getSelectedNodes();
            if (!this.isVisible()) {
                return;
            }
            if (nodeArray.length == 1 && (dataFolder = (DataFolder)nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
                this.setTargetFolder(dataFolder);
                this.updatePropertyEditor();
                this.enableCreateButton();
                return;
            }
            this.setTargetFolder((DataFolder)null);
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = DataFolderPanel.this.packageName.getText();
                    if (string != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(string);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
            return;
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string;
                    if (DataFolderPanel.this.packageName.getText().length() == 0 && (string = (FileSystem)DataFolderPanel.this.system.get()) != null) {
                        DataFolder dataFolder = DataFolder.findFolder((FileObject)string.getRoot());
                        DataFolderPanel.this.setTargetFolder(dataFolder);
                        DataFolderPanel.this.packageName.selectAll();
                    }
                    if ((string = DataFolderPanel.this.packageName.getText()) != null) {
                        if (DataFolderPanel.this.isValid()) {
                            DataFolderPanel.this.setTargetFolder(string);
                            DataFolderPanel.this.updatePropertyEditor();
                        }
                        DataFolderPanel.this.updateDirectory();
                    }
                    DataFolderPanel.this.enableCreateButton();
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$netbeans$beaninfo$editors$DataFolderPanel == null ? (class$org$netbeans$beaninfo$editors$DataFolderPanel = DataFolderPanel.class$("org.netbeans.beaninfo.editors.DataFolderPanel")) : class$org$netbeans$beaninfo$editors$DataFolderPanel);
    }

    public boolean isValid() {
        Object object;
        String string = this.packageName.getText();
        if (string.length() == 0 && ((Node[])(object = this.packagesPanel.getExplorerManager().getSelectedNodes())).length == 1 && object[0] == this.rootNode) {
            return false;
        }
        if (string.equals(DataFolderPanel.defaultPackageName((FileSystem)this.system.get()))) {
            return true;
        }
        object = new StringTokenizer(string, ".");
        while (((StringTokenizer)object).hasMoreElements()) {
            String string2 = ((StringTokenizer)object).nextToken();
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    private static String computeSuggestion(Node node, String string, Node[] nodeArray) {
        Node[] nodeArray2 = node.getChildren().getNodes();
        String string2 = null;
        int n = 0;
        while (n < nodeArray2.length) {
            String string3 = nodeArray2[n].getName();
            if (string3.startsWith(string)) {
                if (string2 == null) {
                    string2 = string3;
                    if (nodeArray != null) {
                        nodeArray[0] = nodeArray2[n];
                    }
                } else {
                    int n2 = string.length();
                    int n3 = Math.min(string3.length(), string2.length());
                    while (n2 < n3 && string2.charAt(n2) == string3.charAt(n2)) {
                        ++n2;
                    }
                    string2 = string2.substring(0, n2);
                }
            }
            ++n;
        }
        if (string2 == null || string2.length() == string.length()) {
            return null;
        }
        return string2.substring(string.length());
    }

    boolean setTargetFolder(DataFolder dataFolder) {
        boolean bl;
        Node node;
        String string;
        FileObject fileObject;
        boolean bl2 = false;
        this.df = dataFolder;
        if (dataFolder != null) {
            fileObject = dataFolder.getPrimaryFile();
            string = fileObject.getPackageName('.');
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                if (fileObject.isRoot()) {
                    string = "";
                    bl2 = true;
                }
                this.system = new WeakReference<FileSystem>(fileSystem);
                SequenceEnumeration sequenceEnumeration = new SequenceEnumeration((Enumeration)new SingletonEnumeration((Object)fileSystem.getSystemName()), (Enumeration)stringTokenizer);
                node = NodeOp.findPath((Node)this.rootNode, (Enumeration)sequenceEnumeration);
                bl = true;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                node = this.rootNode;
                string = "";
                bl = false;
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                node = nodeNotFoundException.getClosestNode();
                DataFolder dataFolder2 = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                string = dataFolder2 != null ? dataFolder2.getPrimaryFile().getPackageName('.') : "";
                bl = false;
            }
        } else {
            node = this.rootNode;
            string = null;
            bl = true;
        }
        fileObject = this.packagesPanel.getExplorerManager();
        fileObject.removePropertyChangeListener((PropertyChangeListener)this);
        this.packageName.getDocument().removeDocumentListener(this);
        try {
            fileObject.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new InternalError();
        }
        this.packageName.setText(string);
        this.updateDirectory();
        this.packageName.getDocument().addDocumentListener(this);
        fileObject.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return bl;
    }

    private DataFolder getTargetFolder(boolean bl) throws IOException {
        FileSystem fileSystem;
        if (bl && this.isValid() && (fileSystem = (FileSystem)this.system.get()) != null) {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileSystem.getRoot());
            String string = this.packageName.getText();
            if (string.length() > 0) {
                String string2 = string.replace('.', '/');
                dataFolder = DataFolder.create((DataFolder)dataFolder, (String)string2);
            }
            this.df = dataFolder;
            return dataFolder;
        }
        return this.df;
    }

    private boolean setTargetFolder(String string) {
        Object object;
        FileSystem fileSystem;
        Node node;
        Node node2 = null;
        NodeNotFoundException nodeNotFoundException = null;
        HashSet<Node> hashSet = new HashSet<Node>(Arrays.asList(this.packagesPanel.getExplorerManager().getSelectedNodes()));
        Node[] nodeArray = this.rootNode.getChildren().getNodes();
        int n = 0;
        while (n < nodeArray.length) {
            node = nodeArray[n];
            fileSystem = new StringTokenizer(string, ".");
            try {
                node2 = NodeOp.findPath((Node)node, (Enumeration)fileSystem);
                break;
            }
            catch (NodeNotFoundException nodeNotFoundException2) {
                if (!fileSystem.hasMoreElements()) {
                    object = DataFolderPanel.computeSuggestion(nodeNotFoundException2.getClosestNode(), nodeNotFoundException2.getMissingChildName(), null);
                    if (nodeNotFoundException == null || hashSet.contains(node) && object != null) {
                        nodeNotFoundException = nodeNotFoundException2;
                    }
                }
                ++n;
            }
        }
        if (node2 != null) {
            nodeNotFoundException = null;
        } else {
            if (nodeNotFoundException == null) {
                return false;
            }
            node2 = nodeNotFoundException.getClosestNode();
        }
        node = this.packagesPanel.getExplorerManager();
        node.removePropertyChangeListener((PropertyChangeListener)this);
        if (nodeNotFoundException != null) {
            fileSystem = new Node[1];
            String string2 = DataFolderPanel.computeSuggestion(nodeNotFoundException.getClosestNode(), nodeNotFoundException.getMissingChildName(), (Node[])fileSystem);
            if (string2 != null) {
                this.packageName.getDocument().removeDocumentListener(this);
                this.packageName.setText(string + string2);
                this.updateDirectory();
                object = this.packageName.getCaret();
                object.setDot(string.length() + string2.length());
                object.moveDot(string.length());
                this.packageName.getDocument().addDocumentListener(this);
            }
            if (fileSystem[0] != null) {
                node2 = fileSystem[0];
            }
        }
        try {
            node.setSelectedNodes(new Node[]{node2});
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new InternalError();
        }
        this.df = (DataFolder)node2.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = DataFolderPanel.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (this.df != null) {
            try {
                fileSystem = this.df.getPrimaryFile().getFileSystem();
                this.system = new WeakReference<FileSystem>(fileSystem);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        node.addPropertyChangeListener((PropertyChangeListener)this);
        this.fireStateChanged();
        return nodeNotFoundException == null;
    }

    private static String defaultPackageName(FileSystem fileSystem) {
        if (defaultPackageName == null) {
            defaultPackageName = new MessageFormat(DataFolderPanel.getString("FMT_TemplateDefaultPackageName"));
        }
        String string = fileSystem == null ? "" : fileSystem.getDisplayName();
        return defaultPackageName.format(new Object[]{string});
    }

    private void updateDirectory() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        FileSystem fileSystem = (FileSystem)this.system.get();
        if (fileSystem != null) {
            stringBuffer.append(fileSystem.getDisplayName());
        }
        if ((string = this.packageName.getText()).equals(DataFolderPanel.defaultPackageName(fileSystem))) {
            string = "";
        }
        if (string.length() > 0) {
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string.replace('.', File.separatorChar));
        }
        this.directoryName.setText(stringBuffer.toString());
    }

    private void updatePropertyEditor() {
        if (this.editor != null) {
            try {
                DataFolder dataFolder = this.getTargetFolder(false);
                String string = dataFolder.getPrimaryFile().getPackageName('.');
                if (string.equals(this.packageName.getText())) {
                    this.editor.setDataFolder(this.df);
                } else {
                    this.editor.setDataFolder(null);
                }
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
            }
        }
    }

    private void enableCreateButton() {
        String string = null;
        string = this.df != null ? this.df.getPrimaryFile().getPackageName('.') : "";
        if (string.equals(this.packageName.getText())) {
            this.createButton.setEnabled(false);
        } else {
            this.createButton.setEnabled(this.isValid());
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        if (this.isValid()) {
            DataFolder dataFolder = this.df;
            try {
                this.df = this.getTargetFolder(true);
                return this.df;
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException();
    }

    private static String getString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$DataFolderPanel == null ? (class$org$netbeans$beaninfo$editors$DataFolderPanel = DataFolderPanel.class$("org.netbeans.beaninfo.editors.DataFolderPanel")) : class$org$netbeans$beaninfo$editors$DataFolderPanel)).getString(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        bundle = ResourceBundle.getBundle("org/netbeans/beaninfo/editors/Bundle");
    }

    public static class ShadowLeafNode
    extends AbstractNode {
        public ShadowLeafNode() {
            super(Children.LEAF);
        }
    }

    public static class ShadowDirNode
    extends AbstractNode {
        public ShadowDirNode(Children children) {
            super(children);
        }
    }
}

