/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.netbeans.beaninfo.editors.TableModelEditor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomTableModelEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$beaninfo$editors$CustomTableModelEditor == null ? (class$org$netbeans$beaninfo$editors$CustomTableModelEditor = CustomTableModelEditor.class$("org.netbeans.beaninfo.editors.CustomTableModelEditor")) : class$org$netbeans$beaninfo$editors$CustomTableModelEditor));
    private boolean isCreated = false;
    private boolean isChangingTableModel = false;
    private ChangeListener changeListener = new TabChangeListener();
    private ListSelectionListener selectionListener = new SelectionListener();
    private JTabbedPane tabbedPane;
    private JTable settingsTable;
    private JTable defaultValuesTable;
    private JTextField rowsField;
    private JTextField columnsField;
    private TableModelEditor.NbTableModel model;
    private TableModelEditor.NbTableModel titleModel;
    private int stSelectedRow;
    private int stSelectedColumn;
    private int defSelectedRow;
    private int defSelectedColumn;
    private JButton insertSColBtn;
    private JButton deleteSColBtn;
    private JButton moveSColUpBtn;
    private JButton moveSColDownBtn;
    private JButton insertColBtn;
    private JButton deleteColBtn;
    private JButton moveColLeftBtn;
    private JButton moveColRightBtn;
    private JButton insertRowBtn;
    private JButton deleteRowBtn;
    private JButton moveRowUpBtn;
    private JButton moveRowDownBtn;
    private JButton addRowBtn;
    private JButton removeRowBtn;
    private JButton addColBtn;
    private JButton removeColBtn;
    static final int SETTINGS_TAB = 0;
    static final int DEFAULT_TAB = 1;
    static final long serialVersionUID = 8002510111948803668L;
    static /* synthetic */ Class class$org$netbeans$beaninfo$editors$CustomTableModelEditor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public CustomTableModelEditor(TableModelEditor tableModelEditor) {
        this.model = new TableModelEditor.NbTableModel((TableModel)tableModelEditor.getValue());
        this.setLayout(new BorderLayout(0, 2));
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.tabbedPane = new JTabbedPane();
        JLabel jLabel = new JLabel(bundle.getString("CTL_TableModelTitle"));
        jLabel.setDisplayedMnemonic(bundle.getString("CTL_TableModelTitle_Mnemonic").charAt(0));
        jLabel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_TableModelTitle"));
        jLabel.setLabelFor(this.tabbedPane);
        this.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(6, 6));
        jPanel.setBorder(new EmptyBorder(6, 2, 0, 2));
        this.settingsTable = new CustomJTable();
        JLabel jLabel2 = new JLabel(bundle.getString("CTL_Title1"));
        jLabel2.setDisplayedMnemonic(bundle.getString("CTL_Title1_Mnemonic").charAt(0));
        jLabel2.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Title1"));
        jLabel2.setLabelFor(this.settingsTable);
        jPanel.add((Component)jLabel2, "North");
        this.titleModel = new TableModelEditor.NbTableModel(new String[]{bundle.getString("CTL_Column"), bundle.getString("CTL_Title"), bundle.getString("CTL_Type"), bundle.getString("CTL_Editable")}, new Class[]{class$java$lang$String == null ? (class$java$lang$String = CustomTableModelEditor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CustomTableModelEditor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CustomTableModelEditor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CustomTableModelEditor.class$("java.lang.Boolean")) : class$java$lang$Boolean}, new boolean[]{false, true, true, true}, this.model.getColumnCount());
        this.settingsTable.setModel(this.titleModel);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem("Object");
        jComboBox.addItem("String");
        jComboBox.addItem("Boolean");
        jComboBox.addItem("Integer");
        jComboBox.addItem("Byte");
        jComboBox.addItem("Short");
        jComboBox.addItem("Long");
        jComboBox.addItem("Float");
        jComboBox.addItem("Double");
        jComboBox.addItem("Character");
        jComboBox.setSelectedIndex(0);
        TableColumn tableColumn = this.settingsTable.getColumn(bundle.getString("CTL_Type"));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        JScrollPane jScrollPane = new JScrollPane(this.settingsTable);
        this.settingsTable.setSelectionMode(0);
        this.settingsTable.setCellSelectionEnabled(true);
        this.settingsTable.setRowSelectionAllowed(true);
        this.settingsTable.setColumnSelectionAllowed(true);
        this.settingsTable.setPreferredScrollableViewportSize(new Dimension(450, 200));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(4, 0, 0, 3));
        this.insertSColBtn = new JButton(bundle.getString("CTL_InsertColumn"));
        this.insertSColBtn.setMnemonic(bundle.getString("CTL_InsertColumn_Mnemonic").charAt(0));
        this.insertSColBtn.setToolTipText(bundle.getString("CTL_HINT_InsertColumn"));
        jPanel2.add(this.insertSColBtn);
        this.insertSColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.insertColumn();
            }
        });
        this.deleteSColBtn = new JButton(bundle.getString("CTL_DeleteColumn"));
        this.deleteSColBtn.setMnemonic(bundle.getString("CTL_DeleteColumn_Mnemonic").charAt(0));
        this.deleteSColBtn.setToolTipText(bundle.getString("CTL_HINT_DeleteColumn"));
        jPanel2.add(this.deleteSColBtn);
        this.deleteSColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeColumn();
            }
        });
        this.moveSColUpBtn = new JButton(bundle.getString("CTL_MoveRowUp"));
        this.moveSColUpBtn.setMnemonic(bundle.getString("CTL_MoveRowUp_Mnemonic").charAt(0));
        this.moveSColUpBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnUp"));
        jPanel2.add(this.moveSColUpBtn);
        this.moveSColUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnLeft();
            }
        });
        this.moveSColDownBtn = new JButton(bundle.getString("CTL_MoveRowDown"));
        this.moveSColDownBtn.setMnemonic(bundle.getString("CTL_MoveRowDown_Mnemonic").charAt(0));
        this.moveSColDownBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnDown"));
        jPanel2.add(this.moveSColDownBtn);
        this.moveSColDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnRight();
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "East");
        this.tabbedPane.addTab(bundle.getString("CTL_Title2"), jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(6, 6));
        jPanel.setBorder(new EmptyBorder(6, 2, 0, 2));
        this.defaultValuesTable = new CustomJTable();
        JLabel jLabel3 = new JLabel(bundle.getString("CTL_DefaultTableValues"));
        jLabel3.setDisplayedMnemonic(bundle.getString("CTL_DefaultTableValues_Mnemonic").charAt(0));
        jLabel3.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_DefaultTableValues"));
        jLabel3.setLabelFor(this.defaultValuesTable);
        jPanel.add((Component)jLabel3, "North");
        this.defaultValuesTable.setModel(this.model);
        this.model.alwaysEditable = true;
        jScrollPane = new JScrollPane(this.defaultValuesTable);
        this.defaultValuesTable.setSelectionMode(0);
        this.defaultValuesTable.setCellSelectionEnabled(true);
        this.defaultValuesTable.setRowSelectionAllowed(true);
        this.defaultValuesTable.setColumnSelectionAllowed(true);
        this.defaultValuesTable.setPreferredScrollableViewportSize(new Dimension(450, 80));
        this.defaultValuesTable.setAutoResizeMode(0);
        jPanel.add((Component)jScrollPane, "Center");
        this.tabbedPane.addTab(bundle.getString("CTL_DefaultValues"), jPanel);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridLayout(4, 0, 0, 3));
        JLabel jLabel4 = new JLabel(bundle.getString("CTL_Columns"));
        jLabel4.setLabelFor(jPanel4);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jPanel4, gridBagConstraints);
        this.insertColBtn = new JButton(bundle.getString("CTL_InsertColumn"));
        this.insertColBtn.setMnemonic(bundle.getString("CTL_InsertColumn_Mnemonic").charAt(0));
        this.insertColBtn.setToolTipText(bundle.getString("CTL_HINT_InsertColumn"));
        jPanel4.add(this.insertColBtn);
        this.insertColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.insertColumn();
            }
        });
        this.deleteColBtn = new JButton(bundle.getString("CTL_DeleteColumn"));
        this.deleteColBtn.setMnemonic(bundle.getString("CTL_DeleteColumn_Mnemonic").charAt(0));
        this.deleteColBtn.setToolTipText(bundle.getString("CTL_HINT_DeleteColumn"));
        jPanel4.add(this.deleteColBtn);
        this.deleteColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeColumn();
            }
        });
        this.moveColLeftBtn = new JButton(bundle.getString("CTL_MoveColumnLeft"));
        this.moveColLeftBtn.setMnemonic(bundle.getString("CTL_MoveColumnLeft_Mnemonic").charAt(0));
        this.moveColLeftBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnLeft"));
        jPanel4.add(this.moveColLeftBtn);
        this.moveColLeftBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnLeft();
            }
        });
        this.moveColRightBtn = new JButton(bundle.getString("CTL_MoveColumnRight"));
        this.moveColRightBtn.setMnemonic(bundle.getString("CTL_MoveColumnRight_Mnemonic").charAt(0));
        this.moveColRightBtn.setToolTipText(bundle.getString("CTL_HINT_MoveColumnRight"));
        jPanel4.add(this.moveColRightBtn);
        this.moveColRightBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveColumnRight();
            }
        });
        JPanel jPanel5 = new JPanel(new GridLayout(4, 0, 0, 3));
        JLabel jLabel5 = new JLabel(bundle.getString("CTL_Rows"));
        jLabel5.setLabelFor(jPanel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)jPanel5, gridBagConstraints);
        this.insertRowBtn = new JButton(bundle.getString("CTL_InsertRow"));
        this.insertRowBtn.setMnemonic(bundle.getString("CTL_InsertRow_Mnemonic").charAt(0));
        this.insertRowBtn.setToolTipText(bundle.getString("CTL_HINT_InsertRow"));
        jPanel5.add(this.insertRowBtn);
        this.insertRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.insertRow();
            }
        });
        this.deleteRowBtn = new JButton(bundle.getString("CTL_DeleteRow"));
        this.deleteRowBtn.setMnemonic(bundle.getString("CTL_DeleteRow_Mnemonic").charAt(0));
        this.deleteRowBtn.setToolTipText(bundle.getString("CTL_HINT_DeleteRow"));
        jPanel5.add(this.deleteRowBtn);
        this.deleteRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeRow();
            }
        });
        this.moveRowUpBtn = new JButton(bundle.getString("CTL_MoveRowUp"));
        this.moveRowUpBtn.setMnemonic(bundle.getString("CTL_MoveRowUp_Mnemonic").charAt(0));
        this.moveRowUpBtn.setToolTipText(bundle.getString("CTL_HINT_MoveRowUp"));
        jPanel5.add(this.moveRowUpBtn);
        this.moveRowUpBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveRowUp();
            }
        });
        this.moveRowDownBtn = new JButton(bundle.getString("CTL_MoveRowDown"));
        this.moveRowDownBtn.setMnemonic(bundle.getString("CTL_MoveRowDown_Mnemonic").charAt(0));
        this.moveRowDownBtn.setToolTipText(bundle.getString("CTL_HINT_MoveRowDown"));
        jPanel5.add(this.moveRowDownBtn);
        this.moveRowDownBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.moveRowDown();
            }
        });
        jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jPanel.add((Component)jPanel2, "East");
        this.add((Component)this.tabbedPane, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new EmptyBorder(8, 2, 0, 2));
        jPanel6.setLayout(new GridBagLayout());
        this.rowsField = new JTextField(3);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText(bundle.getString("CTL_Rows"));
        jLabel6.setDisplayedMnemonic(bundle.getString("CTL_Rows_Mnemonic").charAt(0));
        jLabel6.setLabelFor(this.rowsField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jPanel6.add((Component)jLabel6, gridBagConstraints);
        this.rowsField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Rows"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.rowsField, gridBagConstraints);
        this.addRowBtn = new JButton(" " + bundle.getString("CTL_CountPlus") + " ");
        this.addRowBtn.setMnemonic(bundle.getString("CTL_CountPlusRow_Mnemonic").charAt(0));
        this.addRowBtn.setToolTipText(bundle.getString("CTL_HINT_AddRow"));
        this.addRowBtn.setMargin(new Insets(-1, 1, -2, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.addRowBtn, gridBagConstraints);
        this.addRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.addRow();
            }
        });
        this.removeRowBtn = new JButton(" " + bundle.getString("CTL_CountMinus") + " ");
        this.removeRowBtn.setMnemonic(bundle.getString("CTL_CountMinusRow_Mnemonic").charAt(0));
        this.removeRowBtn.setToolTipText(bundle.getString("CTL_HINT_RemoveRow"));
        this.removeRowBtn.setMargin(new Insets(-2, 1, -1, 1));
        gridBagConstraints = new GridBagConstraints();
        jPanel6.add((Component)this.removeRowBtn, gridBagConstraints);
        this.removeRowBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeLastRow();
            }
        });
        this.columnsField = new JTextField(3);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText(bundle.getString("CTL_Columns"));
        jLabel7.setDisplayedMnemonic(bundle.getString("CTL_Columns_Mnemonic").charAt(0));
        jLabel7.setLabelFor(this.columnsField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel6.add((Component)jLabel7, gridBagConstraints);
        this.columnsField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_CTL_Columns"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.columnsField, gridBagConstraints);
        this.addColBtn = new JButton(" " + bundle.getString("CTL_CountPlus") + " ");
        this.addColBtn.setMnemonic(bundle.getString("CTL_CountPlusColumn_Mnemonic").charAt(0));
        this.addColBtn.setToolTipText(bundle.getString("CTL_HINT_AddColumn"));
        this.addColBtn.setMargin(new Insets(-1, 1, -2, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        jPanel6.add((Component)this.addColBtn, gridBagConstraints);
        this.addColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.addColumn();
            }
        });
        this.removeColBtn = new JButton(" " + bundle.getString("CTL_CountMinus") + " ");
        this.removeColBtn.setMnemonic(bundle.getString("CTL_CountMinusColumn_Mnemonic").charAt(0));
        this.removeColBtn.setToolTipText(bundle.getString("CTL_HINT_RemoveColumn"));
        this.removeColBtn.setMargin(new Insets(-2, 1, -1, 1));
        gridBagConstraints = new GridBagConstraints();
        jPanel6.add((Component)this.removeColBtn, gridBagConstraints);
        this.removeColBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.removeLastColumn();
            }
        });
        jPanel3 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel6.add((Component)jPanel3, gridBagConstraints);
        this.add((Component)jPanel6, "South");
        this.rowsField.setText(String.valueOf(this.model.getRowCount()));
        this.columnsField.setText(String.valueOf(this.model.getColumnCount()));
        this.rowsField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CustomTableModelEditor.this.updateRows(CustomTableModelEditor.this.rowsField.getText());
            }
        });
        this.rowsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.updateRows(CustomTableModelEditor.this.rowsField.getText());
            }
        });
        this.columnsField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                CustomTableModelEditor.this.updateColumns(CustomTableModelEditor.this.columnsField.getText());
            }
        });
        this.columnsField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomTableModelEditor.this.updateColumns(CustomTableModelEditor.this.columnsField.getText());
            }
        });
        this.updateSettingsTable();
        this.enableButtons();
        this.isCreated = true;
        HelpCtx.setHelpIDString((JComponent)this, (String)(class$org$netbeans$beaninfo$editors$CustomTableModelEditor == null ? (class$org$netbeans$beaninfo$editors$CustomTableModelEditor = CustomTableModelEditor.class$("org.netbeans.beaninfo.editors.CustomTableModelEditor")) : class$org$netbeans$beaninfo$editors$CustomTableModelEditor).getName());
        this.titleModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 0) {
                    int n = CustomTableModelEditor.this.defaultValuesTable.getSelectedRow();
                    int n2 = CustomTableModelEditor.this.defaultValuesTable.getSelectedColumn();
                    CustomTableModelEditor.this.updateDefaultTable();
                    CustomTableModelEditor.refreshSelection(CustomTableModelEditor.this.defaultValuesTable, n, n2);
                } else {
                    CustomTableModelEditor.this.enableButtons();
                }
            }
        });
        this.model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() != 0) {
                    CustomTableModelEditor.this.enableButtons();
                }
            }
        });
        this.defaultValuesTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                int n;
                int n2 = tableColumnModelEvent.getFromIndex();
                if (n2 != (n = tableColumnModelEvent.getToIndex())) {
                    CustomTableModelEditor.this.moveColumn(n2, n);
                } else {
                    CustomTableModelEditor.this.defSelectedRow = CustomTableModelEditor.this.defaultValuesTable.getSelectedRow();
                    CustomTableModelEditor.this.defSelectedColumn = CustomTableModelEditor.this.defaultValuesTable.getSelectedColumn();
                }
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.tabbedPane.addChangeListener(this.changeListener);
        this.settingsTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.settingsTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
        this.defaultValuesTable.getSelectionModel().addListSelectionListener(this.selectionListener);
        this.defaultValuesTable.getColumnModel().getSelectionModel().addListSelectionListener(this.selectionListener);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TableCustomEditor"));
    }

    private void enableButtons() {
        int n = this.model.getRowCount();
        boolean bl = n > 0;
        int n2 = this.model.getColumnCount();
        boolean bl2 = n2 > 0;
        int n3 = -1;
        if (bl2) {
            if (this.tabbedPane.getSelectedIndex() == 1) {
                n3 = this.defaultValuesTable.getSelectedColumn();
            } else if (this.tabbedPane.getSelectedIndex() == 0) {
                n3 = this.settingsTable.getSelectedRow();
            }
        }
        boolean bl3 = n3 >= 0 && n3 < n2;
        int n4 = -1;
        if (bl && this.tabbedPane.getSelectedIndex() == 1) {
            n4 = this.defaultValuesTable.getSelectedRow();
            bl3 &= n4 >= 0 && n4 < n;
        }
        boolean bl4 = n4 >= 0 && n4 < n;
        bl4 &= bl3;
        this.insertSColBtn.setEnabled(bl3);
        this.deleteSColBtn.setEnabled(bl3);
        this.moveSColUpBtn.setEnabled(n3 > 0 && n3 < n2);
        this.moveSColDownBtn.setEnabled(bl3 && n3 < n2 - 1);
        this.insertColBtn.setEnabled(bl3);
        this.deleteColBtn.setEnabled(bl3);
        this.moveColLeftBtn.setEnabled(n3 > 0 && n3 < n2 && bl4);
        this.moveColRightBtn.setEnabled(bl3 && n3 < n2 - 1);
        this.insertRowBtn.setEnabled(bl4);
        this.deleteRowBtn.setEnabled(bl4);
        this.moveRowUpBtn.setEnabled(n4 > 0 && n4 < n && bl3);
        this.moveRowDownBtn.setEnabled(bl4 && n4 < n - 1);
        this.addRowBtn.setEnabled(true);
        this.removeRowBtn.setEnabled(bl);
        this.addColBtn.setEnabled(true);
        this.removeColBtn.setEnabled(bl2);
    }

    private void addRow() {
        this.model.setRowCount(this.model.getRowCount() + 1);
        this.rowsField.setText(Integer.toString(this.model.getRowCount()));
        this.defaultValuesTable.clearSelection();
    }

    private void removeLastRow() {
        int n = this.model.getRowCount();
        if (n > 0) {
            this.model.setRowCount(n - 1);
            this.rowsField.setText(Integer.toString(this.model.getRowCount()));
            this.defaultValuesTable.clearSelection();
        }
    }

    private void insertRow() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.examineSelections();
            if (this.defSelectedRow >= 0) {
                this.model.addRow(this.defSelectedRow);
                this.rowsField.setText(Integer.toString(this.model.getRowCount()));
                this.updateSelections(true);
            } else if (this.model.getRowCount() == 0) {
                this.addRow();
            }
        }
    }

    private void removeRow() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow >= 0) {
                this.model.removeRow(this.defSelectedRow);
                this.rowsField.setText(Integer.toString(this.model.getRowCount()));
                if (this.defSelectedRow == this.model.getRowCount() && this.defSelectedRow > 0) {
                    --this.defSelectedRow;
                }
                this.updateSelections(true);
            }
        }
    }

    private void updateRows(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n >= 0) {
            this.model.setRowCount(n);
        }
    }

    private void moveRowUp() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow > 0) {
                this.model.moveRow(this.defSelectedRow, this.defSelectedRow - 1);
                --this.defSelectedRow;
                this.updateSelections(true);
            }
        }
    }

    private void moveRowDown() {
        if (this.tabbedPane.getSelectedIndex() == 1 && this.model.getRowCount() > 0) {
            this.examineSelections();
            if (this.defSelectedRow >= 0 && this.defSelectedRow < this.model.getRowCount() - 1) {
                this.model.moveRow(this.defSelectedRow, this.defSelectedRow + 1);
                ++this.defSelectedRow;
                this.updateSelections(true);
            }
        }
    }

    private void addColumn() {
        int n = this.model.getColumnCount();
        this.model.setColumnCount(n + 1);
        this.defaultValuesTable.clearSelection();
        this.updateSettingsTable();
        this.settingsTable.clearSelection();
        this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
    }

    private void removeLastColumn() {
        int n = this.model.getColumnCount();
        if (n > 0) {
            this.model.setColumnCount(n - 1);
            this.defaultValuesTable.clearSelection();
            this.updateSettingsTable();
            this.settingsTable.clearSelection();
            this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
        }
    }

    private void insertColumn() {
        this.examineSelections();
        int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (n >= 0) {
            this.model.addColumn(n);
            this.updateSettingsTable();
            this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
            this.updateSelections(true);
        } else if (this.model.getColumnCount() == 0) {
            this.addColumn();
        }
    }

    private void removeColumn() {
        if (this.model.getColumnCount() > 0) {
            this.examineSelections();
            int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
            if (n >= 0) {
                this.model.removeColumn(n);
                this.updateSettingsTable();
                this.columnsField.setText(Integer.toString(this.model.getColumnCount()));
                if (n == this.model.getColumnCount() && n > 0) {
                    --n;
                }
                if (this.tabbedPane.getSelectedIndex() == 1) {
                    this.defSelectedColumn = n;
                } else {
                    this.stSelectedRow = n;
                }
                this.updateSelections(true);
            }
        }
    }

    private void updateColumns(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        if (n >= 0) {
            this.model.setColumnCount(n);
            this.updateSettingsTable();
        }
    }

    private void moveColumnLeft() {
        this.examineSelections();
        int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (n > 0) {
            this.model.moveColumn(n, n - 1);
            this.updateSettingsTable();
            if (this.tabbedPane.getSelectedIndex() == 1) {
                this.defSelectedColumn = n - 1;
            } else {
                this.stSelectedRow = n - 1;
            }
            this.updateSelections(true);
        }
    }

    private void moveColumnRight() {
        this.examineSelections();
        int n = this.tabbedPane.getSelectedIndex() == 1 ? this.defSelectedColumn : (this.tabbedPane.getSelectedIndex() == 0 ? this.stSelectedRow : -1);
        if (n >= 0 && n < this.model.getColumnCount() - 1) {
            this.model.moveColumn(n, n + 1);
            this.updateSettingsTable();
            if (this.tabbedPane.getSelectedIndex() == 1) {
                this.defSelectedColumn = n + 1;
            } else {
                this.stSelectedRow = n + 1;
            }
            this.updateSelections(true);
        }
    }

    private void moveColumn(int n, int n2) {
        this.model.moveColumn(n, n2);
        this.updateSettingsTable();
        int n3 = this.defSelectedRow >= 0 ? (this.defSelectedColumn == n ? n2 : (this.defSelectedColumn == n2 ? n : this.defSelectedColumn)) : -1;
        if (n3 >= 0) {
            this.defaultValuesTable.setRowSelectionInterval(this.defSelectedRow, this.defSelectedRow);
            this.defaultValuesTable.setColumnSelectionInterval(n3, n3);
        } else {
            this.defaultValuesTable.clearSelection();
            this.defaultValuesTable.getParent().requestFocus();
        }
    }

    private void examineSelections() {
        this.stSelectedRow = this.settingsTable.getSelectedRow();
        this.stSelectedColumn = this.settingsTable.getSelectedColumn();
        this.defSelectedRow = this.defaultValuesTable.getSelectedRow();
        this.defSelectedColumn = this.defaultValuesTable.getSelectedColumn();
    }

    private void updateSelections(boolean bl) {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            CustomTableModelEditor.refreshSelection(this.settingsTable, this.defSelectedColumn, this.stSelectedColumn);
            if (bl && CustomTableModelEditor.refreshSelection(this.defaultValuesTable, this.defSelectedRow, this.defSelectedColumn)) {
                this.defaultValuesTable.requestFocus();
            }
        } else if (this.tabbedPane.getSelectedIndex() == 0) {
            CustomTableModelEditor.refreshSelection(this.defaultValuesTable, this.defSelectedRow, this.stSelectedRow);
            if (bl && CustomTableModelEditor.refreshSelection(this.settingsTable, this.stSelectedRow, this.stSelectedColumn)) {
                this.settingsTable.requestFocus();
            }
        }
    }

    private static boolean refreshSelection(JTable jTable, int n, int n2) {
        jTable.clearSelection();
        if (n >= 0 && n < jTable.getRowCount() && n2 >= 0 && n2 < jTable.getColumnCount()) {
            jTable.setRowSelectionInterval(n, n);
            jTable.setColumnSelectionInterval(n2, n2);
            return true;
        }
        return false;
    }

    void updateDefaultTable() {
        if (this.model == null || this.isChangingTableModel) {
            return;
        }
        int n = this.model.getColumnCount();
        int n2 = this.model.getRowCount();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            Class<?> clazz;
            this.model.setColumnName(n3, (String)this.titleModel.getValueAt(n3, 1));
            try {
                clazz = Class.forName("java.lang." + (String)this.titleModel.getValueAt(n3, 2));
            }
            catch (Exception exception) {
                Class<Object> clazz2 = clazz = class$java$lang$Object == null ? CustomTableModelEditor.class$("java.lang.Object") : class$java$lang$Object;
            }
            if (!clazz.equals(this.model.getColumnClass(n3))) {
                bl = true;
                this.model.setColumnClass(n3, clazz);
                int n4 = 0;
                while (n4 < n2) {
                    this.model.setValueAt(null, n4, n3);
                    ++n4;
                }
            }
            this.model.setColumnEditable(n3, (Boolean)this.titleModel.getValueAt(n3, 3));
            ++n3;
        }
        if (bl) {
            this.defaultValuesTable.createDefaultColumnsFromModel();
        }
        this.model.fireTableStructureChanged();
    }

    void updateSettingsTable() {
        this.isChangingTableModel = true;
        int n = this.model.getColumnCount();
        if (n != this.titleModel.getRowCount()) {
            this.isCreated = false;
            this.titleModel.setRowCount(n);
            this.isCreated = true;
        }
        int n2 = 0;
        while (n2 < n) {
            this.titleModel.setValueAt(Integer.toString(n2 + 1), n2, 0);
            this.titleModel.setValueAt(this.model.getColumnName(n2), n2, 1);
            String string = this.model.getColumnClass(n2).getName();
            int n3 = string.lastIndexOf(46);
            if (n3 >= 0) {
                string = string.substring(n3 + 1, string.length());
            }
            this.titleModel.setValueAt(string, n2, 2);
            this.titleModel.setValueAt(new Boolean(this.model.isColumnEditable(n2)), n2, 3);
            ++n2;
        }
        this.isChangingTableModel = false;
    }

    public Object getPropertyValue() throws IllegalStateException {
        this.updateDefaultTable();
        return new TableModelEditor.NbTableModel(this.model);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class CustomJTable
    extends JTable {
        Component edComp;

        private CustomJTable() {
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (keyEvent != null && keyEvent.getID() == 401 && (keyEvent.getModifiers() & 0xA) != 0) {
                return false;
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                if (keyEvent.getKeyCode() == 27) {
                    if (!this.isEditing()) {
                        return;
                    }
                } else if (keyEvent.getKeyCode() == 32) {
                    int n = this.getSelectionModel().getAnchorSelectionIndex();
                    int n2 = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
                    if (n != -1 && n2 != -1 && !this.isEditing()) {
                        super.processKeyEvent(keyEvent);
                        keyEvent.consume();
                        if (this.edComp != null) {
                            this.edComp.requestFocus();
                        }
                        return;
                    }
                }
            }
            super.processKeyEvent(keyEvent);
        }

        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            this.edComp = super.prepareEditor(tableCellEditor, n, n2);
            return this.edComp;
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CustomTableModelEditor.this.enableButtons();
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CustomTableModelEditor.this.enableButtons();
        }
    }
}

