/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Set;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public abstract class WindowManager
implements Serializable {
    public static final String PROP_WORKSPACES = "workspaces";
    public static final String PROP_CURRENT_WORKSPACE = "currentWorkspace";
    private TopComponent activeComponent;
    private TopComponent.Registry registry;
    static final long serialVersionUID = -4133918059009277602L;

    public abstract Frame getMainWindow();

    public abstract void updateUI();

    protected abstract Component createTopComponentManager(TopComponent var1);

    protected abstract TopComponent.Registry componentRegistry();

    public TopComponent.Registry getRegistry() {
        if (this.registry != null) {
            return this.registry;
        }
        WindowManager windowManager = this;
        synchronized (windowManager) {
            if (this.registry == null) {
                this.registry = this.componentRegistry();
            }
        }
        return this.registry;
    }

    public final Workspace createWorkspace(String string) {
        return this.createWorkspace(string, string);
    }

    public abstract Workspace createWorkspace(String var1, String var2);

    public abstract Workspace findWorkspace(String var1);

    public abstract Workspace[] getWorkspaces();

    public abstract void setWorkspaces(Workspace[] var1);

    public abstract Workspace getCurrentWorkspace();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    protected static final Component findComponentManager(TopComponent topComponent) {
        return topComponent.getManager();
    }

    protected void activateComponent(TopComponent topComponent) {
        if (this.activeComponent == topComponent) {
            return;
        }
        if (this.activeComponent != null) {
            this.activeComponent.componentDeactivated();
        }
        this.activeComponent = topComponent;
        if (this.activeComponent != null) {
            this.activeComponent.componentActivated();
        }
    }

    protected void componentOpenNotify(TopComponent topComponent) {
        topComponent.openNotify();
    }

    protected void componentCloseNotify(TopComponent topComponent) {
        topComponent.closeNotify();
    }

    protected static interface Component
    extends Serializable {
        public static final long serialVersionUID = 0L;

        public void open();

        public void open(Workspace var1);

        public void close(Workspace var1);

        public void requestFocus();

        public void requestVisible();

        public Node[] getActivatedNodes();

        public void setActivatedNodes(Node[] var1);

        public void nameChanged();

        public void setIcon(Image var1);

        public Image getIcon();

        public Set whereOpened();
    }
}

