/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.WaitableResult;

public class ProxyLookup
extends Lookup {
    private Lookup[] lookups;
    private HashMap results;

    public ProxyLookup(Lookup[] lookupArray) {
        this.lookups = lookupArray;
    }

    protected final Lookup[] getLookups() {
        return this.lookups;
    }

    protected final void setLookups(Lookup[] lookupArray) {
        Reference[] referenceArray;
        Lookup[] lookupArray2;
        HashSet<Lookup> hashSet;
        HashSet<Lookup> hashSet2;
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            hashSet2 = new HashSet<Lookup>(Arrays.asList(this.lookups));
            hashSet = new HashSet<Lookup>(Arrays.asList(lookupArray));
            lookupArray2 = this.lookups;
            this.lookups = lookupArray;
            if (this.results == null || this.results.isEmpty()) {
                return;
            }
            referenceArray = this.results.values().toArray(new Reference[0]);
        }
        HashSet<Lookup> hashSet3 = new HashSet<Lookup>(hashSet2);
        hashSet3.removeAll(hashSet);
        hashSet.removeAll(hashSet2);
        if (hashSet3.isEmpty() && hashSet.isEmpty()) {
            return;
        }
        int n = 0;
        while (n < referenceArray.length) {
            R r = (R)referenceArray[n].get();
            if (r != null) {
                r.lookupChange(hashSet, hashSet3, lookupArray2, lookupArray);
            }
            ++n;
        }
    }

    protected void beforeLookup(Lookup.Template template) {
    }

    public final Object lookup(Class clazz) {
        this.beforeLookup(new Lookup.Template(clazz));
        Lookup[] lookupArray = this.lookups;
        int n = 0;
        while (n < lookupArray.length) {
            Object object = lookupArray[n].lookup(clazz);
            if (object != null) {
                return object;
            }
            ++n;
        }
        return null;
    }

    public final Lookup.Item lookupItem(Lookup.Template template) {
        this.beforeLookup(template);
        Lookup[] lookupArray = this.lookups;
        int n = 0;
        while (n < lookupArray.length) {
            Lookup.Item item = lookupArray[n].lookupItem(template);
            if (item != null) {
                return item;
            }
            ++n;
        }
        return null;
    }

    public final synchronized Lookup.Result lookup(Lookup.Template template) {
        R r;
        if (this.results != null) {
            Reference reference = (Reference)this.results.get(template);
            R r2 = r = reference == null ? null : (R)reference.get();
            if (r != null) {
                return r;
            }
        } else {
            this.results = new HashMap();
        }
        r = new R(template);
        this.results.put(template, new SoftReference<R>(r));
        return r;
    }

    private final synchronized void unregisterTemplate(Lookup.Template template) {
        if (this.results == null) {
            return;
        }
        Reference reference = (Reference)this.results.remove(template);
        if (reference != null && reference.get() != null) {
            this.results.put(template, reference);
        }
    }

    private final class R
    extends WaitableResult
    implements LookupListener {
        private EventListenerList listeners;
        private Lookup.Template template;
        private Lookup.Result[] results;
        private Collection[] cache;
        static /* synthetic */ Class class$org$openide$util$LookupListener;

        public R(Lookup.Template template) {
            this.template = template;
        }

        protected void finalize() {
            ProxyLookup.this.unregisterTemplate(this.template);
        }

        private Lookup.Result[] initResults() {
            if (this.results != null) {
                return this.results;
            }
            Lookup.Result[] resultArray = new Lookup.Result[ProxyLookup.this.lookups.length];
            int n = 0;
            while (n < resultArray.length) {
                resultArray[n] = ProxyLookup.this.lookups[n].lookup(this.template);
                resultArray[n].addLookupListener(this);
                ++n;
            }
            this.cache = new Collection[3];
            this.results = resultArray;
            return resultArray;
        }

        protected void lookupChange(Set set, Set set2, Lookup[] lookupArray, Lookup[] lookupArray2) {
            R r = this;
            synchronized (r) {
                if (this.results == null) {
                    return;
                }
                HashMap<Lookup, Lookup.Result> hashMap = new HashMap<Lookup, Lookup.Result>(lookupArray.length * 2);
                int n = 0;
                while (n < lookupArray.length) {
                    if (set2.contains(lookupArray[n])) {
                        this.results[n].removeLookupListener(this);
                    } else {
                        hashMap.put(lookupArray[n], this.results[n]);
                    }
                    ++n;
                }
                Lookup.Result[] resultArray = new Lookup.Result[lookupArray2.length];
                int n2 = 0;
                while (n2 < lookupArray2.length) {
                    if (set.contains(lookupArray2[n2])) {
                        resultArray[n2] = lookupArray2[n2].lookup(this.template);
                        resultArray[n2].addLookupListener(this);
                    } else {
                        resultArray[n2] = (Lookup.Result)hashMap.get(lookupArray2[n2]);
                        if (resultArray[n2] == null) {
                            throw new IllegalStateException();
                        }
                    }
                    ++n2;
                }
                this.results = resultArray;
            }
            this.resultChanged(null);
        }

        public void addLookupListener(LookupListener lookupListener) {
            if (this.listeners == null) {
                R r = this;
                synchronized (r) {
                    if (this.listeners == null) {
                        this.listeners = new EventListenerList();
                    }
                }
            }
            this.listeners.add(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = R.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, lookupListener);
        }

        public void removeLookupListener(LookupListener lookupListener) {
            if (this.listeners != null) {
                this.listeners.remove(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = R.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, lookupListener);
            }
        }

        public Collection allInstances() {
            return this.computeResult(0);
        }

        public Set allClasses() {
            return (Set)this.computeResult(1);
        }

        public Collection allItems() {
            return this.computeResult(2);
        }

        private Collection computeResult(int n) {
            Lookup.Result[] resultArray = this.myBeforeLookup();
            R r = this;
            synchronized (r) {
                if (this.cache != null && this.cache[n] != null) {
                    Collection collection = this.cache[n];
                    return collection;
                }
            }
            AbstractCollection abstractCollection = n == 1 ? new HashSet() : new ArrayList(resultArray.length * 2);
            int n2 = 0;
            while (n2 < resultArray.length) {
                switch (n) {
                    case 0: {
                        abstractCollection.addAll(resultArray[n2].allInstances());
                        break;
                    }
                    case 1: {
                        abstractCollection.addAll(resultArray[n2].allClasses());
                        break;
                    }
                    case 2: {
                        abstractCollection.addAll(resultArray[n2].allItems());
                    }
                }
                ++n2;
            }
            R r2 = this;
            synchronized (r2) {
                if (resultArray == this.results && this.cache != null) {
                    this.cache[n] = abstractCollection;
                }
            }
            return abstractCollection;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            R r = this;
            synchronized (r) {
                this.cache = null;
                if (this.listeners == null) {
                    return;
                }
            }
            Object[] objectArray = this.listeners.getListenerList();
            if (objectArray.length == 0) {
                return;
            }
            lookupEvent = new LookupEvent(this);
            int n = objectArray.length - 1;
            while (n >= 0) {
                LookupListener lookupListener = (LookupListener)objectArray[n];
                lookupListener.resultChanged(lookupEvent);
                n -= 2;
            }
        }

        private Lookup.Result[] myBeforeLookup() {
            Lookup.Result[] resultArray;
            ProxyLookup.this.beforeLookup(this.template);
            R r = this;
            synchronized (r) {
                resultArray = this.initResults();
            }
            int n = 0;
            while (n < resultArray.length) {
                if (resultArray[n] instanceof WaitableResult) {
                    WaitableResult waitableResult = (WaitableResult)resultArray[n];
                    waitableResult.beforeLookup(this.template);
                }
                ++n;
            }
            return resultArray;
        }

        protected void beforeLookup(Lookup.Template template) {
            if (template.getType() == this.template.getType()) {
                this.myBeforeLookup();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

