/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public abstract class CallbackSystemAction
extends CallableSystemAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet notSurviving = new WeakSet(37);
    private static TopComponent.Registry registry;
    private static ExplorerManager explorerManager;
    private static FocusTracker ft;
    static final long serialVersionUID = -6305817805474624653L;

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
        this.setSurviveFocusChange(false);
    }

    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    public void setActionPerformer(ActionPerformer actionPerformer) {
        ActionPerformer actionPerformer2 = (ActionPerformer)this.putProperty(PROP_ACTION_PERFORMER, actionPerformer);
        this.setEnabled(actionPerformer != null);
    }

    public void performAction() {
        ActionPerformer actionPerformer = this.getActionPerformer();
        if (actionPerformer != null) {
            actionPerformer.performAction(this);
        }
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    public void setSurviveFocusChange(boolean bl) {
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            if (bl) {
                notSurviving.remove(this.getClass());
            } else {
                notSurviving.add(this.getClass());
            }
        }
    }

    static TopComponent.Registry getRegistry() {
        if (registry != null) {
            return registry;
        }
        try {
            Class<?> clazz = Class.forName("org.openide.windows.TopComponent$Registry");
            registry = (TopComponent.Registry)Lookup.getDefault().lookup(clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (registry == null && ft == null) {
            CallbackSystemAction.startTrackingFocus();
        }
        if (registry != null) {
            CallbackSystemAction.stopTrackingFocus();
            registry.addPropertyChangeListener(new FocusTracker());
        }
        return registry;
    }

    static ExplorerManager getExplorerManager() {
        return explorerManager;
    }

    static void setExplorerManager(ExplorerManager explorerManager) {
        CallbackSystemAction.explorerManager = explorerManager;
    }

    private static void startTrackingFocus() {
        ft = new FocusTracker();
        Toolkit.getDefaultToolkit().addAWTEventListener(ft, 4L);
    }

    private static void stopTrackingFocus() {
        if (ft != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(ft);
            ft = null;
        }
    }

    private static void clearActionPerformers() {
        Serializable serializable;
        Iterator iterator;
        ArrayList<SharedClassObject> arrayList;
        WeakSet weakSet = notSurviving;
        synchronized (weakSet) {
            arrayList = new ArrayList<SharedClassObject>(notSurviving.size());
            iterator = notSurviving.iterator();
            while (iterator.hasNext()) {
                serializable = (Class)iterator.next();
                SharedClassObject sharedClassObject = SharedClassObject.findObject((Class)serializable, false);
                if (sharedClassObject == null) continue;
                arrayList.add(sharedClassObject);
            }
        }
        iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            serializable = (CallbackSystemAction)iterator.next();
            ((CallbackSystemAction)serializable).setActionPerformer(null);
        }
    }

    static {
        CallbackSystemAction.getRegistry();
    }

    private static class FocusTracker
    implements AWTEventListener,
    PropertyChangeListener {
        FocusTracker() {
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            Object object;
            if (aWTEvent instanceof FocusEvent && (((AWTEvent)(object = (FocusEvent)aWTEvent)).getID() & 0x3EC) == 0) {
                return;
            }
            object = aWTEvent.getSource();
            if (object instanceof Component) {
                Component component = (Component)object;
                while (component != null && !(component instanceof ExplorerManager.Provider)) {
                    component = component.getParent();
                }
                if (component instanceof ExplorerManager.Provider) {
                    CallbackSystemAction.setExplorerManager(((ExplorerManager.Provider)((Object)component)).getExplorerManager());
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                CallbackSystemAction.clearActionPerformers();
            }
        }
    }
}

