/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListener12;

public abstract class WeakListener
implements EventListener {
    private static ReferenceQueue QUEUE = new ReferenceQueue();
    private static int CLEANER_TIME = 25000;
    private static RequestProcessor.Task CLEANER_TASK = RequestProcessor.postRequest(new Cleaner(), CLEANER_TIME, 1);
    private static ErrorManager errorManager;
    private Reference ref;
    Class listenerClass;
    private Reference source;
    private static Factory factory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$openide$util$WeakListener;

    protected WeakListener(Class clazz, EventListener eventListener) {
        this.listenerClass = clazz;
        this.ref = new ListenerReference(eventListener, this);
    }

    protected final void setSource(Object object) {
        this.source = object == null ? null : new WeakReference<Object>(object);
    }

    protected abstract String removeMethodName();

    protected final EventListener get(EventObject eventObject) {
        if (this.ref == null) {
            return null;
        }
        EventListener eventListener = (EventListener)this.ref.get();
        if (eventListener != null) {
            return eventListener;
        }
        if (eventObject != null) {
            this.removeListener(eventObject.getSource());
            this.ref = null;
        }
        return null;
    }

    private void removeListener() {
        Reference reference = this.source;
        if (reference == null) {
            return;
        }
        Object t = reference.get();
        if (t != null) {
            this.removeListener(t);
        }
    }

    private void removeListener(Object object) {
        try {
            Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
            Method method = WeakListener.getRemoveMethod(this.removeMethodName(), clazz, this.listenerClass);
            method.invoke(object, this.getImplementator());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            WeakListener.notifyException(0, noSuchMethodException);
        }
        catch (Exception exception) {
            ErrorManager errorManager = Utilities.errMan();
            if (errorManager != null) {
                errorManager.notify(1, exception);
            }
            exception.printStackTrace();
        }
    }

    private static final ErrorManager getErrorManager() {
        ErrorManager errorManager;
        if (WeakListener.errorManager == null && (errorManager = Utilities.errMan()) != null) {
            WeakListener.errorManager = errorManager.getInstance("org.openide.util");
        }
        return WeakListener.errorManager;
    }

    private static final void notifyException(int n, Throwable throwable) {
        ErrorManager errorManager = WeakListener.getErrorManager();
        if (errorManager != null) {
            if (errorManager.isLoggable(n)) {
                errorManager.notify(n, throwable);
            }
        } else {
            throwable.printStackTrace();
        }
    }

    private static final Method getRemoveMethod(String string, Class clazz, Class clazz2) throws NoSuchMethodException {
        Method method = null;
        Class[] classArray = new Class[]{clazz2};
        Class clazz3 = clazz;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            do {
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    // empty catch block
                }
                clazz = clazz.getSuperclass();
            } while (method == null && clazz != (class$java$lang$Object == null ? WeakListener.class$("java.lang.Object") : class$java$lang$Object));
        }
        if (method == null) {
            throw new NoSuchMethodException(clazz3 + "." + string);
        }
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            ((AccessibleObject)method).setAccessible(true);
        }
        return method;
    }

    Object getImplementator() {
        return this;
    }

    public String toString() {
        Reference reference = this.ref;
        if (reference == null) {
            return super.toString() + " " + NbBundle.getBundle(class$org$openide$util$WeakListener == null ? (class$org$openide$util$WeakListener = WeakListener.class$("org.openide.util.WeakListener")) : class$org$openide$util$WeakListener).getString("MSG_ToNowhere");
        }
        return super.toString() + " " + NbBundle.getBundle(class$org$openide$util$WeakListener == null ? (class$org$openide$util$WeakListener = WeakListener.class$("org.openide.util.WeakListener")) : class$org$openide$util$WeakListener).getString("MSG_To") + reference.get();
    }

    public static NodeListener node(NodeListener nodeListener, Object object) {
        return factory.node(nodeListener, object);
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener propertyChangeListener, Object object) {
        return factory.propertyChange(propertyChangeListener, object);
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener vetoableChangeListener, Object object) {
        return factory.vetoableChange(vetoableChangeListener, object);
    }

    public static FileChangeListener fileChange(FileChangeListener fileChangeListener, Object object) {
        return factory.fileChange(fileChangeListener, object);
    }

    public static FileStatusListener fileStatus(FileStatusListener fileStatusListener, Object object) {
        return factory.fileStatus(fileStatusListener, object);
    }

    public static RepositoryListener repository(RepositoryListener repositoryListener, Object object) {
        return factory.repository(repositoryListener, object);
    }

    public static DocumentListener document(DocumentListener documentListener, Object object) {
        return factory.document(documentListener, object);
    }

    public static ChangeListener change(ChangeListener changeListener, Object object) {
        return factory.change(changeListener, object);
    }

    public static FocusListener focus(FocusListener focusListener, Object object) {
        return factory.focus(focusListener, object);
    }

    public static OperationListener operation(OperationListener operationListener, Object object) {
        return factory.operation(operationListener, object);
    }

    public static EventListener create(Class clazz, EventListener eventListener, Object object) {
        return factory.create(clazz, eventListener, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.openide.util.WeakListener13");
            Class.forName("java.lang.reflect.InvocationHandler");
            factory = (Factory)clazz.newInstance();
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            System.err.println("Note: using less efficient 1.2 weak listeners due to " + throwable);
            factory = new WeakListener12();
        }
    }

    static interface Factory {
        public NodeListener node(NodeListener var1, Object var2);

        public PropertyChangeListener propertyChange(PropertyChangeListener var1, Object var2);

        public VetoableChangeListener vetoableChange(VetoableChangeListener var1, Object var2);

        public FileChangeListener fileChange(FileChangeListener var1, Object var2);

        public FileStatusListener fileStatus(FileStatusListener var1, Object var2);

        public RepositoryListener repository(RepositoryListener var1, Object var2);

        public DocumentListener document(DocumentListener var1, Object var2);

        public ChangeListener change(ChangeListener var1, Object var2);

        public FocusListener focus(FocusListener var1, Object var2);

        public OperationListener operation(OperationListener var1, Object var2);

        public EventListener create(Class var1, EventListener var2, Object var3);
    }

    private static final class Cleaner
    implements Runnable {
        Cleaner() {
        }

        public void run() {
            ListenerReference listenerReference;
            while ((listenerReference = (ListenerReference)QUEUE.poll()) != null) {
                listenerReference.weakListener.removeListener();
            }
            CLEANER_TASK.schedule(CLEANER_TIME);
        }
    }

    private static final class ListenerReference
    extends WeakReference {
        final WeakListener weakListener;

        public ListenerReference(Object object, WeakListener weakListener) {
            super(object, QUEUE);
            this.weakListener = weakListener;
        }
    }

    static final class Operation
    extends WeakListener
    implements OperationListener {
        static /* synthetic */ Class class$java$beans$PropertyChangeListener;

        public Operation(OperationListener operationListener) {
            super(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Operation.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, operationListener);
        }

        protected String removeMethodName() {
            return "removeOperationListener";
        }

        public void operationPostCreate(OperationEvent operationEvent) {
            OperationListener operationListener = (OperationListener)super.get(operationEvent);
            if (operationListener != null) {
                operationListener.operationPostCreate(operationEvent);
            }
        }

        public void operationCopy(OperationEvent.Copy copy) {
            OperationListener operationListener = (OperationListener)super.get(copy);
            if (operationListener != null) {
                operationListener.operationCopy(copy);
            }
        }

        public void operationMove(OperationEvent.Move move) {
            OperationListener operationListener = (OperationListener)super.get(move);
            if (operationListener != null) {
                operationListener.operationMove(move);
            }
        }

        public void operationDelete(OperationEvent operationEvent) {
            OperationListener operationListener = (OperationListener)super.get(operationEvent);
            if (operationListener != null) {
                operationListener.operationDelete(operationEvent);
            }
        }

        public void operationRename(OperationEvent.Rename rename) {
            OperationListener operationListener = (OperationListener)super.get(rename);
            if (operationListener != null) {
                operationListener.operationRename(rename);
            }
        }

        public void operationCreateShadow(OperationEvent.Copy copy) {
            OperationListener operationListener = (OperationListener)super.get(copy);
            if (operationListener != null) {
                operationListener.operationCreateShadow(copy);
            }
        }

        public void operationCreateFromTemplate(OperationEvent.Copy copy) {
            OperationListener operationListener = (OperationListener)super.get(copy);
            if (operationListener != null) {
                operationListener.operationCreateFromTemplate(copy);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static final class Focus
    extends WeakListener
    implements FocusListener {
        static /* synthetic */ Class class$java$awt$event$FocusListener;

        public Focus(FocusListener focusListener) {
            super(class$java$awt$event$FocusListener == null ? (class$java$awt$event$FocusListener = Focus.class$("java.awt.event.FocusListener")) : class$java$awt$event$FocusListener, focusListener);
        }

        public void focusGained(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusGained(focusEvent);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            FocusListener focusListener = (FocusListener)super.get(focusEvent);
            if (focusListener != null) {
                focusListener.focusLost(focusEvent);
            }
        }

        protected String removeMethodName() {
            return "removeFocusListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static final class Node
    extends PropertyChange
    implements NodeListener {
        static /* synthetic */ Class class$org$openide$nodes$NodeListener;

        public Node(NodeListener nodeListener) {
            super(class$org$openide$nodes$NodeListener == null ? (class$org$openide$nodes$NodeListener = Node.class$("org.openide.nodes.NodeListener")) : class$org$openide$nodes$NodeListener, nodeListener);
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            NodeListener nodeListener = (NodeListener)super.get(nodeMemberEvent);
            if (nodeListener != null) {
                nodeListener.childrenAdded(nodeMemberEvent);
            }
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            NodeListener nodeListener = (NodeListener)super.get(nodeMemberEvent);
            if (nodeListener != null) {
                nodeListener.childrenRemoved(nodeMemberEvent);
            }
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            NodeListener nodeListener = (NodeListener)super.get(nodeReorderEvent);
            if (nodeListener != null) {
                nodeListener.childrenReordered(nodeReorderEvent);
            }
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            NodeListener nodeListener = (NodeListener)super.get(nodeEvent);
            if (nodeListener != null) {
                nodeListener.nodeDestroyed(nodeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeNodeListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static final class Change
    extends WeakListener
    implements ChangeListener {
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        public Change(ChangeListener changeListener) {
            super(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Change.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ChangeListener changeListener = (ChangeListener)super.get(changeEvent);
            if (changeListener != null) {
                changeListener.stateChanged(changeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeChangeListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static final class Document
    extends WeakListener
    implements DocumentListener {
        static /* synthetic */ Class class$javax$swing$event$DocumentListener;

        public Document(DocumentListener documentListener) {
            super(class$javax$swing$event$DocumentListener == null ? (class$javax$swing$event$DocumentListener = Document.class$("javax.swing.event.DocumentListener")) : class$javax$swing$event$DocumentListener, documentListener);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.changedUpdate(documentEvent);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.insertUpdate(documentEvent);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            DocumentListener documentListener = this.docGet(documentEvent);
            if (documentListener != null) {
                documentListener.removeUpdate(documentEvent);
            }
        }

        protected String removeMethodName() {
            return "removeDocumentListener";
        }

        private DocumentListener docGet(DocumentEvent documentEvent) {
            if (((WeakListener)this).ref == null) {
                return null;
            }
            DocumentListener documentListener = (DocumentListener)((WeakListener)this).ref.get();
            if (documentListener != null) {
                return documentListener;
            }
            ((WeakListener)this).removeListener(documentEvent.getDocument());
            ((WeakListener)this).ref = null;
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class Repository
    extends WeakListener
    implements RepositoryListener {
        static /* synthetic */ Class class$org$openide$filesystems$RepositoryListener;

        public Repository(RepositoryListener repositoryListener) {
            super(class$org$openide$filesystems$RepositoryListener == null ? (class$org$openide$filesystems$RepositoryListener = Repository.class$("org.openide.filesystems.RepositoryListener")) : class$org$openide$filesystems$RepositoryListener, repositoryListener);
        }

        public void fileSystemAdded(RepositoryEvent repositoryEvent) {
            RepositoryListener repositoryListener = (RepositoryListener)super.get(repositoryEvent);
            if (repositoryListener != null) {
                repositoryListener.fileSystemAdded(repositoryEvent);
            }
        }

        public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
            RepositoryListener repositoryListener = (RepositoryListener)super.get(repositoryEvent);
            if (repositoryListener != null) {
                repositoryListener.fileSystemRemoved(repositoryEvent);
            }
        }

        public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
            RepositoryListener repositoryListener = (RepositoryListener)super.get(repositoryReorderedEvent);
            if (repositoryListener != null) {
                repositoryListener.fileSystemPoolReordered(repositoryReorderedEvent);
            }
        }

        protected String removeMethodName() {
            return "removeRepositoryListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class FileStatus
    extends WeakListener
    implements FileStatusListener {
        static /* synthetic */ Class class$org$openide$filesystems$FileStatusListener;

        public FileStatus(FileStatusListener fileStatusListener) {
            super(class$org$openide$filesystems$FileStatusListener == null ? (class$org$openide$filesystems$FileStatusListener = FileStatus.class$("org.openide.filesystems.FileStatusListener")) : class$org$openide$filesystems$FileStatusListener, fileStatusListener);
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            FileStatusListener fileStatusListener = (FileStatusListener)super.get(fileStatusEvent);
            if (fileStatusListener != null) {
                fileStatusListener.annotationChanged(fileStatusEvent);
            }
        }

        protected String removeMethodName() {
            return "removeFileStatusListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class FileChange
    extends WeakListener
    implements FileChangeListener {
        static /* synthetic */ Class class$org$openide$filesystems$FileChangeListener;

        public FileChange(FileChangeListener fileChangeListener) {
            super(class$org$openide$filesystems$FileChangeListener == null ? (class$org$openide$filesystems$FileChangeListener = FileChange.class$("org.openide.filesystems.FileChangeListener")) : class$org$openide$filesystems$FileChangeListener, fileChangeListener);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get(fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileFolderCreated(fileEvent);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get(fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileDataCreated(fileEvent);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get(fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileChanged(fileEvent);
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get(fileEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileDeleted(fileEvent);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get(fileRenameEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileRenamed(fileRenameEvent);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            FileChangeListener fileChangeListener = (FileChangeListener)super.get(fileAttributeEvent);
            if (fileChangeListener != null) {
                fileChangeListener.fileAttributeChanged(fileAttributeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeFileChangeListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class VetoableChange
    extends WeakListener
    implements VetoableChangeListener {
        static /* synthetic */ Class class$java$beans$VetoableChangeListener;

        public VetoableChange(VetoableChangeListener vetoableChangeListener) {
            super(class$java$beans$VetoableChangeListener == null ? (class$java$beans$VetoableChangeListener = VetoableChange.class$("java.beans.VetoableChangeListener")) : class$java$beans$VetoableChangeListener, vetoableChangeListener);
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            VetoableChangeListener vetoableChangeListener = (VetoableChangeListener)super.get(propertyChangeEvent);
            if (vetoableChangeListener != null) {
                vetoableChangeListener.vetoableChange(propertyChangeEvent);
            }
        }

        protected String removeMethodName() {
            return "removeVetoableChangeListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class PropertyChange
    extends WeakListener
    implements PropertyChangeListener {
        static /* synthetic */ Class class$java$beans$PropertyChangeListener;

        public PropertyChange(PropertyChangeListener propertyChangeListener) {
            super(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = PropertyChange.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        }

        PropertyChange(Class clazz, PropertyChangeListener propertyChangeListener) {
            super(clazz, propertyChangeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)super.get(propertyChangeEvent);
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
        }

        protected String removeMethodName() {
            return "removePropertyChangeListener";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

