/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public abstract class Lookup {
    public static final Lookup EMPTY = new Empty();
    private static Lookup defaultLookup;

    public static Lookup getDefault() {
        if (defaultLookup != null) {
            return defaultLookup;
        }
        return Lookup.initializeLookup();
    }

    private static synchronized Lookup initializeLookup() {
        if (defaultLookup != null) {
            return defaultLookup;
        }
        String string = System.getProperty("org.openide.util.Lookup");
        if (string == null) {
            defaultLookup = EMPTY;
            return defaultLookup;
        }
        try {
            Class<?> clazz = Class.forName(string);
            defaultLookup = (Lookup)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
        if (defaultLookup instanceof Runnable) {
            ((Runnable)((Object)defaultLookup)).run();
        }
        return defaultLookup;
    }

    public abstract Object lookup(Class var1);

    public abstract Result lookup(Template var1);

    public Item lookupItem(Template template) {
        Result result = this.lookup(template);
        Iterator iterator = result.allItems().iterator();
        return iterator.hasNext() ? (Item)iterator.next() : null;
    }

    private static final class Empty
    extends Lookup {
        private static final Result NO_RESULT = new Result(){

            public void addLookupListener(LookupListener lookupListener) {
            }

            public void removeLookupListener(LookupListener lookupListener) {
            }

            public Collection allInstances() {
                return Collections.EMPTY_LIST;
            }
        };

        Empty() {
        }

        public Object lookup(Class clazz) {
            return null;
        }

        public Result lookup(Template template) {
            return NO_RESULT;
        }
    }

    public static abstract class Item {
        public abstract Object getInstance();

        public abstract Class getType();

        public abstract String getId();

        public abstract String getDisplayName();

        public String toString() {
            return this.getId();
        }
    }

    public static abstract class Result {
        public abstract void addLookupListener(LookupListener var1);

        public abstract void removeLookupListener(LookupListener var1);

        public abstract Collection allInstances();

        public Set allClasses() {
            return Collections.EMPTY_SET;
        }

        public Collection allItems() {
            return Collections.EMPTY_SET;
        }
    }

    public static final class Template {
        private int hashCode;
        private Class type;
        private String id;
        private Object instance;
        static /* synthetic */ Class class$java$lang$Object;

        public Template() {
            this(null);
        }

        public Template(Class clazz) {
            this(clazz, null, null);
        }

        public Template(Class clazz, String string, Object object) {
            Class clazz2 = clazz == null ? (class$java$lang$Object == null ? (class$java$lang$Object = Template.class$("java.lang.Object")) : class$java$lang$Object) : clazz;
            this.type = clazz2;
            this.id = string;
            this.instance = object;
        }

        public Class getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public Object getInstance() {
            return this.instance;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = (this.type == null ? 1 : this.type.hashCode()) + (this.id == null ? 2 : this.id.hashCode()) + (this.instance == null ? 3 : 0);
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object instanceof Template) {
                Template template = (Template)object;
                if (this.hashCode() != template.hashCode()) {
                    return false;
                }
                if (this.type != template.type) {
                    return false;
                }
                if (!Utilities.compareObjects(this.id, template.id)) {
                    return false;
                }
                return Utilities.compareObjects(this.instance, template.instance);
            }
            return false;
        }

        public String toString() {
            return "Lookup.Template[type=" + this.type + ",id=" + this.id + ",instance=" + this.instance + "]";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

