/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.Line;
import org.openide.text.LineStruct;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.WeakListener;

final class LineListener
implements DocumentListener {
    private int orig;
    public final StyledDocument doc;
    private Element root;
    private int lines;
    private LineStruct struct;
    private ComparingLine comparingLine = null;
    private CloneableEditorSupport support;

    public LineListener(StyledDocument styledDocument, CloneableEditorSupport cloneableEditorSupport) {
        this.doc = styledDocument;
        this.struct = new LineStruct();
        this.root = NbDocument.findLineRootElement(styledDocument);
        this.orig = this.lines = this.root.getElementCount();
        this.support = cloneableEditorSupport;
        if (cloneableEditorSupport != null) {
            this.comparingLine = new ComparingLine();
        }
        styledDocument.addDocumentListener(WeakListener.document(this, styledDocument));
    }

    public int getOriginalLineCount() {
        return this.orig;
    }

    public int getLine(int n) {
        return this.struct.originalToCurrent(n);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n = this.root.getElementCount();
        int n2 = this.lines - n;
        this.lines = n;
        int n3 = NbDocument.findLineNumber(this.doc, documentEvent.getOffset());
        if (n2 > 0) {
            this.struct.deleteLines(n3, n2);
        }
        if (this.support == null) {
            return;
        }
        Line.Set set = this.support.getLineSet();
        if (!(set instanceof DocumentLine.Set)) {
            return;
        }
        int n4 = n3;
        while (n4 <= n3 + n2) {
            this.comparingLine.setLineNumber(n4);
            ((DocumentLine.Set)set).fireLineChanged(this.comparingLine, documentEvent);
            ++n4;
        }
        if (n2 > 0) {
            int n5 = n3;
            while (n5 < n) {
                this.comparingLine.setLineNumber(n5);
                ((DocumentLine.Set)set).fireLineMoved(this.comparingLine);
                ++n5;
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n = this.root.getElementCount();
        int n2 = n - this.lines;
        this.lines = n;
        int n3 = NbDocument.findLineNumber(this.doc, documentEvent.getOffset());
        if (n2 > 0) {
            this.struct.insertLines(n3, n2);
        }
        if (this.support == null) {
            return;
        }
        Line.Set set = this.support.getLineSet();
        if (!(set instanceof DocumentLine.Set)) {
            return;
        }
        this.comparingLine.setLineNumber(n3);
        ((DocumentLine.Set)set).fireLineChanged(this.comparingLine, documentEvent);
        if (n2 > 0) {
            int n4 = n3;
            while (n4 < n) {
                this.comparingLine.setLineNumber(n4);
                ((DocumentLine.Set)set).fireLineMoved(this.comparingLine);
                ++n4;
            }
        }
    }

    private class ComparingLine
    extends DocumentLine {
        private int lineNumber;

        public ComparingLine() {
            super(null, new PositionRef(LineListener.this.support.getPositionManager(), 0, Position.Bias.Backward));
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int setLineNumber(int n) {
            this.lineNumber = n;
            return this.lineNumber;
        }

        public void show(int n, int n2) {
        }
    }
}

