/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.Line;
import org.openide.text.PositionRef;
import org.openide.util.WeakListener;

final class EditorSupportLineSet
extends DocumentLine.Set {
    private CloneableEditorSupport support;

    public EditorSupportLineSet(CloneableEditorSupport cloneableEditorSupport, StyledDocument styledDocument) {
        super(styledDocument, cloneableEditorSupport);
        this.support = cloneableEditorSupport;
    }

    public Line createLine(int n) {
        StyledDocument styledDocument = this.support.getDocument();
        if (styledDocument == null) {
            return null;
        }
        PositionRef positionRef = new PositionRef(this.support.getPositionManager(), n, Position.Bias.Forward);
        return new SupportLine(this.support.getDataObjectHack(), positionRef, this.support);
    }

    static class Closed
    extends Line.Set
    implements ChangeListener {
        private CloneableEditorSupport support;
        private Line.Set delegate;

        public Closed(CloneableEditorSupport cloneableEditorSupport) {
            this.support = cloneableEditorSupport;
            cloneableEditorSupport.addChangeListener(WeakListener.change(this, cloneableEditorSupport));
        }

        public List getLines() {
            if (this.delegate != null) {
                return this.delegate.getLines();
            }
            return new ArrayList();
        }

        public Line getOriginal(int n) throws IndexOutOfBoundsException {
            if (this.delegate != null) {
                return this.delegate.getOriginal(n);
            }
            return this.getCurrent(n);
        }

        public Line getCurrent(int n) throws IndexOutOfBoundsException {
            PositionRef positionRef = new PositionRef(this.support.getPositionManager(), n, 0, Position.Bias.Forward);
            DataObject dataObject = this.support.getDataObjectHack();
            Line line = DocumentLine.Set.registerLine(new SupportLine(dataObject, positionRef, this.support));
            return line;
        }

        public synchronized void stateChanged(ChangeEvent changeEvent) {
            if (this.delegate == null) {
                StyledDocument styledDocument = this.support.getDocument();
                if (styledDocument != null) {
                    this.delegate = new EditorSupportLineSet(this.support, styledDocument);
                }
            } else if (this.support.getDocument() == null) {
                this.delegate = null;
            }
        }
    }

    private static final class SupportLine
    extends DocumentLine {
        static final long serialVersionUID = 7282223299866986051L;

        public SupportLine(DataObject dataObject, PositionRef positionRef, CloneableEditorSupport cloneableEditorSupport) {
            super(dataObject, positionRef);
        }

        public void show(int n, int n2) {
            CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
            if (n == 0 && !cloneableEditorSupport.isDocumentLoaded()) {
                return;
            }
            CloneableEditor cloneableEditor = cloneableEditorSupport.openAt(this.pos, n2);
            if (n == 2) {
                cloneableEditor.requestFocus();
            }
        }

        public Line.Part createPart(int n, int n2) {
            DocumentLine.Part part = new DocumentLine.Part(this, new PositionRef(this.pos.getCloneableEditorSupport().getPositionManager(), this.pos.getOffset() + n, Position.Bias.Forward), n2);
            this.addLinePart(part);
            return part;
        }
    }
}

