/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.TopManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.PositionRef;
import org.openide.util.Task;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class EditorSupport
extends OpenSupport
implements EditorCookie,
OpenCookie,
CloseCookie,
PrintCookie {
    public static final String EDITOR_MODE = "editor";
    protected String modifiedAppendix = " *";
    private boolean listenToModifs = true;
    Del del;

    public EditorSupport(MultiDataObject.Entry entry) {
        super(entry, new EntryEnv(entry.getDataObject()));
        this.del = new Del(entry.getDataObject(), new DelEnv(entry.getDataObject()), this.allEditors);
    }

    protected String messageOpening() {
        return this.del.superMessageOpening();
    }

    protected String messageOpened() {
        return this.del.superMessageOpened();
    }

    protected String messageSave() {
        return this.del.superMessageSave();
    }

    protected String messageName() {
        return this.del.superMessageName();
    }

    protected String messageToolTip() {
        return this.del.superMessageToolTip();
    }

    protected void updateTitles() {
        this.del.superUpdateTitles();
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        MultiDataObject multiDataObject = this.findDataObject();
        Editor editor = new Editor(multiDataObject);
        return editor;
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedo.Manager();
    }

    public boolean close() {
        return this.del.close();
    }

    protected boolean close(boolean bl) {
        return this.del.superClose(bl);
    }

    public synchronized Task prepareDocument() {
        return this.del.prepareDocument();
    }

    public StyledDocument openDocument() throws IOException {
        return this.del.openDocument();
    }

    public StyledDocument getDocument() {
        return this.del.getDocument();
    }

    public boolean isDocumentLoaded() {
        return this.del.isDocumentLoaded();
    }

    public void saveDocument() throws IOException {
        this.del.superSaveDocument();
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        this.del.superSaveFromKitToStream(styledDocument, editorKit, outputStream);
    }

    public boolean isModified() {
        return this.del.isModified();
    }

    protected MultiDataObject findDataObject() {
        return this.entry.getDataObject();
    }

    public final PositionRef createPositionRef(int n, Position.Bias bias) {
        return this.del.createPositionRef(n, bias);
    }

    public Line.Set getLineSet() {
        return this.del.getLineSet();
    }

    public void setMIMEType(String string) {
        this.del.setMIMEType(string);
    }

    public void setActions(SystemAction[] systemActionArray) {
    }

    protected EditorKit createEditorKit() {
        return this.del.superCreateEditorKit();
    }

    public void setModificationListening(boolean bl) {
        this.listenToModifs = bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.del.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.del.removeChangeListener(changeListener);
    }

    public void print() {
        this.del.print();
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        this.del.superLoadFromStreamToKit(styledDocument, inputStream, editorKit);
    }

    protected void reloadDocument() {
        this.reloadDocumentTask().waitFinished();
    }

    protected Task reloadDocumentTask() {
        return this.del.superReloadDocument();
    }

    protected Editor openAt(PositionRef positionRef) {
        return (Editor)this.del.openAt(positionRef, -1);
    }

    protected boolean canClose() {
        return this.del.superCanClose();
    }

    public JEditorPane[] getOpenedPanes() {
        return this.del.getOpenedPanes();
    }

    protected void notifyUnmodified() {
        this.modifySaveCookie(false);
        this.del.superNotifyUnmodified();
    }

    protected boolean notifyModified() {
        if (this.del.superNotifyModified()) {
            this.modifySaveCookie(true);
            return true;
        }
        return false;
    }

    protected void notifyClosed() {
        this.del.superNotifyClosed();
    }

    static EditorSupport extract(CloneableEditorSupport cloneableEditorSupport) {
        Del del = (Del)cloneableEditorSupport;
        return del.es();
    }

    final void modifySaveCookie(boolean bl) {
        if (this.listenToModifs) {
            if (bl) {
                ((EntryEnv)this.env).addSaveCookie();
            } else {
                ((EntryEnv)this.env).removeSaveCookie();
            }
        }
    }

    private static final class DelEnv
    extends EntryEnv {
        static final long serialVersionUID = 174320972368471234L;

        public DelEnv(MultiDataObject multiDataObject) {
            super(multiDataObject);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            CloneableOpenSupport cloneableOpenSupport = super.findCloneableOpenSupport();
            if (cloneableOpenSupport instanceof EditorSupport) {
                EditorSupport editorSupport = (EditorSupport)cloneableOpenSupport;
                return editorSupport.del;
            }
            return cloneableOpenSupport;
        }
    }

    private static class EntryEnv
    extends DataEditorSupport.Env
    implements SaveCookie {
        static final long serialVersionUID = 354528097109874355L;
        private static Method getCookieSetMethod = null;
        static /* synthetic */ Class class$org$openide$text$EditorSupport;
        static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
        static /* synthetic */ Class class$org$openide$loaders$MultiDataObject;

        public EntryEnv(MultiDataObject multiDataObject) {
            super(multiDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EditorSupport editorSupport;
            if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                this.changeFile();
            }
            if ("name".equals(propertyChangeEvent.getPropertyName()) && (editorSupport = (EditorSupport)this.getDataObject().getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = EntryEnv.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport)) != null) {
                editorSupport.updateTitles();
            }
            super.propertyChange(propertyChangeEvent);
        }

        public void save() throws IOException {
            EditorSupport editorSupport = (EditorSupport)this.getDataObject().getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = EntryEnv.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport);
            if (editorSupport == null) {
                throw new IOException("no EditorSupport found on this data object");
            }
            editorSupport.saveDocument();
        }

        final void addSaveCookie() {
            DataObject dataObject = this.getDataObject();
            if (dataObject instanceof MultiDataObject && dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = EntryEnv.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
                EntryEnv.getCookieSet((MultiDataObject)dataObject).add(this);
            }
        }

        final void removeSaveCookie() {
            DataObject dataObject = this.getDataObject();
            if (dataObject instanceof MultiDataObject && dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = EntryEnv.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == this) {
                EntryEnv.getCookieSet((MultiDataObject)dataObject).remove(this);
            }
        }

        private static final CookieSet getCookieSet(MultiDataObject multiDataObject) {
            try {
                if (getCookieSetMethod == null) {
                    getCookieSetMethod = (class$org$openide$loaders$MultiDataObject == null ? (class$org$openide$loaders$MultiDataObject = EntryEnv.class$("org.openide.loaders.MultiDataObject")) : class$org$openide$loaders$MultiDataObject).getDeclaredMethod("getCookieSet", new Class[0]);
                    ((AccessibleObject)getCookieSetMethod).setAccessible(true);
                }
                return (CookieSet)getCookieSetMethod.invoke((Object)multiDataObject, new Object[0]);
            }
            catch (Exception exception) {
                TopManager.getDefault().notifyException(exception);
                return new CookieSet();
            }
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            CloneableOpenSupport cloneableOpenSupport = super.findCloneableOpenSupport();
            if (cloneableOpenSupport != null) {
                return cloneableOpenSupport;
            }
            EditorSupport editorSupport = (EditorSupport)this.getDataObject().getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = EntryEnv.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport);
            if (editorSupport != null) {
                return editorSupport.del;
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private final class Del
    extends DataEditorSupport
    implements NodeListener {
        public Del(DataObject dataObject, CloneableEditorSupport.Env env, CloneableTopComponent.Ref ref) {
            super(dataObject, env);
            this.allEditors = ref;
        }

        public final EditorSupport es() {
            return EditorSupport.this;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                this.updateTitles();
            } else if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                DataObject dataObject = this.getDataObject();
                if (!dataObject.isValid()) {
                    return;
                }
                Enumeration enumeration = this.allEditors.getComponents();
                while (enumeration.hasMoreElements()) {
                    CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
                    cloneableTopComponent.setIcon(dataObject.getNodeDelegate().getIcon(1));
                }
            }
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        protected void notifyUnmodified() {
            EditorSupport.this.notifyUnmodified();
        }

        protected boolean notifyModified() {
            return EditorSupport.this.notifyModified();
        }

        protected void notifyClosed() {
            EditorSupport.this.notifyClosed();
        }

        final void superNotifyUnmodified() {
            super.notifyUnmodified();
        }

        final boolean superNotifyModified() {
            return super.notifyModified();
        }

        final void superNotifyClosed() {
            super.notifyClosed();
        }

        protected CloneableEditor createCloneableEditor() {
            CloneableTopComponent cloneableTopComponent = EditorSupport.this.createCloneableTopComponent();
            if (cloneableTopComponent instanceof Editor) {
                return (CloneableEditor)cloneableTopComponent;
            }
            return new Editor(this.getDataObject());
        }

        protected String messageToolTip() {
            return EditorSupport.this.messageToolTip();
        }

        protected String messageName() {
            return EditorSupport.this.messageName();
        }

        protected String messageOpening() {
            return EditorSupport.this.messageOpening();
        }

        protected String messageOpened() {
            return EditorSupport.this.messageOpened();
        }

        protected String messageSave() {
            return EditorSupport.this.messageSave();
        }

        protected void updateTitles() {
            EditorSupport.this.updateTitles();
        }

        final String superMessageToolTip() {
            return super.messageToolTip();
        }

        final String superMessageName() {
            return super.messageName();
        }

        final String superMessageOpening() {
            return super.messageOpening();
        }

        final String superMessageOpened() {
            return super.messageOpened();
        }

        final String superMessageSave() {
            return super.messageSave();
        }

        final void superUpdateTitles() {
            super.updateTitles();
        }

        protected boolean close(boolean bl) {
            return EditorSupport.this.close(bl);
        }

        protected boolean superClose(boolean bl) {
            return super.close(bl);
        }

        protected CloneableTopComponent createCloneableTopComponent() {
            return EditorSupport.this.createCloneableTopComponent();
        }

        final void superLoadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
            super.loadFromStreamToKit(styledDocument, inputStream, editorKit);
        }

        protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
            EditorSupport.this.loadFromStreamToKit(styledDocument, inputStream, editorKit);
        }

        protected void superSaveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
            super.saveFromKitToStream(styledDocument, editorKit, outputStream);
        }

        protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
            EditorSupport.this.saveFromKitToStream(styledDocument, editorKit, outputStream);
        }

        protected Task reloadDocument() {
            return EditorSupport.this.reloadDocumentTask();
        }

        final Task superReloadDocument() {
            return super.reloadDocument();
        }

        public void saveDocument() throws IOException {
            EditorSupport.this.saveDocument();
        }

        final void superSaveDocument() throws IOException {
            super.saveDocument();
        }

        protected UndoRedo.Manager createUndoRedoManager() {
            return EditorSupport.this.createUndoRedoManager();
        }

        EditorKit superCreateEditorKit() {
            return super.createEditorKit();
        }

        protected EditorKit createEditorKit() {
            return EditorSupport.this.createEditorKit();
        }

        final boolean superCanClose() {
            return super.canClose();
        }

        protected boolean canClose() {
            return EditorSupport.this.canClose();
        }
    }

    public static class Editor
    extends CloneableEditor {
        protected DataObject obj;
        static final long serialVersionUID = -185739563792410059L;
        static /* synthetic */ Class class$org$openide$text$EditorSupport;

        public Editor() {
        }

        public Editor(DataObject dataObject) {
            this(dataObject, (EditorSupport)dataObject.getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = Editor.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport));
        }

        public Editor(DataObject dataObject, EditorSupport editorSupport) {
            super(editorSupport.del);
            this.obj = dataObject;
            if (dataObject.isValid()) {
                Node node = dataObject.getNodeDelegate();
                this.setActivatedNodes(new Node[]{node});
                this.setIcon(node.getIcon(1));
                node.addNodeListener(WeakListener.node(editorSupport.del, node));
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            EditorSupport editorSupport;
            super.readExternal(objectInput);
            CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
            if (cloneableEditorSupport instanceof Del && (editorSupport = ((Del)cloneableEditorSupport).es()) != null) {
                this.obj = this.cloneableEditorSupport().getDataObjectHack();
                if (this.obj.isValid()) {
                    Node node = this.obj.getNodeDelegate();
                    this.setActivatedNodes(new Node[]{node});
                    this.setIcon(node.getIcon(1));
                    node.addNodeListener(WeakListener.node(editorSupport.del, node));
                }
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

