/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.TopManager;
import org.openide.actions.PasteAction;
import org.openide.awt.UndoRedo;
import org.openide.loaders.DataObject;
import org.openide.loaders.InstanceSupport;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.Workspace;

public class CloneableEditor
extends CloneableTopComponent {
    protected JEditorPane pane;
    private PropertyChangeListener copyL;
    private PropertyChangeListener cutL;
    private PropertyChangeListener deleteL;
    private PropertyChangeListener saveCookieL;
    private CloneableEditorSupport support;
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    private Map kitActions;
    static /* synthetic */ Class class$org$openide$text$CloneableEditor;
    static /* synthetic */ Class class$org$openide$actions$FileSystemAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
    static /* synthetic */ Class class$org$openide$text$CloneableEditorSupport;
    static /* synthetic */ Class class$org$openide$text$EditorSupport;

    public CloneableEditor() {
        this.putClientProperty("PersistenceType", "OnlyOpened");
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport) {
        this.support = cloneableEditorSupport;
        this.putClientProperty("PersistenceType", "OnlyOpened");
        this.initialize();
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx = InstanceSupport.findHelp(new InstanceSupport.Instance(this.support.kit()));
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose(Workspace workspace, boolean bl) {
        boolean bl2 = super.canClose(workspace, bl);
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StyledDocument styledDocument = CloneableEditor.this.support.createStyledDocument(CloneableEditor.this.pane.getEditorKit());
                    CloneableEditor.this.pane.setDocument(styledDocument);
                    CloneableEditor.this.pane.setEditorKit(null);
                    CloneableEditor.this.removeAll();
                }
            });
        }
        return bl2;
    }

    private void initialize() {
        ResourceBundle resourceBundle = NbBundle.getBundle(class$org$openide$text$CloneableEditor == null ? (class$org$openide$text$CloneableEditor = CloneableEditor.class$("org.openide.text.CloneableEditor")) : class$org$openide$text$CloneableEditor);
        this.setCloseOperation(0);
        this.setLayout(new BorderLayout());
        QuietEditorPane quietEditorPane = new QuietEditorPane();
        quietEditorPane.getAccessibleContext().setAccessibleName(MessageFormat.format(resourceBundle.getString("ACS_CloneableEditor_QuietEditorPane"), this.getName()));
        quietEditorPane.getAccessibleContext().setAccessibleName(MessageFormat.format(resourceBundle.getString("ACSD_CloneableEditor_QuietEditorPane"), this.getAccessibleContext().getAccessibleDescription()));
        this.pane = quietEditorPane;
        quietEditorPane.setEditorKit(this.support.kit());
        this.updateName();
        StyledDocument styledDocument = this.support.getDocumentHack();
        quietEditorPane.setDocument(styledDocument);
        if (styledDocument instanceof NbDocument.CustomEditor) {
            NbDocument.CustomEditor customEditor = (NbDocument.CustomEditor)((Object)styledDocument);
            this.add(customEditor.createEditor(quietEditorPane), "Center");
        } else {
            this.add((Component)new JScrollPane(quietEditorPane), "Center");
        }
        quietEditorPane.setWorking(3);
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    public void open(Workspace workspace) {
        if (!this.discard()) {
            Workspace workspace2 = workspace == null ? TopManager.getDefault().getWindowManager().getCurrentWorkspace() : workspace;
            this.dockIfNeeded(workspace2);
            boolean bl = false;
            TopComponent[] topComponentArray = this.editorMode(workspace2).getTopComponents();
            int n = 0;
            while (n < topComponentArray.length) {
                if (topComponentArray[n].isOpened(workspace2)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.openOtherEditors(workspace2);
            }
            super.open(workspace);
            this.openOnOtherWorkspaces(workspace2);
        }
    }

    protected boolean closeLast() {
        if (!this.support.canClose()) {
            return false;
        }
        this.support.notifyClosed();
        if (this.support.lastSelected == this) {
            this.support.lastSelected = null;
        }
        return true;
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public SystemAction[] getSystemActions() {
        SystemAction[] systemActionArray = super.getSystemActions();
        return SystemAction.linkActions(systemActionArray, new SystemAction[]{null, SystemAction.get(class$org$openide$actions$FileSystemAction == null ? (class$org$openide$actions$FileSystemAction = CloneableEditor.class$("org.openide.actions.FileSystemAction")) : class$org$openide$actions$FileSystemAction)});
    }

    public void requestFocus() {
        super.requestFocus();
        this.pane.requestFocus();
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = TopManager.getDefault().getWindowManager().getCurrentWorkspace().getBounds();
        return new Dimension(rectangle.width / 2, rectangle.height / 2);
    }

    private Action getAction(String string) {
        Object object;
        Reference reference;
        if (string == null) {
            return null;
        }
        if (this.kitActions == null) {
            this.kitActions = new HashMap(5);
        }
        if ((reference = (Reference)this.kitActions.get(string)) != null && (object = (Action)reference.get()) != null) {
            return object;
        }
        object = this.support.kit();
        if (object == null) {
            return null;
        }
        Action[] actionArray = ((EditorKit)object).getActions();
        this.kitActions = new HashMap(5);
        int n = 0;
        while (n < actionArray.length) {
            if (string.equals(actionArray[n].getValue("Name"))) {
                this.kitActions.put(actionArray[n].getValue("Name"), new WeakReference<Action>(actionArray[n]));
                return actionArray[n];
            }
            ++n;
        }
        return null;
    }

    protected void componentActivated() {
        Action action;
        Action action2;
        Action action3 = this.getAction("copy-to-clipboard");
        CallbackSystemAction callbackSystemAction = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = CloneableEditor.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction);
        if (action3 != null && action3 != callbackSystemAction) {
            action2 = action3;
            if (action3 == this.pane.getActionMap().get(action3)) {
                action2 = new SubstituteAction(action3);
                this.pane.getActionMap().put(action3, action2);
            }
            this.copyL = new Bridge(action2, callbackSystemAction);
        }
        action2 = this.getAction("cut-to-clipboard");
        CallbackSystemAction callbackSystemAction2 = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = CloneableEditor.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction);
        if (action2 != null && action2 != callbackSystemAction2) {
            action = action2;
            if (action2 == this.pane.getActionMap().get(action2)) {
                action = new SubstituteAction(action2);
                this.pane.getActionMap().put(action2, action);
            }
            this.cutL = new Bridge(action, callbackSystemAction2);
        }
        action = this.getAction("delete-next");
        CallbackSystemAction callbackSystemAction3 = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = CloneableEditor.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction);
        if (action != null && action != callbackSystemAction3) {
            this.deleteL = new Bridge(action, callbackSystemAction3);
        }
        this.updatePasteAction();
        this.support.lastSelected = this;
    }

    protected void componentDeactivated() {
        Action action;
        if (this.copyL != null && (action = this.getAction("copy-to-clipboard")) != null) {
            action.removePropertyChangeListener(this.copyL);
            if (action != this.pane.getActionMap().get(action)) {
                this.pane.getActionMap().put(action, action);
            }
        }
        if (this.cutL != null && (action = this.getAction("cut-to-clipboard")) != null) {
            action.removePropertyChangeListener(this.cutL);
            if (action != this.pane.getActionMap().get(action)) {
                this.pane.getActionMap().put(action, action);
            }
        }
        if (this.deleteL != null && (action = this.getAction("delete-next")) != null) {
            action.removePropertyChangeListener(this.deleteL);
        }
    }

    private void updatePasteAction() {
        Transferable transferable;
        final Action action = this.getAction("paste-from-clipboard");
        if (action == null) {
            return;
        }
        PasteAction pasteAction = (PasteAction)SystemAction.get(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = CloneableEditor.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = CloneableEditor.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        Transferable transferable2 = transferable = clipboard != null ? clipboard.getContents(null) : null;
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            pasteAction.setPasteTypes(new PasteType[]{new PasteType(){

                public Transferable paste() {
                    action.actionPerformed(new ActionEvent(CloneableEditor.this, 0, ""));
                    return null;
                }
            }});
        } else {
            pasteAction.setPasteTypes(null);
        }
    }

    protected void updateName() {
        this.setName(this.cloneableEditorSupport().messageName());
        this.setToolTipText(this.cloneableEditorSupport().messageToolTip());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.support != null ? this.support.env() : null);
        int n = 0;
        JEditorPane jEditorPane = this.pane;
        if (jEditorPane != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret != null) {
                n = caret.getDot();
            } else {
                StyledDocument styledDocument;
                StyledDocument styledDocument2 = styledDocument = this.support != null ? this.support.getDocument() : null;
                if (styledDocument != null) {
                    TopManager.getDefault().getErrorManager().notify(1, new IllegalStateException("Caret is null in editor pane=" + jEditorPane + "\nsupport=" + this.support + "\ndoc=" + styledDocument));
                }
            }
        }
        objectOutput.writeObject(new Integer(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        int n;
        Object object2;
        super.readExternal(objectInput);
        Object object3 = objectInput.readObject();
        if (object3 instanceof DataObject) {
            object2 = (DataObject)object3;
            n = (Integer)objectInput.readObject();
            object = objectInput.readObject();
            if (object instanceof CloneableEditorSupport) {
                this.support = (CloneableEditorSupport)object;
            } else {
                EditorSupport editorSupport;
                this.support = (CloneableEditorSupport)((Object)((DataObject)object2).getCookie(class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditor.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport));
                if (this.support == null && (editorSupport = (EditorSupport)((DataObject)object2).getCookie(class$org$openide$text$EditorSupport == null ? (class$org$openide$text$EditorSupport = CloneableEditor.class$("org.openide.text.EditorSupport")) : class$org$openide$text$EditorSupport)) != null) {
                    this.support = editorSupport.del;
                }
            }
        } else {
            if (object3 instanceof CloneableOpenSupport.Env) {
                object2 = (CloneableOpenSupport.Env)object3;
                object = object2.findCloneableOpenSupport();
                this.support = object instanceof EditorSupport ? ((EditorSupport)object).del : (CloneableEditorSupport)object;
            }
            n = (Integer)objectInput.readObject();
        }
        if (!this.discard()) {
            object2 = this.support.prepareDocument();
            this.initialize();
            final int n2 = n;
            ((Task)object2).addTaskListener(new TaskListener((Task)object2){
                private final /* synthetic */ Task val$t;
                {
                    this.val$t = task;
                }

                public void taskFinished(Task task) {
                    CloneableEditor.this.pane.getCaret().setDot(n2);
                    this.val$t.removeTaskListener(this);
                }
            });
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            return null;
        }
        this.support.initializeCloneableEditor(this);
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.env().isValid();
    }

    private void dockIfNeeded(Workspace workspace) {
        Mode mode = workspace.findMode(this);
        if (mode == null) {
            this.editorMode(workspace).dockInto(this);
        }
    }

    private Mode editorMode(Workspace workspace) {
        Mode mode = workspace.findMode(this);
        if (mode == null) {
            mode = workspace.createMode("editor", this.getName(), (class$org$openide$text$CloneableEditorSupport == null ? (class$org$openide$text$CloneableEditorSupport = CloneableEditor.class$("org.openide.text.CloneableEditorSupport")) : class$org$openide$text$CloneableEditorSupport).getResource("/org/openide/resources/editorMode.gif"));
        }
        return mode;
    }

    private void openOnOtherWorkspaces(Workspace workspace) {
        Workspace[] workspaceArray = TopManager.getDefault().getWindowManager().getWorkspaces();
        Mode mode = null;
        Mode mode2 = null;
        int n = 0;
        while (n < workspaceArray.length) {
            if (!workspaceArray[n].equals(workspace)) {
                mode = workspaceArray[n].findMode("editor");
                mode2 = workspaceArray[n].findMode(this);
                if (!this.isOpened(workspaceArray[n]) && mode != null && (mode2 == null || mode2.equals(mode))) {
                    TopComponent[] topComponentArray = mode.getTopComponents();
                    int n2 = 0;
                    while (n2 < topComponentArray.length) {
                        if (topComponentArray[n2].isOpened(workspaceArray[n])) {
                            this.pureOpen(this, workspaceArray[n]);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void openOtherEditors(Workspace workspace) {
        HashSet<TopComponent> hashSet = new HashSet<TopComponent>(15);
        Workspace[] workspaceArray = TopManager.getDefault().getWindowManager().getWorkspaces();
        Mode mode = null;
        TopComponent[] topComponentArray = null;
        int n = 0;
        while (n < workspaceArray.length) {
            mode = workspaceArray[n].findMode("editor");
            if (mode != null) {
                topComponentArray = mode.getTopComponents();
                int n2 = 0;
                while (n2 < topComponentArray.length) {
                    if (topComponentArray[n2].isOpened(workspaceArray[n])) {
                        hashSet.add(topComponentArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.pureOpen((TopComponent)iterator.next(), workspace);
        }
    }

    private void pureOpen(TopComponent topComponent, Workspace workspace) {
        if (topComponent instanceof CloneableEditor) {
            ((CloneableEditor)topComponent).dockIfNeeded(workspace);
            ((CloneableEditor)topComponent).superOpen(workspace);
        } else {
            topComponent.open(workspace);
        }
    }

    private void superOpen(Workspace workspace) {
        super.open(workspace);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SubstituteAction
    implements Action {
        private Action substitutee;

        public SubstituteAction(Action action) {
            this.substitutee = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.substitutee.actionPerformed(actionEvent);
            CloneableEditor.this.updatePasteAction();
        }

        public Object getValue(String string) {
            return this.substitutee.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.substitutee.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
            this.substitutee.setEnabled(bl);
        }

        public boolean isEnabled() {
            return this.substitutee.isEnabled();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.substitutee.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.substitutee.removePropertyChangeListener(propertyChangeListener);
        }
    }

    private class Bridge
    implements PropertyChangeListener,
    ActionPerformer {
        private Action action;
        private CallbackSystemAction sys;

        Bridge(Action action, CallbackSystemAction callbackSystemAction) {
            this.action = action;
            this.sys = callbackSystemAction;
            if (this.action.isEnabled()) {
                callbackSystemAction.setActionPerformer(this);
            } else {
                callbackSystemAction.setActionPerformer(null);
            }
            this.action.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                    this.sys.setActionPerformer(this);
                } else if (this.sys.getActionPerformer() == this) {
                    this.sys.setActionPerformer(null);
                }
            }
        }

        public void performAction(SystemAction systemAction) {
            this.action.actionPerformed(new ActionEvent(CloneableEditor.this, 0, ""));
        }
    }
}

