/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.openide.TopManager;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.src.ConstructorElement;
import org.openide.src.Element;
import org.openide.src.ElementFormat;
import org.openide.src.ElementPrinter;
import org.openide.src.ElementPrinterInterruptException;
import org.openide.src.FieldElement;
import org.openide.src.Identifier;
import org.openide.src.InitializerElement;
import org.openide.src.JavaDoc;
import org.openide.src.JavaDocSupport;
import org.openide.src.MemberElement;
import org.openide.src.MemoryCollection;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public final class ClassElement
extends MemberElement {
    public static final boolean CLASS = true;
    public static final boolean INTERFACE = false;
    public static final Identifier ROOT_OBJECT = Identifier.create("java.lang.Object", "Object");
    private static final ElementFormat[] HEADER_FORMAT = new ElementFormat[]{new ElementFormat("{m,,\" \"}class {n}{s,\" extends \",}{i,\" implements \",}"), new ElementFormat("{m,,\" \"}interface {n}{i,\" extends \",}")};
    private SourceElement source;
    static final long serialVersionUID = 1692944638104452533L;
    private static List finders = new LinkedList();
    static /* synthetic */ Class class$org$openide$src$ClassElement;
    static /* synthetic */ Class class$org$openide$cookies$SourceCookie;

    public ClassElement() {
        this(new Memory(), null, null);
    }

    public ClassElement(Impl impl, ClassElement classElement) {
        this(impl, classElement, classElement.getSource());
    }

    public ClassElement(Impl impl, SourceElement sourceElement) {
        this(impl, null, sourceElement);
    }

    private ClassElement(Impl impl, ClassElement classElement, SourceElement sourceElement) {
        super(impl, classElement);
        this.source = sourceElement;
    }

    public Object clone() {
        Memory memory = new Memory(this);
        ClassElement classElement = new ClassElement(memory, null, null);
        memory.copyFrom(this);
        return classElement;
    }

    final Impl getClassImpl() {
        return (Impl)this.impl;
    }

    void updateConstructorsNames(Identifier identifier) throws SourceException {
        ConstructorElement[] constructorElementArray = this.getConstructors();
        Identifier identifier2 = Identifier.create(identifier.getName());
        int n = 0;
        while (n < constructorElementArray.length) {
            constructorElementArray[n].setName(identifier2);
            ++n;
        }
        ClassElement[] classElementArray = this.getClasses();
        String string = this.getName().getFullName() + ".";
        int n2 = 0;
        while (n2 < classElementArray.length) {
            String string2 = classElementArray[n2].getName().getName();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(string2);
            Identifier identifier3 = Identifier.create(stringBuffer.toString(), string2);
            classElementArray[n2].setName(identifier3);
            ++n2;
        }
    }

    public SourceElement getSource() {
        return this.source;
    }

    public void setClassOrInterface(boolean bl) throws SourceException {
        this.getClassImpl().setClassOrInterface(bl);
    }

    public boolean isClassOrInterface() {
        return this.getClassImpl().isClassOrInterface();
    }

    public boolean isClass() {
        return this.getClassImpl().isClassOrInterface();
    }

    public boolean isInterface() {
        return !this.getClassImpl().isClassOrInterface();
    }

    public boolean isInner() {
        return this.getDeclaringClass() != null;
    }

    public int getModifiersMask() {
        int n = 1025;
        if (this.isClass()) {
            n |= 0x10;
        }
        if (this.isInner()) {
            n |= 0xE;
        }
        return n;
    }

    public final void setName(Identifier identifier) throws SourceException {
        ClassElement classElement;
        String string = identifier.getName();
        String string2 = identifier.getFullName();
        if (!identifier.getSourceName().equals(string)) {
            identifier = Identifier.create(string2, string);
        }
        ClassElement classElement2 = this.getDeclaringClass();
        String string3 = null;
        if (classElement2 != null) {
            ClassElement classElement3 = classElement2.getClass(identifier);
            if (classElement3 != null && classElement3 != this) {
                MessageFormat messageFormat = new MessageFormat(ElementFormat.bundle.getString("FMT_EXC_RenameClass"));
                string3 = messageFormat.format(new Object[]{classElement2.getName().getName(), identifier});
            }
        } else if (this.source != null && (classElement = this.source.getClass(identifier)) != null && classElement != this) {
            MessageFormat messageFormat = new MessageFormat(ElementFormat.bundle.getString("FMT_EXC_RenameClassInSource"));
            string3 = messageFormat.format(new Object[]{identifier});
        }
        if (string3 != null) {
            this.throwSourceException(string3);
        }
        super.setName(identifier);
    }

    public final String getSignature() {
        return this.getVMName().replace('.', '/');
    }

    public final String getVMName() {
        Identifier identifier = this.getName();
        if (!this.isInner()) {
            return identifier.getFullName();
        }
        StringBuffer stringBuffer = new StringBuffer(identifier.getFullName());
        ClassElement classElement = this;
        int n = stringBuffer.length();
        while (true) {
            stringBuffer.setCharAt(n -= identifier.getSourceName().length() + 1, '$');
            classElement = classElement.getDeclaringClass();
            if (!classElement.isInner()) break;
            identifier = classElement.getName();
        }
        return stringBuffer.toString();
    }

    public void setSuperclass(Identifier identifier) throws SourceException {
        this.getClassImpl().setSuperclass(identifier);
    }

    public Identifier getSuperclass() {
        return this.getClassImpl().getSuperclass();
    }

    public void addInitializer(InitializerElement initializerElement) throws SourceException {
        this.getClassImpl().changeInitializers(new InitializerElement[]{initializerElement}, 1);
    }

    public void addInitializers(InitializerElement[] initializerElementArray) throws SourceException {
        this.getClassImpl().changeInitializers(initializerElementArray, 1);
    }

    public void removeInitializer(InitializerElement initializerElement) throws SourceException {
        this.getClassImpl().changeInitializers(new InitializerElement[]{initializerElement}, -1);
    }

    public void removeInitializers(InitializerElement[] initializerElementArray) throws SourceException {
        this.getClassImpl().changeInitializers(initializerElementArray, -1);
    }

    public void setInitializers(InitializerElement[] initializerElementArray) throws SourceException {
        this.getClassImpl().changeInitializers(initializerElementArray, 0);
    }

    public InitializerElement[] getInitializers() {
        return this.getClassImpl().getInitializers();
    }

    public void addField(FieldElement fieldElement) throws SourceException {
        if (this.getField(fieldElement.getName()) != null) {
            this.throwAddException("FMT_EXC_AddField", fieldElement);
        }
        this.getClassImpl().changeFields(new FieldElement[]{fieldElement}, 1);
    }

    public void addFields(FieldElement[] fieldElementArray) throws SourceException {
        int n = 0;
        while (n < fieldElementArray.length) {
            if (this.getField(fieldElementArray[n].getName()) != null) {
                this.throwAddException("FMT_EXC_AddField", fieldElementArray[n]);
            }
            ++n;
        }
        this.getClassImpl().changeFields(fieldElementArray, 1);
    }

    public void removeField(FieldElement fieldElement) throws SourceException {
        this.getClassImpl().changeFields(new FieldElement[]{fieldElement}, -1);
    }

    public void removeFields(FieldElement[] fieldElementArray) throws SourceException {
        this.getClassImpl().changeFields(fieldElementArray, -1);
    }

    public void setFields(FieldElement[] fieldElementArray) throws SourceException {
        this.getClassImpl().changeFields(fieldElementArray, 0);
    }

    public FieldElement[] getFields() {
        return this.getClassImpl().getFields();
    }

    public FieldElement getField(Identifier identifier) {
        return this.getClassImpl().getField(identifier);
    }

    public void addMethod(MethodElement methodElement) throws SourceException {
        this.testMethod(methodElement);
        this.getClassImpl().changeMethods(new MethodElement[]{methodElement}, 1);
    }

    public void addMethods(MethodElement[] methodElementArray) throws SourceException {
        int n = 0;
        while (n < methodElementArray.length) {
            this.testMethod(methodElementArray[n]);
            ++n;
        }
        this.getClassImpl().changeMethods(methodElementArray, 1);
    }

    private void testMethod(MethodElement methodElement) throws SourceException {
        MethodParameter[] methodParameterArray = methodElement.getParameters();
        Type[] typeArray = new Type[methodParameterArray.length];
        int n = 0;
        while (n < typeArray.length) {
            typeArray[n] = methodParameterArray[n].getType();
            ++n;
        }
        if (this.getMethod(methodElement.getName(), typeArray) != null) {
            this.throwAddException("FMT_EXC_AddMethod", methodElement);
        }
    }

    public void removeMethod(MethodElement methodElement) throws SourceException {
        this.getClassImpl().changeMethods(new MethodElement[]{methodElement}, -1);
    }

    public void removeMethods(MethodElement[] methodElementArray) throws SourceException {
        this.getClassImpl().changeMethods(methodElementArray, -1);
    }

    public void setMethods(MethodElement[] methodElementArray) throws SourceException {
        this.getClassImpl().changeMethods(methodElementArray, 0);
    }

    public MethodElement[] getMethods() {
        return this.getClassImpl().getMethods();
    }

    public MethodElement getMethod(Identifier identifier, Type[] typeArray) {
        return this.getClassImpl().getMethod(identifier, typeArray);
    }

    public void addConstructor(ConstructorElement constructorElement) throws SourceException {
        this.testConstructor(constructorElement);
        this.getClassImpl().changeConstructors(new ConstructorElement[]{constructorElement}, 1);
    }

    public void addConstructors(ConstructorElement[] constructorElementArray) throws SourceException {
        int n = 0;
        while (n < constructorElementArray.length) {
            this.testConstructor(constructorElementArray[n]);
            ++n;
        }
        this.getClassImpl().changeConstructors(constructorElementArray, 1);
    }

    private void testConstructor(ConstructorElement constructorElement) throws SourceException {
        MethodParameter[] methodParameterArray = constructorElement.getParameters();
        Type[] typeArray = new Type[methodParameterArray.length];
        int n = 0;
        while (n < typeArray.length) {
            typeArray[n] = methodParameterArray[n].getType();
            ++n;
        }
        if (this.getConstructor(typeArray) != null) {
            this.throwAddException("FMT_EXC_AddConstructor", constructorElement);
        }
    }

    public void removeConstructor(ConstructorElement constructorElement) throws SourceException {
        this.getClassImpl().changeConstructors(new ConstructorElement[]{constructorElement}, -1);
    }

    public void removeConstructors(ConstructorElement[] constructorElementArray) throws SourceException {
        this.getClassImpl().changeConstructors(constructorElementArray, -1);
    }

    public void setConstructors(ConstructorElement[] constructorElementArray) throws SourceException {
        this.getClassImpl().changeConstructors(constructorElementArray, 0);
    }

    public ConstructorElement[] getConstructors() {
        return this.getClassImpl().getConstructors();
    }

    public ConstructorElement getConstructor(Type[] typeArray) {
        return this.getClassImpl().getConstructor(typeArray);
    }

    public void addClass(ClassElement classElement) throws SourceException {
        Identifier identifier = Identifier.create(classElement.getName().getName());
        if (this.getClass(identifier) != null) {
            this.throwAddException("FMT_EXC_AddClass", classElement);
        }
        this.getClassImpl().changeClasses(new ClassElement[]{classElement}, 1);
    }

    public void addClasses(ClassElement[] classElementArray) throws SourceException {
        int n = 0;
        while (n < classElementArray.length) {
            Identifier identifier = Identifier.create(classElementArray[n].getName().getName());
            if (this.getClass(identifier) != null) {
                this.throwAddException("FMT_EXC_AddClass", classElementArray[n]);
            }
            ++n;
        }
        this.getClassImpl().changeClasses(classElementArray, 1);
    }

    public void removeClass(ClassElement classElement) throws SourceException {
        this.getClassImpl().changeClasses(new ClassElement[]{classElement}, -1);
    }

    public void removeClasses(ClassElement[] classElementArray) throws SourceException {
        this.getClassImpl().changeClasses(classElementArray, -1);
    }

    public void setClasses(ClassElement[] classElementArray) throws SourceException {
        this.getClassImpl().changeClasses(classElementArray, 0);
    }

    public ClassElement[] getClasses() {
        return this.getClassImpl().getClasses();
    }

    public ClassElement getClass(Identifier identifier) {
        return this.getClassImpl().getClass(identifier);
    }

    public void addInterface(Identifier identifier) throws SourceException {
        this.getClassImpl().changeInterfaces(new Identifier[]{identifier}, 1);
    }

    public void addInterfaces(Identifier[] identifierArray) throws SourceException {
        this.getClassImpl().changeInterfaces(identifierArray, 1);
    }

    public void removeInterface(Identifier identifier) throws SourceException {
        this.getClassImpl().changeInterfaces(new Identifier[]{identifier}, -1);
    }

    public void removeInterfaces(Identifier identifier) throws SourceException {
        this.removeInterface(identifier);
    }

    public void removeInterfaces(Identifier[] identifierArray) throws SourceException {
        this.getClassImpl().changeInterfaces(identifierArray, -1);
    }

    public void removeInterface(Identifier[] identifierArray) throws SourceException {
        this.removeInterfaces(identifierArray);
    }

    public void setInterfaces(Identifier[] identifierArray) throws SourceException {
        this.getClassImpl().changeInterfaces(identifierArray, 0);
    }

    public Identifier[] getInterfaces() {
        return this.getClassImpl().getInterfaces();
    }

    public JavaDoc.Class getJavaDoc() {
        return this.getClassImpl().getJavaDoc();
    }

    public void print(ElementPrinter elementPrinter) throws ElementPrinterInterruptException {
        elementPrinter.markClass(this, 0);
        JavaDoc.Class clazz = this.getJavaDoc();
        if (clazz != null && !clazz.isEmpty()) {
            elementPrinter.markClass(this, 2);
            Element.printJavaDoc(clazz, elementPrinter);
            elementPrinter.markClass(this, 3);
            elementPrinter.println("");
        }
        elementPrinter.markClass(this, 4);
        elementPrinter.print(this.isClass() ? HEADER_FORMAT[0].format(this) : HEADER_FORMAT[1].format(this));
        elementPrinter.markClass(this, 5);
        elementPrinter.print(" {");
        elementPrinter.markClass(this, 6);
        elementPrinter.println("");
        if (Element.print(this.getInitializers(), elementPrinter)) {
            elementPrinter.println("");
            elementPrinter.println("");
        }
        if (Element.print(this.getFields(), elementPrinter)) {
            elementPrinter.println("");
            elementPrinter.println("");
        }
        if (Element.print(this.getConstructors(), elementPrinter)) {
            elementPrinter.println("");
            elementPrinter.println("");
        }
        if (Element.print(this.getMethods(), elementPrinter)) {
            elementPrinter.println("");
            elementPrinter.println("");
        }
        Element.print(this.getClasses(), elementPrinter);
        elementPrinter.println("");
        elementPrinter.markClass(this, 7);
        elementPrinter.print("}");
        elementPrinter.markClass(this, 1);
    }

    private void throwAddException(String string, MemberElement memberElement) throws SourceException {
        MessageFormat messageFormat = new MessageFormat(ElementFormat.bundle.getString(string));
        String string2 = messageFormat.format(new Object[]{this.getName().getName(), memberElement.getName().getName()});
        this.throwSourceException(string2);
    }

    public boolean hasMainMethod() {
        MethodElement[] methodElementArray = this.getMethods();
        Identifier identifier = Identifier.create("main");
        int n = 0;
        while (n < methodElementArray.length) {
            Type type;
            MethodParameter[] methodParameterArray;
            MethodElement methodElement = methodElementArray[n];
            if (methodElement.getName().equals(identifier) && methodElement.getReturn() == Type.VOID && (methodElement.getModifiers() & 0xFFFFFFEF) == 9 && (methodParameterArray = methodElement.getParameters()).length == 1 && (type = methodParameterArray[0].getType()).isArray() && (type = type.getElementType()).isClass() && type.getClassName().getFullName().equals("java.lang.String")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isDeclaredAsJavaBean() {
        if (Modifier.isPublic(this.getModifiers()) && !Modifier.isAbstract(this.getModifiers()) && this.isClass()) {
            ConstructorElement[] constructorElementArray = this.getConstructors();
            int n = 0;
            while (n < constructorElementArray.length) {
                if (constructorElementArray[n].getParameters().length == 0 && Modifier.isPublic(constructorElementArray[n].getModifiers())) {
                    return true;
                }
                ++n;
            }
            return constructorElementArray.length == 0;
        }
        return false;
    }

    public boolean isDeclaredAsApplet() {
        Identifier identifier;
        if (this.isClass() && (identifier = this.getSuperclass()) != null) {
            String string = identifier.getFullName();
            return string.equals("java.applet.Applet") || string.equals("javax.swing.JApplet");
        }
        return false;
    }

    public static void register(Finder finder) {
        List list = finders;
        synchronized (list) {
            finders.add(finder);
        }
    }

    public static void unregister(Finder finder) {
        List list = finders;
        synchronized (list) {
            finders.remove(finder);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static ClassElement forName(String var0) {
        var4_1 = ClassElement.finders;
        synchronized (var4_1) {
            var3_2 = new ArrayList<E>(ClassElement.finders).iterator();
            // MONITOREXIT @DISABLED, blocks:[0, 4] lbl5 : MonitorExitStatement: MONITOREXIT : var4_1
            if (true) ** GOTO lbl12
        }
        do {
            if ((var5_4 = ((Finder)var3_2.next()).find(var0)) == null) continue;
            return var5_4;
lbl12:
            // 2 sources

        } while (var3_2.hasNext());
        var5_4 = TopManager.getDefault().getRepository();
        var6_5 = var0.lastIndexOf(46);
        if (var6_5 >= 0 && var6_5 <= var0.length()) {
            var1_6 = var0.substring(0, var6_5);
            var2_7 = var0.substring(var6_5 + 1);
        } else {
            var1_6 = "";
            var2_7 = var0;
        }
        var7_8 = var5_4.find(var1_6, var2_7, "class");
        var8_9 = ClassElement.testFileForName(var7_8, var2_7);
        if (var8_9 != null) {
            return var8_9;
        }
        var6_5 = var2_7.indexOf(36);
        if (var6_5 != -1) {
            var7_8 = var5_4.find(var1_6, var2_7.substring(0, var6_5), "java");
            var8_9 = ClassElement.testFileForName(var7_8, var2_7);
            if (var8_9 != null) {
                return var8_9;
            }
        } else {
            var9_10 = var2_7;
            while (true) {
                if ((var8_9 = ClassElement.testFileForName(var7_8 = var5_4.find(var1_6, (String)var9_10, "java"), var2_7)) != null) {
                    return var8_9;
                }
                if (var1_6.length() == 0) break;
                var10_11 = var1_6.lastIndexOf(46);
                var9_10 = var1_6.substring(var10_11 + 1);
                var2_7 = (String)var9_10 + "." + var2_7;
                if (var10_11 >= 0) {
                    var1_6 = var1_6.substring(0, var10_11);
                    continue;
                }
                var1_6 = "";
            }
        }
        if ((var10_12 = TopManager.getDefault().currentClassLoader()) == null) {
            var10_12 = (ClassElement.class$org$openide$src$ClassElement == null ? (ClassElement.class$org$openide$src$ClassElement = ClassElement.class$("org.openide.src.ClassElement")) : ClassElement.class$org$openide$src$ClassElement).getClassLoader();
        }
        try {
            try {
                var9_10 = Class.forName(var0, true, var10_12);
                return ClassElement.forClass(var9_10);
            }
            catch (ClassNotFoundException var11_13) {
                if (var6_5 != -1) {
                    return null;
                }
                var11_14 = new StringBuffer(var0);
                var6_5 = var0.lastIndexOf(46);
                ** while (var6_5 > 0)
            }
lbl-1000:
            // 1 sources

            {
                var11_14.setCharAt(var6_5, '$');
                var6_5 = var0.lastIndexOf(46, var6_5 - 1);
                try {
                    var1_6 = var6_5 < 1 ? "" : var11_14.substring(0, var6_5);
                    var2_7 = var11_14.substring(var6_5 + 1);
                    var12_17 = var5_4.find(var1_6, var2_7, "class");
                    var8_9 = ClassElement.testFileForName(var12_17, var2_7);
                    if (var8_9 != null) {
                        return var8_9;
                    }
                    var9_10 = Class.forName(var11_14.toString(), true, var10_12);
                    return ClassElement.forClass(var9_10);
                }
                catch (ClassNotFoundException var12_16) {
                    // empty catch block
                }
                continue;
lbl71:
                // 1 sources

            }
        }
        catch (LinkageError var11_15) {
            // empty catch block
        }
        return null;
    }

    private static ClassElement testFileForName(FileObject fileObject, String string) {
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find(fileObject);
                SourceCookie sourceCookie = (SourceCookie)dataObject.getCookie(class$org$openide$cookies$SourceCookie == null ? (class$org$openide$cookies$SourceCookie = ClassElement.class$("org.openide.cookies.SourceCookie")) : class$org$openide$cookies$SourceCookie);
                if (sourceCookie != null) {
                    ClassElement[] classElementArray = sourceCookie.getSource().getClasses();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "$.");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        ClassElement classElement = null;
                        int n = 0;
                        while (n < classElementArray.length) {
                            Identifier identifier = classElementArray[n].getName();
                            if (identifier.getName().equals(string2)) {
                                if (!stringTokenizer.hasMoreTokens()) {
                                    return classElementArray[n];
                                }
                                classElement = classElementArray[n];
                                break;
                            }
                            ++n;
                        }
                        if (classElement == null) {
                            return null;
                        }
                        classElementArray = classElement.getClasses();
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClassElement forClass(Class clazz) {
        Iterator iterator;
        List list = finders;
        synchronized (list) {
            iterator = ((AbstractList)new ArrayList(finders)).iterator();
        }
        while (iterator.hasNext()) {
            ClassElement classElement = ((Finder)iterator.next()).find(clazz);
            if (classElement == null) continue;
            return classElement;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class Memory
    extends MemberElement.Memory
    implements Impl {
        private Identifier superClass;
        private boolean isClass;
        private MemoryCollection interfaces;
        private MemoryCollection.Initializer initializers;
        private MemoryCollection.Constructor constructors;
        private MemoryCollection.Method methods;
        private MemoryCollection.Field fields;
        private MemoryCollection.Class classes;
        JavaDoc.Class javaDoc = null;
        static final long serialVersionUID = 6058485742932189851L;

        public Memory() {
            this.superClass = null;
            this.isClass = true;
            this.javaDoc = JavaDocSupport.createClassJavaDoc(null);
        }

        public Memory(ClassElement classElement) {
            super(classElement);
            this.superClass = classElement.getSuperclass();
            this.isClass = classElement.isClassOrInterface();
            this.javaDoc = classElement.getJavaDoc().isEmpty() ? JavaDocSupport.createClassJavaDoc(null) : JavaDocSupport.createClassJavaDoc(classElement.getJavaDoc().getRawText());
        }

        void updateNameToParent() {
            MemberElement memberElement = (MemberElement)this.element;
            if (memberElement.getDeclaringClass() == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(memberElement.getDeclaringClass().getName().getFullName());
            stringBuffer.append('.');
            String string = this.getName().getName();
            stringBuffer.append(string);
            this.setName(Identifier.create(stringBuffer.toString(), string));
        }

        void initialize(ClassElement classElement) {
            this.updateNameToParent();
            this.copyFrom(classElement);
        }

        public void copyFrom(ClassElement classElement) {
            this.changeInterfaces(classElement.getInterfaces(), 0);
            this.changeConstructors(classElement.getConstructors(), 0);
            this.changeMethods(classElement.getMethods(), 0);
            this.changeFields(classElement.getFields(), 0);
            this.changeClasses(classElement.getClasses(), 0);
        }

        public void setSuperclass(Identifier identifier) throws SourceException {
            Identifier identifier2 = this.superClass;
            this.superClass = identifier;
            this.firePropertyChange("superclass", identifier2, identifier);
        }

        public Identifier getSuperclass() {
            return this.superClass;
        }

        public void setClassOrInterface(boolean bl) {
            boolean bl2 = this.isClass;
            this.isClass = bl;
            this.firePropertyChange("classOrInterface", new Boolean(bl2), new Boolean(bl));
        }

        public boolean isClassOrInterface() {
            return this.isClass;
        }

        public synchronized void changeInitializers(InitializerElement[] initializerElementArray, int n) {
            this.initInitializers();
            this.initializers.change(initializerElementArray, n);
        }

        public synchronized InitializerElement[] getInitializers() {
            this.initInitializers();
            return (InitializerElement[])this.initializers.toArray();
        }

        void initInitializers() {
            if (this.initializers == null) {
                this.initializers = new MemoryCollection.Initializer(this);
            }
        }

        public synchronized void changeFields(FieldElement[] fieldElementArray, int n) {
            this.initFields();
            this.fields.change(fieldElementArray, n);
        }

        public synchronized FieldElement[] getFields() {
            this.initFields();
            return (FieldElement[])this.fields.toArray();
        }

        public synchronized FieldElement getField(Identifier identifier) {
            this.initFields();
            return (FieldElement)this.fields.find(identifier, null);
        }

        void initFields() {
            if (this.fields == null) {
                this.fields = new MemoryCollection.Field(this);
            }
        }

        public synchronized void changeMethods(MethodElement[] methodElementArray, int n) {
            this.initMethods();
            this.methods.change(methodElementArray, n);
        }

        public MethodElement[] getMethods() {
            this.initMethods();
            return (MethodElement[])this.methods.toArray();
        }

        public synchronized MethodElement getMethod(Identifier identifier, Type[] typeArray) {
            this.initMethods();
            return (MethodElement)this.methods.find(identifier, typeArray);
        }

        void initMethods() {
            if (this.methods == null) {
                this.methods = new MemoryCollection.Method(this);
            }
        }

        public synchronized void changeConstructors(ConstructorElement[] constructorElementArray, int n) {
            this.initConstructors();
            this.constructors.change(constructorElementArray, n);
        }

        public synchronized ConstructorElement[] getConstructors() {
            this.initConstructors();
            return (ConstructorElement[])this.constructors.toArray();
        }

        public synchronized ConstructorElement getConstructor(Type[] typeArray) {
            this.initConstructors();
            return (ConstructorElement)this.constructors.find(null, typeArray);
        }

        void initConstructors() {
            if (this.constructors == null) {
                this.constructors = new MemoryCollection.Constructor(this);
            }
        }

        public synchronized void changeClasses(ClassElement[] classElementArray, int n) {
            this.initClasses();
            this.classes.change(classElementArray, n);
        }

        public synchronized ClassElement[] getClasses() {
            this.initClasses();
            return (ClassElement[])this.classes.toArray();
        }

        public synchronized ClassElement getClass(Identifier identifier) {
            this.initClasses();
            return (ClassElement)this.classes.find(identifier, null);
        }

        void initClasses() {
            if (this.classes == null) {
                this.classes = new MemoryCollection.Class(this);
            }
        }

        public synchronized void changeInterfaces(Identifier[] identifierArray, int n) {
            this.initInterfaces();
            this.interfaces.change(identifierArray, n);
        }

        public synchronized Identifier[] getInterfaces() {
            this.initInterfaces();
            return (Identifier[])this.interfaces.toArray();
        }

        void initInterfaces() {
            if (this.interfaces == null) {
                this.interfaces = new MemoryCollection.Interface(this);
            }
        }

        void markCurrent(Element element, boolean bl) {
            MemoryCollection memoryCollection;
            if (element instanceof InitializerElement) {
                memoryCollection = this.initializers;
            } else if (element instanceof ClassElement) {
                memoryCollection = this.classes;
            } else if (element instanceof FieldElement) {
                memoryCollection = this.fields;
            } else if (element instanceof MethodElement) {
                memoryCollection = this.methods;
            } else if (element instanceof ConstructorElement) {
                memoryCollection = this.constructors;
            } else {
                throw new IllegalArgumentException();
            }
            memoryCollection.markCurrent(element, bl);
        }

        public JavaDoc.Class getJavaDoc() {
            return this.javaDoc;
        }

        final ClassElement getClassElement() {
            return (ClassElement)this.element;
        }

        public Object readResolve() {
            return new ClassElement((Impl)this, (SourceElement)null);
        }
    }

    public static interface Impl
    extends MemberElement.Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;
        public static final long serialVersionUID = 2564194659099459416L;

        public void setSuperclass(Identifier var1) throws SourceException;

        public Identifier getSuperclass();

        public void setClassOrInterface(boolean var1) throws SourceException;

        public boolean isClassOrInterface();

        public void changeInitializers(InitializerElement[] var1, int var2) throws SourceException;

        public InitializerElement[] getInitializers();

        public void changeFields(FieldElement[] var1, int var2) throws SourceException;

        public FieldElement[] getFields();

        public FieldElement getField(Identifier var1);

        public void changeMethods(MethodElement[] var1, int var2) throws SourceException;

        public MethodElement[] getMethods();

        public MethodElement getMethod(Identifier var1, Type[] var2);

        public void changeConstructors(ConstructorElement[] var1, int var2) throws SourceException;

        public ConstructorElement[] getConstructors();

        public ConstructorElement getConstructor(Type[] var1);

        public void changeClasses(ClassElement[] var1, int var2) throws SourceException;

        public ClassElement[] getClasses();

        public ClassElement getClass(Identifier var1);

        public void changeInterfaces(Identifier[] var1, int var2) throws SourceException;

        public Identifier[] getInterfaces();

        public JavaDoc.Class getJavaDoc();
    }

    public static interface Finder {
        public ClassElement find(Class var1);

        public ClassElement find(String var1);
    }
}

