/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Dialog;
import java.awt.Frame;
import java.beans.Customizer;
import java.util.Hashtable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.propertysheet.editors.NodeCustomizer;
import org.openide.explorer.view.NodeRenderer;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Index;
import org.openide.nodes.IndexedCustomizer;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;

abstract class TMUtil {
    private static final ThreadLocal TALK = new ThreadLocal();
    private static Hashtable algorithms = new Hashtable(10);
    private static Frame owner;

    TMUtil() {
    }

    static Node.Cookie createInstanceCookie(Object object) {
        try {
            TALK.set(object);
            Node.Cookie cookie = TMUtil.exec("Bean") ? (Node.Cookie)TALK.get() : null;
            Object var3_2 = null;
            TALK.set(null);
            return cookie;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            TALK.set(null);
            throw throwable;
        }
    }

    static HelpCtx findHelp(BeanNode beanNode) {
        TALK.set(beanNode);
        return TMUtil.exec("Help") ? (HelpCtx)TALK.get() : null;
    }

    static Dialog createDialog(Object object) {
        TALK.set(object);
        return TMUtil.exec("Dial") ? (Dialog)TALK.get() : null;
    }

    static void attachCustomizer(Node node, Customizer customizer) {
        TALK.set(new Object[]{node, customizer});
        TMUtil.exec("Cust");
    }

    static Frame mainWindow() {
        if (TMUtil.exec("Win")) {
            return (Frame)TALK.get();
        }
        if (owner == null) {
            owner = (Frame)new JDialog().getOwner();
        }
        return owner;
    }

    static ListCellRenderer findListCellRenderer() {
        if (TMUtil.exec("Rend")) {
            return (ListCellRenderer)TALK.get();
        }
        return new DefaultListCellRenderer();
    }

    static void showIndexedCustomizer(Index index) {
        TALK.set(index);
        if (!TMUtil.exec("IndexC")) {
            final IndexedCustomizer indexedCustomizer = new IndexedCustomizer();
            indexedCustomizer.setObject(index);
            indexedCustomizer.setImmediateReorder(false);
            Mutex.EVENT.readAccess(new Mutex.Action(){

                public Object run() {
                    indexedCustomizer.show();
                    return null;
                }
            });
        }
    }

    private static boolean exec(String string) {
        Object object = algorithms.get(string);
        if (object == null) {
            try {
                Class<?> clazz = Class.forName("org.openide.nodes.TMUtil$" + string);
                object = clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                object = classNotFoundException;
                NodeOp.exception(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                object = instantiationException;
            }
            catch (IllegalAccessException illegalAccessException) {
                object = illegalAccessException;
                NodeOp.exception(illegalAccessException);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                object = noClassDefFoundError;
            }
            algorithms.put(string, object);
        }
        try {
            if (object instanceof Runnable) {
                ((Runnable)object).run();
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            algorithms.put(string, noClassDefFoundError);
        }
        return false;
    }

    static final class IndexC
    implements Runnable {
        IndexC() {
        }

        public void run() {
            Index index = (Index)TALK.get();
            JPanel jPanel = new JPanel();
            IndexedCustomizer indexedCustomizer = new IndexedCustomizer(jPanel, false);
            indexedCustomizer.setObject(index);
            indexedCustomizer.setImmediateReorder(false);
            DialogDescriptor dialogDescriptor = new DialogDescriptor(jPanel, Node.getString("LAB_order"));
            dialogDescriptor.setModal(true);
            dialogDescriptor.setOptionType(-1);
            Object object = TopManager.getDefault().notify(dialogDescriptor);
            if (object == NotifyDescriptor.OK_OPTION) {
                indexedCustomizer.doClose();
            }
        }
    }

    static final class Rend
    implements Runnable {
        Rend() {
        }

        public void run() {
            TALK.set(new NodeRenderer());
        }
    }

    static final class Win
    implements Runnable {
        Win() {
        }

        public void run() {
            TALK.set(TopManager.getDefault().getWindowManager().getMainWindow());
        }
    }

    static final class Cust
    implements Runnable {
        Cust() {
        }

        public void run() {
            Object[] objectArray = (Object[])TALK.get();
            Node node = (Node)objectArray[0];
            Object object = objectArray[1];
            if (object instanceof NodeCustomizer) {
                ((NodeCustomizer)object).attach(node);
            }
        }
    }

    static final class Dial
    implements Runnable {
        Dial() {
        }

        public void run() {
            Object t = TALK.get();
            if (t instanceof DialogDescriptor) {
                TALK.set(TopManager.getDefault().createDialog((DialogDescriptor)t));
            } else {
                TALK.set(null);
            }
        }
    }

    static final class Help
    implements Runnable {
        static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;

        Help() {
        }

        public void run() {
            BeanNode beanNode = (BeanNode)TALK.get();
            HelpCtx helpCtx = InstanceSupport.findHelp((InstanceCookie)beanNode.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = Help.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie));
            TALK.set(helpCtx);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    static final class Bean
    implements Runnable,
    InstanceCookie {
        private Object bean;

        Bean() {
        }

        public void run() {
            Bean bean = new Bean();
            bean.bean = TALK.get();
            TALK.set(bean);
        }

        public String instanceName() {
            return this.bean.getClass().getName();
        }

        public Class instanceClass() {
            return this.bean.getClass();
        }

        public Object instanceCreate() {
            return this.bean;
        }
    }
}

