/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.openide.nodes.Node;

public final class Sheet {
    private ArrayList sets;
    private Node.PropertySet[] array;
    private PropertyChangeSupport supp = new PropertyChangeSupport(this);
    private PropertyChangeListener propL = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Sheet.this.supp.firePropertyChange(null, null, null);
        }
    };
    public static final String PROPERTIES = "properties";
    public static final String EXPERT = "expert";

    public Sheet() {
        this(new ArrayList(2));
    }

    private Sheet(ArrayList arrayList) {
        this.sets = arrayList;
    }

    public final Node.PropertySet[] toArray() {
        Node.PropertySet[] propertySetArray = this.array;
        if (propertySetArray != null) {
            return propertySetArray;
        }
        Sheet sheet = this;
        synchronized (sheet) {
            if (this.array != null) {
                Node.PropertySet[] propertySetArray2 = this.array;
                return propertySetArray2;
            }
            this.array = new Node.PropertySet[this.sets.size()];
            this.sets.toArray(this.array);
            Node.PropertySet[] propertySetArray3 = this.array;
            return propertySetArray3;
        }
    }

    public synchronized Sheet cloneSheet() {
        int n = this.sets.size();
        ArrayList<Set> arrayList = new ArrayList<Set>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(((Set)this.sets.get(n2)).cloneSet());
            ++n2;
        }
        return new Sheet(arrayList);
    }

    public synchronized Set get(String string) {
        int n = this.findIndex(string);
        return n == -1 ? null : (Set)this.sets.get(n);
    }

    public synchronized Set put(Set set) {
        Set set2;
        int n = this.findIndex(set.getName());
        if (n == -1) {
            this.sets.add(set);
            set2 = null;
        } else {
            set2 = this.sets.set(n, set);
        }
        set.addPropertyChangeListener(this.propL);
        if (set2 != null) {
            set.removePropertyChangeListener(this.propL);
        }
        this.refresh();
        return set2;
    }

    public synchronized Set remove(String string) {
        int n = this.findIndex(string);
        if (n != -1) {
            Set set = (Set)this.sets.remove(n);
            set.removePropertyChangeListener(this.propL);
            this.refresh();
            return set;
        }
        return null;
    }

    public static Sheet createDefault() {
        Sheet sheet = new Sheet();
        sheet.put(Sheet.createPropertiesSet());
        return sheet;
    }

    public static Set createPropertiesSet() {
        Set set = new Set();
        set.setName(PROPERTIES);
        set.setDisplayName(Node.getString("Properties"));
        set.setShortDescription(Node.getString("HINT_Properties"));
        return set;
    }

    public static Set createExpertSet() {
        Set set = new Set();
        set.setName(EXPERT);
        set.setDisplayName(Node.getString("Expert"));
        set.setShortDescription(Node.getString("HINT_Expert"));
        return set;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.supp.removePropertyChangeListener(propertyChangeListener);
    }

    private int findIndex(String string) {
        int n = this.sets.size();
        int n2 = 0;
        while (n2 < n) {
            Node.PropertySet propertySet = (Node.PropertySet)this.sets.get(n2);
            if (propertySet.getName().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private void refresh() {
        this.array = null;
        this.supp.firePropertyChange(null, null, null);
    }

    public static final class Set
    extends Node.PropertySet {
        private ArrayList props;
        private Node.Property[] array;
        private PropertyChangeSupport supp = new PropertyChangeSupport(this);

        public Set() {
            this(new ArrayList());
        }

        private Set(ArrayList arrayList) {
            this.props = arrayList;
        }

        public synchronized Set cloneSet() {
            return new Set((ArrayList)this.props.clone());
        }

        public Node.Property get(String string) {
            int n = this.findIndex(string);
            return n == -1 ? null : (Node.Property)this.props.get(n);
        }

        public Node.Property[] getProperties() {
            Node.Property[] propertyArray = this.array;
            if (propertyArray != null) {
                return propertyArray;
            }
            Set set = this;
            synchronized (set) {
                if (this.array != null) {
                    Node.Property[] propertyArray2 = this.array;
                    return propertyArray2;
                }
                this.array = new Node.Property[this.props.size()];
                this.props.toArray(this.array);
                Node.Property[] propertyArray3 = this.array;
                return propertyArray3;
            }
        }

        public synchronized Node.Property put(Node.Property property) {
            Node.Property property2;
            int n = this.findIndex(property.getName());
            if (n != -1) {
                property2 = this.props.set(n, property);
            } else {
                this.props.add(property);
                property2 = null;
            }
            this.refresh();
            return property2;
        }

        public synchronized void put(Node.Property[] propertyArray) {
            int n = 0;
            while (n < propertyArray.length) {
                Node.Property property = propertyArray[n];
                property = propertyArray[n];
                int n2 = this.findIndex(property.getName());
                if (n2 != -1) {
                    this.props.set(n2, property);
                } else {
                    this.props.add(property);
                }
                ++n;
            }
            this.refresh();
        }

        public synchronized Node.Property remove(String string) {
            int n = this.findIndex(string);
            if (n != -1) {
                try {
                    Node.Property property = (Node.Property)this.props.remove(n);
                    Object var5_4 = null;
                    this.refresh();
                    return property;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.refresh();
                    throw throwable;
                }
            }
            return null;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.supp.removePropertyChangeListener(propertyChangeListener);
        }

        private int findIndex(String string) {
            int n = this.props.size();
            int n2 = 0;
            while (n2 < n) {
                Node.Property property = (Node.Property)this.props.get(n2);
                if (property.getName().equals(string)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        private void refresh() {
            this.array = null;
            this.supp.firePropertyChange(null, null, null);
        }
    }
}

