/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public abstract class Node
extends FeatureDescriptor {
    public static final Node EMPTY = new AbstractNode(Children.LEAF);
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_NAME = "name";
    public static final String PROP_SHORT_DESCRIPTION = "shortDescription";
    public static final String PROP_ICON = "icon";
    public static final String PROP_OPENED_ICON = "openedIcon";
    public static final String PROP_PARENT_NODE = "parentNode";
    public static final String PROP_PROPERTY_SETS = "propertySets";
    public static final String PROP_COOKIE = "cookie";
    static transient ErrorManager err;
    private Children parent;
    Children hierarchy;
    private transient EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$openide$nodes$NodeListener;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$org$openide$nodes$Node;

    protected Node(Children children) throws IllegalStateException {
        ErrorManager errorManager;
        this.hierarchy = children;
        children.attachTo(this);
        if (err == null && (errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = Node.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager)) != null) {
            err = errorManager.getInstance("org.openide.nodes.Node");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        Node node = (Node)super.clone();
        this.hierarchy = this.hierarchy instanceof Cloneable ? (Children)this.hierarchy.cloneHierarchy() : Children.LEAF;
        this.hierarchy.attachTo(node);
        node.parent = null;
        node.listeners = new EventListenerList();
        return node;
    }

    public abstract Node cloneNode();

    final synchronized void assignTo(Children children, int n) {
        if (this.parent != null && this.parent != children) {
            throw new IllegalStateException("Cannot initialize " + n + "th child of node " + children.getNode() + "; it already belongs to node " + this.parent.getNode());
        }
        this.parent = children;
    }

    final synchronized void deassignFrom(Children children) {
        if (children != this.parent) {
            throw new IllegalArgumentException("Deassign from wrong parent. Old: " + this.parent + " Caller: " + children);
        }
        this.parent = null;
    }

    public void setName(String string) {
        String string2 = super.getName();
        if (string2 == null || !string2.equals(string)) {
            super.setName(string);
            this.fireNameChange(string2, string);
        }
    }

    public void setDisplayName(String string) {
        String string2 = super.getDisplayName();
        if (string2 == null || !string2.equals(string)) {
            super.setDisplayName(string);
            this.fireDisplayNameChange(string2, string);
        }
    }

    public void setShortDescription(String string) {
        String string2 = super.getShortDescription();
        if (string2 == null || !string2.equals(string)) {
            super.setShortDescription(string);
            this.fireShortDescriptionChange(string2, string);
        }
    }

    public abstract Image getIcon(int var1);

    public abstract Image getOpenedIcon(int var1);

    public abstract HelpCtx getHelpCtx();

    public final Children getChildren() {
        return this.hierarchy;
    }

    public final boolean isLeaf() {
        return this.hierarchy == Children.LEAF;
    }

    public final Node getParentNode() {
        return this.parent == null ? null : this.parent.getNode();
    }

    public abstract boolean canRename();

    public abstract boolean canDestroy();

    public void destroy() throws IOException {
        Children.MUTEX.postWriteRequest(new Runnable(){

            public void run() {
                if (Node.this.parent != null) {
                    Node.this.parent.remove(new Node[]{Node.this});
                }
                Node.this.fireNodeDestroyed();
            }
        });
    }

    public abstract PropertySet[] getPropertySets();

    public abstract Transferable clipboardCopy() throws IOException;

    public abstract Transferable clipboardCut() throws IOException;

    public abstract Transferable drag() throws IOException;

    public abstract boolean canCopy();

    public abstract boolean canCut();

    public abstract PasteType[] getPasteTypes(Transferable var1);

    public abstract PasteType getDropType(Transferable var1, int var2, int var3);

    public abstract NewType[] getNewTypes();

    public SystemAction[] getActions() {
        return NodeOp.getDefaultActions();
    }

    public SystemAction[] getContextActions() {
        return this.getActions();
    }

    public abstract SystemAction getDefaultAction();

    public final JPopupMenu getContextMenu() {
        return NodeOp.findContextMenuImpl(new Node[]{this});
    }

    public abstract boolean hasCustomizer();

    public abstract Component getCustomizer();

    public abstract Cookie getCookie(Class var1);

    public abstract Handle getHandle();

    public final void addNodeListener(NodeListener nodeListener) {
        this.listeners.add(class$org$openide$nodes$NodeListener == null ? (class$org$openide$nodes$NodeListener = Node.class$("org.openide.nodes.NodeListener")) : class$org$openide$nodes$NodeListener, nodeListener);
    }

    public final void removeNodeListener(NodeListener nodeListener) {
        this.listeners.remove(class$org$openide$nodes$NodeListener == null ? (class$org$openide$nodes$NodeListener = Node.class$("org.openide.nodes.NodeListener")) : class$org$openide$nodes$NodeListener, nodeListener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl;
        int n = -1;
        boolean bl2 = bl = err != null && err.isLoggable(1);
        if (bl) {
            n = this.getPropertyChangeListenersCount();
        }
        this.listeners.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Node.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        if (bl) {
            err.log(1, "ADD - " + this.getName() + " [" + n + "]->[" + this.getPropertyChangeListenersCount() + "] " + propertyChangeListener);
        }
        this.notifyPropertyChangeListenerAdded(propertyChangeListener);
    }

    void notifyPropertyChangeListenerAdded(PropertyChangeListener propertyChangeListener) {
    }

    int getPropertyChangeListenersCount() {
        return this.listeners.getListenerCount(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Node.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener);
    }

    protected final boolean hasPropertyChangeListener() {
        return this.getPropertyChangeListenersCount() > 0;
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        int n = -1;
        if (err.isLoggable(1)) {
            n = this.getPropertyChangeListenersCount();
        }
        this.listeners.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = Node.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, propertyChangeListener);
        if (err.isLoggable(1)) {
            err.log(1, "RMV - " + this.getName() + " [" + n + "]->[" + this.getPropertyChangeListenersCount() + "] " + propertyChangeListener);
        }
        this.notifyPropertyChangeListenerRemoved(propertyChangeListener);
    }

    void notifyPropertyChangeListenerRemoved(PropertyChangeListener propertyChangeListener) {
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && (object == object2 || object.equals(object2))) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$java$beans$PropertyChangeListener == null ? Node.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                }
                ((PropertyChangeListener)objectArray[n + 1]).propertyChange(propertyChangeEvent);
            }
            n -= 2;
        }
    }

    protected final void fireNameChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_NAME, string, string2);
    }

    protected final void fireDisplayNameChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_DISPLAY_NAME, string, string2);
    }

    protected final void fireShortDescriptionChange(String string, String string2) {
        this.fireOwnPropertyChange(PROP_SHORT_DESCRIPTION, string, string2);
    }

    protected final void fireIconChange() {
        this.fireOwnPropertyChange(PROP_ICON, null, null);
    }

    protected final void fireOpenedIconChange() {
        this.fireOwnPropertyChange(PROP_OPENED_ICON, null, null);
    }

    final void fireSubNodesChange(boolean bl, Node[] nodeArray, Node[] nodeArray2) {
        NodeMemberEvent nodeMemberEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) {
                if (nodeMemberEvent == null) {
                    nodeMemberEvent = new NodeMemberEvent(this, bl, nodeArray, nodeArray2);
                }
                if (bl) {
                    ((NodeListener)objectArray[n + 1]).childrenAdded(nodeMemberEvent);
                } else {
                    ((NodeListener)objectArray[n + 1]).childrenRemoved(nodeMemberEvent);
                }
            }
            n -= 2;
        }
    }

    final void fireReorderChange(int[] nArray) {
        NodeReorderEvent nodeReorderEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) {
                if (nodeReorderEvent == null) {
                    nodeReorderEvent = new NodeReorderEvent(this, nArray);
                }
                ((NodeListener)objectArray[n + 1]).childrenReordered(nodeReorderEvent);
            }
            n -= 2;
        }
    }

    protected final void fireNodeDestroyed() {
        NodeEvent nodeEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) {
                if (nodeEvent == null) {
                    nodeEvent = new NodeEvent(this);
                }
                ((NodeListener)objectArray[n + 1]).nodeDestroyed(nodeEvent);
            }
            n -= 2;
        }
    }

    final void fireParentNodeChange(Node node, Node node2) {
        this.fireOwnPropertyChange(PROP_PARENT_NODE, node, node2);
    }

    protected final void firePropertySetsChange(PropertySet[] propertySetArray, PropertySet[] propertySetArray2) {
        this.fireOwnPropertyChange(PROP_PROPERTY_SETS, propertySetArray, propertySetArray2);
    }

    protected final void fireCookieChange() {
        this.fireOwnPropertyChange(PROP_COOKIE, null, null);
    }

    final void fireOwnPropertyChange(String string, Object object, Object object2) {
        if (object != null && object2 != null && (object == object2 || object.equals(object2))) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = null;
        Object[] objectArray = this.listeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$openide$nodes$NodeListener == null ? Node.class$("org.openide.nodes.NodeListener") : class$org$openide$nodes$NodeListener)) {
                if (propertyChangeEvent == null) {
                    propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                }
                ((NodeListener)objectArray[n + 1]).propertyChange(propertyChangeEvent);
            }
            n -= 2;
        }
    }

    static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$nodes$Node == null ? (class$org$openide$nodes$Node = Node.class$("org.openide.nodes.Node")) : class$org$openide$nodes$Node).getString(string);
    }

    public String toString() {
        return super.toString() + "[Name=" + this.getName() + ", displayName=" + this.getDisplayName() + "]";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Handle
    extends Serializable {
        public static final long serialVersionUID = -4518262478987434353L;

        public Node getNode() throws IOException;
    }

    public static interface Cookie {
    }

    public static abstract class IndexedProperty
    extends Property {
        private Class elementType;

        public IndexedProperty(Class clazz, Class clazz2) {
            super(clazz);
            this.elementType = clazz2;
        }

        public abstract boolean canIndexedRead();

        public Class getElementType() {
            return this.elementType;
        }

        public abstract Object getIndexedValue(int var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public abstract boolean canIndexedWrite();

        public abstract void setIndexedValue(int var1, Object var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public PropertyEditor getIndexedPropertyEditor() {
            return PropertyEditorManager.findEditor(this.elementType);
        }
    }

    public static abstract class Property
    extends FeatureDescriptor {
        private Class type;

        public Property(Class clazz) {
            this.type = clazz;
            super.setName("");
        }

        public Class getValueType() {
            return this.type;
        }

        public abstract boolean canRead();

        public abstract Object getValue() throws IllegalAccessException, InvocationTargetException;

        public abstract boolean canWrite();

        public abstract void setValue(Object var1) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

        public boolean supportsDefaultValue() {
            return false;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        }

        public PropertyEditor getPropertyEditor() {
            if (this.type == null) {
                return null;
            }
            return PropertyEditorManager.findEditor(this.type);
        }

        public boolean equals(Object object) {
            try {
                return ((Property)object).getName().equals(this.getName()) && ((Property)object).getValueType().equals(this.getValueType());
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.getName().hashCode() * this.getValueType().hashCode();
        }
    }

    public static abstract class PropertySet
    extends FeatureDescriptor {
        public PropertySet() {
        }

        public PropertySet(String string, String string2, String string3) {
            super.setName(string);
            super.setDisplayName(string2);
            super.setShortDescription(string3);
        }

        public abstract Property[] getProperties();

        public boolean equals(Object object) {
            if (!(object instanceof PropertySet)) {
                return false;
            }
            return ((PropertySet)object).getName().equals(this.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }
    }
}

