/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.TMUtil;

public interface Index
extends Node.Cookie {
    public int getNodesCount();

    public Node[] getNodes();

    public int indexOf(Node var1);

    public void reorder();

    public void reorder(int[] var1);

    public void move(int var1, int var2);

    public void exchange(int var1, int var2);

    public void moveUp(int var1);

    public void moveDown(int var1);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static abstract class KeysChildren
    extends Children.Keys {
        private Index support;
        protected final List list;

        public KeysChildren(List list) {
            this.list = list;
            this.update();
        }

        public Index getIndex() {
            KeysChildren keysChildren = this;
            synchronized (keysChildren) {
                if (this.support == null) {
                    this.support = this.createIndex();
                }
                Index index = this.support;
                return index;
            }
        }

        protected Index createIndex() {
            return new Support(this){
                private final /* synthetic */ KeysChildren this$0;
                {
                    this.this$0 = keysChildren;
                }

                public Node[] getNodes() {
                    List<Node> list = Arrays.asList(this.this$0.getNodes());
                    if (this.this$0.nodes != null) {
                        list.removeAll(this.this$0.nodes);
                    }
                    return list.toArray(new Node[list.size()]);
                }

                public int getNodesCount() {
                    return this.this$0.list.size();
                }

                public void reorder(int[] nArray) {
                    this.this$0.reorder(nArray);
                    this.this$0.update();
                    this.fireChangeEvent(new ChangeEvent(this));
                }
            };
        }

        protected void reorder(int[] nArray) {
            Object object = this.lock();
            synchronized (object) {
                Object[] objectArray = this.list.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    this.list.set(nArray[n], objectArray[n]);
                    ++n;
                }
            }
        }

        protected Object lock() {
            return this.list;
        }

        public final void update() {
            Object[] objectArray;
            Object object = this.lock();
            synchronized (object) {
                objectArray = this.list.toArray();
            }
            super.setKeys(objectArray);
        }
    }

    public static class ArrayChildren
    extends Children.Array
    implements Index {
        protected Index support = new Support(this){
            private final /* synthetic */ ArrayChildren this$0;
            {
                this.this$0 = arrayChildren;
            }

            public Node[] getNodes() {
                return this.this$0.getNodes();
            }

            public int getNodesCount() {
                return this.this$0.getNodesCount();
            }

            public void reorder(int[] nArray) {
                this.this$0.reorder(nArray);
                this.fireChangeEvent(new ChangeEvent(this.this$0));
            }
        };

        public ArrayChildren() {
            this(null);
        }

        private ArrayChildren(List list) {
            super(list);
        }

        protected Collection initCollection() {
            return new ArrayList();
        }

        public void reorder(int[] nArray) {
            try {
                Children.PR.enterWriteAccess();
                Object[] objectArray = this.nodes.toArray();
                List list = (List)this.nodes;
                int n = 0;
                while (n < objectArray.length) {
                    list.set(nArray[n], objectArray[n]);
                    ++n;
                }
                this.refresh();
                Object var6_5 = null;
                Children.PR.exitWriteAccess();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Children.PR.exitWriteAccess();
                throw throwable;
            }
        }

        public void reorder() {
            try {
                Children.PR.enterReadAccess();
                Support.showIndexedCustomizer(this);
                Object var2_1 = null;
                Children.PR.exitReadAccess();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Children.PR.exitReadAccess();
                throw throwable;
            }
        }

        public void move(int n, int n2) {
            this.support.move(n, n2);
        }

        public void exchange(int n, int n2) {
            this.support.exchange(n, n2);
        }

        public void moveUp(int n) {
            this.support.exchange(n, n - 1);
        }

        public void moveDown(int n) {
            this.support.exchange(n, n + 1);
        }

        public int indexOf(Node node) {
            try {
                Children.PR.enterWriteAccess();
                int n = ((List)this.nodes).indexOf(node);
                Object var4_3 = null;
                Children.PR.exitWriteAccess();
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                Children.PR.exitWriteAccess();
                throw throwable;
            }
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.support.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.support.removeChangeListener(changeListener);
        }
    }

    public static abstract class Support
    implements Index {
        private HashSet listeners;

        public void move(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = n3 >= n && n3 < n2 ? n3 - 1 : (n3 >= n2 && n3 < n ? n3 + 1 : n3);
                ++n3;
            }
            nArray[n] = n2;
            nArray[n2] = n;
            this.reorder(nArray);
        }

        public void exchange(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = n3;
                ++n3;
            }
            nArray[n] = n2;
            nArray[n2] = n;
            this.reorder(nArray);
        }

        public void moveUp(int n) {
            this.exchange(n, n - 1);
        }

        public void moveDown(int n) {
            this.exchange(n, n + 1);
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new HashSet();
            }
            this.listeners.add(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        protected void fireChangeEvent(ChangeEvent changeEvent) {
            HashSet hashSet;
            if (this.listeners == null) {
                return;
            }
            Support support = this;
            synchronized (support) {
                hashSet = (HashSet)this.listeners.clone();
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }

        public abstract Node[] getNodes();

        public int indexOf(Node node) {
            Node[] nodeArray = this.getNodes();
            int n = 0;
            while (n < nodeArray.length) {
                if (node.equals(nodeArray[n])) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public void reorder() {
            Support.showIndexedCustomizer(this);
        }

        public static void showIndexedCustomizer(Index index) {
            TMUtil.showIndexedCustomizer(index);
        }

        public abstract int getNodesCount();

        public abstract void reorder(int[] var1);
    }
}

