/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.nodes.Node;

public final class CookieSet {
    private HashMap map = new HashMap(31);
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$openide$nodes$Node$Cookie;

    public void add(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    public void remove(Node.Cookie cookie) {
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.unregisterCookie(cookie.getClass(), cookie);
        }
        this.fireChangeEvent();
    }

    public synchronized Node.Cookie getCookie(Class clazz) {
        R r = this.findR(clazz);
        if (r != null) {
            Node.Cookie cookie = r.cookie();
            if (cookie instanceof CookieEntry) {
                cookie = ((CookieEntry)cookie).getCookie();
            }
            return cookie;
        }
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CookieSet.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = CookieSet.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    private void fireChangeEvent() {
        Object[] objectArray = this.listeners.getListenerList();
        if (objectArray.length > 0) {
            ChangeEvent changeEvent = null;
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? CookieSet.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                    if (changeEvent == null) {
                        changeEvent = new ChangeEvent(this);
                    }
                    ((ChangeListener)objectArray[n + 1]).stateChanged(changeEvent);
                }
                n -= 2;
            }
        }
    }

    private void registerCookie(Class clazz, Node.Cookie cookie) {
        if (clazz == null || !(class$org$openide$nodes$Node$Cookie == null ? (class$org$openide$nodes$Node$Cookie = CookieSet.class$("org.openide.nodes.Node$Cookie")) : class$org$openide$nodes$Node$Cookie).isAssignableFrom(clazz)) {
            return;
        }
        R r = this.findR(clazz);
        if (r == null) {
            r = new R();
            this.map.put(clazz, r);
        }
        r.add(cookie);
        this.registerCookie(clazz.getSuperclass(), cookie);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            this.registerCookie(classArray[n], cookie);
            ++n;
        }
    }

    private void unregisterCookie(Class clazz, Node.Cookie cookie) {
        if (clazz == null || !(class$org$openide$nodes$Node$Cookie == null ? (class$org$openide$nodes$Node$Cookie = CookieSet.class$("org.openide.nodes.Node$Cookie")) : class$org$openide$nodes$Node$Cookie).isAssignableFrom(clazz)) {
            return;
        }
        R r = this.findR(clazz);
        if (r != null) {
            r.remove(cookie);
        }
        this.unregisterCookie(clazz.getSuperclass(), cookie);
        Class<?>[] classArray = clazz.getInterfaces();
        int n = 0;
        while (n < classArray.length) {
            this.unregisterCookie(classArray[n], cookie);
            ++n;
        }
    }

    public void add(Class clazz, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            this.registerCookie(clazz, new CookieEntry(factory, clazz));
        }
        this.fireChangeEvent();
    }

    public void add(Class[] classArray, Factory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        CookieSet cookieSet = this;
        synchronized (cookieSet) {
            int n = 0;
            while (n < classArray.length) {
                this.registerCookie(classArray[n], new CookieEntry(factory, classArray[n]));
                ++n;
            }
        }
        this.fireChangeEvent();
    }

    private R findR(Class clazz) {
        return (R)this.map.get(clazz);
    }

    private static Class baseForCookie(Node.Cookie cookie) {
        if (cookie instanceof CookieEntry) {
            return ((CookieEntry)cookie).klass;
        }
        return cookie.getClass();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class R {
        public List cookies;
        public Class base;

        private R() {
        }

        public void add(Node.Cookie cookie) {
            if (this.cookies == null) {
                this.cookies = new ArrayList(1);
                this.cookies.add(cookie);
                this.base = CookieSet.baseForCookie(cookie);
                return;
            }
            Class clazz = CookieSet.baseForCookie(cookie);
            if (this.base == null || clazz.isAssignableFrom(this.base)) {
                this.cookies.set(0, cookie);
                this.base = clazz;
            } else {
                this.cookies.add(cookie);
            }
        }

        public boolean remove(Node.Cookie cookie) {
            if (this.cookies == null) {
                return true;
            }
            if (this.cookies.remove(cookie) && this.cookies.size() == 0) {
                this.base = null;
                this.cookies = null;
                return true;
            }
            this.base = CookieSet.baseForCookie((Node.Cookie)this.cookies.get(0));
            return false;
        }

        public Node.Cookie cookie() {
            return this.cookies == null || this.cookies.isEmpty() ? null : (Node.Cookie)this.cookies.get(0);
        }
    }

    private static class CookieEntry
    implements Node.Cookie {
        private final Factory factory;
        private final Class klass;
        private Reference cookie;

        public CookieEntry(Factory factory, Class clazz) {
            this.factory = factory;
            this.klass = clazz;
        }

        public Node.Cookie getCookie() {
            Node.Cookie cookie;
            if (this.cookie == null || (cookie = (Node.Cookie)this.cookie.get()) == null) {
                cookie = this.factory.createCookie(this.klass);
                if (cookie == null) {
                    return null;
                }
                this.cookie = new WeakReference<Node.Cookie>(cookie);
            }
            return cookie;
        }
    }

    public static interface Factory {
        public Node.Cookie createCookie(Class var1);
    }
}

