/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.beans.Beans;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.modules.IllegalModuleException;
import org.openide.modules.ManifestSection;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public final class ModuleDescription {
    private static final boolean VERBOSE;
    public static final Attributes.Name TAG_MAGIC;
    public static final Attributes.Name TAG_NAME;
    public static final Attributes.Name TAG_SHORT_DESCRIPTION;
    public static final Attributes.Name TAG_LONG_DESCRIPTION;
    public static final Attributes.Name TAG_CATEGORY;
    private static final Comparator codeNameComparator;
    public static final Attributes.Name TAG_SPEC_VERSION;
    public static final Attributes.Name TAG_IMPL_VERSION;
    public static final Attributes.Name TAG_MODULE_DEPENDENCIES;
    public static final Attributes.Name TAG_PACKAGE_DEPENDENCIES;
    public static final Attributes.Name TAG_JAVA_DEPENDENCIES;
    public static final Attributes.Name TAG_IDE_DEPENDENCIES;
    public static final Attributes.Name TAG_MAIN;
    public static final Attributes.Name TAG_LAYER;
    public static final Attributes.Name TAG_DESCRIPTION;
    public static final Attributes.Name TAG_SECTION_CLASS;
    public static final String SECTION_ACTION = "Action";
    public static final String SECTION_OPTION = "Option";
    public static final String SECTION_LOADER = "Loader";
    public static final Attributes.Name TAG_INSTALL_BEFORE;
    public static final Attributes.Name TAG_INSTALL_AFTER;
    public static final String SECTION_FILESYSTEM = "Filesystem";
    public static final Attributes.Name TAG_FILESYSTEM_NAME;
    public static final Attributes.Name TAG_FILESYSTEM_HELP;
    public static final String SECTION_SERVICE = "Service";
    public static final Attributes.Name TAG_SERVICE_DEFAULT;
    public static final String SECTION_DEBUGGER = "Debugger";
    public static final String SECTION_NODE = "Node";
    public static final Attributes.Name TAG_NODE_TYPE;
    public static final String SECTION_CLIPBOARD_CONVERTOR = "ClipboardConvertor";
    ClassLoader cl;
    private String moduleName;
    private String codeName;
    private String shortDescription;
    private String longDescription;
    private String displayCategory;
    private String mainClass;
    private boolean mainClassSer;
    private ModuleInstall main;
    private String layerResource;
    private URL layer;
    private String specVersion;
    private String implVersion;
    private Set dependenciesSet;
    private String description;
    private ManifestSection[] sections;
    private static ResourceBundle bundle;
    final Set badClasses = new HashSet();
    private static final ModuleInstall MODULE_NONE;
    static /* synthetic */ Class class$org$openide$modules$ModuleDescription;

    public ModuleDescription(String string, Manifest manifest) throws IllegalModuleException {
        this(string, manifest, TopManager.getDefault().currentClassLoader());
    }

    public ModuleDescription(String string, Manifest manifest, ClassLoader classLoader) throws IllegalModuleException {
        this.setClassLoader(classLoader);
        this.createDescription(string, manifest);
        if (VERBOSE) {
            System.err.println("Making module description for " + this);
            Enumeration enumeration = this.dependencies();
            while (enumeration.hasMoreElements()) {
                System.err.println("\t=>" + (Dependency)enumeration.nextElement());
            }
        }
    }

    public ModuleDescription(File file) throws IllegalModuleException, IOException {
        this(file.getPath(), new Manifest(new FileInputStream(file)), new URLClassLoader(new URL[]{file.getCanonicalFile().toURL()}, TopManager.getDefault().currentClassLoader()));
    }

    public ModuleDescription(String string) throws IllegalModuleException, IOException {
        this("/no/path/to/testManifest.mf", new Manifest(new ByteArrayInputStream(string.getBytes())));
    }

    public String getName() {
        return this.moduleName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getDisplayCategory() {
        return this.displayCategory;
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        int n = this.codeName.indexOf("/");
        if (n == -1) {
            return this.codeName;
        }
        return this.codeName.substring(0, n);
    }

    public int getCodeNameRelease() {
        int n = this.codeName.indexOf("/");
        if (n == -1) {
            return -1;
        }
        return Integer.parseInt(this.codeName.substring(n + 1));
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        if (this.cl != null && classLoader == null) {
            this.main = null;
            this.layer = null;
            this.badClasses.clear();
            int n = 0;
            while (n < this.sections.length) {
                this.sections[n].release();
                ++n;
            }
        }
        this.cl = classLoader;
        if (VERBOSE) {
            this.showLoader();
        }
    }

    public Set getBadClasses() {
        return Collections.unmodifiableSet(this.badClasses);
    }

    public synchronized ModuleInstall getModule() {
        try {
            if (this.mainClass != null) {
                this.main = this.mainClassSer ? (ModuleInstall)Beans.instantiate(this.cl, this.mainClass) : (ModuleInstall)SharedClassObject.findObject(Class.forName(this.mainClass, true, this.cl), true);
                if (!this.mainClassSer && this.main.getClass().getClassLoader() != this.cl) {
                    this.badClasses.add(this.main.getClass());
                }
            }
            this.mainClass = null;
        }
        catch (Exception exception) {
            if (exception instanceof ClassNotFoundException) {
                this.showLoader();
            }
            TopManager.getDefault().notifyException(exception);
        }
        if (this.main == null) {
            this.main = MODULE_NONE;
        }
        return this.main;
    }

    void showLoader() {
        if (!Boolean.getBoolean("netbeans.debug.exceptions")) {
            return;
        }
        System.err.println("Offending classloader: " + this.cl);
        ModuleDescription.showLoader0(this.cl);
    }

    private static void showLoader0(ClassLoader classLoader) {
        if (classLoader != null) {
            ModuleDescription.showLoader0(classLoader.getParent());
            if (classLoader instanceof URLClassLoader) {
                URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
                int n = 0;
                while (n < uRLArray.length) {
                    System.err.println("\t" + uRLArray[n]);
                    ++n;
                }
            }
        }
    }

    public synchronized URL getLayer() {
        if (this.layerResource != null) {
            try {
                int n = this.layerResource.lastIndexOf(46);
                if (n == -1) {
                    throw new MalformedURLException();
                }
                String string = this.layerResource.substring(0, n).replace('/', '.');
                String string2 = this.layerResource.substring(n + 1);
                this.layer = NbBundle.getLocalizedFile(string, string2, Locale.getDefault(), this.cl);
            }
            catch (Exception exception) {
                TopManager.getDefault().notifyException(exception);
            }
            this.layerResource = null;
        }
        return this.layer;
    }

    public String getLayerResource() {
        return this.layerResource;
    }

    public URL getDescription() {
        if (this.description == null) {
            return null;
        }
        ErrorManager errorManager = TopManager.getDefault().getErrorManager();
        if (this.cl == null) {
            throw (IllegalStateException)errorManager.annotate((Throwable)new IllegalStateException(), new NullPointerException());
        }
        try {
            return NbBundle.getLocalizedFile(this.description, "hs", Locale.getDefault(), this.cl);
        }
        catch (MissingResourceException missingResourceException) {
            IllegalStateException illegalStateException = new IllegalStateException();
            throw (IllegalStateException)errorManager.annotate((Throwable)illegalStateException, missingResourceException);
        }
    }

    public String getDescriptionResource() {
        if (this.description == null) {
            return null;
        }
        return this.description.replace('.', '/') + ".hs";
    }

    public synchronized void forEachSection(ManifestSection.Iterator iterator) {
        int n = this.sections.length;
        LinkedList<ManifestSection> linkedList = new LinkedList<ManifestSection>();
        int n2 = 0;
        while (n2 < n) {
            try {
                this.sections[n2].invokeIterator(iterator);
                linkedList.add(this.sections[n2]);
            }
            catch (Exception exception) {
                TopManager.getDefault().notifyException(exception);
            }
            ++n2;
        }
        if (this.sections.length > linkedList.size()) {
            this.sections = linkedList.toArray(new ManifestSection[linkedList.size()]);
        }
    }

    public Enumeration dependencies() {
        return Collections.enumeration(this.dependenciesSet);
    }

    public Dependency[] getDependencies() {
        return this.dependenciesSet.toArray(new Dependency[0]);
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public String reasonWhyUnsatisfied(ModuleDescription[] moduleDescriptionArray) throws IllegalModuleException {
        if (VERBOSE) {
            System.err.println("Checking all dependencies for " + this);
        }
        String string = null;
        Iterator iterator = this.dependenciesSet.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            String string2 = dependency.checkForMiss(moduleDescriptionArray);
            if (string2 == null) continue;
            string = string == null ? ModuleDescription.getStringFormatted("MSG_Why_Dep_Failed", this.getName(), this.getCodeName()) + string2 : string + "\n" + string2;
        }
        return string;
    }

    public boolean dependsOnModule(ModuleDescription moduleDescription) {
        if (this == moduleDescription || this.codeName.equals(moduleDescription.codeName)) {
            return true;
        }
        Iterator iterator = this.dependenciesSet.iterator();
        while (iterator.hasNext()) {
            Dependency dependency = (Dependency)iterator.next();
            if (dependency.getType() != 1 || !dependency.getName().equals(moduleDescription.getCodeName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return ModuleDescription.getStringFormatted("DBG_Module_ToString", this.getCodeName(), this.getName());
    }

    public static List resolveOrdering(Set set) throws IllegalModuleException {
        Object object;
        Iterator iterator;
        AbstractCollection abstractCollection;
        Object object2;
        Object object3;
        if (VERBOSE) {
            System.err.println("Incoming module list: ");
            object3 = set.iterator();
            while (object3.hasNext()) {
                System.err.println("\t" + (ModuleDescription)object3.next());
            }
        }
        object3 = new HashMap();
        Iterator iterator2 = set.iterator();
        while (iterator2.hasNext()) {
            object2 = (ModuleDescription)iterator2.next();
            abstractCollection = new HashSet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (ModuleDescription)iterator.next();
                if (object2 == object || !((ModuleDescription)object2).dependsOnModule((ModuleDescription)object)) continue;
                abstractCollection.add(object);
            }
            object3.put(object2, abstractCollection);
        }
        object2 = new TreeSet(codeNameComparator);
        object2.addAll(set);
        if (object2.size() != set.size()) {
            ModuleDescription.throwOverlapException(set, (SortedSet)object2);
        }
        abstractCollection = new ArrayList();
        block3: while (object2.size() > 0) {
            ModuleDescription moduleDescription;
            Object object4;
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ModuleDescription)iterator.next();
                Set set2 = (Set)object3.get(object);
                if (set2.size() != 0) continue;
                abstractCollection.add(object);
                iterator.remove();
                object4 = object2.iterator();
                while (object4.hasNext()) {
                    moduleDescription = (ModuleDescription)object4.next();
                    if (moduleDescription == object) {
                        throw new IllegalModuleException("Should not happen.");
                    }
                    Set set3 = (Set)object3.get(moduleDescription);
                    set3.remove(object);
                }
                continue block3;
            }
            object = object2.iterator();
            boolean bl = true;
            object4 = new StringBuffer();
            while (object.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    ((StringBuffer)object4).append("; ");
                }
                moduleDescription = (ModuleDescription)object.next();
                ((StringBuffer)object4).append(moduleDescription.getName());
                ((StringBuffer)object4).append(" (=> ");
                boolean bl2 = true;
                Iterator iterator3 = ((Set)object3.get(moduleDescription)).iterator();
                while (iterator3.hasNext()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        ((StringBuffer)object4).append(", ");
                    }
                    ((StringBuffer)object4).append(((ModuleDescription)iterator3.next()).getName());
                }
                ((StringBuffer)object4).append(")");
            }
            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Cyclic", ((StringBuffer)object4).toString()));
        }
        if (VERBOSE) {
            System.err.println("Outgoing module list: ");
            iterator = abstractCollection.iterator();
            while (iterator.hasNext()) {
                System.err.println("\t" + (ModuleDescription)iterator.next());
            }
        }
        return abstractCollection;
    }

    private static void throwOverlapException(Set set, SortedSet sortedSet) throws IllegalModuleException {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ModuleDescription moduleDescription = (ModuleDescription)iterator.next();
            object2 = moduleDescription.getCodeName();
            object = (Integer)hashMap.get(object2);
            if (object == null) {
                hashMap.put(object2, new Integer(1));
                continue;
            }
            hashMap.put(object2, new Integer((Integer)object + 1));
        }
        boolean bl = true;
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            Integer n = (Integer)hashMap.get(object);
            if (n <= 1) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(' ');
            }
            stringBuffer.append((String)object);
            stringBuffer.append('(');
            stringBuffer.append(n.toString());
            stringBuffer.append(')');
        }
        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Overlapping_Code_Names", String.valueOf(sortedSet.size()), String.valueOf(set.size() - sortedSet.size()), TAG_MAGIC.toString(), stringBuffer.toString()));
    }

    public static List resolveOrderingForRealInstall(Set set, Set set2) throws IllegalModuleException {
        Object object;
        if (VERBOSE) {
            System.err.println("rOFRI called.");
        }
        AbstractCollection abstractCollection = new TreeSet(codeNameComparator);
        abstractCollection.addAll(set);
        abstractCollection.addAll(set2);
        int n = abstractCollection.size();
        int n2 = set.size() + set2.size();
        if (n != n2) {
            object = new HashSet();
            object.addAll(set);
            object.addAll(set2);
            ModuleDescription.throwOverlapException(object, abstractCollection);
        }
        abstractCollection = new ArrayList();
        HashSet hashSet = new HashSet();
        hashSet.addAll(set2);
        do {
            n2 = 0;
            object = hashSet.iterator();
            while (object.hasNext()) {
                ModuleDescription moduleDescription = (ModuleDescription)object.next();
                HashSet hashSet2 = new HashSet();
                hashSet2.addAll(set);
                hashSet2.addAll(hashSet);
                String string = moduleDescription.reasonWhyUnsatisfied(hashSet2.toArray(new ModuleDescription[0]));
                if (string == null) continue;
                ++n2;
                object.remove();
                abstractCollection.add((String)string);
            }
        } while (n2 > 0);
        return ModuleDescription.resolveOrdering(hashSet);
    }

    public static boolean compatibleWith(String string, String string2) throws IllegalModuleException {
        if (string == null || string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            if (!stringTokenizer2.hasMoreTokens()) {
                return false;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return true;
            }
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer2.nextToken();
            int n = 0;
            int n2 = 0;
            try {
                n = Integer.parseInt(string3);
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                IllegalModuleException illegalModuleException = new IllegalModuleException(string + "<" + string2 + "?");
                TopManager.getDefault().getErrorManager().annotate((Throwable)illegalModuleException, numberFormatException);
                throw illegalModuleException;
            }
            if (n < 0 || n2 < 0) {
                return false;
            }
            if (n < n2) {
                return true;
            }
            if (n <= n2) continue;
            return false;
        }
        return true;
    }

    static void checkCodeName(String string, boolean bl) throws IllegalModuleException {
        ModuleDescription.checkCodeName("", string, bl);
    }

    static void checkCodeName(String string, String string2, boolean bl) throws IllegalModuleException {
        int n;
        String string3;
        int n2 = string2.indexOf("/");
        if (n2 == -1) {
            string3 = string2;
            n = -1;
        } else {
            if (!bl) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_slash_not_permitted", string2, string));
            }
            string3 = string2.substring(0, n2);
            try {
                n = Integer.parseInt(string2.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Non_Numeric_Release", string2, string));
            }
        }
        int n3 = 0;
        while (n3 < string3.length()) {
            char c = string3.charAt(n3);
            if (!Character.isJavaIdentifierPart(c) && c != '.') {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Char_In_Code_Name", string2, string));
            }
            ++n3;
        }
    }

    static void checkSpec(String string) throws IllegalModuleException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() % 2 == 0) {
            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", string));
        }
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            block7: {
                String string2 = stringTokenizer.nextToken();
                if (n % 2 == 0) {
                    try {
                        int n2 = Integer.parseInt(string2);
                        if (n2 < 0) {
                            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", string));
                        }
                        break block7;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", string));
                    }
                }
                if (!".".equals(string2)) {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Spec", string));
                }
            }
            ++n;
        }
    }

    private void createDescription(String string, Manifest manifest) throws IllegalModuleException {
        Object object;
        Attributes attributes = manifest.getMainAttributes();
        this.codeName = attributes.getValue(TAG_MAGIC);
        if (this.codeName == null) {
            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Not_A_Module", TAG_MAGIC.toString(), string));
        }
        ModuleDescription.checkCodeName(string, this.codeName, true);
        this.moduleName = NbBundle.getLocalizedValue(attributes, TAG_NAME);
        if (this.moduleName == null) {
            object = string;
            int n = ((String)object).lastIndexOf(47);
            int n2 = ((String)object).lastIndexOf(46);
            this.moduleName = ((String)object).substring(n == -1 ? 0 : n + 1, n2 == -1 ? ((String)object).length() : n2);
        }
        this.shortDescription = NbBundle.getLocalizedValue(attributes, TAG_SHORT_DESCRIPTION);
        this.longDescription = NbBundle.getLocalizedValue(attributes, TAG_LONG_DESCRIPTION);
        this.displayCategory = NbBundle.getLocalizedValue(attributes, TAG_CATEGORY);
        this.specVersion = attributes.getValue(TAG_SPEC_VERSION);
        if (this.specVersion != null) {
            ModuleDescription.checkSpec(this.specVersion);
        }
        this.implVersion = attributes.getValue(TAG_IMPL_VERSION);
        this.dependenciesSet = new HashSet();
        this.parseDependencies(1, attributes.getValue(TAG_MODULE_DEPENDENCIES), this.dependenciesSet);
        this.parseDependencies(2, attributes.getValue(TAG_PACKAGE_DEPENDENCIES), this.dependenciesSet);
        this.parseDependencies(3, attributes.getValue(TAG_JAVA_DEPENDENCIES), this.dependenciesSet);
        this.parseDependencies(4, attributes.getValue(TAG_IDE_DEPENDENCIES), this.dependenciesSet);
        this.mainClass = attributes.getValue(TAG_MAIN);
        if (this.mainClass != null) {
            this.mainClassSer = this.mainClass.endsWith(".ser");
            this.mainClass = ModuleDescription.createPackageName(this.mainClass);
        }
        this.layerResource = attributes.getValue(TAG_LAYER);
        this.description = attributes.getValue(TAG_DESCRIPTION);
        object = manifest.getEntries().entrySet().iterator();
        ArrayList<ManifestSection> arrayList = new ArrayList<ManifestSection>();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            ManifestSection manifestSection = ManifestSection.createSection((String)entry.getKey(), (Attributes)entry.getValue(), this);
            if (manifestSection == null) continue;
            arrayList.add(manifestSection);
        }
        this.sections = new ManifestSection[arrayList.size()];
        arrayList.toArray(this.sections);
    }

    /*
     * Unable to fully structure code
     */
    private void parseDependencies(int var1_1, String var2_2, Set var3_3) throws IllegalModuleException {
        if (var2_2 == null) {
            return;
        }
        var4_4 = new StringTokenizer(var2_2, ",");
        if (var4_4.hasMoreTokens()) ** GOTO lbl30
        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_No_Deps_Given", var2_2));
lbl-1000:
        // 1 sources

        {
            var5_5 = var4_4.nextToken();
            var6_6 = new StringTokenizer(var5_5, " \t\n\r");
            if (!var6_6.hasMoreTokens()) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_No_Name_In_Dep", var5_5));
            }
            var7_7 = var6_6.nextToken();
            if (var6_6.hasMoreTokens()) {
                var10_10 = var6_6.nextToken();
                if (var10_10.equals(">")) {
                    var8_8 = 1;
                } else if (var10_10.equals("=")) {
                    var8_8 = 2;
                } else {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Unrec_Comp_Str", var10_10));
                }
                if (!var6_6.hasMoreTokens()) {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Comp_Str_Without_Vers", var5_5));
                }
                var9_9 = var6_6.nextToken();
                if (var6_6.hasMoreTokens()) {
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Garbage", var5_5));
                }
            } else {
                var8_8 = 3;
                var9_9 = null;
            }
            var3_3.add(new Dependency(var1_1, var7_7, var8_8, var9_9, this));
lbl30:
            // 2 sources

            ** while (var4_4.hasMoreTokens())
        }
lbl31:
        // 1 sources

    }

    static String createPackageName(String string) throws IllegalModuleException {
        String string2 = ".class";
        if (!string.endsWith(string2)) {
            string2 = ".ser";
        }
        if (string.endsWith(string2)) {
            String string3 = string.substring(0, string.length() - string2.length());
            if (string3.length() == 0) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", string));
            }
            if (string3.charAt(0) == '/') {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", string));
            }
            if (string3.charAt(string3.length() - 1) == '/') {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", string));
            }
            if (string3.indexOf(46) != -1) {
                throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", string));
            }
            return string3.replace('/', '.');
        }
        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Class_File_Name", string));
    }

    static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = NbBundle.getBundle(class$org$openide$modules$ModuleDescription == null ? (class$org$openide$modules$ModuleDescription = ModuleDescription.class$("org.openide.modules.ModuleDescription")) : class$org$openide$modules$ModuleDescription);
        }
        return bundle;
    }

    static String getString(String string) {
        return ModuleDescription.getBundle().getString(string);
    }

    static String getStringFormatted(String string, Object[] objectArray) {
        return MessageFormat.format(ModuleDescription.getString(string), objectArray);
    }

    static String getStringFormatted(String string, String string2) {
        return ModuleDescription.getStringFormatted(string, new Object[]{string2});
    }

    static String getStringFormatted(String string, String string2, String string3) {
        return ModuleDescription.getStringFormatted(string, new Object[]{string2, string3});
    }

    static String getStringFormatted(String string, String string2, String string3, String string4) {
        return ModuleDescription.getStringFormatted(string, new Object[]{string2, string3, string4});
    }

    static String getStringFormatted(String string, String string2, String string3, String string4, String string5) {
        return ModuleDescription.getStringFormatted(string, new Object[]{string2, string3, string4, string5});
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            System.err.println("WARNING: use of deprecated class org.openide.modules.ModuleDescription");
            Thread.dumpStack();
        }
        VERBOSE = Boolean.getBoolean("org.openide.modules.ModuleDescription.VERBOSE");
        TAG_MAGIC = new Attributes.Name("OpenIDE-Module");
        TAG_NAME = new Attributes.Name("OpenIDE-Module-Name");
        TAG_SHORT_DESCRIPTION = new Attributes.Name("OpenIDE-Module-Short-Description");
        TAG_LONG_DESCRIPTION = new Attributes.Name("OpenIDE-Module-Long-Description");
        TAG_CATEGORY = new Attributes.Name("OpenIDE-Module-Display-Category");
        codeNameComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                ModuleDescription moduleDescription = (ModuleDescription)object;
                ModuleDescription moduleDescription2 = (ModuleDescription)object2;
                return moduleDescription.getCodeName().compareTo(moduleDescription2.getCodeName());
            }
        };
        TAG_SPEC_VERSION = new Attributes.Name("OpenIDE-Module-Specification-Version");
        TAG_IMPL_VERSION = new Attributes.Name("OpenIDE-Module-Implementation-Version");
        TAG_MODULE_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-Module-Dependencies");
        TAG_PACKAGE_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-Package-Dependencies");
        TAG_JAVA_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-Java-Dependencies");
        TAG_IDE_DEPENDENCIES = new Attributes.Name("OpenIDE-Module-IDE-Dependencies");
        TAG_MAIN = new Attributes.Name("OpenIDE-Module-Install");
        TAG_LAYER = new Attributes.Name("OpenIDE-Module-Layer");
        TAG_DESCRIPTION = new Attributes.Name("OpenIDE-Module-Description");
        TAG_SECTION_CLASS = new Attributes.Name("OpenIDE-Module-Class");
        TAG_INSTALL_BEFORE = new Attributes.Name("Install-Before");
        TAG_INSTALL_AFTER = new Attributes.Name("Install-After");
        TAG_FILESYSTEM_NAME = new Attributes.Name("Display-Name");
        TAG_FILESYSTEM_HELP = new Attributes.Name("Help");
        TAG_SERVICE_DEFAULT = new Attributes.Name("Default");
        TAG_NODE_TYPE = new Attributes.Name("Type");
        MODULE_NONE = new ModuleInstall();
    }

    public static interface PackageAccessibleClassLoader {
        public Package getPackageAccessibly(String var1);

        public Package[] getPackagesAccessibly();
    }

    public static final class Dependency {
        public static final int TYPE_MODULE = 1;
        public static final int TYPE_PACKAGE = 2;
        public static final int TYPE_JAVA = 3;
        public static final int TYPE_IDE = 4;
        private int type;
        private String name;
        public static final int COMPARE_SPEC = 1;
        public static final int COMPARE_IMPL = 2;
        public static final int COMPARE_ANY = 3;
        private int comparison;
        private String version;
        private ModuleDescription desc;

        Dependency(int n, String string, int n2, String string2, ModuleDescription moduleDescription) throws IllegalModuleException {
            this.type = n;
            this.name = string;
            this.comparison = n2;
            this.version = string2;
            this.desc = moduleDescription;
            if (n2 == 1) {
                ModuleDescription.checkSpec(string2);
            }
            switch (n) {
                case 1: {
                    ModuleDescription.checkCodeName(string, true);
                    break;
                }
                case 2: {
                    int n3 = string.indexOf(91);
                    if (n3 != -1) {
                        if (n3 > 0) {
                            ModuleDescription.checkCodeName(string.substring(0, n3), false);
                        }
                        if (string.charAt(string.length() - 1) != ']') {
                            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_pkg_dep_not_close_bracket", this.toString()));
                        }
                        ModuleDescription.checkCodeName(string.substring(n3 + 1, string.length() - 1), false);
                        break;
                    }
                    ModuleDescription.checkCodeName(string, false);
                    break;
                }
                case 3: {
                    if (string.equals("Java") || string.equals("VM")) break;
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_Java_Dep", this.toString()));
                }
                case 4: {
                    if (!string.equals("IDE")) {
                        boolean bl;
                        int n4 = string.indexOf("/");
                        if (n4 == -1) {
                            bl = false;
                        } else {
                            try {
                                Integer.parseInt(string.substring(n4 + 1));
                                bl = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl = false;
                            }
                        }
                        if (!bl) {
                            throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_Bad_IDE_Dep", this.toString()));
                        }
                    }
                    if (n2 != 3) break;
                    throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_IDE_Dep_Uncompared", this.toString()));
                }
                default: {
                    throw new IllegalModuleException("unknown type");
                }
            }
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public int getComparison() {
            return this.comparison;
        }

        public String getVersion() {
            return this.version;
        }

        /*
         * Unable to fully structure code
         */
        public String checkForMiss(ModuleDescription[] var1_1) throws IllegalModuleException {
            switch (this.type) {
                case 1: {
                    var2_2 = 0;
                    while (var2_2 < var1_1.length) {
                        var3_3 = var1_1[var2_2];
                        if (this.name.equals(var3_3.getCodeName())) {
                            if (this.comparison == 3) {
                                return null;
                            }
                            if (this.comparison == 1) {
                                if (var3_3.getSpecVersion() == null) {
                                    return ModuleDescription.getStringFormatted("MSG_Module_Spec_None", var3_3.getName());
                                }
                                if (!ModuleDescription.compatibleWith(this.version, var3_3.getSpecVersion())) {
                                    return ModuleDescription.getStringFormatted("MSG_Module_Spec_Bad", var3_3.getName(), var3_3.getSpecVersion(), this.version);
                                }
                                return null;
                            }
                            if (var3_3.getImplVersion() == null) {
                                return ModuleDescription.getStringFormatted("MSG_Module_Impl_None", var3_3.getName());
                            }
                            if (!var3_3.getImplVersion().equals(this.version)) {
                                return ModuleDescription.getStringFormatted("MSG_Module_Impl_Bad", var3_3.getName(), var3_3.getImplVersion(), this.version);
                            }
                            return null;
                        }
                        ++var2_2;
                    }
                    return ModuleDescription.getStringFormatted("MSG_Module_None", this.name);
                }
                case 2: {
                    if (!(this.desc.cl instanceof PackageAccessibleClassLoader)) {
                        throw new IllegalModuleException(ModuleDescription.getStringFormatted("EXC_not_package_accessible", this.desc.cl.getClass().getName()));
                    }
                    var5_5 = this.name.indexOf(91);
                    if (var5_5 == -1) {
                        var3_4 = this.name;
                        var4_6 = null;
                    } else if (var5_5 == 0) {
                        var3_4 = null;
                        var4_6 = this.name.substring(1, this.name.length() - 1);
                    } else {
                        var3_4 = this.name.substring(0, var5_5);
                        var4_6 = this.name.substring(var5_5 + 1, this.name.length() - 1);
                        if (var4_6.indexOf(46) == -1) {
                            var4_6 = var3_4 + '.' + var4_6;
                        }
                    }
                    if (var4_6 == null) ** GOTO lbl47
                    try {
                        this.desc.cl.loadClass(var4_6);
                    }
                    catch (ClassNotFoundException var6_7) {
                        if (var3_4 != null) ** GOTO lbl47
                        return ModuleDescription.getStringFormatted("MSG_pkg_sample_not_found", var4_6);
                    }
lbl47:
                    // 3 sources

                    if (var3_4 != null) {
                        var6_8 = ((PackageAccessibleClassLoader)this.desc.cl).getPackageAccessibly(var3_4);
                        if (var6_8 == null) {
                            return ModuleDescription.getStringFormatted("MSG_Package_None", var3_4);
                        }
                        if (this.comparison == 3) {
                            return null;
                        }
                        if (this.comparison == 1) {
                            if (var6_8.getSpecificationVersion() == null) {
                                return ModuleDescription.getStringFormatted("MSG_Package_Spec_None", var6_8.getName());
                            }
                            if (!ModuleDescription.compatibleWith(this.version, var6_8.getSpecificationVersion().trim())) {
                                return ModuleDescription.getStringFormatted("MSG_Package_Spec_Bad", var6_8.getName(), var6_8.getSpecificationVersion(), this.version);
                            }
                            return null;
                        }
                        if (var6_8.getImplementationVersion() == null) {
                            return ModuleDescription.getStringFormatted("MSG_Package_Impl_None", var6_8.getName());
                        }
                        if (!var6_8.getImplementationVersion().trim().equals(this.version)) {
                            return ModuleDescription.getStringFormatted("MSG_Package_Impl_Bad", var6_8.getName(), var6_8.getImplementationVersion(), this.version);
                        }
                        return null;
                    }
                    return null;
                }
                case 3: {
                    if (this.name.equals("Java")) {
                        if (this.comparison == 1) {
                            return ModuleDescription.compatibleWith(this.version, System.getProperty("java.specification.version")) != false ? null : ModuleDescription.getStringFormatted("MSG_Java_Spec", this.version);
                        }
                        return System.getProperty("java.version").equals(this.version) != false ? null : ModuleDescription.getStringFormatted("MSG_Java_Impl", this.version);
                    }
                    if (this.comparison == 1) {
                        return ModuleDescription.compatibleWith(this.version, System.getProperty("java.vm.specification.version")) != false ? null : ModuleDescription.getStringFormatted("MSG_VM_Spec", this.version);
                    }
                    return System.getProperty("java.vm.version").equals(this.version) != false ? null : ModuleDescription.getStringFormatted("MSG_VM_Impl", this.version);
                }
                case 4: {
                    var6_9 = System.getProperty("org.openide.major.version", "IDE");
                    var7_10 = System.getProperty("org.openide.specification.version", "0.0");
                    var8_11 = System.getProperty("org.openide.version", "<unknown>");
                    if (!var6_9.equals(this.name)) {
                        return ModuleDescription.getStringFormatted("MSG_IDE_Name", this.name, var6_9);
                    }
                    if (this.comparison == 1) {
                        return ModuleDescription.compatibleWith(this.version, var7_10) != false ? null : ModuleDescription.getStringFormatted("MSG_IDE_Spec", this.version, var7_10);
                    }
                    if (this.comparison == 2) {
                        return this.version.equals(var8_11) != false ? null : ModuleDescription.getStringFormatted("MSG_IDE_Impl", this.version, var8_11);
                    }
                    return null;
                }
            }
            throw new IllegalModuleException("should never happen");
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Dependency)) {
                return false;
            }
            Dependency dependency = (Dependency)object;
            return this.type == dependency.type && this.name.equals(dependency.name) && this.comparison == dependency.comparison && (this.version == null && dependency.version == null || this.version != null && dependency.version != null && this.version.equals(dependency.version));
        }

        public int hashCode() {
            return this.type * 57 ^ this.name.hashCode() ^ this.comparison * 231 ^ (this.version == null ? 111 : this.version.hashCode());
        }

        public String toString() {
            return ModuleDescription.getStringFormatted("DBG_Dependency_ToString", this.type == 1 ? "Module" : (this.type == 2 ? "Package" : (this.type == 3 ? "Java" : (this.type == 4 ? "IDE" : "???"))), this.name, this.comparison == 3 ? "" : ModuleDescription.getStringFormatted("DBG_Dependency_Comparison", this.comparison == 1 ? ">" : (this.comparison == 2 ? "=" : "???"), this.version));
        }
    }
}

