/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Utilities;

public final class Dependency {
    public static final int TYPE_MODULE = 1;
    public static final int TYPE_PACKAGE = 2;
    public static final int TYPE_JAVA = 3;
    public static final int TYPE_IDE = 4;
    public static final int COMPARE_SPEC = 1;
    public static final int COMPARE_IMPL = 2;
    public static final int COMPARE_ANY = 3;
    public static final String IDE_NAME = System.getProperty("org.openide.major.version", "IDE");
    public static final SpecificationVersion IDE_SPEC = Dependency.makeSpec(System.getProperty("org.openide.specification.version"));
    public static final String IDE_IMPL = System.getProperty("org.openide.version");
    public static final String JAVA_NAME = "Java";
    public static final SpecificationVersion JAVA_SPEC = Dependency.ibmHack(Dependency.makeSpec(System.getProperty("java.specification.version")));
    public static final String JAVA_IMPL = System.getProperty("java.version");
    public static final String VM_NAME = "VM";
    public static final SpecificationVersion VM_SPEC = Dependency.makeSpec(System.getProperty("java.vm.specification.version"));
    public static final String VM_IMPL = System.getProperty("java.vm.version");
    private final int type;
    private final int comparison;
    private final String name;
    private final String version;
    static /* synthetic */ Class class$org$openide$modules$Dependency;

    private Dependency(int n, String string, int n2, String string2) {
        this.type = n;
        this.name = string;
        this.comparison = n2;
        this.version = string2;
    }

    private static void checkCodeName(String string, boolean bl) throws IllegalArgumentException {
        String string2;
        int n = string.indexOf("/");
        if (n == -1) {
            string2 = string;
        } else {
            if (!bl) {
                throw new IllegalArgumentException("No slash permitted in: " + string);
            }
            string2 = string.substring(0, n);
            try {
                int n2 = Integer.parseInt(string.substring(n + 1));
                if (n2 < 0) {
                    throw new IllegalArgumentException("Negative release number: " + string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(numberFormatException.toString());
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".", true);
        if (stringTokenizer.countTokens() % 2 == 0) {
            throw new NumberFormatException("Even number of pieces: " + string2);
        }
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            if (bl2) {
                bl2 = false;
                if (Utilities.isJavaIdentifier(stringTokenizer.nextToken())) continue;
                throw new IllegalArgumentException("Bad package component in " + string2);
            }
            if (!".".equals(stringTokenizer.nextToken())) {
                throw new NumberFormatException("Expected dot in code name: " + string2);
            }
            bl2 = true;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Set create(int var0, String var1_1) throws IllegalArgumentException {
        if (var1_1 == null) {
            return Collections.EMPTY_SET;
        }
        var2_2 = new HashSet<Dependency>(5);
        var3_3 = new StringTokenizer(var1_1.trim(), ",");
        if (var3_3.hasMoreTokens()) ** GOTO lbl82
        throw new IllegalArgumentException("No deps given: \"" + var1_1 + "\"");
lbl-1000:
        // 1 sources

        {
            var4_4 = var3_3.nextToken().trim();
            var5_5 = new StringTokenizer(var4_4, " \t\n\r");
            if (!var5_5.hasMoreTokens()) {
                throw new IllegalArgumentException("No name in dependency: " + var4_4);
            }
            var6_6 = var5_5.nextToken();
            if (var5_5.hasMoreTokens()) {
                var9_9 = var5_5.nextToken();
                if (var9_9.equals(">")) {
                    var7_7 = 1;
                } else if (var9_9.equals("=")) {
                    var7_7 = 2;
                } else {
                    throw new IllegalArgumentException("Strange comparison string: " + var9_9);
                }
                if (!var5_5.hasMoreTokens()) {
                    throw new IllegalArgumentException("Comparison string without version: " + var4_4);
                }
                var8_8 = var5_5.nextToken();
                if (var5_5.hasMoreTokens()) {
                    throw new IllegalArgumentException("Trailing garbage in dependency: " + var4_4);
                }
                if (var7_7 == 1) {
                    try {
                        new SpecificationVersion(var8_8);
                    }
                    catch (NumberFormatException var10_13) {
                        throw new IllegalArgumentException(var10_13.toString());
                    }
                }
            } else {
                var7_7 = 3;
                var8_8 = null;
            }
            if (var0 == 1) {
                Dependency.checkCodeName(var6_6, true);
            } else if (var0 == 2) {
                var9_10 = var6_6.indexOf(91);
                if (var9_10 != -1) {
                    if (var9_10 > 0) {
                        Dependency.checkCodeName(var6_6.substring(0, var9_10), false);
                    }
                    if (var6_6.charAt(var6_6.length() - 1) != ']') {
                        throw new IllegalArgumentException("No close bracket on package dep: " + var6_6);
                    }
                    Dependency.checkCodeName(var6_6.substring(var9_10 + 1, var6_6.length() - 1), false);
                } else {
                    Dependency.checkCodeName(var6_6, false);
                }
                if (var9_10 == 0 && var7_7 != 3) {
                    throw new IllegalArgumentException("Cannot use a version comparison on a package dependency when only a sample class is given");
                }
                if (var9_10 > 0 && var6_6.substring(var9_10 + 1, var6_6.length() - 1).indexOf(46) != -1) {
                    throw new IllegalArgumentException("Cannot have a sample class with dots when package is specified");
                }
            } else if (var0 == 3) {
                if (!var6_6.equals("Java") && !var6_6.equals("VM")) {
                    throw new IllegalArgumentException("Java dependency must be on \"Java\" or \"VM\": " + var6_6);
                }
                if (var7_7 == 3) {
                    throw new IllegalArgumentException("Must give a comparison for a Java dep: " + var1_1);
                }
            } else if (var0 == 4) {
                if (!var6_6.equals("IDE")) {
                    var9_11 = var6_6.indexOf("/");
                    if (var9_11 == -1) {
                        var10_12 = false;
                    } else {
                        if (!var6_6.substring(0, var9_11).equals("IDE")) {
                            var10_12 = false;
                        }
                        try {
                            var11_14 = Integer.parseInt(var6_6.substring(var9_11 + 1));
                            var10_12 = var11_14 >= 0;
                        }
                        catch (NumberFormatException var11_15) {
                            var10_12 = false;
                        }
                    }
                    if (!var10_12) {
                        throw new IllegalArgumentException("Invalid IDE dependency: " + var6_6);
                    }
                }
                if (var7_7 == 3) {
                    throw new IllegalArgumentException("Must give a comparison for an IDE dep: " + var1_1);
                }
            } else {
                throw new IllegalArgumentException("unknown type");
            }
            var2_2.add(new Dependency(var0, var6_6, var7_7, var8_8));
lbl82:
            // 2 sources

            ** while (var3_3.hasMoreTokens())
        }
lbl83:
        // 1 sources

        return var2_2;
    }

    public final int getType() {
        return this.type;
    }

    public final String getName() {
        return this.name;
    }

    public final int getComparison() {
        return this.comparison;
    }

    public final String getVersion() {
        return this.version;
    }

    public boolean equals(Object object) {
        if (object.getClass() != (class$org$openide$modules$Dependency == null ? (class$org$openide$modules$Dependency = Dependency.class$("org.openide.modules.Dependency")) : class$org$openide$modules$Dependency)) {
            return false;
        }
        Dependency dependency = (Dependency)object;
        return this.type == dependency.type && this.comparison == dependency.comparison && this.name.equals(dependency.name) && Utilities.compareObjects(this.version, dependency.version);
    }

    public int hashCode() {
        return 0xBC7E3 ^ this.type ^ this.name.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.type == 1) {
            stringBuffer.append("module ");
        } else if (this.type == 2) {
            stringBuffer.append("package ");
        }
        stringBuffer.append(this.name);
        if (this.comparison == 2) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.version);
        } else if (this.comparison == 1) {
            stringBuffer.append(" > ");
            stringBuffer.append(this.version);
        }
        return stringBuffer.toString();
    }

    private static SpecificationVersion makeSpec(String string) {
        if (string != null) {
            try {
                return new SpecificationVersion(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("WARNING: invalid specification version: " + string);
                while (true) {
                    string = string.substring(0, string.length() - 1);
                    try {
                        return new SpecificationVersion(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        if (string.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    private static SpecificationVersion ibmHack(SpecificationVersion specificationVersion) {
        if (specificationVersion.equals(new SpecificationVersion("1.2")) && "IBM Corporation".equals(System.getProperty("java.vendor")) && "1.3.0".equals(System.getProperty("java.version"))) {
            System.err.println("WARNING - this IBM JDK claims java.specification.version=1.2 but is really 1.3");
            return new SpecificationVersion("1.3");
        }
        return specificationVersion;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

