/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class TemplateWizard1
extends JPanel
implements DataFilter,
WizardDescriptor.Panel,
ExplorerManager.Provider,
PropertyChangeListener {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private ChangeListener listener;
    private DataObject template;
    private DataFolder templatesRoot;
    private ExplorerManager manager;
    private JPanel browserPanel;
    private HtmlBrowser browser;
    private JLabel noBrowser;
    private JLabel templatesLabel;
    private JLabel browserLabel;
    private TemplatesTreeView treeView;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard1;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public TemplateWizard1() {
        this.initComponents();
        this.treeView = new TemplatesTreeView();
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.setName(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1).getString("LAB_TemplateChooserPanelName"));
        ResourceBundle resourceBundle = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1);
        this.templatesLabel.setLabelFor(this.treeView);
        this.browserLabel.setLabelFor(this.browser);
        this.templatesLabel.setText(resourceBundle.getString("LAB_SelectTemplateBorder"));
        this.templatesLabel.setDisplayedMnemonic(resourceBundle.getString("LAB_SelectTemplateBorder_Mnemonic").charAt(0));
        this.browserLabel.setText(resourceBundle.getString("LAB_TemplateDescriptionBorder"));
        this.browserLabel.setDisplayedMnemonic(resourceBundle.getString("LAB_TemplateDescriptionBorder_Mnemonic").charAt(0));
        this.noBrowser.setText(resourceBundle.getString("MSG_NoDescription"));
        this.updateRootNode(null);
        CardLayout cardLayout = (CardLayout)this.browserPanel.getLayout();
        cardLayout.show(this.browserPanel, "noBrowser");
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        this.putClientProperty(PROP_CONTENT_DATA, new String[]{this.getName(), "..."});
        this.treeView.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TemplatesTree"));
        this.browser.getAccessibleContext().setAccessibleName(this.browserLabel.getText());
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TemplateWizard1"));
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener(this);
        }
        return this.manager;
    }

    public boolean requestDefaultFocus() {
        return this.treeView.requestDefaultFocus();
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    private void updateRootNode(DataFolder dataFolder) {
        if (dataFolder == null) {
            dataFolder = TopManager.getDefault().getPlaces().folders().templates();
        }
        if (dataFolder.equals(this.templatesRoot)) {
            return;
        }
        this.templatesRoot = dataFolder;
        Children children = dataFolder.createNodeChildren(this);
        this.getExplorerManager().setRootContext(new FilterNode(dataFolder.getNodeDelegate(), children));
    }

    private void updateDescription(DataObject dataObject) {
        URL uRL = null;
        if (dataObject != null) {
            uRL = TemplateWizard.getDescription(dataObject);
        }
        CardLayout cardLayout = (CardLayout)this.browserPanel.getLayout();
        if (uRL != null && this.getExplorerManager().getSelectedNodes().length != 0) {
            this.browser.setURL(uRL);
            cardLayout.show(this.browserPanel, "browser");
        } else {
            cardLayout.show(this.browserPanel, "noBrowser");
        }
    }

    private void initComponents() {
        this.browserPanel = new JPanel();
        this.browser = new HtmlBrowser();
        this.noBrowser = new JLabel();
        this.templatesLabel = new JLabel();
        this.browserLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(0, 0));
        this.browserPanel.setLayout(new CardLayout());
        this.browser.setStatusLineVisible(false);
        this.browser.setName("browser");
        this.browser.setToolbarVisible(false);
        this.browserPanel.add((Component)this.browser, "browser");
        this.noBrowser.setHorizontalAlignment(0);
        this.browserPanel.add((Component)this.noBrowser, "noBrowser");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.browserPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.templatesLabel, gridBagConstraints);
        this.browserLabel.setLabelFor(this.browser);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.browserLabel, gridBagConstraints);
    }

    private void nameFocusGained(FocusEvent focusEvent) {
    }

    private void templatesTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "selectedNodes" && this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
            this.updateDescription(this.template);
        }
    }

    private void packagesListValueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public boolean acceptDataObject(DataObject dataObject) {
        if (dataObject instanceof DataFolder) {
            Object object = dataObject.getPrimaryFile().getAttribute("simple");
            return object == null || Boolean.TRUE.equals(object);
        }
        return dataObject.isTemplate();
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        if (this.getExplorerManager().getRootContext() != Node.EMPTY) {
            return new HelpCtx((class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1).getName() + "." + this.getExplorerManager().getRootContext().getName());
        }
        return new HelpCtx(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1);
    }

    public void readSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        templateWizard.setTitle(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard1.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).getString("CTL_TemplateTitle"));
        this.updateRootNode(templateWizard.getTemplatesFolder());
        this.template = templateWizard.getTemplate();
        if (this.template != null && !this.template.isValid()) {
            this.template = null;
        }
        DataFolder dataFolder = templateWizard.getTemplatesFolder();
        final LinkedList<String> linkedList = new LinkedList<String>();
        for (DataObject dataObject = this.template; dataObject != null && dataObject != dataFolder; dataObject = dataObject.getFolder()) {
            String string = dataObject.getNodeDelegate().getName();
            linkedList.addFirst(string);
        }
        RequestProcessor.postRequest(new Runnable(){
            private Node selection;

            public void run() {
                if (this.selection == null) {
                    Node node = TemplateWizard1.this.getExplorerManager().getRootContext();
                    ListIterator listIterator = linkedList.listIterator();
                    while (listIterator.hasNext()) {
                        String string = (String)listIterator.next();
                        if ((node = node.getChildren().findChild(string)) != null) continue;
                        node = TemplateWizard1.this.getExplorerManager().getRootContext();
                        break;
                    }
                    this.selection = node;
                    SwingUtilities.invokeLater(this);
                } else {
                    try {
                        TemplateWizard1.this.getExplorerManager().setSelectedNodes(new Node[]{this.selection});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }, 300, 1);
    }

    public void storeSettings(Object object) {
        if (this.template != null) {
            Component component;
            TemplateWizard templateWizard = (TemplateWizard)object;
            if (templateWizard.getTemplate() != this.template && (component = templateWizard.targetChooser().getComponent()) instanceof JComponent) {
                ((JComponent)component).putClientProperty(PROP_CONTENT_DATA, new String[]{component.getName()});
                ((JComponent)component).putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
            }
            templateWizard.setTemplateImpl(this.template, false);
        }
    }

    public boolean isValid() {
        boolean bl = false;
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray.length == 1) {
            this.template = (DataObject)nodeArray[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateWizard1.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            bl = this.template != null && this.template.isTemplate();
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class TemplatesTreeView
    extends BeanTreeView {
        TemplatesTreeView() {
            this.tree.setEditable(false);
            this.tree.getSelectionModel().setSelectionMode(1);
        }

        protected NodeTreeModel createModel() {
            return new TemplatesModel();
        }
    }

    private static final class TemplatesModel
    extends NodeTreeModel {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        private TemplatesModel() {
        }

        public int getChildCount(Object object) {
            Node node = Visualizer.findNode(object);
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplatesModel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return dataObject == null || dataObject.isTemplate() ? 0 : super.getChildCount(object);
        }

        public boolean isLeaf(Object object) {
            Node node = Visualizer.findNode(object);
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplatesModel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return dataObject == null || dataObject.isTemplate();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

