/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderListListener;
import org.openide.loaders.FolderOrder;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;

final class FolderList
implements FileChangeListener,
DataObject.Container {
    static final long serialVersionUID = -592616022226761148L;
    private static final int LATER_PRIORITY = 5;
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder recognizer");
    private static final WeakHashMap map = new WeakHashMap(101);
    protected FileObject folder;
    private transient long time;
    private transient RequestProcessor.Task refreshTask;
    private transient HashMap primaryFiles = null;
    private transient List order;
    private transient ErrorManager err;
    private transient PropertyChangeSupport pcs;

    private FolderList(FileObject fileObject, boolean bl) {
        this.folder = fileObject;
        this.err = TopManager.getDefault().getErrorManager().getInstance("org.openide.loaders.FolderList." + fileObject.getPackageName('.'));
        if (bl) {
            fileObject.addFileChangeListener(WeakListener.fileChange(this, fileObject));
        }
    }

    public static synchronized FolderList find(FileObject fileObject, boolean bl) {
        FolderList folderList;
        Reference reference = (Reference)map.get(fileObject);
        FolderList folderList2 = folderList = reference == null ? null : (FolderList)reference.get();
        if (folderList == null && bl) {
            folderList = new FolderList(fileObject, true);
            map.put(fileObject, new SoftReference<FolderList>(folderList));
        }
        return folderList;
    }

    public static boolean isFolderRecognizerThread() {
        return PROCESSOR.isRequestProcessorThread();
    }

    public static void changedFolderOrder(FileObject fileObject) {
        FolderList folderList = FolderList.find(fileObject, false);
        if (folderList != null) {
            folderList.changeComparator();
        }
    }

    public static void changedDataSystem(FileObject fileObject) {
        FolderList folderList = FolderList.find(fileObject, false);
        if (folderList != null) {
            folderList.refresh();
        }
    }

    public DataObject[] getChildren() {
        List list = this.getChildrenList();
        DataObject[] dataObjectArray = new DataObject[list.size()];
        list.toArray(dataObjectArray);
        return dataObjectArray;
    }

    public List getChildrenList() {
        ListTask listTask = this.getChildrenList(null);
        listTask.task.waitFinished();
        return listTask.result;
    }

    public void waitProcessingFinished() {
        RequestProcessor.Task task = this.refreshTask;
        if (task != null) {
            ((Task)task).waitFinished();
        }
    }

    public RequestProcessor.Task computeChildrenList(FolderListListener folderListListener) {
        return this.getChildrenList((FolderListListener)folderListListener).task;
    }

    private ListTask getChildrenList(FolderListListener folderListListener) {
        ListTask listTask = new ListTask(folderListListener);
        int n = Thread.currentThread().getPriority();
        listTask.task = PROCESSOR.post(listTask, 0, n);
        return listTask;
    }

    private void changeComparator() {
        this.err.log("changeComparator");
        PROCESSOR.post(new Runnable(){

            public void run() {
                if (FolderList.this.primaryFiles != null) {
                    FolderList.this.err.log("changeComparator: get old");
                    List list = FolderList.this.getObjects(null);
                    if (list.size() != 0) {
                        FolderList.this.order = null;
                        FolderList.this.err.log("changeComparator: get new");
                        List list2 = FolderList.this.getObjects(null);
                        FolderList.this.err.log("changeComparator: fire change");
                        FolderList.this.fireChildrenChange(list2, list);
                    }
                }
            }
        }, 0, 1);
    }

    public void refresh() {
        this.refresh(Long.MAX_VALUE);
    }

    private RequestProcessor.Task doRefreshIfNotDone() {
        if (this.refreshTask == null) {
            FolderList folderList = this;
            synchronized (folderList) {
                if (this.refreshTask == null) {
                    this.refresh();
                }
            }
        }
        return this.refreshTask;
    }

    private void refresh(final long l) {
        this.err.log("refresh @" + l);
        this.refreshTask = PROCESSOR.post(new Runnable(){

            public void run() {
                FolderList.this.err.log("refresh: now=" + l + " time=" + FolderList.this.time);
                if (l > FolderList.this.time - 10L) {
                    FolderList.this.time = System.currentTimeMillis();
                    if (FolderList.this.primaryFiles != null) {
                        FolderList.this.createBoth(null, true);
                    }
                }
            }
        }, 0, 5);
    }

    public void fileChanged(FileEvent fileEvent) {
        this.err.log("fileChanged: " + fileEvent);
        FileObject fileObject = fileEvent.getFile();
        if (fileObject.isData() && fileObject.isValid() && this.primaryFiles != null) {
            try {
                DataObject dataObject = DataObject.find(fileObject);
                if (!this.primaryFiles.containsKey(dataObject.getPrimaryFile())) {
                    this.refresh(fileEvent.getTime());
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                TopManager.getDefault().getErrorManager().notify(1, dataObjectNotFoundException);
            }
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.err.log("fileDeleted: " + fileEvent);
        if (this.primaryFiles == null || this.primaryFiles.containsKey(fileEvent.getFile())) {
            this.refresh(fileEvent.getTime());
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        this.err.log("fileDataCreated: " + fileEvent);
        this.refresh(fileEvent.getTime());
    }

    public void fileFolderCreated(FileEvent fileEvent) {
        this.err.log("fileFolderCreated: " + fileEvent);
        this.refresh(fileEvent.getTime());
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.err.log("fileRenamed: " + fileRenameEvent);
        this.refresh(fileRenameEvent.getTime());
        this.changeComparator();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.err.log("fileAttributeChanged: " + fileAttributeEvent);
        if (fileAttributeEvent.getFile() == this.folder) {
            if (fileAttributeEvent.getName() == null) {
                this.changeComparator();
                return;
            }
            if ("OpenIDE-Folder-Order".equals(fileAttributeEvent.getName()) || "OpenIDE-Folder-SortMode".equals(fileAttributeEvent.getName()) || -1 != fileAttributeEvent.getName().indexOf("/")) {
                this.changeComparator();
            }
        }
    }

    private FolderOrder getComparator() {
        return FolderOrder.findFor(this.folder);
    }

    private List getObjects(FolderListListener folderListListener) {
        List list;
        this.err.log("getObjects");
        if (this.primaryFiles == null) {
            list = this.createBoth(folderListListener, false);
        } else if (this.order != null) {
            list = this.createObjects(this.order, this.primaryFiles, folderListListener);
        } else {
            list = this.createObjects(this.primaryFiles.keySet(), this.primaryFiles, folderListListener);
            list = this.carefullySort(list, this.getComparator());
            this.order = FolderList.createOrder(list);
        }
        return list;
    }

    private List carefullySort(List list, FolderOrder folderOrder) {
        this.err.log("carefullySort");
        Collections.sort(list, folderOrder);
        Comparator comparator = folderOrder.getPartialComparator();
        if (comparator == null) {
            return list;
        }
        this.err.log("carefullySort: partial orders");
        try {
            return Utilities.partialSort(list, comparator, true);
        }
        catch (Utilities.UnorderableException unorderableException) {
            this.err.annotate(unorderableException, 16, "Folder cannot be sorted: " + this.folder, null, null, null);
            this.err.notify(16, unorderableException);
            return list;
        }
    }

    private static List createOrder(List list) {
        int n = list.size();
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(((DataObject)list.get(n2)).getPrimaryFile());
            ++n2;
        }
        return arrayList;
    }

    private List createObjects(Collection collection, Map map, FolderListListener folderListListener) {
        this.err.log("createObjects");
        int n = collection.size();
        Iterator iterator = collection.iterator();
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(n);
        int n2 = 0;
        while (n2 < n) {
            FileObject fileObject = (FileObject)iterator.next();
            if (fileObject.isValid()) {
                SoftReference<DataObject> softReference = (SoftReference<DataObject>)map.get(fileObject);
                DataObject dataObject = (DataObject)((Reference)softReference).get();
                if (dataObject == null) {
                    try {
                        dataObject = DataObject.find(fileObject);
                        softReference = new SoftReference<DataObject>(dataObject);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        TopManager.getDefault().getErrorManager().notify(1, dataObjectNotFoundException);
                    }
                }
                if (dataObject != null) {
                    if (folderListListener == null) {
                        arrayList.add(dataObject);
                    } else {
                        folderListListener.process(dataObject, arrayList);
                    }
                }
            }
            ++n2;
        }
        if (folderListListener != null) {
            folderListListener.finished(arrayList);
        }
        return arrayList;
    }

    private List createBoth(FolderListListener folderListListener, boolean bl) {
        this.err.log("createBoth");
        HashMap<FileObject, WeakReference<DataObject>> hashMap = new HashMap<FileObject, WeakReference<DataObject>>();
        List<DataObject> list = new ArrayList();
        List<DataObject> list2 = new ArrayList();
        HashMap hashMap2 = this.primaryFiles == null ? new HashMap() : (HashMap)this.primaryFiles.clone();
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        DataLoaderPool dataLoaderPool = TopManager.getDefault().getLoaderPool();
        final HashSet hashSet = new HashSet();
        DataLoader.RecognizedFiles recognizedFiles = new DataLoader.RecognizedFiles(){

            public void markRecognized(FileObject fileObject) {
                if (fileObject != null) {
                    hashSet.add(fileObject);
                }
            }
        };
        Enumeration enumeration = this.folder.getChildren(false);
        while (enumeration.hasMoreElements()) {
            DataObject dataObject;
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (hashSet.contains(fileObject)) continue;
            try {
                dataObject = dataLoaderPool.findDataObject(fileObject, recognizedFiles);
            }
            catch (DataObjectExistsException dataObjectExistsException) {
                dataObject = dataObjectExistsException.getDataObject();
            }
            catch (IOException iOException) {
                dataObject = null;
                TopManager.getDefault().getErrorManager().notify(iOException);
            }
            if (dataObject == null) continue;
            dataObject.recognizedByFolder();
            FileObject fileObject2 = dataObject.getPrimaryFile();
            boolean bl2 = false;
            if (!hashMap.containsKey(fileObject2)) {
                boolean bl3;
                boolean bl4 = bl3 = this.primaryFiles == null;
                if (!bl3) {
                    Reference reference = (Reference)this.primaryFiles.get(fileObject2);
                    boolean bl5 = bl3 = reference == null;
                    if (!bl3) {
                        DataObject dataObject2 = (DataObject)reference.get();
                        boolean bl6 = bl3 = dataObject2 == null || dataObject2 != dataObject;
                        if (bl3) {
                            bl2 = true;
                        }
                    }
                }
                if (bl3) {
                    arrayList.add(dataObject);
                }
                list.add(dataObject);
                if (folderListListener == null) {
                    list2.add(dataObject);
                } else {
                    folderListListener.process(dataObject, list2);
                }
            }
            if (!bl2) {
                hashMap2.remove(fileObject2);
            }
            hashMap.put(fileObject2, new WeakReference<DataObject>(dataObject));
        }
        this.primaryFiles = hashMap;
        list = this.carefullySort(list, this.getComparator());
        this.order = FolderList.createOrder(list);
        list2 = list.size() == list2.size() ? list : this.carefullySort(list2, this.getComparator());
        if (bl) {
            this.fireChildrenChange(arrayList, hashMap2.keySet());
        }
        if (folderListListener != null) {
            folderListListener.finished(list2);
        }
        return list2;
    }

    private void fireChildrenChange(Collection collection, Collection collection2) {
        if (!(this.pcs == null || collection.isEmpty() && collection2.isEmpty())) {
            this.pcs.firePropertyChange("children", null, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            FolderList folderList = this;
            synchronized (folderList) {
                if (this.pcs == null) {
                    this.pcs = new PropertyChangeSupport(this);
                }
            }
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    private final class ListTask
    implements Runnable {
        private FolderListListener filter;
        public List result;
        public RequestProcessor.Task task;

        public ListTask(FolderListListener folderListListener) {
            this.filter = folderListListener;
        }

        public void run() {
            FolderList.this.err.log("ListTask.run 1");
            if (FolderList.this.refreshTask != null) {
                FolderList.this.refreshTask.waitFinished();
            }
            FolderList.this.err.log("ListTask.run 2");
            this.result = FolderList.this.getObjects(this.filter);
            FolderList.this.err.log("ListTask.run 3");
        }
    }
}

