/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class FileEntry
extends MultiDataObject.Entry {
    static final long serialVersionUID = 5972727204237511983L;

    public FileEntry(MultiDataObject multiDataObject, FileObject fileObject) {
        super(multiDataObject, fileObject);
    }

    public FileObject copy(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = this.getFile();
        String string2 = fileObject2.getName() + string;
        return fileObject2.copy(fileObject, string2, fileObject2.getExt());
    }

    public FileObject rename(String string) throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().rename(fileLock, string, this.getFile().getExt());
            Object var5_4 = null;
            if (!bl) {
                fileLock.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!bl) {
                fileLock.releaseLock();
            }
            throw throwable;
        }
        return this.getFile();
    }

    public FileObject move(FileObject fileObject, String string) throws IOException {
        boolean bl = this.isLocked();
        FileObject fileObject2 = this.getFile();
        FileLock fileLock = this.takeLock();
        try {
            FileObject fileObject3;
            String string2 = fileObject2.getName() + string;
            FileObject fileObject4 = fileObject3 = fileObject2.move(fileLock, fileObject, string2, fileObject2.getExt());
            Object var10_9 = null;
            if (!bl) {
                fileLock.releaseLock();
            }
            return fileObject4;
        }
        catch (Throwable throwable) {
            block3: {
                Object var10_10 = null;
                if (bl) break block3;
                fileLock.releaseLock();
            }
            throw throwable;
        }
    }

    public void delete() throws IOException {
        boolean bl = this.isLocked();
        FileLock fileLock = this.takeLock();
        try {
            this.getFile().delete(fileLock);
            Object var4_3 = null;
            if (!bl) {
                fileLock.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!bl) {
                fileLock.releaseLock();
            }
            throw throwable;
        }
    }

    public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
        if (string == null) {
            string = FileUtil.findFreeFileName(fileObject, this.getFile().getName(), this.getFile().getExt());
        }
        FileObject fileObject2 = this.getFile().copy(fileObject, string, this.getFile().getExt());
        DataObject.setTemplate(fileObject2, false);
        return fileObject2;
    }

    public static final class Folder
    extends MultiDataObject.Entry {
        public Folder(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        public FileObject copy(FileObject fileObject, String string) throws IOException {
            FileObject fileObject2 = FileUtil.createFolder(fileObject, this.getFile().getName() + string);
            FileUtil.copyAttributes(this.getFile(), fileObject2);
            return fileObject2;
        }

        public FileObject move(FileObject fileObject, String string) throws IOException {
            return this.copy(fileObject, string);
        }

        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            if (string == null) {
                string = FileUtil.findFreeFileName(fileObject, this.getFile().getName(), this.getFile().getExt());
            }
            FileObject fileObject2 = FileUtil.createFolder(fileObject, string);
            FileUtil.copyAttributes(this.getFile(), fileObject2);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        public FileObject rename(String string) throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().rename(fileLock, string, null);
                Object var5_4 = null;
                if (!bl) {
                    fileLock.releaseLock();
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!bl) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            return this.getFile();
        }

        public void delete() throws IOException {
            boolean bl = this.isLocked();
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
                Object var4_3 = null;
                if (!bl) {
                    fileLock.releaseLock();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!bl) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
        }
    }

    public static final class Numb
    extends MultiDataObject.Entry {
        static final long serialVersionUID = -6572157492885890612L;
        static /* synthetic */ Class class$org$openide$loaders$FileEntry;

        public Numb(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        public boolean isImportant() {
            return false;
        }

        public FileObject copy(FileObject fileObject, String string) {
            return null;
        }

        public FileObject rename(String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        public FileObject move(FileObject fileObject, String string) throws IOException {
            this.stdBehaving();
            return null;
        }

        public void delete() throws IOException {
            this.stdBehaving();
        }

        private void stdBehaving() throws IOException {
            if (this.getFile() == null) {
                return;
            }
            if (this.isLocked()) {
                throw new IOException(NbBundle.getBundle(class$org$openide$loaders$FileEntry == null ? (class$org$openide$loaders$FileEntry = Numb.class$("org.openide.loaders.FileEntry")) : class$org$openide$loaders$FileEntry).getString("EXC_SharedAccess"));
            }
            FileLock fileLock = this.takeLock();
            try {
                this.getFile().delete(fileLock);
                Object var3_2 = null;
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
        }

        public FileObject createFromTemplate(FileObject fileObject, String string) {
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static abstract class Format
    extends FileEntry {
        static final long serialVersionUID = 8896750589709521197L;

        public Format(MultiDataObject multiDataObject, FileObject fileObject) {
            super(multiDataObject, fileObject);
        }

        public FileObject createFromTemplate(FileObject fileObject, String string) throws IOException {
            String string2 = this.getFile().getExt();
            if (string == null) {
                string = FileUtil.findFreeFileName(fileObject, this.getFile().getName(), string2);
            }
            FileObject fileObject2 = fileObject.createData(string, string2);
            java.text.Format format = this.createFormat(fileObject, string, string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock fileLock = fileObject2.lock();
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject2.getOutputStream(fileLock)));
                    try {
                        String string3;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            bufferedWriter.write(format.format(string3));
                            bufferedWriter.newLine();
                        }
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        bufferedWriter.close();
                        throw throwable;
                    }
                    bufferedWriter.close();
                    Object var13_13 = null;
                    fileLock.releaseLock();
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    fileLock.releaseLock();
                    throw throwable;
                }
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                bufferedReader.close();
                throw throwable;
            }
            bufferedReader.close();
            FileUtil.copyAttributes(this.getFile(), fileObject2);
            DataObject.setTemplate(fileObject2, false);
            return fileObject2;
        }

        protected abstract java.text.Format createFormat(FileObject var1, String var2, String var3);
    }
}

