/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.nodes.NodeOp;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.SafeException;

public abstract class DataLoader
extends SharedClassObject {
    private static final long serialVersionUID = 1986614061378346169L;
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_ACTIONS = "actions";
    private static final String PROP_DEF_ACTIONS = "defaultActions";
    private static final Object PROP_REPRESENTATION_CLASS = new Object();
    private static final Object PROP_REPRESENTATION_CLASS_NAME = new Object();
    private static final int LOADER_VERSION = 1;
    static /* synthetic */ Class class$org$openide$loaders$DataLoader;

    protected DataLoader(Class clazz) {
        this.putProperty(PROP_REPRESENTATION_CLASS, clazz);
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, clazz.getName());
    }

    protected DataLoader(String string) {
        this.putProperty(PROP_REPRESENTATION_CLASS_NAME, string);
    }

    public final Class getRepresentationClass() {
        Class<?> clazz = (Class<?>)this.getProperty(PROP_REPRESENTATION_CLASS);
        if (clazz != null) {
            return clazz;
        }
        String string = (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
        try {
            clazz = Class.forName(string, false, this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException.toString());
        }
        this.putProperty(PROP_REPRESENTATION_CLASS, clazz);
        return clazz;
    }

    private String getRepresentationClassName() {
        return (String)this.getProperty(PROP_REPRESENTATION_CLASS_NAME);
    }

    public final SystemAction[] getActions() {
        SystemAction[] systemActionArray = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (systemActionArray == null && (systemActionArray = (SystemAction[])this.getProperty(PROP_DEF_ACTIONS)) == null) {
            systemActionArray = this.defaultActions();
            this.putProperty(PROP_DEF_ACTIONS, systemActionArray, false);
        }
        return systemActionArray;
    }

    protected SystemAction[] defaultActions() {
        SystemAction[] systemActionArray = NodeOp.getDefaultActions();
        return systemActionArray;
    }

    public final void setActions(SystemAction[] systemActionArray) {
        this.putProperty(PROP_ACTIONS, systemActionArray, true);
    }

    public final String getDisplayName() {
        String string = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (string != null) {
            return string;
        }
        string = this.defaultDisplayName();
        if (string != null) {
            return string;
        }
        return this.getRepresentationClassName();
    }

    protected final void setDisplayName(String string) {
        this.putProperty(PROP_DISPLAY_NAME, string, true);
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(class$org$openide$loaders$DataLoader == null ? (class$org$openide$loaders$DataLoader = DataLoader.class$("org.openide.loaders.DataLoader")) : class$org$openide$loaders$DataLoader).getString("LBL_loader_display_name");
    }

    public final DataObject findDataObject(FileObject fileObject, RecognizedFiles recognizedFiles) throws IOException {
        try {
            return this.handleFindDataObject(fileObject, recognizedFiles);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            IOException iOException = new IOException();
            TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, throwable);
            throw iOException;
        }
    }

    protected abstract DataObject handleFindDataObject(FileObject var1, RecognizedFiles var2) throws IOException;

    public final void markFile(FileObject fileObject) throws IOException {
        DataLoaderPool.setPreferredLoader(fileObject, this);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        objectOutput.writeObject(new Integer(1));
        SystemAction[] systemActionArray = (SystemAction[])this.getProperty(PROP_ACTIONS);
        if (systemActionArray == null) {
            objectOutput.writeObject(null);
        } else {
            object = new LinkedList();
            int n = 0;
            while (n < systemActionArray.length) {
                if (systemActionArray[n] == null) {
                    ((LinkedList)object).add(null);
                } else {
                    ((LinkedList)object).add(systemActionArray[n].getClass().getName());
                }
                ++n;
            }
            objectOutput.writeObject(((LinkedList)object).toArray());
        }
        object = (String)this.getProperty(PROP_DISPLAY_NAME);
        if (object == null) {
            object = "";
        }
        objectOutput.writeUTF((String)object);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        Object[] objectArray;
        ClassNotFoundException classNotFoundException = null;
        int n = 0;
        Object object2 = objectInput.readObject();
        if (object2 instanceof Integer) {
            n = (Integer)object2;
            object2 = objectInput.readObject();
        }
        if (object2 != null && !(object2 instanceof SystemAction[])) {
            objectArray = (Object[])object2;
            boolean bl = true;
            object = this.getActions();
            if (n > 0 || n == 0 && objectArray.length != ((SystemAction[])object).length) {
                bl = false;
            }
            LinkedList<SystemAction> linkedList = new LinkedList<SystemAction>();
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] == null) {
                    linkedList.add(null);
                    if (n == 0 && bl && object[n2] != null) {
                        bl = false;
                    }
                } else {
                    try {
                        Class<?> clazz = Class.forName(Utilities.translate((String)objectArray[n2]), false, TopManager.getDefault().systemClassLoader());
                        SystemAction systemAction = SystemAction.get(clazz);
                        linkedList.add(systemAction);
                        if (n == 0 && bl && !object[n2].equals(systemAction)) {
                            bl = false;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        TopManager.getDefault().getErrorManager().annotate(classNotFoundException2, 1, null, null, null, null);
                        if (classNotFoundException == null) {
                            classNotFoundException = classNotFoundException2;
                        }
                        TopManager.getDefault().getErrorManager().annotate((Throwable)classNotFoundException, classNotFoundException2);
                    }
                }
                ++n2;
            }
            if (classNotFoundException == null && !bl) {
                this.setActions(linkedList.toArray(new SystemAction[0]));
            }
        }
        if ((objectArray = objectInput.readUTF()).equals("") || n == 0 && objectArray.equals(this.defaultDisplayName())) {
            objectArray = null;
        }
        this.setDisplayName((String)objectArray);
        if (classNotFoundException != null) {
            SafeException safeException = new SafeException(classNotFoundException);
            object = NbBundle.getMessage(class$org$openide$loaders$DataLoader == null ? (class$org$openide$loaders$DataLoader = DataLoader.class$("org.openide.loaders.DataLoader")) : class$org$openide$loaders$DataLoader, "EXC_missing_actions_in_loader", this.getDisplayName());
            TopManager.getDefault().getErrorManager().annotate((Throwable)safeException, (String)object);
            throw safeException;
        }
    }

    protected boolean clearSharedData() {
        return false;
    }

    public static DataLoader getLoader(Class clazz) {
        return (DataLoader)SharedClassObject.findObject(clazz, true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface RecognizedFiles {
        public void markRecognized(FileObject var1);
    }
}

