/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashSet;
import org.openide.ServiceType;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerType;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.SequenceEnumeration;

public class CompilerSupport
implements CompilerCookie {
    private static final String EA_COMPILER_MANAGER = "NetBeansAttrDataObjectCompilerManager";
    public static final String PROP_COMPILER_TYPE = "compiler";
    private MultiDataObject.Entry entry;
    private Class cookie;
    static /* synthetic */ Class class$org$openide$compiler$CompilerType;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    protected CompilerSupport(MultiDataObject.Entry entry, Class clazz) {
        this.entry = entry;
        this.cookie = clazz;
    }

    public boolean isDepthSupported(Compiler.Depth depth) {
        return Compiler.DEPTH_ONE == depth;
    }

    public void addToJob(CompilerJob compilerJob, Compiler.Depth depth) {
        CompilerType compilerType = CompilerSupport.getCompilerType(this.entry);
        if (compilerType == null) {
            compilerType = this.defaultCompilerType();
        }
        if (compilerType == null) {
            throw new IllegalStateException(this.getClass().getName() + ".defaultCompilerType returned null");
        }
        compilerType.prepareJob(compilerJob, this.cookie, this.entry.getDataObject());
    }

    protected CompilerType defaultCompilerType() {
        return CompilerType.getDefault();
    }

    public static void setCompilerType(MultiDataObject.Entry entry, CompilerType compilerType) throws IOException {
        entry.getFile().setAttribute(EA_COMPILER_MANAGER, compilerType == null ? null : new ServiceType.Handle(compilerType));
    }

    public static CompilerType getCompilerType(MultiDataObject.Entry entry) {
        Object object = entry.getFile().getAttribute(EA_COMPILER_MANAGER);
        if (object == null || !(object instanceof ServiceType.Handle)) {
            return null;
        }
        ServiceType serviceType = ((ServiceType.Handle)object).getServiceType();
        if (serviceType instanceof CompilerType) {
            return (CompilerType)serviceType;
        }
        Lookup lookup = Environment.find(entry.getDataObject());
        return (CompilerType)lookup.lookup(class$org$openide$compiler$CompilerType == null ? (class$org$openide$compiler$CompilerType = CompilerSupport.class$("org.openide.compiler.CompilerType")) : class$org$openide$compiler$CompilerType);
    }

    public void addProperties(Sheet.Set set) {
        set.put(this.createCompilerProperty());
    }

    public static void prepareJob(CompilerJob compilerJob, Enumeration enumeration, Class clazz, Compiler.Depth depth) {
        CompilerSupport.prepareJobFor(compilerJob, enumeration, clazz, depth, null);
    }

    static void prepareJobFor(CompilerJob compilerJob, Enumeration enumeration, Class clazz, Compiler.Depth depth, Object object) {
        HashSet<Object> hashSet = new HashSet<Object>(37);
        if (object != null) {
            hashSet.add(object);
        }
        FilterEnumeration filterEnumeration = new FilterEnumeration(CompilerSupport.enumerateForDepth(clazz, enumeration, depth, hashSet));
        while (filterEnumeration.hasMoreElements()) {
            CompilerCookie compilerCookie = (CompilerCookie)filterEnumeration.nextElement();
            compilerCookie.addToJob(compilerJob, depth);
        }
    }

    private static Enumeration enumerateForDepth(Class clazz, Enumeration enumeration, Compiler.Depth depth, HashSet hashSet) {
        QueueEnumeration queueEnumeration = new QueueEnumeration();
        queueEnumeration.put(CompilerSupport.processArray(enumeration, clazz, queueEnumeration, depth, hashSet));
        return new SequenceEnumeration(queueEnumeration);
    }

    private static Enumeration processArray(Enumeration enumeration, final Class clazz, final QueueEnumeration queueEnumeration, final Compiler.Depth depth, final HashSet hashSet) {
        return new AlterEnumeration(enumeration){

            public Object alter(Object object) {
                return CompilerSupport.processObject(object, clazz, queueEnumeration, depth, hashSet);
            }
        };
    }

    private static CompilerCookie processObject(Object object, Class clazz, QueueEnumeration queueEnumeration, Compiler.Depth depth, HashSet hashSet) {
        Node.Cookie cookie;
        if (hashSet.contains(object)) {
            return null;
        }
        CompilerCookie compilerCookie = (CompilerCookie)CompilerSupport.resolveCookie(object, clazz);
        if (compilerCookie != object) {
            hashSet.add(object);
        }
        if (compilerCookie instanceof DataFolder.Cmp && ((DataFolder.Cmp)(cookie = (DataFolder.Cmp)compilerCookie)).wasCreatedFor(object)) {
            compilerCookie = null;
        }
        if (compilerCookie != null) {
            if (hashSet.contains(compilerCookie)) {
                return null;
            }
            hashSet.add(compilerCookie);
            return compilerCookie;
        }
        if (!depth.isLastDepth() && (cookie = (DataObject.Container)CompilerSupport.resolveCookie(object, class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = CompilerSupport.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container)) != null) {
            Object[] objectArray = cookie.getChildren();
            ArrayEnumeration arrayEnumeration = new ArrayEnumeration(objectArray);
            queueEnumeration.put(CompilerSupport.processArray(arrayEnumeration, clazz, queueEnumeration, depth.nextDepth(), hashSet));
        }
        return null;
    }

    private static Object resolveCookie(Object object, Class clazz) {
        Object object2 = null;
        if (object instanceof DataObject) {
            object2 = ((DataObject)object).getCookie(clazz);
        } else if (object instanceof Node) {
            object2 = ((Node)object).getCookie(clazz);
        } else if (clazz.isInstance(object)) {
            object2 = object;
        }
        return object2;
    }

    private PropertySupport createCompilerProperty() {
        return new PropertySupport.ReadWrite(PROP_COMPILER_TYPE, class$org$openide$compiler$CompilerType == null ? (class$org$openide$compiler$CompilerType = CompilerSupport.class$("org.openide.compiler.CompilerType")) : class$org$openide$compiler$CompilerType, DataObject.getString("PROP_compilerType"), DataObject.getString("HINT_compilerType")){

            public Object getValue() {
                CompilerType compilerType = CompilerSupport.getCompilerType(CompilerSupport.this.entry);
                if (compilerType == null) {
                    return CompilerSupport.this.defaultCompilerType();
                }
                return compilerType;
            }

            public void setValue(Object object) throws InvocationTargetException {
                try {
                    CompilerSupport.setCompilerType(CompilerSupport.this.entry, (CompilerType)object);
                }
                catch (IOException iOException) {
                    throw new InvocationTargetException(iOException);
                }
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() throws InvocationTargetException {
                this.setValue(null);
            }

            public boolean canWrite() {
                return !CompilerSupport.this.entry.getFile().isReadOnly();
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Clean
    extends CompilerSupport
    implements CompilerCookie.Clean {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Clean;

        public Clean(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Clean == null ? (class$org$openide$cookies$CompilerCookie$Clean = Clean.class$("org.openide.cookies.CompilerCookie$Clean")) : class$org$openide$cookies$CompilerCookie$Clean);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class Build
    extends CompilerSupport
    implements CompilerCookie.Build {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Build;

        public Build(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Build == null ? (class$org$openide$cookies$CompilerCookie$Build = Build.class$("org.openide.cookies.CompilerCookie$Build")) : class$org$openide$cookies$CompilerCookie$Build);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class Compile
    extends CompilerSupport
    implements CompilerCookie.Compile {
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

        public Compile(MultiDataObject.Entry entry) {
            super(entry, class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = Compile.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

