/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;

public final class Repository
implements Serializable {
    private ArrayList fileSystems;
    private transient ArrayList fileSystemsClone;
    private FileSystem system;
    private Hashtable names;
    private Hashtable listeners = new Hashtable();
    private VetoableChangeListener vetoListener = new VetoableChangeListener(){

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                if (Repository.this.names.get(string2) != null) {
                    throw new PropertyVetoException(this, string, string2, "system name already exists", propertyChangeEvent){
                        static /* synthetic */ Class class$org$openide$filesystems$Repository;
                        private final /* synthetic */ String val$ov;
                        private final /* synthetic */ String val$nv;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$ov = string;
                            this.val$nv = string2;
                        }

                        public String getLocalizedMessage() {
                            return NbBundle.getMessage(class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = 2.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository, "EXC_duplicate_system_name", this.val$ov, this.val$nv);
                        }

                        static /* synthetic */ Class class$(String string) {
                            try {
                                return Class.forName(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                    };
                }
            }
        }
    };
    private PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("systemName")) {
                String string = (String)propertyChangeEvent.getOldValue();
                String string2 = (String)propertyChangeEvent.getNewValue();
                FileSystem fileSystem = (FileSystem)propertyChangeEvent.getSource();
                if (fileSystem.isValid()) {
                    Repository.this.names.remove(string);
                }
                Repository.this.names.put(string2, fileSystem);
                fileSystem.setValid(true);
            }
        }
    };
    static final long serialVersionUID = -6344768369160069704L;

    public Repository(FileSystem fileSystem) {
        this.system = fileSystem;
        this.init();
    }

    public static Repository getDefault() {
        return ExternalUtil.getRepository();
    }

    private void init() {
        this.fileSystems = new ArrayList();
        this.names = new Hashtable();
        this.addFileSystem(this.system);
    }

    public FileSystem getDefaultFileSystem() {
        return this.system;
    }

    public final void addFileSystem(FileSystem fileSystem) {
        boolean bl = false;
        Repository repository = this;
        synchronized (repository) {
            if (!fileSystem.assigned && !this.fileSystems.contains(fileSystem)) {
                boolean bl2;
                this.fileSystems.add(fileSystem);
                this.fileSystemsClone = (ArrayList)this.fileSystems.clone();
                String string = fileSystem.getSystemName();
                boolean bl3 = bl2 = this.names.get(string) == null;
                if (bl2 && !string.equals("")) {
                    this.names.put(string, fileSystem);
                    fileSystem.setValid(true);
                } else {
                    fileSystem.setValid(false);
                }
                fileSystem.assigned = true;
                fileSystem.addPropertyChangeListener(this.propListener);
                fileSystem.addVetoableChangeListener(this.vetoListener);
                fileSystem.addNotify();
                bl = true;
            }
        }
        if (bl) {
            this.fireFileSystem(fileSystem, true);
        }
    }

    public final void removeFileSystem(FileSystem fileSystem) {
        boolean bl = false;
        Repository repository = this;
        synchronized (repository) {
            if (fileSystem.isDefault()) {
                return;
            }
            bl = ((AbstractCollection)this.fileSystems).remove(fileSystem);
            if (bl) {
                this.fileSystemsClone = (ArrayList)this.fileSystems.clone();
                if (fileSystem.isValid()) {
                    this.names.remove(fileSystem.getSystemName());
                    fileSystem.setValid(false);
                }
                fileSystem.removePropertyChangeListener(this.propListener);
                fileSystem.removeVetoableChangeListener(this.vetoListener);
                fileSystem.removeNotify();
            }
            fileSystem.assigned = false;
        }
        if (bl) {
            this.fireFileSystem(fileSystem, false);
        }
    }

    public final void reorder(int[] nArray) {
        Repository repository = this;
        synchronized (repository) {
            if (nArray == null) {
                throw new IllegalArgumentException("null permutation");
            }
            if (nArray.length != this.fileSystems.size()) {
                throw new IllegalArgumentException("permutation is wrong size: " + nArray.length + " elements but should be " + this.fileSystems.size());
            }
            if (!Repository.isPermutation(nArray)) {
                StringBuffer stringBuffer = new StringBuffer("permutation is not really a permutation:");
                int n = 0;
                while (n < nArray.length) {
                    stringBuffer.append(' ');
                    stringBuffer.append(nArray[n]);
                    ++n;
                }
                throw new IllegalArgumentException(stringBuffer.toString());
            }
            ArrayList arrayList = new ArrayList(this.fileSystems.size());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                arrayList.add(this.fileSystems.get(nArray[n2]));
                ++n2;
            }
            this.fileSystems = arrayList;
            this.fileSystemsClone = (ArrayList)this.fileSystems.clone();
        }
        this.fireFileSystemReordered(nArray);
    }

    private static boolean isPermutation(int[] nArray) {
        int n = nArray.length;
        boolean[] blArray = new boolean[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                if (blArray[nArray[n2]]) {
                    return false;
                }
                blArray[nArray[n2]] = true;
                ++n2;
            }
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public final Enumeration getFileSystems() {
        ArrayList arrayList = this.fileSystemsClone;
        return Collections.enumeration(arrayList);
    }

    public final Enumeration fileSystems() {
        return this.getFileSystems();
    }

    public final FileSystem[] toArray() {
        ArrayList arrayList = this.fileSystemsClone;
        FileSystem[] fileSystemArray = new FileSystem[arrayList.size()];
        arrayList.toArray(fileSystemArray);
        return fileSystemArray;
    }

    public final FileSystem findFileSystem(String string) {
        FileSystem fileSystem = (FileSystem)this.names.get(string);
        return fileSystem;
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        Iterator iterator = ((AbstractList)this.fileSystems).iterator();
        while (iterator.hasNext()) {
            FileSystem fileSystem = (FileSystem)iterator.next();
            if (fileSystem.isDefault() || fileSystem.isPersistent()) continue;
            objectOutput.writeObject(new NbMarshalledObject(fileSystem));
        }
        objectOutput.writeObject(null);
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        FileSystem fileSystem;
        Object object2;
        ArrayList<FileSystem> arrayList = new ArrayList<FileSystem>(10);
        while ((object2 = objectInput.readObject()) != null) {
            if (object2 instanceof FileSystem) {
                fileSystem = (FileSystem)object2;
            } else {
                try {
                    object = (NbMarshalledObject)object2;
                    fileSystem = (FileSystem)((NbMarshalledObject)object).get();
                }
                catch (IOException iOException) {
                    ExternalUtil.exception(iOException);
                    fileSystem = null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ExternalUtil.exception(classNotFoundException);
                    fileSystem = null;
                }
            }
            if (fileSystem == null) continue;
            arrayList.add(fileSystem);
        }
        object2 = this.getFileSystems();
        while (object2.hasMoreElements()) {
            fileSystem = (FileSystem)object2.nextElement();
            if (fileSystem.isPersistent()) continue;
            this.removeFileSystem(fileSystem);
        }
        this.system.assigned = false;
        this.init();
        object = ((AbstractList)arrayList).iterator();
        while (object.hasNext()) {
            this.addFileSystem((FileSystem)object.next());
        }
    }

    public final FileObject find(String string, String string2, String string3) {
        Enumeration enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public FileObject findResource(String string) {
        Enumeration enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public Enumeration findAllResources(String string) {
        Vector<FileObject> vector = new Vector<FileObject>(8);
        Enumeration enumeration = this.getFileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    public final Enumeration findAll(String string, String string2, String string3) {
        Enumeration enumeration = this.getFileSystems();
        Vector<FileObject> vector = new Vector<FileObject>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    private void fireFileSystem(FileSystem fileSystem, boolean bl) {
        Enumeration enumeration = ((Hashtable)this.listeners.clone()).elements();
        RepositoryEvent repositoryEvent = new RepositoryEvent(this, fileSystem, bl);
        while (enumeration.hasMoreElements()) {
            RepositoryListener repositoryListener = (RepositoryListener)enumeration.nextElement();
            if (bl) {
                repositoryListener.fileSystemAdded(repositoryEvent);
                continue;
            }
            repositoryListener.fileSystemRemoved(repositoryEvent);
        }
    }

    private void fireFileSystemReordered(int[] nArray) {
        Enumeration enumeration = ((Hashtable)this.listeners.clone()).elements();
        RepositoryReorderedEvent repositoryReorderedEvent = new RepositoryReorderedEvent(this, nArray);
        while (enumeration.hasMoreElements()) {
            RepositoryListener repositoryListener = (RepositoryListener)enumeration.nextElement();
            repositoryListener.fileSystemPoolReordered(repositoryReorderedEvent);
        }
    }

    public void addRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.put(repositoryListener, repositoryListener);
    }

    public void removeRepositoryListener(RepositoryListener repositoryListener) {
        this.listeners.remove(repositoryListener);
    }

    private Object writeReplace() {
        return new Replacer();
    }

    private static class Replacer
    implements Serializable {
        static final long serialVersionUID = -3814531276726840241L;

        private Replacer() {
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            ExternalUtil.getRepository().writeExternal(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ExternalUtil.getRepository().readExternal(objectInputStream);
        }

        public Object readResolve() {
            return ExternalUtil.getRepository();
        }
    }
}

