/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Lookup;

final class MIMESupport {
    private static Map cache;
    private static LinkedList recentlist;
    private static int cachesize;
    private static MIMESupport defaultInst;
    private static final int MAX_CACHE_SIZE = 5;

    static String findMIMEType(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        if (!CachedFileObject.isAnyResolver()) {
            return null;
        }
        CachedFileObject cachedFileObject = MIMESupport.getDefault().getCachedFileObject(fileObject);
        return cachedFileObject.getMIMEType();
    }

    private static MIMESupport getDefault() {
        if (defaultInst == null) {
            defaultInst = new MIMESupport();
        }
        return defaultInst;
    }

    private MIMESupport() {
        cachesize = 5;
        cache = new HashMap(cachesize);
        recentlist = new LinkedList();
    }

    private CachedFileObject getCachedFileObject(FileObject fileObject) {
        CachedFileObject cachedFileObject = null;
        Map map = cache;
        synchronized (map) {
            cachedFileObject = (CachedFileObject)cache.get(fileObject);
            if (cachedFileObject == null) {
                if (recentlist.size() > cachesize) {
                    cache.remove(recentlist.getLast());
                    recentlist.removeLast();
                }
                cachedFileObject = new CachedFileObject(fileObject);
                cache.put(fileObject, cachedFileObject);
                recentlist.addFirst(fileObject);
            } else {
                boolean bl;
                boolean bl2 = bl = fileObject.lastModified().getTime() != cachedFileObject.lastModified().getTime();
                if (bl) {
                    cachedFileObject = new CachedFileObject(fileObject);
                    cache.put(fileObject, cachedFileObject);
                }
                recentlist.remove(fileObject);
                recentlist.addFirst(fileObject);
            }
        }
        return cachedFileObject;
    }

    private static class CachedInputStream
    extends InputStream {
        private InputStream inputStream;
        private byte[] buffer = new byte[256];
        private int len = 0;
        private int pos = 0;
        private boolean eof = false;

        CachedInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void close() throws IOException {
        }

        void internalClose() {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void finalize() {
            this.internalClose();
        }

        public int read() throws IOException {
            if (this.eof) {
                return -1;
            }
            if (this.pos < this.len) {
                int n;
                n = (n = this.buffer[this.pos++]) < 0 ? n + 256 : n;
                return n;
            }
            int n = this.inputStream.read();
            if (n < 0) {
                this.eof = true;
                return -1;
            }
            if (this.len >= this.buffer.length) {
                byte[] byArray = new byte[this.buffer.length * 2 + 1];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
                this.buffer = byArray;
            }
            this.buffer[this.len++] = n > 127 ? (byte)(n - 256) : (byte)n;
            this.pos = this.len;
            return n;
        }

        void cacheToStart() {
            this.pos = 0;
            this.eof = false;
        }

        public String toString() {
            String string = super.toString() + '[' + this.inputStream.toString() + ']' + '\n';
            string = string + new String(this.buffer);
            return string;
        }
    }

    private static class CachedFileObject
    extends FileObject
    implements FileChangeListener {
        String mimeType;
        Date lastModified;
        static Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$filesystems$MIMEResolver == null ? (class$org$openide$filesystems$MIMEResolver = CachedFileObject.class$("org.openide.filesystems.MIMEResolver")) : class$org$openide$filesystems$MIMEResolver));
        CachedInputStream fixIt;
        FileObject fileObj;
        static /* synthetic */ Class class$org$openide$filesystems$MIMEResolver;

        CachedFileObject(FileObject fileObject) {
            this.fileObj = fileObject;
            this.lastModified = this.fileObj.lastModified();
            this.fileObj.addFileChangeListener(this);
        }

        public static boolean isAnyResolver() {
            return !result.allInstances().isEmpty();
        }

        public void freeCaches() {
            this.fixIt = null;
            this.mimeType = null;
            this.lastModified = null;
        }

        public String getMIMEType() {
            if (this.mimeType == null) {
                this.mimeType = this.resolveMIME();
            }
            return this.mimeType;
        }

        private String resolveMIME() {
            String string = null;
            Iterator iterator = result.allInstances().iterator();
            try {
                while (iterator.hasNext()) {
                    MIMEResolver mIMEResolver = (MIMEResolver)iterator.next();
                    string = mIMEResolver.findMIMEType(this);
                    if (string == null) continue;
                    String string2 = string;
                    Object var6_5 = null;
                    if (this.fixIt != null) {
                        this.fixIt.internalClose();
                    }
                    this.fixIt = null;
                    return string2;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (this.fixIt != null) {
                    this.fixIt.internalClose();
                }
                this.fixIt = null;
                throw throwable;
            }
            Object var6_6 = null;
            if (this.fixIt != null) {
                this.fixIt.internalClose();
            }
            this.fixIt = null;
            return FileUtil.getMIMEType(this.getExt());
        }

        public Date lastModified() {
            if (this.lastModified != null) {
                return this.lastModified;
            }
            this.lastModified = this.fileObj.lastModified();
            return this.lastModified;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            if (this.fixIt == null) {
                InputStream inputStream = this.fileObj.getInputStream();
                if (!(inputStream instanceof BufferedInputStream)) {
                    inputStream = new BufferedInputStream(inputStream);
                }
                this.fixIt = new CachedInputStream(inputStream);
            }
            this.fixIt.cacheToStart();
            return this.fixIt;
        }

        public void fileChanged(FileEvent fileEvent) {
            this.freeCaches();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.freeCaches();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.freeCaches();
        }

        public FileObject getParent() {
            return this.fileObj.getParent();
        }

        public String getPackageNameExt(char c, char c2) {
            return this.fileObj.getPackageNameExt(c, c2);
        }

        public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.copy(fileObject, string, string2);
        }

        protected void fireFileDeletedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDeletedEvent(enumeration, fileEvent);
        }

        protected void fireFileFolderCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileFolderCreatedEvent(enumeration, fileEvent);
        }

        public void setImportant(boolean bl) {
            this.fileObj.setImportant(bl);
        }

        public boolean isData() {
            return this.fileObj.isData();
        }

        public Object getAttribute(String string) {
            return this.fileObj.getAttribute(string);
        }

        public Enumeration getFolders(boolean bl) {
            return this.fileObj.getFolders(bl);
        }

        public void delete(FileLock fileLock) throws IOException {
            this.fileObj.delete(fileLock);
        }

        public boolean isRoot() {
            return this.fileObj.isRoot();
        }

        public Enumeration getData(boolean bl) {
            return this.fileObj.getData(bl);
        }

        public FileObject[] getChildren() {
            return this.fileObj.getChildren();
        }

        public String getNameExt() {
            return this.fileObj.getNameExt();
        }

        public boolean isValid() {
            return this.fileObj.isValid();
        }

        public boolean isReadOnly() {
            return this.fileObj.isReadOnly();
        }

        public String getExt() {
            return this.fileObj.getExt();
        }

        public String getName() {
            return this.fileObj.getName();
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.removeFileChangeListener(fileChangeListener);
        }

        protected void fireFileRenamedEvent(Enumeration enumeration, FileRenameEvent fileRenameEvent) {
            this.fileObj.fireFileRenamedEvent(enumeration, fileRenameEvent);
        }

        public void refresh(boolean bl) {
            this.fileObj.refresh(bl);
        }

        protected void fireFileAttributeChangedEvent(Enumeration enumeration, FileAttributeEvent fileAttributeEvent) {
            this.fileObj.fireFileAttributeChangedEvent(enumeration, fileAttributeEvent);
        }

        public long getSize() {
            return this.fileObj.getSize();
        }

        public Enumeration getAttributes() {
            return this.fileObj.getAttributes();
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            this.fileObj.rename(fileLock, string, string2);
        }

        protected void fireFileChangedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileChangedEvent(enumeration, fileEvent);
        }

        public FileObject getFileObject(String string, String string2) {
            return this.fileObj.getFileObject(string, string2);
        }

        public void refresh() {
            this.fileObj.refresh();
        }

        public FileObject createData(String string, String string2) throws IOException {
            return this.fileObj.createData(string, string2);
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
            this.fileObj.addFileChangeListener(fileChangeListener);
        }

        protected void fireFileDataCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
            this.fileObj.fireFileDataCreatedEvent(enumeration, fileEvent);
        }

        public boolean isFolder() {
            return this.fileObj.isFolder();
        }

        public FileObject createFolder(String string) throws IOException {
            return this.fileObj.createFolder(string);
        }

        public Enumeration getChildren(boolean bl) {
            return this.fileObj.getChildren(bl);
        }

        public void setAttribute(String string, Object object) throws IOException {
            this.fileObj.setAttribute(string, object);
        }

        public String getPackageName(char c) {
            return this.fileObj.getPackageName(c);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            return this.fileObj.getFileSystem();
        }

        public OutputStream getOutputStream(FileLock fileLock) throws IOException {
            return this.fileObj.getOutputStream(fileLock);
        }

        public boolean existsExt(String string) {
            return this.fileObj.existsExt(string);
        }

        public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
            return this.fileObj.move(fileLock, fileObject, string, string2);
        }

        public FileLock lock() throws IOException {
            return this.fileObj.lock();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public int hashCode() {
            return this.fileObj.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CachedFileObject) {
                return ((CachedFileObject)object).fileObj.equals(this.fileObj);
            }
            return super.equals(object);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

