/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.openide.filesystems.DefaultAttributes;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.MIMESupport;
import org.openide.filesystems.Repository;
import org.openide.util.Utilities;

public final class FileUtil {
    static final Set transientAttributes = new HashSet();
    private static Dictionary map;

    private FileUtil() {
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    static FileObject copyFileImpl(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        OutputStream outputStream;
        FileLock fileLock;
        FileObject fileObject3;
        block7: {
            fileObject3 = fileObject2.createData(string, string2);
            fileLock = null;
            InputStream inputStream = null;
            outputStream = null;
            try {
                fileLock = fileObject3.lock();
                inputStream = fileObject.getInputStream();
                outputStream = fileObject3.getOutputStream(fileLock);
                FileUtil.copy(inputStream, outputStream);
                FileUtil.copyAttributes(fileObject, fileObject3);
                Object var9_8 = null;
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (fileLock != null) {
            fileLock.releaseLock();
        }
        return fileObject3;
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string, String string2) throws IOException {
        return fileObject.copy(fileObject2, string, string2);
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        return FileUtil.copyFile(fileObject, fileObject2, string, fileObject.getExt());
    }

    public static FileObject moveFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            FileObject fileObject3 = fileObject.move(fileLock, fileObject2, string, fileObject.getExt());
            Object var6_5 = null;
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            return fileObject3;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (fileLock == null) break block3;
                fileLock.releaseLock();
            }
            throw throwable;
        }
    }

    public static FileObject createFolder(FileObject fileObject, String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreElements()) {
            FileObject fileObject2;
            block4: {
                string = stringTokenizer.nextToken();
                if (string.length() <= 0) continue;
                fileObject2 = fileObject.getFileObject(string);
                if (fileObject2 == null) {
                    try {
                        fileObject2 = fileObject.createFolder(string);
                    }
                    catch (SyncFailedException syncFailedException) {
                        fileObject.refresh();
                        fileObject2 = fileObject.getFileObject(string);
                        if (fileObject2 != null) break block4;
                        throw syncFailedException;
                    }
                }
            }
            fileObject = fileObject2;
        }
        return fileObject;
    }

    public static FileObject createData(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2;
        block8: {
            String string2;
            String string3;
            String string4;
            int n = string.lastIndexOf(47);
            if (n >= string.length()) {
                throw new IOException("Wrong file name.");
            }
            if (n != -1) {
                String string5 = string.substring(0, n);
                string4 = string.substring(n + 1);
                fileObject = FileUtil.createFolder(fileObject, string5);
            } else {
                string4 = string;
            }
            n = string4.lastIndexOf(46);
            if (n != -1) {
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
            } else {
                string3 = string4;
                string2 = "";
            }
            fileObject2 = fileObject.getFileObject(string3, string2);
            if (fileObject2 == null) {
                try {
                    fileObject2 = fileObject.createData(string3, string2);
                }
                catch (SyncFailedException syncFailedException) {
                    fileObject.refresh();
                    fileObject2 = fileObject.getFileObject(string3, string2);
                    if (fileObject2 != null) break block8;
                    throw syncFailedException;
                }
            }
        }
        return fileObject2;
    }

    public static File toFile(FileObject fileObject) {
        return (File)fileObject.getAttribute("java.io.File");
    }

    /*
     * Unable to fully structure code
     */
    public static FileObject[] fromFile(File var0) {
        var1_1 = Repository.getDefault().getFileSystems();
        var2_2 = new ArrayList<FileObject>();
        var3_3 = null;
        try {
            var0 = var0.getCanonicalFile();
            var3_3 = var0.getCanonicalPath();
            if (true) ** GOTO lbl24
        }
        catch (IOException var4_4) {
            return new FileObject[0];
        }
        do {
            var4_5 = (FileSystem)var1_1.nextElement();
            try {
                var5_6 = FileUtil.toFile(var4_5.getRoot());
                if (var5_6 == null || var3_3.indexOf(var6_8 = var5_6.getCanonicalPath()) != 0) continue;
                var7_9 = var3_3.substring(var6_8.length()).replace(File.separatorChar, '/');
                var8_10 = var4_5.findResource(var7_9);
                v0 = var9_11 = var8_10 != null ? FileUtil.toFile(var8_10) : null;
                if (var8_10 == null || var9_11 == null || !var0.equals(var9_11.getCanonicalFile())) continue;
                var2_2.add(var8_10);
            }
            catch (IOException var5_7) {
                // empty catch block
            }
lbl24:
            // 5 sources

        } while (var1_1.hasMoreElements());
        var4_5 = new FileObject[var2_2.size()];
        var2_2.toArray((T[])var4_5);
        return var4_5;
    }

    public static void copyAttributes(FileObject fileObject, FileObject fileObject2) throws IOException {
        Enumeration enumeration = fileObject.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (transientAttributes.contains(string) || (object = fileObject.getAttribute(string)) == null) continue;
            fileObject2.setAttribute(string, object);
        }
    }

    public static void extractJar(final FileObject fileObject, final InputStream inputStream) throws IOException {
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                FileUtil.extractJarImpl(fileObject, inputStream);
            }
        });
    }

    private static void extractJarImpl(FileObject fileObject, InputStream inputStream) throws IOException {
        Iterator iterator;
        String string;
        Object object;
        Object object2;
        Object object3;
        JarEntry jarEntry;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(7);
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
            object3 = jarEntry.getName();
            if (((String)object3).toLowerCase().startsWith("meta-inf/")) continue;
            if (jarEntry.isDirectory()) {
                FileUtil.createFolder(fileObject, (String)object3);
                continue;
            }
            if (DefaultAttributes.acceptName((String)object3)) {
                object2 = DefaultAttributes.loadTable(jarInputStream, (String)object3);
                hashMap.put(object3, object2);
                continue;
            }
            object2 = FileUtil.createData(fileObject, (String)object3);
            object = ((FileObject)object2).lock();
            try {
                OutputStream outputStream = ((FileObject)object2).getOutputStream((FileLock)object);
                try {
                    FileUtil.copy(jarInputStream, outputStream);
                    string = null;
                }
                catch (Throwable throwable) {
                    string = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                iterator = null;
                ((FileLock)object).releaseLock();
            }
            catch (Throwable throwable) {
                iterator = null;
                ((FileLock)object).releaseLock();
                throw throwable;
            }
        }
        object3 = hashMap.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            object = (String)object2.getKey();
            int n = ((String)object).lastIndexOf(47);
            String string2 = n != -1 ? ((String)object).substring(0, n + 1) : "";
            string = fileObject.isRoot() ? string2 : fileObject.getPackageName('/') + '/' + string2;
            DefaultAttributes.Table table = (DefaultAttributes.Table)object2.getValue();
            iterator = table.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = string + string3;
                FileObject fileObject2 = fileObject.getFileSystem().findResource(string4);
                if (fileObject2 == null) continue;
                Enumeration enumeration = table.attrs(string3);
                while (enumeration.hasMoreElements()) {
                    String string5 = (String)enumeration.nextElement();
                    Object object4 = table.getAttr(string3, string5);
                    if (object4 == null) continue;
                    fileObject2.setAttribute(string5, object4);
                }
            }
        }
    }

    public static String getExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String findFreeFileName(FileObject fileObject, String string, String string2) {
        if (FileUtil.checkFreeName(fileObject, string, string2)) {
            return string;
        }
        int n = 1;
        String string3;
        while (!FileUtil.checkFreeName(fileObject, string3 = string + "_" + n, string2)) {
            ++n;
        }
        return string3;
    }

    public static String findFreeFolderName(FileObject fileObject, String string) {
        if (FileUtil.checkFreeName(fileObject, string, null)) {
            return string;
        }
        int n = 1;
        String string2;
        while (!FileUtil.checkFreeName(fileObject, string2 = string + "_" + n, null)) {
            ++n;
        }
        return string2;
    }

    private static boolean checkFreeName(FileObject fileObject, String string, String string2) {
        if (Utilities.isWindows()) {
            Enumeration enumeration = fileObject.getChildren(false);
            while (enumeration.hasMoreElements()) {
                fileObject = (FileObject)enumeration.nextElement();
                String string3 = fileObject.getName();
                String string4 = fileObject.getExt();
                if (!string3.equalsIgnoreCase(string)) continue;
                if (!(string2 != null && string2.trim().length() != 0 || string4 != null && string4.trim().length() != 0)) {
                    return false;
                }
                if (string2 == null || string4 == null || !string2.equalsIgnoreCase(string4)) continue;
                return false;
            }
            return true;
        }
        if (string2 == null) {
            return fileObject.getFileObject(string) == null;
        }
        return fileObject.getFileObject(string, string2) == null;
    }

    public static FileObject findBrother(FileObject fileObject, String string) {
        if (fileObject == null) {
            return null;
        }
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null) {
            return null;
        }
        return fileObject2.getFileObject(fileObject.getName(), string);
    }

    public static String getMIMEType(String string) {
        String string2 = (String)map.get(string);
        if (string2 != null) {
            return string2;
        }
        return (String)map.get(string.toLowerCase());
    }

    public static String getMIMEType(FileObject fileObject) {
        String string = MIMESupport.findMIMEType(fileObject);
        if (string == null) {
            string = FileUtil.getMIMEType(fileObject.getExt());
        }
        return string;
    }

    public static void setMIMEType(String string, String string2) {
        Dictionary dictionary = map;
        synchronized (dictionary) {
            String string3 = (String)map.get(string);
            if (string3 == null) {
                map.put(string, string2);
            } else if (!string3.equals(string2)) {
                throw new IllegalArgumentException("Cannot overwrite existing MIME type mapping for extension `" + string + "' with " + string2 + " (was " + string3 + ")");
            }
        }
    }

    static {
        transientAttributes.add("templateWizardURL");
        transientAttributes.add("templateWizardIterator");
        transientAttributes.add("templateWizardDescResource");
        transientAttributes.add("SystemFileSystem.localizingBundle");
        transientAttributes.add("SystemFileSystem.icon");
        transientAttributes.add("SystemFileSystem.icon32");
        map = new Hashtable();
        FileUtil.setMIMEType("", "content/unknown");
        FileUtil.setMIMEType("uu", "application/octet-stream");
        FileUtil.setMIMEType("exe", "application/octet-stream");
        FileUtil.setMIMEType("ps", "application/postscript");
        FileUtil.setMIMEType("zip", "application/zip");
        FileUtil.setMIMEType("class", "application/octet-stream");
        FileUtil.setMIMEType("jar", "application/x-jar");
        FileUtil.setMIMEType("sh", "application/x-shar");
        FileUtil.setMIMEType("tar", "application/x-tar");
        FileUtil.setMIMEType("snd", "audio/basic");
        FileUtil.setMIMEType("au", "audio/basic");
        FileUtil.setMIMEType("wav", "audio/x-wav");
        FileUtil.setMIMEType("gif", "image/gif");
        FileUtil.setMIMEType("jpg", "image/jpeg");
        FileUtil.setMIMEType("jpeg", "image/jpeg");
        FileUtil.setMIMEType("htm", "text/html");
        FileUtil.setMIMEType("html", "text/html");
        FileUtil.setMIMEType("xml", "text/xml");
        FileUtil.setMIMEType("xsl", "text/xml");
        FileUtil.setMIMEType("xsd", "text/xml");
        FileUtil.setMIMEType("dtd", "text/x-dtd");
        FileUtil.setMIMEType("css", "text/css");
        FileUtil.setMIMEType("text", "text/plain");
        FileUtil.setMIMEType("pl", "text/plain");
        FileUtil.setMIMEType("txt", "text/plain");
        FileUtil.setMIMEType("properties", "text/plain");
        FileUtil.setMIMEType("java", "text/x-java");
        FileUtil.setMIMEType("ra", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("ram", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("rm", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("rpm", "audio/x-pn-realaudio");
        FileUtil.setMIMEType("mov", "video/quicktime");
        FileUtil.setMIMEType("jsp", "text/plain");
    }
}

