/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.EventControl;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileURL;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileObject;
import org.openide.util.NbBundle;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;

public abstract class FileObject
implements Serializable {
    static final long serialVersionUID = 85305031923497718L;
    static /* synthetic */ Class class$org$openide$filesystems$FileObject;

    public abstract String getName();

    public abstract String getExt();

    public abstract void rename(FileLock var1, String var2, String var3) throws IOException;

    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        if (this.isFolder()) {
            throw new IOException(NbBundle.getBundle(class$org$openide$filesystems$FileObject == null ? (class$org$openide$filesystems$FileObject = FileObject.class$("org.openide.filesystems.FileObject")) : class$org$openide$filesystems$FileObject).getString("EXC_FolderCopy"));
        }
        FileObject fileObject2 = FileUtil.copyFileImpl(this, fileObject, string, string2);
        return fileObject2;
    }

    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        if (this.getParent().equals(fileObject)) {
            this.rename(fileLock, string, string2);
            return this;
        }
        FileObject fileObject2 = this.copy(fileObject, string, string2);
        this.delete(fileLock);
        return fileObject2;
    }

    public String toString() {
        return this.getPackageNameExt('/', '.');
    }

    public String getPackageNameExt(char c, char c2) {
        String string = this.getPackageName(c);
        String string2 = this.getExt();
        if (!string2.equals("")) {
            return string + c2 + string2;
        }
        return string;
    }

    public String getPackageName(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        this.constructName(stringBuffer, c);
        return stringBuffer.toString();
    }

    public String getNameExt() {
        String string = this.getName();
        String string2 = this.getExt();
        return string2 == null || string2.length() == 0 ? string : string + '.' + string2;
    }

    private void constructName(StringBuffer stringBuffer, char c) {
        FileObject fileObject = this.getParent();
        if (fileObject != null && !fileObject.isRoot()) {
            fileObject.constructName(stringBuffer, c);
            stringBuffer.append(c);
        }
        stringBuffer.append(this.getName());
    }

    public abstract FileSystem getFileSystem() throws FileStateInvalidException;

    public abstract FileObject getParent();

    public abstract boolean isFolder();

    public abstract Date lastModified();

    public abstract boolean isRoot();

    public abstract boolean isData();

    public abstract boolean isValid();

    public boolean existsExt(String string) {
        FileObject fileObject = this.getParent();
        return fileObject != null && fileObject.getFileObject(this.getName(), string) != null;
    }

    public abstract void delete(FileLock var1) throws IOException;

    public final void delete() throws IOException {
        FileLock fileLock = this.lock();
        try {
            this.delete(fileLock);
            Object var3_2 = null;
            fileLock.releaseLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            fileLock.releaseLock();
            throw throwable;
        }
    }

    public abstract Object getAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2) throws IOException;

    public abstract Enumeration getAttributes();

    public final boolean hasExt(String string) {
        if (this.isHasExtOverride()) {
            return this.hasExtOverride(string);
        }
        return this.getExt().equals(string);
    }

    boolean isHasExtOverride() {
        return false;
    }

    boolean hasExtOverride(String string) {
        return false;
    }

    public abstract void addFileChangeListener(FileChangeListener var1);

    public abstract void removeFileChangeListener(FileChangeListener var1);

    protected void fireFileDataCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(0, enumeration, fileEvent);
    }

    protected void fireFileFolderCreatedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(1, enumeration, fileEvent);
    }

    protected void fireFileChangedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(2, enumeration, fileEvent);
    }

    protected void fireFileDeletedEvent(Enumeration enumeration, FileEvent fileEvent) {
        this.dispatchEvent(3, enumeration, fileEvent);
    }

    protected void fireFileAttributeChangedEvent(Enumeration enumeration, FileAttributeEvent fileAttributeEvent) {
        this.dispatchEvent(5, enumeration, fileAttributeEvent);
    }

    protected void fireFileRenamedEvent(Enumeration enumeration, FileRenameEvent fileRenameEvent) {
        this.dispatchEvent(4, enumeration, fileRenameEvent);
    }

    private final void dispatchEvent(int n, Enumeration enumeration, FileEvent fileEvent) {
        try {
            FileSystem fileSystem = this.getFileSystem();
            fileSystem.dispatchEvent(new ED(n, enumeration, fileEvent));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public String getMIMEType() {
        String string = FileUtil.getMIMEType(this);
        return string == null ? "content/unknown" : string;
    }

    public abstract long getSize();

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public abstract OutputStream getOutputStream(FileLock var1) throws IOException;

    public abstract FileLock lock() throws IOException;

    public abstract void setImportant(boolean var1);

    public abstract FileObject[] getChildren();

    public Enumeration getChildren(final boolean bl) {
        QueueEnumeration queueEnumeration = new QueueEnumeration(){

            public void process(Object object) {
                FileObject fileObject = (FileObject)object;
                if (bl && fileObject.isFolder()) {
                    this.put(fileObject.getChildren());
                }
            }
        };
        queueEnumeration.put(this.getChildren());
        return queueEnumeration;
    }

    public Enumeration getFolders(boolean bl) {
        return new FilterEnumeration(this.getChildren(bl)){

            protected boolean accept(Object object) {
                return ((FileObject)object).isFolder();
            }
        };
    }

    public Enumeration getData(boolean bl) {
        return new FilterEnumeration(this.getChildren(bl)){

            protected boolean accept(Object object) {
                return ((FileObject)object).isData();
            }
        };
    }

    public abstract FileObject getFileObject(String var1, String var2);

    public final FileObject getFileObject(String string) {
        return this.getFileObject(string, null);
    }

    public abstract FileObject createFolder(String var1) throws IOException;

    public abstract FileObject createData(String var1, String var2) throws IOException;

    public FileObject createData(String string) throws IOException {
        return this.createData(string, "");
    }

    public abstract boolean isReadOnly();

    public void refresh(boolean bl) {
    }

    public void refresh() {
        this.refresh(false);
    }

    public final URL getURL() throws FileStateInvalidException {
        return FileURL.encodeFileObject(this);
    }

    public boolean isVirtual() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ED
    extends FileSystem.EventDispatcher {
        private int op;
        private Enumeration en;
        private FileEvent fe;
        public static final int DATA_CREATED = 0;
        public static final int FOLDER_CREATED = 1;
        public static final int FILE_CHANGED = 2;
        public static final int FILE_DELETED = 3;
        public static final int FILE_RENAMED = 4;
        public static final int ATTR_CHANGED = 5;

        public ED(int n, Enumeration enumeration, FileEvent fileEvent) {
            this.op = n;
            this.en = enumeration;
            this.fe = fileEvent;
        }

        private boolean isPriorityListener(FileChangeListener fileChangeListener) {
            return fileChangeListener instanceof MultiFileObject.MfoWeakListener;
        }

        protected void dispatch(boolean bl) {
            QueueEnumeration queueEnumeration = new QueueEnumeration();
            while (this.en.hasMoreElements()) {
                FileChangeListener fileChangeListener = (FileChangeListener)this.en.nextElement();
                if (bl && !this.isPriorityListener(fileChangeListener)) {
                    queueEnumeration.put(fileChangeListener);
                    continue;
                }
                FileObject fileObject = this.fe.getFile();
                if (fileObject != null && (this.op == 0 || this.op == 1)) {
                    this.op = fileObject.isFolder() ? 1 : 0;
                }
                switch (this.op) {
                    case 0: {
                        fileChangeListener.fileDataCreated(this.fe);
                        break;
                    }
                    case 1: {
                        fileChangeListener.fileFolderCreated(this.fe);
                        break;
                    }
                    case 2: {
                        fileChangeListener.fileChanged(this.fe);
                        break;
                    }
                    case 3: {
                        fileChangeListener.fileDeleted(this.fe);
                        break;
                    }
                    case 4: {
                        fileChangeListener.fileRenamed((FileRenameEvent)this.fe);
                        break;
                    }
                    case 5: {
                        fileChangeListener.fileAttributeChanged((FileAttributeEvent)this.fe);
                    }
                }
            }
            if (bl) {
                this.en = queueEnumeration;
            }
        }

        protected void setAtomicActionLink(EventControl.AtomicActionLink atomicActionLink) {
            this.fe.setAtomicActionLink(atomicActionLink);
        }
    }
}

