/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.openide.filesystems.AbstractFileObject;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.PathElements;
import org.openide.filesystems.RefreshAction;
import org.openide.filesystems.RefreshRequest;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.AlterEnumeration;
import org.openide.util.enum.FilterEnumeration;
import org.openide.util.enum.QueueEnumeration;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

public abstract class AbstractFileSystem
extends FileSystem {
    static final long serialVersionUID = -3345098214331282438L;
    private static SystemAction[] SYSTEM_ACTIONS;
    private static final SystemAction[] NO_SYSTEM_ACTIONS;
    private transient AbstractFileObject root;
    private transient RefreshRequest refresher;
    private static transient PathElements lastEnum;
    protected List list;
    protected Change change;
    protected Transfer transfer;
    protected Info info;
    protected Attr attr;

    public abstract String getDisplayName();

    public FileObject getRoot() {
        return this.getAbstractRoot();
    }

    public FileObject find(String string, String string2, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (string2 == null || string3 == null) {
            FileObject fileObject = this.getAbstractRoot().find(stringTokenizer);
            return fileObject != null && fileObject.isFolder() ? fileObject : null;
        }
        SequenceEnumeration sequenceEnumeration = new SequenceEnumeration(stringTokenizer, new SingletonEnumeration(string2 + '.' + string3));
        return this.getAbstractRoot().find(sequenceEnumeration);
    }

    public FileObject findResource(String string) {
        if (string.length() == 0) {
            return this.getAbstractRoot();
        }
        PathElements pathElements = lastEnum;
        if (pathElements == null || !pathElements.getOriginalName().equals(string)) {
            lastEnum = pathElements = new PathElements(string);
        }
        return this.getAbstractRoot().find(pathElements.getEnumeration());
    }

    protected Reference createReference(FileObject fileObject) {
        return new WeakReference<FileObject>(fileObject);
    }

    protected final Reference findReference(String string) {
        if (string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        return this.getAbstractRoot().findRefIfExists(stringTokenizer);
    }

    public SystemAction[] getActions() {
        if (this.refresher == null) {
            return NO_SYSTEM_ACTIONS;
        }
        if (SYSTEM_ACTIONS == null) {
            try {
                Class<?> clazz = Class.forName("org.openide.filesystems.RefreshAction");
                RefreshAction refreshAction = (RefreshAction)SharedClassObject.findObject(clazz, true);
                SYSTEM_ACTIONS = new SystemAction[]{refreshAction};
            }
            catch (Exception exception) {
                SYSTEM_ACTIONS = NO_SYSTEM_ACTIONS;
            }
        }
        return SYSTEM_ACTIONS;
    }

    protected final synchronized void setRefreshTime(int n) {
        if (this.refresher != null) {
            this.refresher.stop();
        }
        this.refresher = n <= 0 || System.getProperty("netbeans.debug.heap") != null ? null : new RefreshRequest(this, n);
    }

    protected final int getRefreshTime() {
        RefreshRequest refreshRequest = this.refresher;
        return refreshRequest == null ? 0 : refreshRequest.getRefreshTime();
    }

    final synchronized AbstractFileObject refreshRootImpl() {
        this.root = this.createFileObject(null, "");
        return this.root;
    }

    protected final FileObject refreshRoot() {
        return this.refreshRootImpl();
    }

    protected final void refreshResource(String string, boolean bl) {
        AbstractFileObject abstractFileObject = (AbstractFileObject)this.findResourceIfExists(string);
        if (abstractFileObject != null) {
            abstractFileObject.refresh(null, null, true, bl);
        }
    }

    protected final Enumeration existingFileObjects(FileObject fileObject) {
        AlterEnumeration alterEnumeration = new AlterEnumeration(this.existingFileObjectsWeak(fileObject)){

            protected Object alter(Object object) {
                return ((Reference)object).get();
            }
        };
        FilterEnumeration filterEnumeration = new FilterEnumeration(alterEnumeration){

            protected boolean accept(Object object) {
                return object != null && ((FileObject)object).isValid();
            }
        };
        return filterEnumeration;
    }

    final Enumeration existingFileObjectsWeak(FileObject fileObject) {
        QueueEnumeration queueEnumeration = new QueueEnumeration(){

            public void process(Object object) {
                Reference reference = (Reference)object;
                AbstractFileObject abstractFileObject = (AbstractFileObject)reference.get();
                if (abstractFileObject != null) {
                    AbstractFolder[] abstractFolderArray = abstractFileObject.subfiles();
                    Object[] objectArray = new Reference[abstractFolderArray.length];
                    int n = 0;
                    while (n < abstractFolderArray.length) {
                        objectArray[n] = new WeakReference<AbstractFolder>(abstractFolderArray[n]);
                        ++n;
                    }
                    this.put(objectArray);
                }
            }
        };
        queueEnumeration.put(new WeakReference<FileObject>(fileObject));
        return queueEnumeration;
    }

    boolean isLastModifiedCacheEnabled() {
        return true;
    }

    private FileObject findResourceIfExists(String string) {
        if (string.length() == 0) {
            return this.getAbstractRoot();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        return this.getAbstractRoot().findIfExists(stringTokenizer);
    }

    AbstractFileObject createFileObject(AbstractFileObject abstractFileObject, String string) {
        return new AbstractFileObject(this, abstractFileObject, string);
    }

    final AbstractFileObject getAbstractRoot() {
        if (this.root == null) {
            AbstractFileSystem abstractFileSystem = this;
            synchronized (abstractFileSystem) {
                if (this.root == null) {
                    AbstractFileObject abstractFileObject = this.refreshRootImpl();
                    return abstractFileObject;
                }
            }
        }
        return this.root;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("change", this.change);
        putField.put("info", this.info);
        putField.put("attr", this.attr);
        putField.put("list", this.list);
        putField.put("transfer", this.transfer);
        objectOutputStream.writeFields();
        objectOutputStream.writeInt(this.getRefreshTime());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Object object = AbstractFileSystem.readImpl("change", getField);
        Object object2 = AbstractFileSystem.readImpl("info", getField);
        Object object3 = AbstractFileSystem.readImpl("attr", getField);
        Object object4 = AbstractFileSystem.readImpl("list", getField);
        Object object5 = AbstractFileSystem.readImpl("transfer", getField);
        this.change = (Change)object;
        this.info = (Info)object2;
        this.attr = (Attr)object3;
        this.list = (List)object4;
        this.transfer = (Transfer)object5;
        this.setRefreshTime(objectInputStream.readInt());
    }

    static Object readImpl(String string, ObjectInputStream.GetField getField) throws ClassNotFoundException, IOException {
        Object object = getField.get(string, null);
        if (object instanceof LocalFileSystem) {
            return new LocalFileSystem.Impl((LocalFileSystem)object);
        }
        if (object instanceof JarFileSystem) {
            return new JarFileSystem.Impl((JarFileSystem)object);
        }
        return object;
    }

    protected boolean checkVirtual(String string) {
        return false;
    }

    protected void markImportant(String string, boolean bl) {
        if (!bl && this.info != null) {
            this.info.markUnimportant(string);
        }
    }

    static {
        NO_SYSTEM_ACTIONS = new SystemAction[0];
    }

    public static interface Attr
    extends Serializable {
        public static final long serialVersionUID = 5978845941846736946L;

        public Object readAttribute(String var1, String var2);

        public void writeAttribute(String var1, String var2, Object var3) throws IOException;

        public Enumeration attributes(String var1);

        public void renameAttributes(String var1, String var2);

        public void deleteAttributes(String var1);
    }

    public static interface Info
    extends Serializable {
        public static final long serialVersionUID = -2438286177948307985L;

        public Date lastModified(String var1);

        public boolean folder(String var1);

        public boolean readOnly(String var1);

        public String mimeType(String var1);

        public long size(String var1);

        public InputStream inputStream(String var1) throws FileNotFoundException;

        public OutputStream outputStream(String var1) throws IOException;

        public void lock(String var1) throws IOException;

        public void unlock(String var1);

        public void markUnimportant(String var1);
    }

    public static interface Transfer
    extends Serializable {
        public static final long serialVersionUID = -8945397853892302838L;

        public boolean move(String var1, Transfer var2, String var3) throws IOException;

        public boolean copy(String var1, Transfer var2, String var3) throws IOException;
    }

    public static interface Change
    extends Serializable {
        public static final long serialVersionUID = -5841597109944924596L;

        public void createFolder(String var1) throws IOException;

        public void createData(String var1) throws IOException;

        public void rename(String var1, String var2) throws IOException;

        public void delete(String var1) throws IOException;
    }

    public static interface List
    extends Serializable {
        public static final long serialVersionUID = -6242105832891012528L;

        public String[] children(String var1);
    }
}

