/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FSException;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.filesystems.StreamPool;
import org.openide.util.enum.EmptyEnumeration;

final class AbstractFileObject
extends AbstractFolder {
    static final long serialVersionUID = -2343651324897646809L;
    private static final char EXT_SEP = '.';
    private static final char PATH_SEP = '/';
    private Reference lock;
    private Boolean folder;
    private Date lastModified;

    public AbstractFileObject(AbstractFileSystem abstractFileSystem, AbstractFileObject abstractFileObject, String string) {
        super(abstractFileSystem, abstractFileObject, string);
    }

    private AbstractFileSystem getAbstractFileSystem() {
        return (AbstractFileSystem)this.getFileSystem();
    }

    private AbstractFileObject getAbstractChild(String string) {
        return (AbstractFileObject)this.getChild(string);
    }

    protected final String[] list() {
        return this.getAbstractFileSystem().list.children(this.toString());
    }

    protected final AbstractFolder createFile(String string) {
        return this.getAbstractFileSystem().createFileObject(this, string);
    }

    public boolean isFolder() {
        if (this.folder == null) {
            if (this.parent == null || this.getAbstractFileSystem().info.folder(this.toString())) {
                this.folder = Boolean.TRUE;
                return true;
            }
            this.folder = Boolean.FALSE;
            return false;
        }
        return this.folder;
    }

    public final boolean isData() {
        return !this.isFolder();
    }

    public Date lastModified() {
        if (this.lastModified == null || !this.getAbstractFileSystem().isLastModifiedCacheEnabled()) {
            this.lastModified = this.getAbstractFileSystem().info.lastModified(this.toString());
        }
        return this.lastModified;
    }

    public boolean isReadOnly() {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        return abstractFileSystem.isReadOnly() || abstractFileSystem.info.readOnly(this.toString());
    }

    public String getMIMEType() {
        String string = this.getAbstractFileSystem().info.mimeType(this.toString());
        if (string == null) {
            string = FileUtil.getMIMEType(this);
        }
        return string != null ? string : "content/unknown";
    }

    public long getSize() {
        return this.getAbstractFileSystem().info.size(this.toString());
    }

    public InputStream getInputStream() throws FileNotFoundException {
        InputStream inputStream = this.getAbstractFileSystem().info.inputStream(this.toString());
        return StreamPool.createInputStream(this, inputStream);
    }

    public synchronized OutputStream getOutputStream(FileLock fileLock) throws IOException {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        if (abstractFileSystem.isReadOnly()) {
            FSException.io("EXC_FSisRO", ((FileSystem)abstractFileSystem).getDisplayName());
        }
        if (this.isReadOnly()) {
            FSException.io("EXC_FisRO", this.name, ((FileSystem)abstractFileSystem).getDisplayName());
        }
        this.testLock(fileLock);
        OutputStream outputStream = this.getAbstractFileSystem().info.outputStream(this.toString());
        return StreamPool.createOutputStream(this, outputStream);
    }

    public synchronized FileLock lock() throws IOException {
        FileLock fileLock;
        if (this.lock != null && (fileLock = (FileLock)this.lock.get()) != null) {
            throw new FileAlreadyLockedException();
        }
        this.getAbstractFileSystem().info.lock(this.toString());
        fileLock = new AfLock();
        this.lock = new WeakReference<FileLock>(fileLock);
        return fileLock;
    }

    synchronized void unlock() {
        this.getAbstractFileSystem().info.unlock(this.toString());
        this.lastModified = null;
        this.lock = null;
    }

    private void testLock(FileLock fileLock) throws IOException {
        if (this.lock == null) {
            FSException.io("EXC_InvalidLock", fileLock, this.toString(), this.getAbstractFileSystem().getDisplayName(), this.lock);
        }
        if (this.lock.get() != fileLock) {
            FSException.io("EXC_InvalidLock", fileLock, this.toString(), this.getAbstractFileSystem().getDisplayName(), this.lock.get());
        }
    }

    public void setImportant(boolean bl) {
        this.getAbstractFileSystem().markImportant(this.toString(), bl);
    }

    public Object getAttribute(String string) {
        return this.getAttribute(string, this.toString());
    }

    final Object getAttribute(String string, String string2) {
        return this.getAbstractFileSystem().attr.readAttribute(string2, string);
    }

    public void setAttribute(String string, Object object) throws IOException {
        this.setAttribute(string, object, true);
    }

    void setAttribute(String string, Object object, boolean bl) throws IOException {
        Object object2 = null;
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        if (abstractFileSystem.isReadOnly()) {
            FSException.io("EXC_FSisRO", ((FileSystem)abstractFileSystem).getDisplayName());
        }
        if (bl) {
            object2 = this.getAttribute(string);
        }
        this.getAbstractFileSystem().attr.writeAttribute(this.toString(), string, object);
        if (bl && object2 != object && this.hasAtLeastOneListeners()) {
            this.fileAttributeChanged0(new FileAttributeEvent(this, string, object2, object));
        }
    }

    public Enumeration getAttributes() {
        return this.getAttributes(this.toString());
    }

    final Enumeration getAttributes(String string) {
        return this.getAbstractFileSystem().attr.attributes(string);
    }

    protected final Reference createReference(FileObject fileObject) {
        return this.getAbstractFileSystem().createReference(fileObject);
    }

    public FileObject createFolder(String string) throws IOException {
        AbstractFileObject abstractFileObject;
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject2 = this;
            synchronized (abstractFileObject2) {
                AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
                if (abstractFileSystem.isReadOnly()) {
                    FSException.io("EXC_FSisRO", abstractFileSystem.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", string, abstractFileSystem.getDisplayName());
                }
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", string, this.toString(), abstractFileSystem.getDisplayName());
                }
                this.getAbstractFileSystem().change.createFolder(this.toString() + '/' + string);
                this.refresh(string, null);
                abstractFileObject = this.getAbstractChild(string);
                if (abstractFileObject == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), string));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(abstractFileObject), false);
                }
            }
            Object var7_6 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
        return abstractFileObject;
    }

    public FileObject createData(String string, String string2) throws IOException {
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            synchronized (abstractFileObject) {
                String string3;
                AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
                if (abstractFileSystem.isReadOnly()) {
                    FSException.io("EXC_FSisRO", abstractFileSystem.getDisplayName());
                }
                if (this.isReadOnly()) {
                    FSException.io("EXC_FisRO", string, abstractFileSystem.getDisplayName());
                }
                String string4 = string3 = string2 == null || "".equals(string2) ? string : string + '.' + string2;
                if (!this.isFolder()) {
                    FSException.io("EXC_FoNotFolder", string3, this.toString(), abstractFileSystem.getDisplayName());
                }
                this.getAbstractFileSystem().change.createData(this.toString() + '/' + string3);
                this.refresh(string3, null);
                AbstractFileObject abstractFileObject2 = this.getAbstractChild(string3);
                if (abstractFileObject2 == null) {
                    throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", this.toString(), string3));
                }
                if (this.hasListeners()) {
                    this.fileCreated0(new FileEvent(abstractFileObject2), true);
                }
                AbstractFileObject abstractFileObject3 = abstractFileObject2;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl22 : MonitorExitStatement: MONITOREXIT : var3_3
                Object var10_8 = null;
                this.getFileSystem().finishAtomicAction();
                return abstractFileObject3;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public void rename(FileLock fileLock, String string, String string2) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotRenameRoot", this.getAbstractFileSystem().getDisplayName());
        }
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(fileLock);
                if (this.isData() && string2 != null) {
                    string = string + '.' + string2;
                }
                String string3 = this.parent.toString() + '/' + string;
                String string4 = this.toString();
                if (this.isReadOnly()) {
                    FSException.io("EXC_CannotRename", this.toString(), this.getAbstractFileSystem().getDisplayName(), string3);
                }
                if (this.getFileSystem().isReadOnly()) {
                    FSException.io("EXC_FSisRO", this.getAbstractFileSystem().getDisplayName());
                }
                String string5 = this.getName();
                String string6 = this.getExt();
                this.getAbstractFileSystem().change.rename(string4, string3);
                String string7 = this.name;
                this.name = string;
                this.parent.refresh(string, string7);
                this.getAbstractFileSystem().attr.renameAttributes(string4, string3);
                if (this.hasAtLeastOneListeners()) {
                    this.fileRenamed0(new FileRenameEvent((FileObject)this, string5, string6));
                }
            }
            Object var12_11 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public void delete(FileLock fileLock) throws IOException {
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", this.getAbstractFileSystem().getDisplayName());
        }
        try {
            String string;
            this.getFileSystem().beginAtomicAction();
            AbstractFolder abstractFolder = this.parent;
            synchronized (abstractFolder) {
                this.testLock(fileLock);
                string = this.toString();
                try {
                    this.getAbstractFileSystem().change.delete(string);
                }
                catch (IOException iOException) {
                    StreamPool streamPool = StreamPool.find(this);
                    if (streamPool != null) {
                        streamPool.annotate(iOException);
                    }
                    throw iOException;
                }
                String string2 = this.name;
                this.validFlag = false;
                this.parent.refresh(null, string2, true);
            }
            this.getAbstractFileSystem().attr.deleteAttributes(string);
            if (this.hasAtLeastOneListeners()) {
                this.fileDeleted0(new FileEvent(this));
            }
            Object var8_8 = null;
            this.getFileSystem().finishAtomicAction();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    public FileObject copy(FileObject fileObject, String string, String string2) throws IOException {
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        AbstractFileSystem.Transfer transfer = this.getAbstractFileSystem().transfer;
        if (transfer == null || !(fileObject instanceof AbstractFileObject)) {
            return super.copy(fileObject, string, string2);
        }
        AbstractFileObject abstractFileObject = (AbstractFileObject)fileObject;
        AbstractFileSystem abstractFileSystem2 = abstractFileObject.getAbstractFileSystem();
        AbstractFileSystem.Transfer transfer2 = abstractFileSystem2.transfer;
        if (transfer2 != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFileObject abstractFileObject2 = abstractFileObject;
                synchronized (abstractFileObject2) {
                    String string3;
                    if (abstractFileSystem2.isReadOnly()) {
                        FSException.io("EXC_FSisRO", abstractFileSystem2.getDisplayName());
                    }
                    if (fileObject.isReadOnly()) {
                        FSException.io("EXC_FisRO", fileObject.toString(), abstractFileSystem2.getDisplayName());
                    }
                    String string4 = string3 = "".equals(string2) ? string : string + '.' + string2;
                    if (transfer.copy(this.toString(), transfer2, fileObject.toString() + '/' + string3)) {
                        abstractFileObject.refresh(string3, null);
                        AbstractFileObject abstractFileObject3 = abstractFileObject.getAbstractChild(string3);
                        if (abstractFileObject3 == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractFileObject.toString(), string3));
                        }
                        if (abstractFileObject.hasListeners()) {
                            abstractFileObject.fileCreated0(new FileEvent(abstractFileObject3), true);
                        }
                        AbstractFileObject abstractFileObject4 = abstractFileObject3;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 7, 11] lbl27 : MonitorExitStatement: MONITOREXIT : var9_9
                        Object var15_13 = null;
                        this.getFileSystem().finishAtomicAction();
                        return abstractFileObject4;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                this.getFileSystem().finishAtomicAction();
                throw throwable;
            }
            Object var15_14 = null;
            this.getFileSystem().finishAtomicAction();
            {
            }
        }
        return super.copy(fileObject, string, string2);
    }

    public FileObject move(FileLock fileLock, FileObject fileObject, String string, String string2) throws IOException {
        AbstractFileSystem.Transfer transfer;
        AbstractFileSystem abstractFileSystem = this.getAbstractFileSystem();
        if (this.parent == null) {
            FSException.io("EXC_CannotDeleteRoot", abstractFileSystem.getDisplayName());
        }
        if ((transfer = this.getAbstractFileSystem().transfer) == null || !(fileObject instanceof AbstractFileObject)) {
            return super.move(fileLock, fileObject, string, string2);
        }
        AbstractFileObject abstractFileObject = (AbstractFileObject)fileObject;
        AbstractFileSystem abstractFileSystem2 = abstractFileObject.getAbstractFileSystem();
        AbstractFileSystem.Transfer transfer2 = abstractFileSystem2.transfer;
        if (transfer2 != null) {
            try {
                this.getFileSystem().beginAtomicAction();
                AbstractFolder abstractFolder = this.parent;
                synchronized (abstractFolder) {
                    this.testLock(fileLock);
                    if (abstractFileSystem2.isReadOnly()) {
                        FSException.io("EXC_FSisRO", abstractFileSystem2.getDisplayName());
                    }
                    if (fileObject.isReadOnly()) {
                        FSException.io("EXC_FisRO", fileObject.toString(), abstractFileSystem2.getDisplayName());
                    }
                    String string3 = "".equals(string2) ? string : string + '.' + string2;
                    String string4 = this.toString();
                    if (transfer.move(string4, transfer2, fileObject.toString() + '/' + string3)) {
                        String string5 = string;
                        this.validFlag = false;
                        this.parent.refresh(null, string5);
                        abstractFileObject.refresh(string3, null);
                        AbstractFileObject abstractFileObject2 = abstractFileObject.getAbstractChild(string3);
                        if (abstractFileObject2 == null) {
                            throw new FileStateInvalidException(FileSystem.getString("EXC_ApplicationCreateError", abstractFileObject.toString(), string3));
                        }
                        if (this.hasAtLeastOneListeners()) {
                            this.fileDeleted0(new FileEvent(this));
                        }
                        if (abstractFileObject.hasListeners()) {
                            abstractFileObject.fileCreated0(new FileEvent(abstractFileObject2), true);
                        }
                        AbstractFileObject abstractFileObject3 = abstractFileObject2;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 8, 13] lbl35 : MonitorExitStatement: MONITOREXIT : var10_10
                        Object var18_16 = null;
                        this.getFileSystem().finishAtomicAction();
                        return abstractFileObject3;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var18_18 = null;
                this.getFileSystem().finishAtomicAction();
                throw throwable;
            }
            Object var18_17 = null;
            this.getFileSystem().finishAtomicAction();
            {
            }
        }
        return super.move(fileLock, fileObject, string, string2);
    }

    public boolean isVirtual() {
        return this.getAbstractFileSystem().checkVirtual(this.toString());
    }

    protected void refresh(String string, String string2, boolean bl, boolean bl2) {
        this.refresh(string, string2, bl, bl2, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void refresh(String string, String string2, boolean bl, boolean bl2, String[] stringArray) {
        FileEvent fileEvent = null;
        boolean bl3 = false;
        try {
            this.getFileSystem().beginAtomicAction();
            AbstractFileObject abstractFileObject = this;
            // MONITORENTER : abstractFileObject
            if (this.isFolder()) {
                super.refresh(string, string2, bl, bl2, stringArray);
            } else {
                StreamPool streamPool = StreamPool.find(this);
                if (streamPool != null && streamPool.isOutputStreamOpen()) {
                    // MONITOREXIT : abstractFileObject
                    Object var13_10 = null;
                    this.getFileSystem().finishAtomicAction();
                    return;
                }
                Date date = null;
                if (this.lastModified == null) {
                    this.lastModified = date = this.getAbstractFileSystem().info.lastModified(this.toString());
                    // MONITOREXIT : abstractFileObject
                    Object var13_11 = null;
                    this.getFileSystem().finishAtomicAction();
                    return;
                }
                date = this.getAbstractFileSystem().info.lastModified(this.toString());
                if (Math.abs(this.lastModified.getTime() - date.getTime()) != 0L) {
                    this.lastModified = date;
                    if (bl && this.hasAtLeastOneListeners()) {
                        fileEvent = new FileEvent((FileObject)this, (FileObject)this, bl2);
                    }
                    if (date.getTime() == 0L) {
                        this.validFlag = false;
                        if (fileEvent != null) {
                            this.fileDeleted0(fileEvent);
                        }
                        bl3 = true;
                    } else if (fileEvent != null) {
                        this.fileChanged0(fileEvent);
                    }
                }
            }
            // MONITOREXIT : abstractFileObject
            if (bl3 && this.parent.getFileObject(this.getName(), this.getExt()) != null) {
                this.parent.refreshFolder(null, this.getNameExt(), bl, bl2, null);
            }
            Object var13_12 = null;
            this.getFileSystem().finishAtomicAction();
            return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            this.getFileSystem().finishAtomicAction();
            throw throwable;
        }
    }

    protected void outputStreamClosed() {
        AbstractFileObject abstractFileObject = this;
        synchronized (abstractFileObject) {
            this.lastModified = null;
        }
        super.outputStreamClosed();
    }

    static final class Replace
    implements Serializable {
        static final long serialVersionUID = -8543432135435542113L;
        private String fsName;
        private String fileName;

        public Replace(String string, String string2) {
            this.fsName = string;
            this.fileName = string2;
        }

        public Object readResolve() {
            Repository repository = ExternalUtil.getRepository();
            FileSystem fileSystem = repository.findFileSystem(this.fsName);
            FileObject fileObject = null;
            if (fileSystem != null) {
                fileObject = fileSystem.findResource(this.fileName);
            }
            if (fileObject == null) {
                fileObject = repository.findResource(this.fileName);
            }
            if (fileObject == null) {
                return new Invalid(this.fsName, this.fileName);
            }
            return fileObject;
        }
    }

    static final class Invalid
    extends FileObject {
        static final long serialVersionUID = -4558997829579415276L;
        private String name;
        private String fullName;
        private String fileSystemName;
        private static final Invalid ROOT = new Invalid("");

        public Invalid(String string) {
            this.fullName = string;
            int n = string.lastIndexOf(47) + 1;
            this.name = n == 0 || n == string.length() ? string : string.substring(n);
        }

        public Invalid(String string, String string2) {
            this(string2);
            this.fileSystemName = string;
        }

        public String getName() {
            int n = this.name.lastIndexOf(46);
            return n <= 0 ? this.name : this.name.substring(0, n);
        }

        public String getExt() {
            int n = this.name.lastIndexOf(46) + 1;
            return n <= 1 || n == this.name.length() ? "" : this.name.substring(n);
        }

        public FileSystem getFileSystem() throws FileStateInvalidException {
            throw new FileStateInvalidException(null, this.name + "[" + this.fileSystemName + "]");
        }

        public boolean isRoot() {
            return this == ROOT;
        }

        public boolean isFolder() {
            return this == ROOT;
        }

        public Date lastModified() {
            return new Date();
        }

        public boolean isData() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public boolean isValid() {
            return false;
        }

        public String getMIMEType() {
            return "content/unknown";
        }

        public long getSize() {
            return 0L;
        }

        public InputStream getInputStream() throws FileNotFoundException {
            throw new FileNotFoundException();
        }

        public synchronized OutputStream getOutputStream(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        public synchronized FileLock lock() throws IOException {
            throw new IOException();
        }

        public void setImportant(boolean bl) {
        }

        public Object getAttribute(String string) {
            return null;
        }

        public void setAttribute(String string, Object object) throws IOException {
            throw new IOException();
        }

        public Enumeration getAttributes() {
            return EmptyEnumeration.EMPTY;
        }

        public synchronized FileObject createFolder(String string) throws IOException {
            throw new IOException();
        }

        public synchronized FileObject createData(String string, String string2) throws IOException {
            throw new IOException();
        }

        public void rename(FileLock fileLock, String string, String string2) throws IOException {
            throw new IOException();
        }

        public void delete(FileLock fileLock) throws IOException {
            throw new IOException();
        }

        public FileObject getParent() {
            return this == ROOT ? null : ROOT;
        }

        public synchronized FileObject[] getChildren() {
            return new FileObject[0];
        }

        public synchronized FileObject getFileObject(String string, String string2) {
            return null;
        }

        public void refresh() {
        }

        public void addFileChangeListener(FileChangeListener fileChangeListener) {
        }

        public void removeFileChangeListener(FileChangeListener fileChangeListener) {
        }
    }

    private class AfLock
    extends FileLock {
        AfLock() {
        }

        public void releaseLock() {
            if (this.isValid()) {
                super.releaseLock();
                AbstractFileObject.this.unlock();
            }
        }
    }
}

