/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.openide.awt.JMenuPlus;
import org.openide.awt.JPopupMenuUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.MenuView;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public class MenuView
extends JPanel {
    static final long serialVersionUID = -4970665063421766904L;
    private transient ExplorerManager explorerManager;
    private JButton root;
    private JButton current;
    private transient Listener listener;
    static final NodeAcceptor DEFAULT_LISTENER = new NodeAcceptor(){

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            Node node = nodeArray[0];
            SystemAction systemAction = node.getDefaultAction();
            if (systemAction != null) {
                TreeView.invokeAction(systemAction, new ActionEvent(node, 0, ""));
                return true;
            }
            return false;
        }
    };
    static /* synthetic */ Class class$org$openide$explorer$view$MenuView;

    public MenuView() {
        this.setLayout(new FlowLayout());
        this.root = new JButton(NbBundle.getBundle(class$org$openide$explorer$view$MenuView == null ? (class$org$openide$explorer$view$MenuView = MenuView.class$("org.openide.explorer.view.MenuView")) : class$org$openide$explorer$view$MenuView).getString("MenuViewStartFromRoot"));
        this.add(this.root);
        this.current = new JButton(NbBundle.getBundle(class$org$openide$explorer$view$MenuView == null ? (class$org$openide$explorer$view$MenuView = MenuView.class$("org.openide.explorer.view.MenuView")) : class$org$openide$explorer$view$MenuView).getString("MenuViewStartFromCurrent"));
        this.add(this.current);
        this.init();
    }

    private void init() {
        this.listener = new Listener(true);
        this.root.addMouseListener(this.listener);
        this.current.addMouseListener(new Listener(false));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public void addNotify() {
        super.addNotify();
        this.explorerManager = ExplorerManager.find(this);
        this.explorerManager.addPropertyChangeListener(this.listener);
        this.doChecks();
    }

    public void removeNotify() {
        super.removeNotify();
        this.explorerManager.removePropertyChangeListener(this.listener);
        this.explorerManager = null;
    }

    private void doChecks() {
        this.current.setEnabled(this.explorerManager.getSelectedNodes().length == 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MenuItem
    extends JMenuItem {
        static final long serialVersionUID = -918973978614344429L;
        protected Node node;
        protected NodeAcceptor action;

        public MenuItem(Node node) {
            this(node, DEFAULT_LISTENER);
        }

        public MenuItem(Node node, NodeAcceptor nodeAcceptor) {
            this(node, nodeAcceptor, true);
        }

        public MenuItem(Node node, Acceptor acceptor) {
            this(node, new AcceptorProxy(acceptor), true);
        }

        public MenuItem(Node node, Acceptor acceptor, boolean bl) {
            this(node, new AcceptorProxy(acceptor), bl);
        }

        public MenuItem(Node node, NodeAcceptor nodeAcceptor, boolean bl) {
            HelpCtx helpCtx;
            this.node = node;
            this.action = nodeAcceptor;
            if (bl) {
                MenuItem.initialize(this, node);
            }
            if ((helpCtx = node.getHelpCtx()) != null && !helpCtx.equals(HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString(this, helpCtx.getHelpID());
            }
        }

        public void doClick(int n) {
            this.action.acceptNodes(new Node[]{this.node});
        }

        static void initialize(JMenuItem jMenuItem, Node node) {
            final class NI
            implements Runnable,
            NodeListener,
            ItemListener {
                private final /* synthetic */ JMenuItem val$item;
                private final /* synthetic */ Node val$node;

                NI(JMenuItem jMenuItem, Node node) {
                    this.val$item = jMenuItem;
                    this.val$node = node;
                }

                public void run() {
                    this.val$item.setIcon(new ImageIcon(this.val$node.getIcon(1)));
                    this.val$item.setText(this.val$node.getDisplayName());
                }

                public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                }

                public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
                }

                public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                }

                public void nodeDestroyed(NodeEvent nodeEvent) {
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                        Mutex.EVENT.readAccess(this);
                        return;
                    }
                    if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                        Mutex.EVENT.readAccess(this);
                        return;
                    }
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                }
            }
            NI nI = new NI(jMenuItem, node);
            nI.run();
            jMenuItem.addItemListener(nI);
            node.addNodeListener(WeakListener.node(nI, node));
        }
    }

    private static final class AcceptorProxy
    implements NodeAcceptor {
        private Acceptor original;

        AcceptorProxy(Acceptor acceptor) {
            this.original = acceptor;
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            return this.original.accept(nodeArray[0]);
        }
    }

    public static interface Acceptor {
        public boolean accept(Node var1);
    }

    public static class Menu
    extends JMenuPlus {
        private NodeModel nodeModel;
        private VisualizerNode vis;
        private final List oldChildren;
        protected Node node;
        protected NodeAcceptor action;
        static final long serialVersionUID = -1505289666675423991L;
        static /* synthetic */ Class class$org$openide$explorer$view$MenuView;

        public Menu(Node node) {
            this(node, DEFAULT_LISTENER);
        }

        public Menu(Node node, NodeAcceptor nodeAcceptor) {
            this(node, nodeAcceptor, true);
        }

        public Menu(Node node, Acceptor acceptor) {
            this(node, new AcceptorProxy(acceptor), true);
        }

        public Menu(Node node, Acceptor acceptor, boolean bl) {
            this(node, new AcceptorProxy(acceptor), bl);
        }

        public Menu(Node node, NodeAcceptor nodeAcceptor, boolean bl) {
            HelpCtx helpCtx;
            this.node = node;
            this.action = nodeAcceptor;
            this.vis = VisualizerNode.EMPTY;
            this.oldChildren = new ArrayList(5);
            Mutex.EVENT.readAccess(new Runnable(this, node){
                private final /* synthetic */ Node val$node;
                private final /* synthetic */ Menu this$0;
                {
                    this.this$0 = menu;
                    this.val$node = node;
                }

                public void run() {
                    Menu.access$302(this.this$0, VisualizerNode.getVisualizer(null, this.val$node));
                }
            });
            this.nodeModel = new VisNodeModel();
            this.vis.addNodeModel(this.nodeModel);
            if (bl) {
                MenuItem.initialize(this, node);
            }
            if ((helpCtx = node.getHelpCtx()) != null && !helpCtx.equals(HelpCtx.DEFAULT_HELP) && helpCtx.getHelpID() != null) {
                HelpCtx.setHelpIDString(this, helpCtx.getHelpID());
            }
        }

        public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
            super.processMouseEvent(mouseEvent, menuElementArray, menuSelectionManager);
            if (mouseEvent.isPopupTrigger() && this.action.acceptNodes(new Node[]{this.node})) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }

        public JPopupMenu getPopupMenu() {
            this.updatePopup();
            return super.getPopupMenu();
        }

        private void updatePopup() {
            Object object;
            List list = this.vis.getChildren();
            ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (VisualizerNode)iterator.next();
                arrayList.add(Visualizer.findNode(object));
            }
            if (this.oldChildren.equals(arrayList)) {
                if (this.getMenuComponentCount() == 0) {
                    this.add(Menu.createEmptyMenuItem());
                }
                return;
            }
            this.oldChildren.clear();
            this.oldChildren.addAll(arrayList);
            this.removeAll();
            object = arrayList.iterator();
            while (object.hasNext()) {
                this.add(this.createMenuItem((Node)object.next()));
            }
            if (this.getMenuComponentCount() == 0) {
                this.add(Menu.createEmptyMenuItem());
            }
        }

        private static JMenuItem createEmptyMenuItem() {
            JMenuItem jMenuItem = new JMenuItem(NbBundle.getBundle(class$org$openide$explorer$view$MenuView == null ? (class$org$openide$explorer$view$MenuView = Menu.class$("org.openide.explorer.view.MenuView")) : class$org$openide$explorer$view$MenuView).getString("EmptySubMenu"));
            jMenuItem.setEnabled(false);
            return jMenuItem;
        }

        protected JMenuItem createMenuItem(Node node) {
            return node.isLeaf() ? new MenuItem(node, this.action) : new Menu(node, this.action);
        }

        private void nodeModelChanged() {
            JPopupMenu jPopupMenu = super.getPopupMenu();
            this.updatePopup();
            JPopupMenuUtils.dynamicChangeToSubmenu(jPopupMenu, JPopupMenuUtils.isPopupContained(jPopupMenu));
        }

        static /* synthetic */ VisualizerNode access$302(Menu menu, VisualizerNode visualizerNode) {
            menu.vis = visualizerNode;
            return menu.vis;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final class VisNodeModel
        implements NodeModel {
            private VisNodeModel() {
            }

            public void added(VisualizerEvent.Added added) {
                if (!Menu.this.node.equals(Visualizer.findNode(added.getVisualizer()))) {
                    return;
                }
                Menu.this.nodeModelChanged();
            }

            public void removed(VisualizerEvent.Removed removed) {
                if (!Menu.this.node.equals(Visualizer.findNode(removed.getVisualizer()))) {
                    return;
                }
                Menu.this.nodeModelChanged();
            }

            public void reordered(VisualizerEvent.Reordered reordered) {
            }

            public void update(VisualizerNode visualizerNode) {
            }
        }
    }

    private class Listener
    extends MouseAdapter
    implements NodeAcceptor,
    PropertyChangeListener {
        private boolean root;

        public Listener(boolean bl) {
            this.root = bl;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent().isEnabled()) {
                Object object;
                Node node = null;
                if (!this.root && ((Node[])(object = MenuView.this.explorerManager.getSelectedNodes())).length > 0) {
                    node = object[0];
                }
                if (node == null) {
                    node = MenuView.this.explorerManager.getRootContext();
                }
                object = new Menu(node, MenuView.this.listener);
                JPopupMenu jPopupMenu = ((Menu)object).getPopupMenu();
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                point.x = mouseEvent.getX() - point.x;
                point.y = mouseEvent.getY() - point.y;
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                Dimension dimension = jPopupMenu.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                if (point.x + dimension.width > dimension2.width) {
                    point.x = dimension2.width - dimension.width;
                }
                if (point.y + dimension.height > dimension2.height) {
                    point.y = dimension2.height - dimension.height;
                }
                SwingUtilities.convertPointFromScreen(point, mouseEvent.getComponent());
                jPopupMenu.show(mouseEvent.getComponent(), point.x, point.y);
            }
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            Node node = nodeArray[0];
            Node node2 = node.getParentNode();
            if (node2 != null) {
                MenuView.this.explorerManager.setExploredContext(node2, new Node[]{node});
            }
            return true;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                MenuView.this.doChecks();
            }
        }
    }
}

