/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.io.IOException;
import java.util.TooManyListenersException;
import javax.swing.JList;
import org.openide.ErrorManager;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

class ListViewDragSupport
implements DragSourceListener,
DragGestureListener {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    protected ListView view;
    protected JList list;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    public ListViewDragSupport(ListView listView, JList jList) {
        this.view = listView;
        this.list = jList;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        block8: {
            int n = dragGestureEvent.getDragAction();
            if ((n & this.view.getAllowedDragActions()) == 0) {
                return;
            }
            Node[] nodeArray = this.obtainNodes(dragGestureEvent);
            if (nodeArray == null || nodeArray.length == 0) {
                return;
            }
            int n2 = 0;
            while (n2 < nodeArray.length) {
                if (!DragDropUtilities.checkNodeForAction(nodeArray[n2], n)) {
                    return;
                }
                ++n2;
            }
            try {
                Transferable transferable = DragDropUtilities.getNodeTransferable(nodeArray, n);
                dragGestureEvent.startDrag(DragDropUtilities.chooseCursor(n, this.view.isDropTarget(), nodeArray[0]), transferable, this);
            }
            catch (InvalidDnDOperationException invalidDnDOperationException) {
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ListViewDragSupport.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                if (errorManager != null) {
                    errorManager.notify(invalidDnDOperationException);
                }
            }
            catch (IOException iOException) {
                ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = ListViewDragSupport.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
                if (errorManager == null) break block8;
                errorManager.notify(iOException);
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void activate(boolean bl) {
        if (this.active == bl) {
            return;
        }
        this.active = bl;
        DragGestureRecognizer dragGestureRecognizer = this.getDefaultGestureRecognizer();
        if (bl) {
            dragGestureRecognizer.setSourceActions(this.view.getAllowedDragActions());
            try {
                dragGestureRecognizer.removeDragGestureListener(this);
                dragGestureRecognizer.addDragGestureListener(this);
            }
            catch (TooManyListenersException tooManyListenersException) {
                throw new InternalError("Too many listeners for drag gesture.");
            }
        } else {
            dragGestureRecognizer.removeDragGestureListener(this);
        }
    }

    DragGestureRecognizer getDefaultGestureRecognizer() {
        if (this.defaultGesture == null) {
            DragSource dragSource = DragSource.getDefaultDragSource();
            this.defaultGesture = dragSource.createDefaultDragGestureRecognizer(this.list, this.view.getAllowedDragActions(), this);
        }
        return this.defaultGesture;
    }

    Node[] obtainNodes(DragGestureEvent dragGestureEvent) {
        Object e;
        Point point = dragGestureEvent.getDragOrigin();
        int n = this.list.locationToIndex(dragGestureEvent.getDragOrigin());
        if (n < 0 || !((e = this.list.getModel().getElementAt(n)) instanceof Node)) {
            return null;
        }
        Node[] nodeArray = null;
        if (this.list.isSelectedIndex(n)) {
            Object[] objectArray = this.list.getSelectedValues();
            nodeArray = new Node[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (!(objectArray[n2] instanceof Node)) {
                    return null;
                }
                nodeArray[n2] = (Node)objectArray[n2];
                ++n2;
            }
        } else {
            nodeArray = new Node[]{(Node)e};
        }
        return nodeArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

