/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.openide.Places;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.explorer.propertysheet.editors.IconEditor;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class IconEditor
extends PropertyEditorSupport
implements PropertyEditor,
XMLPropertyEditor,
ExPropertyEditor {
    public static final int TYPE_URL = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_CLASSPATH = 3;
    static final String URL_PREFIX = "URL";
    static final String FILE_PREFIX = "File";
    static final String CLASSPATH_PREFIX = "Classpath";
    private Icon icon;
    private PropertyEnv propertyEnv;
    public static final String XML_IMAGE = "Image";
    public static final String ATTR_TYPE = "iconType";
    public static final String ATTR_NAME = "name";
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$editors$IconEditor;

    private static String getString(String string) {
        return NbBundle.getBundle(class$org$openide$explorer$propertysheet$editors$IconEditor == null ? (class$org$openide$explorer$propertysheet$editors$IconEditor = IconEditor.class$("org.openide.explorer.propertysheet.editors.IconEditor")) : class$org$openide$explorer$propertysheet$editors$IconEditor).getString(string);
    }

    public static boolean isImage(String string) {
        return (string = string.toLowerCase()).endsWith(".jpg") || string.endsWith(".gif") || string.endsWith(".jpeg") || string.endsWith(".jpe") || string.equals("jpg") || string.equals("gif") || string.equals("jpeg") || string.equals("jpe");
    }

    static String convert(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(stringTokenizer.nextElement());
            while (stringTokenizer.hasMoreElements()) {
                stringBuffer.append("\\\\").append(stringTokenizer.nextElement());
            }
        }
        return new String(stringBuffer);
    }

    public int getSourceType() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).type;
        }
        return 2;
    }

    public String getSourceName() {
        if (this.getValue() instanceof NbImageIcon) {
            return ((NbImageIcon)this.getValue()).name;
        }
        return null;
    }

    public Object getValue() {
        return super.getValue();
    }

    public void setValue(Object object) {
        if (this.propertyEnv != null && (object == null || object instanceof NbImageIcon && ((NbImageIcon)object).stateValid)) {
            this.propertyEnv.setState(PropertyEnv.STATE_VALID);
        }
        this.icon = (Icon)object;
        super.setValue(this.icon);
    }

    public String getAsText() {
        Object object = this.getValue();
        if (object == null) {
            return "null";
        }
        if (object instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)object;
            switch (nbImageIcon.type) {
                case 1: {
                    return "URL: " + nbImageIcon.name;
                }
                case 2: {
                    return "File: " + nbImageIcon.name;
                }
                case 3: {
                    return "Classpath: " + nbImageIcon.name;
                }
            }
        }
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.iconFromText(string));
    }

    private NbImageIcon iconFromText(String string) throws IllegalArgumentException {
        NbImageIcon nbImageIcon;
        try {
            if (string.startsWith(FILE_PREFIX)) {
                String string2 = string.substring(FILE_PREFIX.length() + 1).trim();
                nbImageIcon = new NbImageIcon(string2);
                nbImageIcon.type = 2;
                nbImageIcon.name = string2;
            } else if (string.startsWith(CLASSPATH_PREFIX)) {
                String string3 = string.substring(CLASSPATH_PREFIX.length() + 1).trim();
                if (string3 == null || "".equals(string3) || "/".equals(string3) || "///".equals(string3) || string3.endsWith("#")) {
                    return null;
                }
                URL uRL = TopManager.getDefault().currentClassLoader().getResource(string3);
                nbImageIcon = uRL == null ? new NbImageIcon() : new NbImageIcon(uRL);
                nbImageIcon.type = 3;
                nbImageIcon.name = string3;
            } else if (string.startsWith(URL_PREFIX)) {
                String string4 = string.substring(URL_PREFIX.length() + 1).trim();
                URL uRL = new URL(string4);
                nbImageIcon = new NbImageIcon(uRL);
                nbImageIcon.type = 1;
                nbImageIcon.name = string4;
            } else if (string.equals("null")) {
                nbImageIcon = null;
            } else {
                nbImageIcon = new NbImageIcon(string.trim());
                nbImageIcon.type = 2;
                nbImageIcon.name = string;
            }
        }
        catch (Exception exception) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
            TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, exception);
            throw illegalArgumentException;
        }
        return nbImageIcon;
    }

    public String getJavaInitializationString() {
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon nbImageIcon = (NbImageIcon)this.getValue();
            switch (nbImageIcon.type) {
                case 1: {
                    return "new javax.swing.JLabel() {\n  public javax.swing.Icon getIcon() {\n    try {\n      return new javax.swing.ImageIcon(\n        new java.net.URL(\"" + IconEditor.convert(nbImageIcon.name) + "\")\n" + "      );\n" + "    } catch (java.net.MalformedURLException e) {\n" + "    }\n" + "    return null;\n" + "  }\n" + "}.getIcon()";
                }
                case 2: {
                    return "new javax.swing.ImageIcon(\"" + IconEditor.convert(nbImageIcon.name) + "\")";
                }
                case 3: {
                    return "new javax.swing.ImageIcon(getClass().getResource(\"" + IconEditor.convert(nbImageIcon.name) + "\"))";
                }
            }
        }
        return "null";
    }

    public String[] getTags() {
        return null;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new IconPanel();
    }

    public void readFromXML(org.w3c.dom.Node node) throws IOException {
        if (!XML_IMAGE.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            int n = Integer.parseInt(namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue());
            String string = namedNodeMap.getNamedItem(ATTR_NAME).getNodeValue();
            switch (n) {
                case 1: {
                    this.setAsText("URL: " + string);
                    break;
                }
                case 2: {
                    this.setAsText("File: " + string);
                    break;
                }
                case 3: {
                    this.setAsText("Classpath: " + string);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            IOException iOException = new IOException();
            TopManager.getDefault().getErrorManager().annotate((Throwable)iOException, nullPointerException);
            throw iOException;
        }
    }

    public org.w3c.dom.Node storeToXML(Document document) {
        Element element = document.createElement(XML_IMAGE);
        NbImageIcon nbImageIcon = (NbImageIcon)this.getValue();
        element.setAttribute(ATTR_TYPE, Integer.toString(nbImageIcon.type));
        element.setAttribute(ATTR_NAME, nbImageIcon.name);
        return element;
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.propertyEnv = propertyEnv;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class IconPanel
    extends JPanel
    implements EnhancedCustomPropertyEditor {
        static final long serialVersionUID = -6904264999063788703L;
        private JPanel jPanel1;
        private JLabel jLabel1;
        private JRadioButton rbUrl;
        private JRadioButton rbFile;
        private JRadioButton rbClasspath;
        private JRadioButton rbNoPicture;
        private JLabel jLabel2;
        private JLabel jLabel3;
        private JLabel jLabel4;
        private JLabel jLabel5;
        private JPanel jPanel2;
        private JLabel lName;
        private JTextField tfName;
        private JButton bSelect;
        private JPanel jPanel3;
        private JLabel jLabel7;
        private JScrollPane spImage;
        private JLabel iconLabel = new JLabel(this){
            private final /* synthetic */ IconPanel this$1;
            {
                this.this$1 = iconPanel;
            }

            public boolean isFocusTraversable() {
                return true;
            }
        };
        private Icon localIcon;

        public IconPanel() {
            this.iconLabel.setPreferredSize(new Dimension(32, 32));
            this.initComponents();
            this.spImage.setViewportView(this.iconLabel);
            this.jLabel1.setText(IconEditor.getString("CTL_ImageSourceType"));
            this.rbUrl.setText(IconEditor.getString("CTL_URL"));
            this.rbFile.setText(IconEditor.getString("CTL_File"));
            this.rbClasspath.setText(IconEditor.getString("CTL_Classpath"));
            this.rbNoPicture.setText(IconEditor.getString("CTL_NoPicture"));
            this.jLabel2.setText(IconEditor.getString("CTL_URLExample"));
            this.jLabel3.setText(IconEditor.getString("CTL_FileExample"));
            this.jLabel4.setText(IconEditor.getString("CTL_ClasspathExample"));
            this.jLabel5.setText(IconEditor.getString("CTL_Null"));
            this.lName.setText(IconEditor.getString("CTL_ImageSourceName"));
            this.lName.setDisplayedMnemonic(IconEditor.getString("CTL_ImageSourceName_mnemonic").charAt(0));
            this.lName.setLabelFor(this.tfName);
            this.jLabel7.setText(IconEditor.getString("CTL_Preview"));
            this.jLabel7.setDisplayedMnemonic(IconEditor.getString("CTL_Preview_mnemonic").charAt(0));
            this.bSelect.setText(IconEditor.getString("CTL_ButtonSelect"));
            this.bSelect.setMnemonic(IconEditor.getString("CTL_ButtonSelect_mnemonic").charAt(0));
            this.jLabel1.setLabelFor(this.jPanel1);
            this.jLabel2.setLabelFor(this.rbUrl);
            this.jLabel3.setLabelFor(this.rbFile);
            this.jLabel4.setLabelFor(this.rbClasspath);
            this.jLabel5.setLabelFor(this.rbNoPicture);
            this.jLabel7.setLabelFor(this.iconLabel);
            this.rbUrl.setMnemonic(IconEditor.getString("CTL_URL_mnemonic").charAt(0));
            this.rbFile.setMnemonic(IconEditor.getString("CTL_File_mnemonic").charAt(0));
            this.rbClasspath.setMnemonic(IconEditor.getString("CTL_Classpath_mnemonic").charAt(0));
            this.rbNoPicture.setMnemonic(IconEditor.getString("CTL_NoPicture_mnemonic").charAt(0));
            this.tfName.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ImageSourceName"));
            this.bSelect.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_ButtonSelect"));
            this.iconLabel.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_CTL_Preview"));
            this.rbUrl.getAccessibleContext().setAccessibleDescription(this.jLabel2.getText());
            this.rbFile.getAccessibleContext().setAccessibleDescription(this.jLabel3.getText());
            this.rbClasspath.getAccessibleContext().setAccessibleDescription(this.jLabel4.getText());
            this.rbNoPicture.getAccessibleContext().setAccessibleDescription(this.jLabel5.getText());
            this.getAccessibleContext().setAccessibleDescription(IconEditor.getString("ACSD_IconCustomEditor"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbUrl);
            buttonGroup.add(this.rbFile);
            buttonGroup.add(this.rbClasspath);
            buttonGroup.add(this.rbNoPicture);
            this.localIcon = (Icon)IconEditor.this.getValue();
            if (IconEditor.this.propertyEnv != null) {
                IconEditor.this.propertyEnv.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            }
            if (this.localIcon == null || !(this.localIcon instanceof NbImageIcon)) {
                this.rbNoPicture.setSelected(true);
                this.bSelect.setEnabled(false);
                this.tfName.setEnabled(false);
                return;
            }
            switch (((NbImageIcon)this.localIcon).type) {
                case 1: {
                    this.rbUrl.setSelected(true);
                    this.bSelect.setEnabled(false);
                    break;
                }
                case 2: {
                    this.rbFile.setSelected(true);
                    this.bSelect.setEnabled(true);
                    break;
                }
                case 3: {
                    this.rbClasspath.setSelected(true);
                    this.bSelect.setEnabled(true);
                }
            }
            this.tfName.setText(((NbImageIcon)this.localIcon).name);
            HelpCtx.setHelpIDString(this, "gui.csh.icon");
            this.updateIcon();
        }

        private void initComponents() {
            this.jPanel1 = new JPanel();
            this.jLabel1 = new JLabel();
            this.rbUrl = new JRadioButton();
            this.rbFile = new JRadioButton();
            this.rbClasspath = new JRadioButton();
            this.rbNoPicture = new JRadioButton();
            this.jLabel2 = new JLabel();
            this.jLabel3 = new JLabel();
            this.jLabel4 = new JLabel();
            this.jLabel5 = new JLabel();
            this.jPanel2 = new JPanel();
            this.lName = new JLabel();
            this.tfName = new JTextField();
            this.bSelect = new JButton();
            this.jPanel3 = new JPanel();
            this.jLabel7 = new JLabel();
            this.spImage = new JScrollPane();
            this.setLayout(new GridBagLayout());
            this.jPanel1.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(12, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbUrl, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbFile, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbClasspath, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.rbNoPicture, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(12, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(5, 5, 0, 12);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel1, gridBagConstraints2);
            this.jPanel2.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.lName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(12, 5, 0, 0);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            this.jPanel2.add((Component)this.tfName, gridBagConstraints3);
            gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(12, 5, 0, 17);
            gridBagConstraints3.anchor = 17;
            this.jPanel2.add((Component)this.bSelect, gridBagConstraints3);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 1;
            this.add((Component)this.jPanel2, gridBagConstraints2);
            this.jPanel3.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints4.anchor = 17;
            this.jPanel3.add((Component)this.jLabel7, gridBagConstraints4);
            gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.insets = new Insets(5, 12, 0, 12);
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            this.jPanel3.add((Component)this.spImage, gridBagConstraints4);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            this.add((Component)this.jPanel3, gridBagConstraints2);
            this.tfName.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.setValue();
                }
            });
            this.rbUrl.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    IconPanel.access$200(this.this$1).setEnabled(false);
                    IconPanel.access$300(this.this$1).setEnabled(true);
                    this.this$1.setValue();
                }
            });
            this.rbFile.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    IconPanel.access$200(this.this$1).setEnabled(true);
                    IconPanel.access$300(this.this$1).setEnabled(true);
                    this.this$1.setValue();
                    this.this$1.updateIcon();
                }
            });
            this.rbClasspath.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    IconPanel.access$200(this.this$1).setEnabled(true);
                    IconPanel.access$300(this.this$1).setEnabled(true);
                    this.this$1.setValue();
                }
            });
            this.rbNoPicture.addActionListener(new ActionListener(this){
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    IconPanel.access$200(this.this$1).setEnabled(false);
                    IconPanel.access$300(this.this$1).setEnabled(false);
                    IconPanel.access$402(this.this$1, null);
                    this.this$1.updateIcon();
                }
            });
            this.bSelect.addActionListener(new ActionListener(this){
                static /* synthetic */ Class class$org$openide$loaders$DataObject;
                private final /* synthetic */ IconPanel this$1;
                {
                    this.this$1 = iconPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (IconPanel.access$500(this.this$1).isSelected()) {
                        JFileChooser jFileChooser = new JFileChooser();
                        FileFilter fileFilter = new FileFilter(this){
                            private final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public boolean accept(File file) {
                                return file.isDirectory() || IconEditor.isImage(file.getName());
                            }

                            public String getDescription() {
                                return IconEditor.access$000("CTL_ImagesExtensionName");
                            }
                        };
                        jFileChooser.setFileFilter(fileFilter);
                        jFileChooser.setFileSelectionMode(2);
                        HelpCtx.setHelpIDString(jFileChooser, "csh.openimage");
                        int n = jFileChooser.showOpenDialog(this.this$1);
                        if (n != 0) {
                            return;
                        }
                        IconPanel.access$300(this.this$1).setText(jFileChooser.getSelectedFile().getAbsolutePath());
                        this.this$1.setValue();
                    } else if (IconPanel.access$600(this.this$1).isSelected()) {
                        String string;
                        Places places = TopManager.getDefault().getPlaces();
                        Node node = places.nodes().repository(new DataFilter(this){
                            private final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public boolean acceptDataObject(DataObject dataObject) {
                                if (dataObject instanceof DataFolder) {
                                    return !dataObject.getPrimaryFile().isReadOnly() || dataObject.getPrimaryFile().getParent() != null;
                                }
                                return IconEditor.isImage(dataObject.getPrimaryFile().getExt());
                            }
                        });
                        try {
                            DataObject dataObject = (DataObject)TopManager.getDefault().getNodeOperation().select(IconEditor.access$000("CTL_OpenDialogName"), IconEditor.access$000("CTL_FileSystemName"), TopManager.getDefault().getPlaces().nodes().repository(), new NodeAcceptor(this){
                                static /* synthetic */ Class class$org$openide$loaders$DataFolder;
                                private final /* synthetic */ 7 this$2;
                                {
                                    this.this$2 = var1_1;
                                }

                                public boolean acceptNodes(Node[] nodeArray) {
                                    if (nodeArray == null || nodeArray.length != 1) {
                                        return false;
                                    }
                                    return nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = 10.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder) == null;
                                }

                                static /* synthetic */ Class class$(String string) {
                                    try {
                                        return Class.forName(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                            }, null)[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = 7.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                            string = dataObject.getPrimaryFile().getPackageNameExt('/', '.');
                        }
                        catch (UserCancelException userCancelException) {
                            return;
                        }
                        IconPanel.access$300(this.this$1).setText("/" + string);
                        this.this$1.setValue();
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }

        public Object getPropertyValue() throws IllegalStateException {
            NbImageIcon nbImageIcon = null;
            String string = this.tfName.getText().trim();
            if (string == null || "".equals(string) || "/".equals(string) || "///".equals(string) || string.endsWith("#")) {
                return null;
            }
            try {
                if (this.rbFile.isSelected()) {
                    nbImageIcon = new NbImageIcon(string);
                    nbImageIcon.type = 2;
                    nbImageIcon.name = string;
                } else if (this.rbClasspath.isSelected()) {
                    URL uRL = TopManager.getDefault().currentClassLoader().getResource(string);
                    nbImageIcon = new NbImageIcon(uRL);
                    nbImageIcon.type = 3;
                    nbImageIcon.name = string;
                } else if (this.rbUrl.isSelected()) {
                    URL uRL = new URL(string);
                    nbImageIcon = new NbImageIcon(uRL);
                    nbImageIcon.type = 1;
                    nbImageIcon.name = string;
                }
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException(exception.toString());
                TopManager.getDefault().getErrorManager().annotate(illegalStateException, 256, IconEditor.getString("MSG_IllegalValue"), IconEditor.getString("MSG_IllegalValue"), null, new Date());
                throw illegalStateException;
            }
            return nbImageIcon;
        }

        void updateIcon() {
            this.iconLabel.setIcon(this.localIcon);
            this.iconLabel.setEnabled(this.localIcon != null);
            this.validate();
        }

        void setValue() {
            String string = this.tfName.getText();
            string.trim();
            if ("".equals(string)) {
                this.localIcon = null;
                return;
            }
            String string2 = "";
            if (this.rbUrl.isSelected()) {
                string2 = "URL: ";
            } else if (this.rbFile.isSelected()) {
                string2 = "File: ";
            } else if (this.rbClasspath.isSelected()) {
                string2 = "Classpath: ";
            }
            try {
                this.localIcon = IconEditor.this.iconFromText(string2 + string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                TopManager.getDefault().getErrorManager().notify(1, illegalArgumentException);
            }
            this.updateIcon();
        }

        static /* synthetic */ JButton access$200(IconPanel iconPanel) {
            return iconPanel.bSelect;
        }

        static /* synthetic */ JTextField access$300(IconPanel iconPanel) {
            return iconPanel.tfName;
        }

        static /* synthetic */ Icon access$402(IconPanel iconPanel, Icon icon) {
            iconPanel.localIcon = icon;
            return iconPanel.localIcon;
        }

        static /* synthetic */ JRadioButton access$500(IconPanel iconPanel) {
            return iconPanel.rbFile;
        }

        static /* synthetic */ JRadioButton access$600(IconPanel iconPanel) {
            return iconPanel.rbClasspath;
        }
    }

    public static class NbImageIcon
    extends ImageIcon
    implements Externalizable {
        static final long serialVersionUID = 7018807466471349466L;
        int type;
        String name;
        boolean stateValid;

        public NbImageIcon() {
            super("");
            this.stateValid = false;
        }

        NbImageIcon(URL uRL) {
            super(uRL);
            this.type = 1;
            this.stateValid = true;
        }

        NbImageIcon(String string) {
            super(string);
            this.type = 2;
            this.stateValid = true;
        }

        String getName() {
            return this.name;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(new Integer(this.type));
            objectOutput.writeObject(this.name);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.type = (Integer)objectInput.readObject();
            this.name = (String)objectInput.readObject();
            ImageIcon imageIcon = null;
            switch (this.type) {
                case 1: {
                    try {
                        imageIcon = new ImageIcon(new URL(this.name));
                        break;
                    }
                    catch (MalformedURLException malformedURLException) {
                        TopManager.getDefault().getErrorManager().notify(1, malformedURLException);
                        return;
                    }
                }
                case 2: {
                    imageIcon = new ImageIcon(this.name);
                    break;
                }
                case 3: {
                    imageIcon = new ImageIcon(TopManager.getDefault().currentClassLoader().getResource(this.name));
                }
            }
            this.setImage(imageIcon.getImage());
        }
    }
}

