/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.text.MessageFormat;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.awt.MouseUtils;
import org.openide.explorer.propertysheet.SheetButtonListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class SheetButton
extends JPanel {
    static final long serialVersionUID = -5681433767155127558L;
    static final String RIGHT_MOUSE_COMMAND = "rightMouseActionCommand";
    private transient Vector listeners = new Vector(1, 5);
    private String actionCommand = "click";
    private String label;
    private Dimension preferredSize;
    private boolean pressed;
    private boolean focusTransferable;
    private boolean isPlastic;
    private IL innerListener;
    private JComponent innerComponent;
    private boolean plasticNotify;
    private Color foreground = SystemColor.controlText;
    private Color inForeground = SystemColor.textInactiveText;
    private boolean invalidMark;

    public SheetButton() {
        this("", false, false);
    }

    public SheetButton(String string) {
        this(string, false, false);
    }

    public SheetButton(String string, boolean bl) {
        this(string, bl, false);
    }

    public SheetButton(String string, boolean bl, boolean bl2) {
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.label = string == null ? "" : string;
        this.isPlastic = bl;
        this.plasticNotify = bl2;
        this.innerListener = new IL();
        this.addMouseListener(this.innerListener);
        this.addKeyListener(this.innerListener);
    }

    public boolean isFocusTraversable() {
        return this.focusTransferable;
    }

    public void setFocusTraversable(boolean bl) {
        if (this.isFocusTraversable() == bl) {
            return;
        }
        this.focusTransferable = bl;
        if (bl) {
            this.addFocusListener(this.innerListener);
        } else {
            this.removeFocusListener(this.innerListener);
        }
    }

    public void setToolTipText(String string) {
        if (this.innerComponent != null) {
            this.innerComponent.setToolTipText(string);
        }
        super.setToolTipText(string);
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.updatePreferredSize();
        }
        return this.preferredSize == null ? new Dimension(10, 10) : this.preferredSize;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.updatePreferredSize();
    }

    public Color getActiveForeground() {
        return this.foreground;
    }

    public void setActiveForeground(Color color) {
        this.foreground = color;
        this.repaint();
    }

    public Color getInactiveForeground() {
        return this.inForeground;
    }

    public void setInactiveForeground(Color color) {
        this.inForeground = color;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        if (this.isShowing()) {
            this.updatePreferredSize();
            this.repaint();
        }
    }

    public void setPressed(boolean bl) {
        if (this.pressed == bl) {
            return;
        }
        this.pressed = bl;
        if (this.pressed) {
            this.setBorder(new EmptyBorder(2, 2, 0, 0));
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        this.repaint();
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPlastic(boolean bl) {
        this.isPlastic = bl;
        this.repaint();
    }

    public boolean isPlastic() {
        return this.isPlastic;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public Component add(Component component) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.add(component, "Center");
        this.removeMouseListener(this.innerListener);
        component.addMouseListener(this.innerListener);
        this.innerComponent = (JComponent)component;
        return this.innerComponent;
    }

    void setInvalidMark(boolean bl) {
        this.invalidMark = bl;
        this.repaint();
    }

    private Image getInvalidImage() {
        return Utilities.loadImage("org/openide/resources/propertysheet/invalid.gif");
    }

    private void updatePreferredSize() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        Font font = null;
        font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.preferredSize = new Dimension(fontMetrics.stringWidth(this.label) + 10, fontMetrics.getHeight() + 6);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        int n = 0;
        if (this.invalidMark) {
            n = this.getInvalidImage().getWidth(null) + 2;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.pressed) {
            if (this.innerComponent == null) {
                graphics.setColor(this.isEnabled() ? this.getActiveForeground() : this.getInactiveForeground());
                graphics.drawString(this.label, 6 + n, (dimension.height - fontMetrics.getHeight()) / 2 + 1 + fontMetrics.getMaxAscent());
                if (this.invalidMark) {
                    graphics.drawImage(this.getInvalidImage(), 2, 2, null);
                }
            }
        } else {
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 0, 0, dimension.height - 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            if (this.innerComponent == null) {
                graphics.setColor(this.isEnabled() ? this.getActiveForeground() : this.getInactiveForeground());
                graphics.drawString(this.label, 5 + n, (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getMaxAscent());
                if (this.invalidMark) {
                    graphics.drawImage(this.getInvalidImage(), 1, 1, null);
                }
            }
        }
        if (this.hasFocus()) {
            graphics.setColor(UIManager.getColor("Button.focus"));
            graphics.drawRect(2, 1, dimension.width - 5, dimension.height - 4);
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public String toString() {
        return this.getClass().getName() + "[ \"" + this.label + "\" ]";
    }

    void addSheetButtonListener(SheetButtonListener sheetButtonListener) {
        if (!this.listeners.contains(sheetButtonListener)) {
            this.listeners.addElement(sheetButtonListener);
        }
    }

    void removeSheetButtonListener(SheetButtonListener sheetButtonListener) {
        this.listeners.removeElement(sheetButtonListener);
    }

    public void notifySheetButtonListenersAboutClick(ActionEvent actionEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((SheetButtonListener)vector.elementAt(n2)).sheetButtonClicked(actionEvent);
            ++n2;
        }
    }

    public void notifySheetButtonListenersAboutEntered(ActionEvent actionEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((SheetButtonListener)vector.elementAt(n2)).sheetButtonEntered(actionEvent);
            ++n2;
        }
    }

    public void notifySheetButtonListenersAboutExited(ActionEvent actionEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            ((SheetButtonListener)vector.elementAt(n2)).sheetButtonExited(actionEvent);
            ++n2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSheetButton();
        }
        return this.accessibleContext;
    }

    class AccessibleSheetButton
    extends JComponent.AccessibleJComponent {
        static /* synthetic */ Class class$org$openide$explorer$propertysheet$SheetButton;

        AccessibleSheetButton() {
            super(SheetButton.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        public String getAccessibleName() {
            String string = super.getAccessibleName();
            if (string == null && SheetButton.this.innerComponent != null) {
                string = SheetButton.this.innerComponent.getAccessibleContext().getAccessibleName();
            }
            if (string == null && SheetButton.this.label != null) {
                string = SheetButton.this.label;
            }
            return MessageFormat.format(NbBundle.getBundle(class$org$openide$explorer$propertysheet$SheetButton == null ? (class$org$openide$explorer$propertysheet$SheetButton = AccessibleSheetButton.class$("org.openide.explorer.propertysheet.SheetButton")) : class$org$openide$explorer$propertysheet$SheetButton).getString("ACS_SheetButton"), new Integer(SheetButton.this.invalidMark ? 0 : 1), string);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class IL
    extends MouseMotionAdapter
    implements MouseListener,
    KeyListener,
    FocusListener {
        IL() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SheetButton.this.isPlastic) {
                SheetButton.this.pressed = true;
                SheetButton.this.setBorder(new EmptyBorder(2, 2, 0, 0));
                SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
                if (SheetButton.this.innerComponent != null) {
                    SheetButton.this.invalidate();
                    if (SheetButton.this.getParent() != null) {
                        SheetButton.this.getParent().validate();
                    }
                    SheetButton.this.innerComponent.addMouseMotionListener(SheetButton.this.innerListener);
                } else {
                    SheetButton.this.addMouseMotionListener(SheetButton.this.innerListener);
                }
                SheetButton.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            boolean bl = MouseUtils.isRightMouseButton(mouseEvent);
            if (SheetButton.this.innerComponent != null) {
                SheetButton.this.innerComponent.removeMouseMotionListener(SheetButton.this.innerListener);
                SheetButton.this.invalidate();
                if (SheetButton.this.getParent() != null) {
                    SheetButton.this.getParent().validate();
                }
            } else {
                SheetButton.this.removeMouseMotionListener(SheetButton.this.innerListener);
            }
            SheetButton.this.repaint();
            if (SheetButton.this.isEnabled()) {
                SheetButton.this.notifySheetButtonListenersAboutClick(new ActionEvent(SheetButton.this, mouseEvent.getClickCount() % 2 == 1 ? 1002 : 1003, bl ? SheetButton.RIGHT_MOUSE_COMMAND : SheetButton.this.actionCommand));
                SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
            }
            SheetButton.this.pressed = false;
            SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (SheetButton.this.isPlastic) {
                SheetButton.this.pressed = true;
                SheetButton.this.setBorder(new EmptyBorder(2, 2, 0, 0));
                SheetButton.this.repaint();
                if (SheetButton.this.plasticNotify) {
                    SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SheetButton.this.isPlastic) {
                SheetButton.this.pressed = false;
                SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
                SheetButton.this.repaint();
                if (SheetButton.this.plasticNotify) {
                    SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (new Rectangle(SheetButton.this.getSize()).contains(mouseEvent.getPoint()) == SheetButton.this.pressed) {
                return;
            }
            if (SheetButton.this.pressed) {
                SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
            } else {
                SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1001, SheetButton.this.actionCommand));
            }
            SheetButton.this.pressed = !SheetButton.this.pressed;
            if (SheetButton.this.pressed) {
                SheetButton.this.setBorder(new EmptyBorder(2, 2, 0, 0));
            } else {
                SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            if (SheetButton.this.innerComponent != null) {
                SheetButton.this.invalidate();
                if (SheetButton.this.getParent() != null) {
                    SheetButton.this.getParent().validate();
                }
            }
            SheetButton.this.repaint();
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown()) {
                return;
            }
            if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                SheetButton.this.notifySheetButtonListenersAboutClick(new ActionEvent(SheetButton.this, 1002, SheetButton.this.actionCommand));
            }
            if (keyEvent.getKeyCode() == 40) {
                FocusManager focusManager = FocusManager.getCurrentManager();
                focusManager.focusNextComponent(SheetButton.this);
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 38) {
                FocusManager focusManager = FocusManager.getCurrentManager();
                focusManager.focusPreviousComponent(SheetButton.this);
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void focusGained(FocusEvent focusEvent) {
            SheetButton.this.notifySheetButtonListenersAboutEntered(new ActionEvent(SheetButton.this, 1002, SheetButton.this.actionCommand));
            Container container = SheetButton.this;
            Rectangle rectangle = SheetButton.this.getBounds();
            while (container != null && !(container instanceof JViewport)) {
                if ((container = container.getParent()) == null) continue;
                rectangle.x += container.getX();
                rectangle.y += container.getY();
            }
            if (container != null) {
                JViewport jViewport = (JViewport)container;
                jViewport.scrollRectToVisible(rectangle);
            }
            SheetButton.this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (SheetButton.this.isPlastic) {
                SheetButton.this.pressed = false;
                SheetButton.this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            SheetButton.this.notifySheetButtonListenersAboutExited(new ActionEvent(SheetButton.this, 1002, SheetButton.this.actionCommand));
            SheetButton.this.repaint();
        }
    }
}

