/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListener;

final class ProxyNode
extends AbstractNode {
    private Node[] original;
    private PropertyChangeListener pcl;

    public ProxyNode(Node[] nodeArray) {
        super(Children.LEAF);
        this.original = nodeArray;
        this.pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ProxyNode.super.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        };
        int n = 0;
        while (n < nodeArray.length) {
            nodeArray[n].addPropertyChangeListener(WeakListener.propertyChange(this.pcl, nodeArray[n]));
            ++n;
        }
    }

    public HelpCtx getHelpCtx() {
        int n = 0;
        while (n < this.original.length) {
            if (this.original[n].getHelpCtx() != HelpCtx.DEFAULT_HELP) {
                return this.original[n].getHelpCtx();
            }
            ++n;
        }
        return HelpCtx.DEFAULT_HELP;
    }

    public Node cloneNode() {
        return new ProxyNode(this.original);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set[] setArray = this.computePropertySets();
        int n = 0;
        while (n < setArray.length) {
            sheet.put(setArray[n]);
            ++n;
        }
        return sheet;
    }

    Node[] getOriginalNodes() {
        return this.original;
    }

    private Sheet.Set[] computePropertySets() {
        if (this.original.length > 0) {
            Node.PropertySet[] propertySetArray = this.original[0].getPropertySets();
            HashSet<Node.PropertySet> hashSet = new HashSet<Node.PropertySet>(Arrays.asList(propertySetArray));
            int n = 1;
            while (n < this.original.length) {
                hashSet.retainAll(new HashSet<Node.PropertySet>(Arrays.asList(this.original[n].getPropertySets())));
                ++n;
            }
            ArrayList<Sheet.Set> arrayList = new ArrayList<Sheet.Set>(hashSet.size());
            int n2 = 0;
            while (n2 < propertySetArray.length) {
                if (hashSet.contains(propertySetArray[n2]) && !propertySetArray[n2].isHidden()) {
                    Object object;
                    int n3;
                    FeatureDescriptor[] featureDescriptorArray;
                    Node.PropertySet propertySet = propertySetArray[n2];
                    Sheet.Set set = new Sheet.Set();
                    set.setName(propertySet.getName());
                    set.setDisplayName(propertySet.getDisplayName());
                    set.setShortDescription(propertySet.getShortDescription());
                    HashSet<Node.Property> hashSet2 = new HashSet<Node.Property>(Arrays.asList(propertySet.getProperties()));
                    int n4 = 0;
                    while (n4 < this.original.length) {
                        featureDescriptorArray = this.original[n4].getPropertySets();
                        n3 = 0;
                        while (n3 < featureDescriptorArray.length) {
                            object = ((Node.PropertySet)featureDescriptorArray[n3]).getProperties();
                            if (propertySet.getName().equals(featureDescriptorArray[n3].getName())) {
                                hashSet2.retainAll(new HashSet<Node.Property>(Arrays.asList(((Node.PropertySet)featureDescriptorArray[n3]).getProperties())));
                            }
                            ++n3;
                        }
                        ++n4;
                    }
                    featureDescriptorArray = propertySet.getProperties();
                    n3 = 0;
                    while (n3 < featureDescriptorArray.length) {
                        if (hashSet2.contains(featureDescriptorArray[n3]) && !featureDescriptorArray[n3].isHidden()) {
                            object = this.createProxyProperty(featureDescriptorArray[n3].getName(), set.getName());
                            set.put((Node.Property)object);
                        }
                        ++n3;
                    }
                    arrayList.add(set);
                }
                ++n2;
            }
            return arrayList.toArray(new Sheet.Set[arrayList.size()]);
        }
        return new Sheet.Set[0];
    }

    private ProxyProperty createProxyProperty(String string, String string2) {
        Node.Property[] propertyArray = new Node.Property[this.original.length];
        int n = 0;
        while (n < this.original.length) {
            Node.PropertySet[] propertySetArray = this.original[n].getPropertySets();
            int n2 = 0;
            while (n2 < propertySetArray.length) {
                if (propertySetArray[n2].getName().equals(string2)) {
                    Node.Property[] propertyArray2 = propertySetArray[n2].getProperties();
                    int n3 = 0;
                    while (n3 < propertyArray2.length) {
                        if (propertyArray2[n3].getName().equals(string)) {
                            propertyArray[n] = propertyArray2[n3];
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return new ProxyProperty(propertyArray);
    }

    static class DifferentValuesException
    extends RuntimeException {
        DifferentValuesException() {
        }
    }

    private static class ProxyProperty
    extends Node.Property {
        private Node.Property[] original;

        public ProxyProperty(Node.Property[] propertyArray) {
            super(propertyArray[0].getValueType());
            this.original = propertyArray;
            this.setName(propertyArray[0].getName());
            this.setDisplayName(propertyArray[0].getDisplayName());
            this.setShortDescription(propertyArray[0].getShortDescription());
        }

        public boolean canWrite() {
            int n = 0;
            while (n < this.original.length) {
                if (!this.original[n].canWrite()) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean canRead() {
            int n = 0;
            while (n < this.original.length) {
                if (!this.original[n].canRead()) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            Object object = this.original[0].getValue();
            if (object == null) {
                return null;
            }
            int n = 0;
            while (n < this.original.length) {
                if (!object.equals(this.original[n].getValue())) {
                    throw new DifferentValuesException();
                }
                ++n;
            }
            return object;
        }

        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            int n = 0;
            while (n < this.original.length) {
                this.original[n].setValue(object);
                ++n;
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.original[0].getPropertyEditor();
        }

        public boolean supportsDefaultValue() {
            int n = 0;
            while (n < this.original.length) {
                if (!this.original[n].supportsDefaultValue()) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            int n = 0;
            while (n < this.original.length) {
                this.original[n].restoreDefaultValue();
                ++n;
            }
        }
    }
}

