/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertyDialogManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.propertysheet.ProxyNode;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;

class IndexedEditorPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private ExplorerManager em;
    private NodeAction moveUp;
    private NodeAction moveDown;
    private NodeAction newAction;
    private boolean showingDetails = false;
    private Node rootNode;
    private Node.Property prop;
    private TreeTableView treeTableView1;
    private JButton detailsButton;
    private JLabel propertiesLabel;
    private JButton newButton;
    private JButton downButton;
    private JPanel detailsPanel;
    private JButton deleteButton;
    private JPanel jPanel1;
    private JButton upButton;
    static /* synthetic */ Class class$org$openide$explorer$propertysheet$IndexedEditorPanel;

    public IndexedEditorPanel(Node node, Node.Property[] propertyArray) {
        this.initComponents();
        this.getExplorerManager().setRootContext(node);
        this.rootNode = node;
        this.prop = propertyArray[0];
        this.getExplorerManager().addPropertyChangeListener(this);
        this.treeTableView1.setProperties(propertyArray);
        this.treeTableView1.setRootVisible(false);
        this.treeTableView1.setDefaultActionAllowed(false);
        this.treeTableView1.setTreePreferredWidth(200);
        node.addPropertyChangeListener(this);
        try {
            this.moveUp = (NodeAction)SystemAction.get(Class.forName("org.openide.actions.MoveUpAction"));
            this.moveDown = (NodeAction)SystemAction.get(Class.forName("org.openide.actions.MoveDownAction"));
            this.newAction = (NodeAction)SystemAction.get(Class.forName("org.openide.actions.NewAction"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ResourceBundle resourceBundle = NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel);
        this.propertiesLabel.setDisplayedMnemonic(resourceBundle.getString("CTL_Properties_Mnemonic").charAt(0));
        this.newButton.setMnemonic(resourceBundle.getString("CTL_New_Mnemonic").charAt(0));
        this.deleteButton.setMnemonic(resourceBundle.getString("CTL_Delete_Mnemonic").charAt(0));
        this.upButton.setMnemonic(resourceBundle.getString("CTL_MoveUp_Mnemonic").charAt(0));
        this.downButton.setMnemonic(resourceBundle.getString("CTL_MoveDown_Mnemonic").charAt(0));
        this.treeTableView1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Properties"));
        this.newButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_New"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Delete"));
        this.upButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MoveDown"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_IndexedEditorPanel"));
    }

    public void addNotify() {
        super.addNotify();
        this.updateButtonState();
    }

    private void initComponents() {
        this.treeTableView1 = new TreeTableView();
        this.jPanel1 = new JPanel();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.detailsButton = new JButton();
        this.propertiesLabel = new JLabel();
        this.detailsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 0, 12)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeTableView1, gridBagConstraints);
        this.jPanel1.setLayout(new GridLayout(5, 1, 0, 5));
        this.newButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_New"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexedEditorPanel.this.newButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.newButton);
        this.deleteButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_Delete"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexedEditorPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.deleteButton);
        this.upButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_MoveUp"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexedEditorPanel.this.upButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.upButton);
        this.downButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_MoveDown"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexedEditorPanel.this.downButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.downButton);
        this.detailsButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_HideDetails"));
        this.detailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IndexedEditorPanel.this.detailsButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.detailsButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.propertiesLabel.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_Properties"));
        this.propertiesLabel.setLabelFor(this.treeTableView1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 11);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.propertiesLabel, gridBagConstraints);
        this.detailsPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.detailsPanel, gridBagConstraints);
    }

    private void detailsButtonActionPerformed(ActionEvent actionEvent) {
        this.showingDetails = !this.showingDetails;
        this.updateButtonState();
        this.updateDetailsPanel();
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.getExplorerManager().setSelectedNodes(new Node[]{this.rootNode});
        }
        catch (PropertyVetoException propertyVetoException) {
            PropertyDialogManager.notify(propertyVetoException);
        }
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (this.newAction != null && this.newAction.isEnabled()) {
            this.newAction.performAction();
        }
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null || nodeArray.length != 1 || nodeArray[0] == this.rootNode) {
            return;
        }
        try {
            nodeArray[0].destroy();
        }
        catch (IOException iOException) {
            PropertyDialogManager.notify(iOException);
        }
        this.rootNode = this.getExplorerManager().getRootContext();
    }

    private void downButtonActionPerformed(ActionEvent actionEvent) {
        if (this.moveDown != null && this.moveDown.isEnabled()) {
            this.moveDown.performAction();
        }
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        if (this.moveUp != null && this.moveUp.isEnabled()) {
            this.moveUp.performAction();
        }
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.em == null) {
            this.em = new ExplorerManager();
        }
        return this.em;
    }

    private void updateButtonState() {
        if (this.showingDetails) {
            this.detailsButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_HideDetails"));
        } else {
            this.detailsButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_ShowDetails"));
        }
        this.upButton.setEnabled(this.moveUp != null && this.moveUp.isEnabled());
        this.downButton.setEnabled(this.moveDown != null && this.moveDown.isEnabled());
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        this.deleteButton.setEnabled(nodeArray != null && nodeArray.length == 1 && nodeArray[0] != this.rootNode);
        this.detailsButton.setVisible(this.prop != null && this.prop.getPropertyEditor() != null && this.prop.getPropertyEditor().supportsCustomEditor());
        if (this.detailsButton.isVisible()) {
            if (this.showingDetails) {
                this.detailsButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_HideDetails"));
                this.detailsButton.setMnemonic(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_HideDetails_Mnemonic").charAt(0));
                this.detailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("ACSD_HideDetails"));
            } else {
                this.detailsButton.setText(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_ShowDetails"));
                this.detailsButton.setMnemonic(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("CTL_ShowDetails_Mnemonic").charAt(0));
                this.detailsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(class$org$openide$explorer$propertysheet$IndexedEditorPanel == null ? (class$org$openide$explorer$propertysheet$IndexedEditorPanel = IndexedEditorPanel.class$("org.openide.explorer.propertysheet.IndexedEditorPanel")) : class$org$openide$explorer$propertysheet$IndexedEditorPanel).getString("ACSD_ShowDetails"));
            }
            this.detailsButton.setEnabled(nodeArray != null && nodeArray.length == 1 && nodeArray[0] != this.rootNode);
        }
    }

    private void updateDetailsPanel() {
        this.detailsPanel.removeAll();
        if (!this.showingDetails) {
            this.revalidateDetailsPanel();
            return;
        }
        Object[] objectArray = this.getExplorerManager().getSelectedNodes();
        if (objectArray == null || objectArray.length == 0) {
            this.revalidateDetailsPanel();
            return;
        }
        Node node = objectArray[0];
        if (node == this.rootNode) {
            this.revalidateDetailsPanel();
            return;
        }
        if (objectArray.length > 1) {
            node = new ProxyNode((Node[])objectArray);
        }
        Node.Property property = node.getPropertySets()[0].getProperties()[0];
        PropertyPanel propertyPanel = new PropertyPanel(property, objectArray);
        propertyPanel.setPreferences(2);
        this.detailsPanel.add((Component)propertyPanel, "Center");
        this.revalidateDetailsPanel();
    }

    private void revalidateDetailsPanel() {
        this.detailsPanel.invalidate();
        if (this.detailsPanel.getParent() != null) {
            this.detailsPanel.getParent().validate();
        } else {
            this.detailsPanel.validate();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.updateButtonState();
            this.updateDetailsPanel();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

