/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.EnvironmentNotSupportedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;

public final class NbClassPath
implements Serializable {
    static final long serialVersionUID = -8458093409814321744L;
    private Object[] items;
    private String classpath;

    public NbClassPath(String[] stringArray) {
        this.items = stringArray;
    }

    public NbClassPath(File[] fileArray) {
        this.items = fileArray;
    }

    private NbClassPath(Object[] objectArray) {
        this.items = objectArray;
    }

    public NbClassPath(String string) {
        this.items = new Exception[0];
        this.classpath = string;
        if (string.indexOf(32) >= 0) {
            if (string.startsWith("\"")) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
            this.classpath = stringBuffer.toString();
        }
    }

    public static NbClassPath createRepositoryPath() {
        return NbClassPath.createRepositoryPath(FileSystemCapability.ALL);
    }

    public static NbClassPath createRepositoryPath(FileSystemCapability fileSystemCapability) {
        LinkedList<EnvironmentNotSupportedException> linkedList = new LinkedList<EnvironmentNotSupportedException>();
        final class Env
        extends FileSystem.Environment {
            private final /* synthetic */ LinkedList val$res;

            Env(LinkedList linkedList) {
                this.val$res = linkedList;
            }

            public void addClassPath(String string) {
                this.val$res.add(string);
            }
        }
        Env env = new Env(linkedList);
        Enumeration enumeration = fileSystemCapability.fileSystems();
        while (enumeration.hasMoreElements()) {
            try {
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                fileSystem.prepareEnvironment(env);
            }
            catch (EnvironmentNotSupportedException environmentNotSupportedException) {
                linkedList.add(environmentNotSupportedException);
            }
        }
        return new NbClassPath(linkedList.toArray());
    }

    public static NbClassPath createLibraryPath() {
        return TopManager.getDefault().getExecutionEngine().createLibraryPath();
    }

    public static NbClassPath createClassPath() {
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return new NbClassPath("");
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.endsWith("openide-compat.jar")) continue;
            if (bl) {
                stringBuffer.append(File.pathSeparatorChar);
            } else {
                bl = true;
            }
            stringBuffer.append(string2);
        }
        return new NbClassPath(stringBuffer.toString());
    }

    public static NbClassPath createBootClassPath() {
        String string;
        StringBuffer stringBuffer;
        String string2 = System.getProperty("sun.boot.class.path");
        StringBuffer stringBuffer2 = stringBuffer = string2 != null ? new StringBuffer(string2) : new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(File.pathSeparatorChar);
        }
        if ((string = System.getProperty("java.ext.dirs")) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                File file = new File(string3);
                if (!string3.endsWith(File.separator)) {
                    string3 = string3 + File.separator;
                }
                if (!file.isDirectory()) continue;
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    String string4 = stringArray[n];
                    if (string4.endsWith(".jar")) {
                        stringBuffer.append(File.pathSeparatorChar).append(string3).append(string4);
                    }
                    ++n;
                }
            }
        }
        return new NbClassPath(stringBuffer.toString());
    }

    public static File toFile(FileObject fileObject) {
        String string = fileObject.getPackageNameExt(File.separatorChar, '.');
        final class Env
        extends FileSystem.Environment {
            public File found;
            private final /* synthetic */ String val$pne;

            Env(String string) {
                this.val$pne = string;
            }

            public void addClassPath(String string) {
                if (this.found != null) {
                    return;
                }
                File file = new File(string);
                if (!file.isDirectory()) {
                    return;
                }
                File file2 = new File(file, this.val$pne);
                if (file2.exists()) {
                    this.found = file2;
                }
            }
        }
        Env env = new Env(string);
        try {
            fileObject.getFileSystem().prepareEnvironment(env);
            return env.found;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Exception[] getExceptions() {
        try {
            return (Exception[])this.items;
        }
        catch (ClassCastException classCastException) {
            NbClassPath nbClassPath = this;
            synchronized (nbClassPath) {
                this.getClassPath();
                int n = 0;
                int n2 = 0;
                while (n2 < this.items.length) {
                    if (this.items[n2] != null) {
                        this.items[n++] = this.items[n2];
                    }
                    ++n2;
                }
                Exception[] exceptionArray = new Exception[n];
                System.arraycopy(this.items, 0, exceptionArray, 0, n);
                this.items = exceptionArray;
                Exception[] exceptionArray2 = exceptionArray;
                return exceptionArray2;
            }
        }
    }

    public String getClassPath() {
        if (this.classpath != null) {
            return this.classpath;
        }
        NbClassPath nbClassPath = this;
        synchronized (nbClassPath) {
            Object object;
            if (this.classpath != null) {
                String string = this.classpath;
                return string;
            }
            if (this.items.length == 0) {
                this.classpath = "";
                String string = "";
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            int n = 0;
            while (n < this.items.length) {
                object = this.items[n];
                if (object != null && (object instanceof String || object instanceof File)) {
                    if (bl) {
                        stringBuffer.append(File.pathSeparatorChar);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(object.toString());
                    this.items[n] = null;
                }
                ++n;
            }
            object = stringBuffer.toString();
            if (((String)object).indexOf(32) >= 0) {
                stringBuffer.insert(0, '\"');
                stringBuffer.append('\"');
                this.classpath = stringBuffer.toString();
            } else {
                this.classpath = object;
            }
            String string = this.classpath;
            return string;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof NbClassPath)) {
            return false;
        }
        NbClassPath nbClassPath = (NbClassPath)object;
        return this.getClassPath().equals(nbClassPath.getClassPath());
    }
}

