/*
 * Decompiled with CFR 0.152.
 */
package org.openide.compiler;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.openide.compiler.Compilable;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.IdSet;

public abstract class Compiler
implements Compilable {
    public static final Depth DEPTH_ZERO = new Depth();
    public static final Depth DEPTH_ONE = new Depth();
    public static final Depth DEPTH_INFINITE = new Depth();
    private Collection dependsOn;
    private static Map jobTable = new WeakHashMap(101);

    public Compiler() {
    }

    public Compiler(CompilerJob compilerJob) {
        compilerJob.add(this);
        this.registerInJob(compilerJob);
    }

    public Compiler(Compiler compiler) {
        this.dependsOn(compiler);
        this.registerInJob(compiler);
    }

    public Compiler(Compiler[] compilerArray) {
        this.dependsOn(Arrays.asList(compilerArray));
        this.registerInJob(compilerArray[0]);
    }

    protected abstract boolean isUpToDate();

    public abstract Class compilerGroupClass();

    public Object compilerGroupKey() {
        return this.compilerGroupClass();
    }

    public final void dependsOn(Compilable compilable) {
        this.dependsOn(Collections.singleton(compilable));
    }

    public void dependsOn(final Collection collection) {
        Compilable.MUTEX.readAccess(new Runnable(){

            public void run() {
                Compiler compiler = Compiler.this;
                synchronized (compiler) {
                    if (Compiler.this.dependsOn == null) {
                        Compiler.this.dependsOn = new IdSet();
                    }
                    Compiler.this.dependsOn.addAll(collection);
                }
            }
        });
    }

    public final Collection compilers() {
        return Collections.singleton(this);
    }

    public final Collection dependsOn() {
        return this.dependsOn == null ? Collections.EMPTY_LIST : this.dependsOn;
    }

    final void registerInJob(CompilerJob compilerJob) {
        jobTable.put(this, new WeakReference<CompilerJob>(compilerJob));
    }

    final void registerInJob(Compiler compiler) {
        CompilerJob compilerJob;
        Reference reference = (Reference)jobTable.get(compiler);
        CompilerJob compilerJob2 = compilerJob = reference == null ? null : (CompilerJob)reference.get();
        if (compilerJob == null) {
            throw new IllegalStateException("Argument Compiler is not in any job");
        }
        jobTable.put(this, reference);
        compilerJob.add(this);
    }

    public static final class Depth {
        Depth() {
        }

        public boolean isLastDepth() {
            return this == DEPTH_ZERO;
        }

        public Depth nextDepth() {
            if (this == DEPTH_INFINITE) {
                return this;
            }
            return DEPTH_ZERO;
        }
    }
}

