/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.enum.QueueEnumeration;

public interface UndoRedo {
    public static final UndoRedo NONE = new Empty();

    public boolean canUndo();

    public boolean canRedo();

    public void undo() throws CannotUndoException;

    public void redo() throws CannotRedoException;

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public String getUndoPresentationName();

    public String getRedoPresentationName();

    public static final class Empty
    implements UndoRedo {
        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        public void undo() throws CannotUndoException {
            throw new CannotUndoException();
        }

        public void redo() throws CannotRedoException {
            throw new CannotRedoException();
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public String getUndoPresentationName() {
            return "";
        }

        public String getRedoPresentationName() {
            return "";
        }
    }

    public static class Manager
    extends UndoManager
    implements UndoRedo {
        private EventListenerList list;
        private QueueEnumeration runus = new QueueEnumeration();
        private Task task = Task.EMPTY;
        private static RequestProcessor internalRequestProcessor = new RequestProcessor();
        static final long serialVersionUID = 6721367974521509720L;
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        private void superUndoableEditHappened(UndoableEditEvent undoableEditEvent) {
            super.undoableEditHappened(undoableEditEvent);
        }

        private void superDiscardAllEdits() {
            super.discardAllEdits();
        }

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            this.runus.put(undoableEditEvent);
            this.updateTask();
        }

        public void discardAllEdits() {
            this.runus.put((Object)null);
            this.updateTask();
        }

        public boolean canUndo() {
            if (this.runus.hasMoreElements()) {
                this.task.waitFinished();
            }
            return super.canUndo();
        }

        private void fireChange() {
            if (this.list == null) {
                return;
            }
            Object[] objectArray = this.list.getListenerList();
            if (objectArray.length == 0) {
                return;
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            int n = objectArray.length - 1;
            while (n >= 0) {
                ((ChangeListener)objectArray[n]).stateChanged(changeEvent);
                n -= 2;
            }
        }

        private void updateTask() {
            this.task = internalRequestProcessor.post(new Runnable(this){
                private final /* synthetic */ Manager this$0;
                {
                    this.this$0 = manager;
                }

                public void run() {
                    while (Manager.access$000(this.this$0).hasMoreElements()) {
                        UndoableEditEvent undoableEditEvent = (UndoableEditEvent)Manager.access$000(this.this$0).nextElement();
                        if (undoableEditEvent == null) {
                            Manager.access$100(this.this$0);
                        } else {
                            Manager.access$200(this.this$0, undoableEditEvent);
                        }
                        Manager.access$300(this.this$0);
                    }
                }
            }, 0, 10);
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            if (this.list == null) {
                this.list = new EventListenerList();
            }
            this.list.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Manager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            if (this.list != null) {
                this.list.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Manager.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
            }
        }

        public String getUndoPresentationName() {
            return this.canUndo() ? super.getUndoPresentationName() : "";
        }

        public String getRedoPresentationName() {
            return this.canRedo() ? super.getRedoPresentationName() : "";
        }

        static /* synthetic */ QueueEnumeration access$000(Manager manager) {
            return manager.runus;
        }

        static /* synthetic */ void access$100(Manager manager) {
            manager.superDiscardAllEdits();
        }

        static /* synthetic */ void access$200(Manager manager, UndoableEditEvent undoableEditEvent) {
            manager.superUndoableEditHappened(undoableEditEvent);
        }

        static /* synthetic */ void access$300(Manager manager) {
            manager.fireChange();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

