/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.beans.PropertyChangeEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.awt.AWTTask;
import org.openide.awt.Actions;
import org.openide.awt.ExecBridge;
import org.openide.awt.JMenuPlus;
import org.openide.cookies.InstanceCookie;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderInstance;
import org.openide.loaders.InstanceSupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Task;
import org.openide.util.WeakListener;
import org.openide.util.actions.Presenter;

public class MenuBar
extends JMenuBar
implements Externalizable {
    private MenuBarFolder menuBarFolder;
    static final long serialVersionUID = -4721949937356581268L;

    public MenuBar() {
    }

    public MenuBar(DataFolder dataFolder) {
        this.startLoading(dataFolder == null ? TopManager.getDefault().getPlaces().folders().menus() : dataFolder);
        if (dataFolder != null) {
            this.getAccessibleContext().setAccessibleDescription(dataFolder.getName());
        }
    }

    public void waitFinished() {
        this.menuBarFolder.instanceFinished();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.menuBarFolder.getFolder());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.startLoading((DataFolder)objectInput.readObject());
    }

    void startLoading(DataFolder dataFolder) {
        this.menuBarFolder = new MenuBarFolder(dataFolder);
    }

    static void allInstances(InstanceCookie[] instanceCookieArray, List list) {
        ErrorManager errorManager = TopManager.getDefault().getErrorManager();
        Exception exception = null;
        int n = 0;
        while (n < instanceCookieArray.length) {
            Exception exception2 = null;
            try {
                Object object = instanceCookieArray[n].instanceCreate();
                list.add(object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception2 = classNotFoundException;
            }
            catch (IOException iOException) {
                exception2 = iOException;
            }
            if (exception2 != null) {
                if (errorManager.findAnnotations(exception2) == null) {
                    errorManager.annotate(exception2, 1, null, null, null, null);
                }
                errorManager.copyAnnotation(exception2, exception);
                exception = exception2;
            }
            ++n;
        }
        if (exception != null) {
            errorManager.notify(exception);
        }
    }

    private static class LazyMenu
    extends JMenuPlus
    implements NodeListener {
        DataFolder master;
        boolean icon;
        MenuFolder slave;

        public LazyMenu(DataFolder dataFolder, boolean bl) {
            this.master = dataFolder;
            this.icon = bl;
            Node node = this.master.getNodeDelegate();
            node.addNodeListener(WeakListener.node(this, node));
            this.updateProps();
        }

        private void updateProps() {
            Node node = this.master.getNodeDelegate();
            Actions.setMenuText(this, node.getDisplayName(), true);
            if (this.icon) {
                this.setIcon(new ImageIcon(node.getIcon(1)));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("displayName".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName()) || "icon".equals(propertyChangeEvent.getPropertyName())) {
                this.updateProps();
            }
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public JPopupMenu getPopupMenu() {
            this.doInitialize();
            return super.getPopupMenu();
        }

        private void doInitialize() {
            if (this.slave == null) {
                this.slave = new MenuFolder();
                this.slave.waitFinished();
            }
        }

        private class MenuFolder
        extends FolderInstance {
            static /* synthetic */ Class class$org$openide$awt$MenuBar$LazyMenu;
            static /* synthetic */ Class class$javax$swing$JMenu;
            static /* synthetic */ Class class$org$openide$util$actions$Presenter$Menu;
            static /* synthetic */ Class class$javax$swing$JMenuItem;
            static /* synthetic */ Class class$javax$swing$JSeparator;
            static /* synthetic */ Class class$javax$swing$Action;

            public MenuFolder() {
                super(LazyMenu.this.master);
                this.recreate();
            }

            public String instanceName() {
                return (class$org$openide$awt$MenuBar$LazyMenu == null ? (class$org$openide$awt$MenuBar$LazyMenu = MenuFolder.class$("org.openide.awt.MenuBar$LazyMenu")) : class$org$openide$awt$MenuBar$LazyMenu).getName();
            }

            public Class instanceClass() {
                return class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = MenuFolder.class$("javax.swing.JMenu")) : class$javax$swing$JMenu;
            }

            protected InstanceCookie acceptDataObject(DataObject dataObject) {
                InstanceCookie instanceCookie = super.acceptDataObject(dataObject);
                if (instanceCookie == null) {
                    JMenuItem jMenuItem = ExecBridge.createMenuItem(dataObject);
                    return jMenuItem != null ? new InstanceSupport.Instance(jMenuItem) : null;
                }
                return instanceCookie;
            }

            protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
                Class clazz;
                InstanceCookie.Of of;
                boolean bl = instanceCookie instanceof InstanceCookie.Of ? (of = (InstanceCookie.Of)instanceCookie).instanceOf(class$org$openide$util$actions$Presenter$Menu == null ? (class$org$openide$util$actions$Presenter$Menu = MenuFolder.class$("org.openide.util.actions.Presenter$Menu")) : class$org$openide$util$actions$Presenter$Menu) || of.instanceOf(class$javax$swing$JMenuItem == null ? (class$javax$swing$JMenuItem = MenuFolder.class$("javax.swing.JMenuItem")) : class$javax$swing$JMenuItem) || of.instanceOf(class$javax$swing$JSeparator == null ? (class$javax$swing$JSeparator = MenuFolder.class$("javax.swing.JSeparator")) : class$javax$swing$JSeparator) || of.instanceOf(class$javax$swing$Action == null ? (class$javax$swing$Action = MenuFolder.class$("javax.swing.Action")) : class$javax$swing$Action) : (class$org$openide$util$actions$Presenter$Menu == null ? (class$org$openide$util$actions$Presenter$Menu = MenuFolder.class$("org.openide.util.actions.Presenter$Menu")) : class$org$openide$util$actions$Presenter$Menu).isAssignableFrom(clazz = instanceCookie.instanceClass()) || (class$javax$swing$JMenuItem == null ? (class$javax$swing$JMenuItem = MenuFolder.class$("javax.swing.JMenuItem")) : class$javax$swing$JMenuItem).isAssignableFrom(clazz) || (class$javax$swing$JSeparator == null ? (class$javax$swing$JSeparator = MenuFolder.class$("javax.swing.JSeparator")) : class$javax$swing$JSeparator).isAssignableFrom(clazz) || (class$javax$swing$Action == null ? (class$javax$swing$Action = MenuFolder.class$("javax.swing.Action")) : class$javax$swing$Action).isAssignableFrom(clazz);
                return bl ? instanceCookie : null;
            }

            protected InstanceCookie acceptFolder(DataFolder dataFolder) {
                return new InstanceSupport.Instance(new LazyMenu(dataFolder, true));
            }

            protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
                LazyMenu lazyMenu = LazyMenu.this;
                LinkedList linkedList = new LinkedList();
                MenuBar.allInstances(instanceCookieArray, linkedList);
                lazyMenu.removeAll();
                if (linkedList.isEmpty()) {
                    JMenuItem jMenuItem = new JMenuItem("Empty");
                    jMenuItem.setEnabled(false);
                    lazyMenu.add(jMenuItem);
                }
                boolean bl = false;
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (object instanceof Presenter.Menu) {
                        object = ((Presenter.Menu)object).getMenuPresenter();
                    }
                    if (object instanceof JMenuItem) {
                        if (bl) {
                            lazyMenu.addSeparator();
                            bl = false;
                        }
                        lazyMenu.add((JMenuItem)object);
                        continue;
                    }
                    if (object instanceof JSeparator) {
                        bl = LazyMenu.this.getMenuComponentCount() > 0;
                        continue;
                    }
                    if (!(object instanceof Action)) continue;
                    Action action = (Action)object;
                    JMenuItem jMenuItem = new JMenuItem();
                    Actions.connect(jMenuItem, action, false);
                    lazyMenu.add(jMenuItem);
                }
                return lazyMenu;
            }

            protected Task postCreationTask(Runnable runnable) {
                return new AWTTask(runnable);
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }
    }

    private final class MenuBarFolder
    extends FolderInstance {
        static /* synthetic */ Class class$org$openide$awt$MenuBar;
        static /* synthetic */ Class class$javax$swing$JMenu;

        public MenuBarFolder(DataFolder dataFolder) {
            super(dataFolder);
            this.recreate();
        }

        public String instanceName() {
            return (class$org$openide$awt$MenuBar == null ? (class$org$openide$awt$MenuBar = MenuBarFolder.class$("org.openide.awt.MenuBar")) : class$org$openide$awt$MenuBar).getName();
        }

        public Class instanceClass() {
            return class$org$openide$awt$MenuBar == null ? (class$org$openide$awt$MenuBar = MenuBarFolder.class$("org.openide.awt.MenuBar")) : class$org$openide$awt$MenuBar;
        }

        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            return (class$javax$swing$JMenu == null ? (class$javax$swing$JMenu = MenuBarFolder.class$("javax.swing.JMenu")) : class$javax$swing$JMenu).isAssignableFrom(instanceCookie.instanceClass()) ? instanceCookie : null;
        }

        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            return new InstanceSupport.Instance(new LazyMenu(dataFolder, false));
        }

        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            LinkedList linkedList = new LinkedList();
            MenuBar.allInstances(instanceCookieArray, linkedList);
            MenuBar menuBar = MenuBar.this;
            menuBar.removeAll();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof JMenu)) continue;
                menuBar.add((JMenu)e);
            }
            menuBar.validate();
            menuBar.repaint();
            return menuBar;
        }

        DataFolder getFolder() {
            return this.folder;
        }

        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

