/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class JPopupMenuUtils {
    private static Rectangle screenRect;
    private static boolean problemTested;
    private static boolean problem;
    private static RequestProcessor reqProc;
    private static RequestProcessor.Task task;

    public static void dynamicChange(JPopupMenu jPopupMenu, boolean bl) {
        if (!jPopupMenu.isShowing()) {
            return;
        }
        if (JPopupMenuUtils.isProblemConfig()) {
            JPopupMenuUtils.callRefreshLater(jPopupMenu);
            return;
        }
        JPopupMenuUtils.refreshPopup(jPopupMenu);
        Point point = jPopupMenu.getLocationOnScreen();
        Point point2 = JPopupMenuUtils.getPopupMenuOrigin(jPopupMenu, point);
        boolean bl2 = JPopupMenuUtils.willPopupBeContained(jPopupMenu, point2);
        if (bl != bl2) {
            jPopupMenu.setVisible(false);
        }
        if (!point2.equals(point)) {
            jPopupMenu.setLocation(point2.x, point2.y);
        }
        if (bl != bl2) {
            jPopupMenu.setVisible(true);
        }
    }

    private static void refreshPopup(JPopupMenu jPopupMenu) {
        jPopupMenu.pack();
        jPopupMenu.invalidate();
        Container container = jPopupMenu.getParent();
        if (container != null) {
            ((Component)container).validate();
        }
    }

    private static void callRefreshLater(final JPopupMenu jPopupMenu) {
        if (reqProc == null) {
            reqProc = new RequestProcessor();
        }
        if (task == null) {
            task = reqProc.create(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            JPopupMenuUtils.access$002(null);
                            if (!1.access$100(this.this$0).isShowing()) {
                                return;
                            }
                            Point point = 1.access$100(this.this$0).getLocationOnScreen();
                            Point point2 = JPopupMenuUtils.getPopupMenuOrigin(1.access$100(this.this$0), point);
                            1.access$100(this.this$0).setVisible(false);
                            JPopupMenuUtils.access$200(1.access$100(this.this$0));
                            if (!point2.equals(point)) {
                                1.access$100(this.this$0).setLocation(point2.x, point2.y);
                            }
                            1.access$100(this.this$0).setVisible(true);
                        }
                    });
                }

                static /* synthetic */ JPopupMenu access$100(1 var0) {
                    return var0.jPopupMenu;
                }
            });
        }
        task.schedule(100);
    }

    private static boolean isProblemConfig() {
        if (problemTested) {
            return problem;
        }
        problem = false;
        String string = System.getProperty("netbeans.popup.linuxhack");
        if (string != null) {
            problem = true;
        }
        return problem;
    }

    public static void dynamicChangeToSubmenu(JPopupMenu jPopupMenu, boolean bl) {
        Component component = jPopupMenu.getInvoker();
        if (!(component instanceof JMenu)) {
            return;
        }
        JMenu jMenu = (JMenu)component;
        if (!jPopupMenu.isShowing()) {
            return;
        }
        if (JPopupMenuUtils.isProblemConfig()) {
            JPopupMenuUtils.callRefreshLater2(jPopupMenu, jMenu);
            return;
        }
        JPopupMenuUtils.refreshPopup(jPopupMenu);
        Point point = jPopupMenu.getLocationOnScreen();
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = new Rectangle(point, dimension);
        Rectangle rectangle2 = JPopupMenuUtils.getScreenRect();
        boolean bl2 = JPopupMenuUtils.isPopupContained(jPopupMenu);
        if (!rectangle2.contains(rectangle)) {
            jMenu.setPopupMenuVisible(false);
            jMenu.setPopupMenuVisible(true);
        } else if (bl != bl2) {
            jPopupMenu.setVisible(false);
            jPopupMenu.setVisible(true);
        }
    }

    private static void callRefreshLater2(final JPopupMenu jPopupMenu, final JMenu jMenu) {
        if (reqProc == null) {
            reqProc = new RequestProcessor();
        }
        if (task == null) {
            task = reqProc.create(new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ 3 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public void run() {
                            JPopupMenuUtils.access$002(null);
                            if (!3.access$300(this.this$0).isShowing()) {
                                return;
                            }
                            3.access$300(this.this$0).setVisible(false);
                            JPopupMenuUtils.access$200(3.access$300(this.this$0));
                            3.access$300(this.this$0).setVisible(true);
                            Point point = 3.access$300(this.this$0).getLocationOnScreen();
                            Dimension dimension = 3.access$300(this.this$0).getPreferredSize();
                            Rectangle rectangle = new Rectangle(point, dimension);
                            Rectangle rectangle2 = JPopupMenuUtils.getScreenRect();
                            if (!rectangle2.contains(rectangle)) {
                                3.access$400(this.this$0).setPopupMenuVisible(false);
                                3.access$400(this.this$0).setPopupMenuVisible(true);
                            }
                        }
                    });
                }

                static /* synthetic */ JPopupMenu access$300(3 var0) {
                    return var0.jPopupMenu;
                }

                static /* synthetic */ JMenu access$400(3 var0) {
                    return var0.jMenu;
                }
            });
        }
        task.schedule(100);
    }

    static Point getPopupMenuOrigin(JPopupMenu jPopupMenu, Point point) {
        Point point2 = new Point(point);
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = JPopupMenuUtils.getScreenRect();
        int n = point2.x + dimension.width;
        int n2 = point2.y + dimension.height;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        if (n > n3) {
            point2.x = n3 - dimension.width;
        }
        if (point2.x < rectangle.x) {
            point2.x = rectangle.x;
        }
        if (n2 > n4) {
            point2.y = n4 - dimension.height;
        }
        if (point2.y < rectangle.y) {
            point2.y = rectangle.y;
        }
        return point2;
    }

    public static boolean isPopupContained(JPopupMenu jPopupMenu) {
        if (!jPopupMenu.isShowing()) {
            return false;
        }
        return JPopupMenuUtils.willPopupBeContained(jPopupMenu, jPopupMenu.getLocationOnScreen());
    }

    private static boolean willPopupBeContained(JPopupMenu jPopupMenu, Point point) {
        if (!jPopupMenu.isShowing()) {
            return false;
        }
        Window window = SwingUtilities.windowForComponent(jPopupMenu.getInvoker());
        Rectangle rectangle = new Rectangle(point, jPopupMenu.getSize());
        return window != null && window.getBounds().contains(rectangle);
    }

    public static Rectangle getScreenRect() {
        if (screenRect != null) {
            return screenRect;
        }
        screenRect = JPopupMenuUtils.getRectFromProperty();
        if (screenRect != null) {
            return screenRect;
        }
        Dimension dimension = Utilities.getScreenSize();
        screenRect = new Rectangle(0, 0, dimension.width, dimension.height);
        return screenRect;
    }

    private static Rectangle getRectFromProperty() {
        String string = System.getProperty("netbeans.screen.rect");
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        if (stringTokenizer.countTokens() != 4) {
            return null;
        }
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            return new Rectangle(n, n2, n3, n4);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static /* synthetic */ RequestProcessor.Task access$002(RequestProcessor.Task task) {
        JPopupMenuUtils.task = task;
        return JPopupMenuUtils.task;
    }

    static /* synthetic */ void access$200(JPopupMenu jPopupMenu) {
        JPopupMenuUtils.refreshPopup(jPopupMenu);
    }

    static {
        problemTested = false;
        problem = false;
    }
}

