/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.UserCancelException;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

public final class PasteAction
extends CallableSystemAction {
    static final long serialVersionUID = -6620328110138256516L;
    private static ActSubMenuModel model = new ActSubMenuModel();
    private static PasteType[] types;
    private static PasteType type;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$java$awt$datatransfer$Clipboard;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
    }

    public String getName() {
        return ActionConstants.BUNDLE.getString("Paste");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = PasteAction.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
    }

    protected String iconResource() {
        return "/org/openide/resources/actions/paste.gif";
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.SubMenu(this, model, false);
    }

    public JMenuItem getPopupPresenter() {
        return new Actions.SubMenu(this, model, true);
    }

    public void performAction() {
        PasteType pasteType = type;
        if (pasteType == null) {
            return;
        }
        try {
            Transferable transferable = pasteType.paste();
            Clipboard clipboard = PasteAction.getClipboard();
            if (transferable != null) {
                ClipboardOwner clipboardOwner = transferable instanceof ClipboardOwner ? (ClipboardOwner)((Object)transferable) : new StringSelection("");
                clipboard.setContents(transferable, clipboardOwner);
            }
        }
        catch (UserCancelException userCancelException) {
        }
        catch (IOException iOException) {
            TopManager.getDefault().notifyException(iOException);
        }
    }

    public void setPasteTypes(PasteType[] pasteTypeArray) {
        types = pasteTypeArray;
        if (pasteTypeArray == null || pasteTypeArray.length == 0) {
            this.setEnabled(false);
            type = null;
        } else {
            this.setEnabled(true);
            type = pasteTypeArray[0];
        }
        model.fireStateChanged();
    }

    public PasteType[] getPasteTypes() {
        return types;
    }

    int getPasteTypesCount() {
        return types == null ? 0 : types.length;
    }

    void setPasteTypeIndex(int n) {
        if (types == null) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= types.length) {
            n = types.length - 1;
        }
        type = types[n];
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(class$java$awt$datatransfer$Clipboard == null ? (class$java$awt$datatransfer$Clipboard = PasteAction.class$("java.awt.datatransfer.Clipboard")) : class$java$awt$datatransfer$Clipboard);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    static void invokeAction(SystemAction systemAction, ActionEvent actionEvent) {
        Object object;
        Exception exception = null;
        try {
            object = Class.forName("org.openide.actions.ActionManager");
            Object object2 = Lookup.getDefault().lookup((Class)object);
            if (object2 != null) {
                Method method = ((Class)object).getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = PasteAction.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = PasteAction.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                method.invoke(object2, systemAction, actionEvent);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (LinkageError linkageError) {
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        if (exception != null) {
            object = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = PasteAction.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (object != null) {
                ((ErrorManager)object).notify(1, exception);
            } else {
                exception.printStackTrace();
            }
        }
        systemAction.actionPerformed(actionEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ActSubMenuModel
    extends EventListenerList
    implements Actions.SubMenuModel {
        static /* synthetic */ Class class$org$openide$actions$PasteAction;
        static /* synthetic */ Class class$javax$swing$event$ChangeListener;

        private ActSubMenuModel() {
        }

        public int getCount() {
            PasteAction pasteAction = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            return pasteAction == null ? 0 : pasteAction.getPasteTypesCount();
        }

        public String getLabel(int n) {
            PasteAction pasteAction = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            if (pasteAction == null) {
                return null;
            }
            PasteType[] pasteTypeArray = pasteAction.getPasteTypes();
            return pasteTypeArray == null ? null : pasteTypeArray[n].getName();
        }

        public HelpCtx getHelpCtx(int n) {
            PasteAction pasteAction = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            if (pasteAction == null) {
                return null;
            }
            PasteType[] pasteTypeArray = pasteAction.getPasteTypes();
            return pasteTypeArray == null ? null : pasteTypeArray[n].getHelpCtx();
        }

        public MenuShortcut getMenuShortcut(int n) {
            return null;
        }

        public void performActionAt(int n) {
            PasteAction pasteAction = (PasteAction)SharedClassObject.findObject(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ActSubMenuModel.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction);
            if (pasteAction != null) {
                pasteAction.setPasteTypeIndex(n);
                PasteAction.invokeAction(pasteAction, new ActionEvent(this, 1001, "Name"));
            }
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ActSubMenuModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ActSubMenuModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
        }

        protected void fireStateChanged() {
            Object[] objectArray = this.getListenerList();
            if (objectArray.length == 0) {
                return;
            }
            ChangeEvent changeEvent = new ChangeEvent(this);
            int n = objectArray.length - 1;
            while (n >= 0) {
                ((ChangeListener)objectArray[n]).stateChanged(changeEvent);
                n -= 2;
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

