/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JMenuItem;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.awt.Actions;
import org.openide.explorer.view.MenuView;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.WeakListener;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class NewTemplateAction
extends NodeAction {
    static final long serialVersionUID = 5408651725508985475L;
    private static Reference where = new WeakReference<Object>(null);
    private static TemplateWizard defaultWizard;
    private static TemplateWizard standardWizard;
    private static DataFolder targetFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction$Cookie;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;

    static TemplateWizard getWizard(Node node) {
        TemplateWizard templateWizard;
        Node[] nodeArray;
        if (node == null && (nodeArray = TopManager.getDefault().getWindowManager().getRegistry().getActivatedNodes()).length == 1) {
            node = nodeArray[0];
        }
        DataFolder dataFolder = node == null ? null : (targetFolder = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NewTemplateAction.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder));
        Node[] nodeArray2 = node == null ? null : (nodeArray = (Node[])node.getCookie(class$org$openide$actions$NewTemplateAction$Cookie == null ? (class$org$openide$actions$NewTemplateAction$Cookie = NewTemplateAction.class$("org.openide.actions.NewTemplateAction$Cookie")) : class$org$openide$actions$NewTemplateAction$Cookie));
        if (nodeArray != null && (templateWizard = nodeArray.getTemplateWizard()) != null) {
            return templateWizard;
        }
        if (defaultWizard == null) {
            defaultWizard = NewTemplateAction.getStandardWizard();
        }
        return defaultWizard;
    }

    static TemplateWizard getStandardWizard() {
        if (standardWizard == null) {
            standardWizard = new TemplateWizard();
        }
        return standardWizard;
    }

    protected void performAction(Node[] nodeArray) {
        try {
            Node node = nodeArray.length == 1 ? nodeArray[0] : null;
            TemplateWizard templateWizard = NewTemplateAction.getWizard(node);
            templateWizard.setTargetName(null);
            if (targetFolder != null && templateWizard == defaultWizard) {
                templateWizard.setTargetFolder(targetFolder);
            }
            templateWizard.instantiate();
        }
        catch (IOException iOException) {
            ErrorManager errorManager = TopManager.getDefault().getErrorManager();
            Throwable throwable = errorManager.annotate((Throwable)iOException, "Creating from template did not succeed.");
            errorManager.notify(1, throwable);
            String string = iOException.getMessage();
            if (string == null || string.equals("")) {
                string = ActionConstants.BUNDLE.getString("EXC_TemplateFailed");
            }
            TopManager.getDefault().notify(new NotifyDescriptor.Message(string, 0));
        }
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        Cookie cookie = (Cookie)nodeArray[0].getCookie(class$org$openide$actions$NewTemplateAction$Cookie == null ? (class$org$openide$actions$NewTemplateAction$Cookie = NewTemplateAction.class$("org.openide.actions.NewTemplateAction$Cookie")) : class$org$openide$actions$NewTemplateAction$Cookie);
        if (cookie != null) {
            return cookie.getTemplateWizard() != null;
        }
        DataFolder dataFolder = (DataFolder)nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NewTemplateAction.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        return dataFolder != null && !dataFolder.getPrimaryFile().isReadOnly();
    }

    public String getName() {
        return ActionConstants.BUNDLE.getString("NewTemplate");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = NewTemplateAction.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction);
    }

    protected String iconResource() {
        return "/org/openide/resources/actions/new.gif";
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.MenuItem(this, true){

            public void setEnabled(boolean bl) {
                super.setEnabled(true);
            }
        };
    }

    public Component getToolbarPresenter() {
        return new Actions.ToolbarButton(this){

            public void setEnabled(boolean bl) {
                super.setEnabled(true);
            }
        };
    }

    public JMenuItem getPopupPresenter() {
        MenuView.Menu menu = new MenuView.Menu(NewTemplateAction.getTemplateRoot(), new TemplateActionListener(), false);
        Actions.connect((JMenuItem)menu, this, true);
        return menu;
    }

    public static Node getTemplateRoot() {
        RootChildren rootChildren = new RootChildren();
        return new AbstractNode(rootChildren);
    }

    private static boolean acceptObj(DataObject dataObject) {
        if (dataObject.isTemplate()) {
            return true;
        }
        if (dataObject instanceof DataFolder) {
            Object object = dataObject.getPrimaryFile().getAttribute("simple");
            return object == null || Boolean.TRUE.equals(object);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TemplateChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public TemplateChildren(Node node) {
            super(node);
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                if (dataObject.isTemplate()) {
                    return new Node[]{new FilterNode(node, Children.LEAF)};
                }
                if (NewTemplateAction.acceptObj(dataObject)) {
                    return new Node[]{new FilterNode(node, new TemplateChildren(node))};
                }
            }
            return new Node[0];
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class RootChildren
    extends Children.Keys
    implements NodeListener {
        private TemplateWizard wizard;
        private WeakReference current;
        private NodeListener listener = WeakListener.node(this, null);
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public RootChildren() {
            TopComponent.Registry registry = TopManager.getDefault().getWindowManager().getRegistry();
            registry.addPropertyChangeListener(WeakListener.propertyChange(this, registry));
            this.updateWizard(NewTemplateAction.getWizard(null));
        }

        protected Node[] createNodes(Object object) {
            Node node = (Node)object;
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = RootChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                if (dataObject.isTemplate()) {
                    return new Node[]{new FilterNode(node, Children.LEAF)};
                }
                if (NewTemplateAction.acceptObj(dataObject)) {
                    return new Node[]{new FilterNode(node, new TemplateChildren(node))};
                }
            }
            return null;
        }

        private void updateNode(Node node) {
            if (this.current != null && this.current.get() == node) {
                return;
            }
            if (this.current != null && this.current.get() != null) {
                ((Node)this.current.get()).removeNodeListener(this.listener);
            }
            node.addNodeListener(this.listener);
            this.current = new WeakReference<Node>(node);
        }

        private void updateWizard(TemplateWizard templateWizard) {
            Node node;
            if (this.wizard == templateWizard) {
                return;
            }
            if (this.wizard != null) {
                node = this.wizard.getTemplatesFolder().getNodeDelegate();
                node.removeNodeListener(this.listener);
            }
            node = templateWizard.getTemplatesFolder().getNodeDelegate();
            node.addNodeListener(this.listener);
            this.wizard = templateWizard;
            this.updateKeys();
        }

        private void updateKeys() {
            this.setKeys(this.wizard.getTemplatesFolder().getNodeDelegate().getChildren().getNodes());
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.updateKeys();
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray;
            String string = propertyChangeEvent.getPropertyName();
            if (this.current != null && propertyChangeEvent.getSource() == this.current.get()) {
                if ("cookie".equals(string)) {
                    this.updateWizard(NewTemplateAction.getWizard((Node)this.current.get()));
                }
            } else if ("activatedNodes".equals(string) && (nodeArray = TopManager.getDefault().getWindowManager().getRegistry().getActivatedNodes()).length == 1) {
                this.updateNode(nodeArray[0]);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private static class TemplateActionListener
    implements NodeAcceptor,
    DataFilter {
        static final long serialVersionUID = 1214995994333505784L;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        private TemplateActionListener() {
        }

        public boolean acceptNodes(Node[] nodeArray) {
            if (nodeArray == null || nodeArray.length != 1) {
                return false;
            }
            Node node = nodeArray[0];
            DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateActionListener.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject == null || !dataObject.isTemplate()) {
                return false;
            }
            TemplateWizard templateWizard = NewTemplateAction.getWizard(null);
            try {
                templateWizard.setTargetName(null);
                templateWizard.instantiate(dataObject, targetFolder);
            }
            catch (IOException iOException) {
                ErrorManager errorManager = TopManager.getDefault().getErrorManager();
                Throwable throwable = errorManager.annotate((Throwable)iOException, "Creating from template did not succeed.");
                errorManager.notify(1, throwable);
                String string = iOException.getMessage();
                if (string == null || string.equals("")) {
                    string = ActionConstants.BUNDLE.getString("EXC_TemplateFailed");
                }
                TopManager.getDefault().notify(new NotifyDescriptor.Message(string, 0));
            }
            return true;
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return NewTemplateAction.acceptObj(dataObject);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static interface Cookie
    extends Node.Cookie {
        public TemplateWizard getTemplateWizard();
    }
}

