/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.ErrorManager;
import org.openide.actions.ActionConstants;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;

public final class MoveUpAction
extends NodeAction {
    static final long serialVersionUID = -8201315242813084212L;
    private static final String PROP_ORDER_LISTENER = "sellistener";
    private Reference curIndexCookie;
    private static ErrorManager err = null;
    private static boolean errInited = false;
    static /* synthetic */ Class class$org$openide$ErrorManager;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$nodes$Index;

    private static final void initErr() {
        if (!errInited) {
            ErrorManager errorManager;
            errInited = true;
            ErrorManager errorManager2 = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = MoveUpAction.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
            if (errorManager2 != null && (errorManager = errorManager2.getInstance("org.openide.actions.MoveUpAction")).isLoggable(0)) {
                err = errorManager;
            }
        }
    }

    protected void initialize() {
        MoveUpAction.initErr();
        if (err != null) {
            err.log(0, "initialize");
        }
        super.initialize();
        OrderingListener orderingListener = new OrderingListener();
        this.putProperty(PROP_ORDER_LISTENER, orderingListener);
    }

    private Index getCurIndexCookie() {
        return this.curIndexCookie == null ? null : (Index)this.curIndexCookie.get();
    }

    protected void performAction(Node[] nodeArray) {
        Index index = this.getIndexCookie(nodeArray);
        if (index == null) {
            return;
        }
        int n = index.indexOf(nodeArray[0]);
        if (n > 0) {
            index.moveUp(n);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        Index index;
        MoveUpAction.initErr();
        if (err != null) {
            err.log(0, "enable; activatedNodes=" + (nodeArray == null ? null : Arrays.asList(nodeArray)));
        }
        if ((index = this.getCurIndexCookie()) != null) {
            index.removeChangeListener((ChangeListener)this.getProperty(PROP_ORDER_LISTENER));
        }
        Index index2 = this.getIndexCookie(nodeArray);
        if (err != null) {
            err.log(0, "enable; cookie=" + index2);
        }
        if (index2 == null) {
            return false;
        }
        index2.addChangeListener((OrderingListener)this.getProperty(PROP_ORDER_LISTENER));
        this.curIndexCookie = new WeakReference<Index>(index2);
        int n = index2.indexOf(nodeArray[0]);
        if (err != null) {
            err.log(0, "enable; index=" + n);
            if (n == -1) {
                Node node = nodeArray[0].getParentNode();
                err.log(0, "enable; parent=" + node + "; parent.children=" + Arrays.asList(node.getChildren().getNodes()));
            }
        }
        return n > 0;
    }

    public String getName() {
        return ActionConstants.BUNDLE.getString("MoveUp");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = MoveUpAction.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction);
    }

    private Index getIndexCookie(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0].getParentNode();
        if (node == null) {
            return null;
        }
        return (Index)node.getCookie(class$org$openide$nodes$Index == null ? (class$org$openide$nodes$Index = MoveUpAction.class$("org.openide.nodes.Index")) : class$org$openide$nodes$Index);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class OrderingListener
    implements ChangeListener {
        private OrderingListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MoveUpAction.initErr();
            Node[] nodeArray = MoveUpAction.this.getActivatedNodes();
            if (err != null) {
                err.log(0, "stateChanged; activatedNodes=" + (nodeArray == null ? null : Arrays.asList(nodeArray)));
            }
            Index index = MoveUpAction.this.getIndexCookie(nodeArray);
            if (err != null) {
                err.log(0, "stateChanged; cookie=" + index);
            }
            if (index == null) {
                MoveUpAction.this.setEnabled(false);
            } else {
                int n = index.indexOf(nodeArray[0]);
                if (err != null) {
                    err.log(0, "stateChanged; index=" + n);
                }
                MoveUpAction.this.setEnabled(n > 0);
            }
        }
    }
}

