/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.text.MessageFormat;
import java.util.Enumeration;
import org.openide.TopManager;
import org.openide.actions.ActionConstants;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.compiler.CompilerTask;
import org.openide.cookies.CompilerCookie;
import org.openide.loaders.CompilerSupport;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.actions.NodeAction;
import org.openide.util.enum.ArrayEnumeration;

public abstract class AbstractCompileAction
extends NodeAction {
    static final long serialVersionUID = 5089785814030008824L;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;

    protected void performAction(Node[] nodeArray) {
        this.compileNodes(nodeArray);
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return false;
        }
        Class clazz = this.cookie();
        Compiler.Depth depth = this.depth();
        int n = 0;
        while (n < nodeArray.length) {
            CompilerCookie compilerCookie = (CompilerCookie)nodeArray[n].getCookie(clazz);
            if (compilerCookie == null ? depth.isLastDepth() || nodeArray[n].getCookie(class$org$openide$loaders$DataObject$Container == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject$Container") : class$org$openide$loaders$DataObject$Container) == null : !compilerCookie.isDepthSupported(depth)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected abstract Compiler.Depth depth();

    protected abstract Class cookie();

    protected String message() {
        return ActionConstants.BUNDLE.getString("CTL_CompilationStarted");
    }

    void compileNodes(Node[] nodeArray) {
        boolean bl;
        DataObject[] dataObjectArray;
        CompilerJob compilerJob;
        TopManager.getDefault().setStatusText(this.message());
        try {
            compilerJob = new CompilerJob(this.depth());
            CompilerSupport.prepareJob(compilerJob, new ArrayEnumeration(nodeArray), this.cookie(), this.depth());
            dataObjectArray = new DataObject[nodeArray.length];
            bl = false;
            int n = 0;
            while (n < nodeArray.length) {
                dataObjectArray[n] = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? AbstractCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObjectArray[n] == null) {
                    bl = true;
                    break;
                }
                ++n;
            }
            Object var7_6 = null;
            TopManager.getDefault().setStatusText("");
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            TopManager.getDefault().setStatusText("");
            throw throwable;
        }
        compilerJob.setDisplayName(bl ? AbstractCompileAction.findName(nodeArray) : AbstractCompileAction.findName(dataObjectArray));
        compilerJob.start();
    }

    static String findName(Node[] nodeArray) {
        Object[] objectArray = new Object[]{new Integer(nodeArray.length), nodeArray.length > 0 ? nodeArray[0].getDisplayName() : ""};
        return MessageFormat.format(ActionConstants.BUNDLE.getString("FMT_Compile"), objectArray);
    }

    static String findName(DataObject[] dataObjectArray) {
        Object[] objectArray = new Object[]{new Integer(dataObjectArray.length), dataObjectArray.length > 0 && dataObjectArray[0].isValid() ? dataObjectArray[0].getNodeDelegate().getDisplayName() : ""};
        return MessageFormat.format(ActionConstants.BUNDLE.getString("FMT_Compile"), objectArray);
    }

    public static CompilerJob createJob(Enumeration enumeration, Compiler.Depth depth) {
        CompilerJob compilerJob = new CompilerJob(depth);
        CompilerSupport.prepareJob(compilerJob, enumeration, class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = AbstractCompileAction.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie, depth);
        return compilerJob;
    }

    public static boolean compile(Enumeration enumeration, String string) {
        CompilerJob compilerJob = AbstractCompileAction.createJob(enumeration, Compiler.DEPTH_ZERO);
        compilerJob.setDisplayName(string);
        if (!compilerJob.isUpToDate()) {
            CompilerTask compilerTask = compilerJob.start();
            return compilerTask.isSuccessful();
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

