/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.Settings;
import org.netbeans.modules.openfile.SettingsBeanInfo;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class Server
implements Runnable {
    private static final int LENGTH = 512;
    private static boolean stop;
    private static DatagramSocket socket;
    private static final Set waitings;
    static /* synthetic */ Class class$org$netbeans$modules$openfile$Server;

    static void startup() {
        stop = false;
        if (!Settings.getDefault().isActualRunning()) {
            new Thread((Runnable)new Server(), "OpenFile Server").start();
        }
    }

    public static void shutdown() {
        Server.shutDownWaitings();
        stop = true;
        if (Settings.getDefault().isActualRunning()) {
            try {
                int n = Settings.getDefault().getActualPort();
                if (n == 0) {
                    if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                        System.err.println("OpenFile: Port should not have been zero during shutdown!");
                    }
                    return;
                }
                DatagramPacket datagramPacket = new DatagramPacket(new byte[]{88}, 1, InetAddress.getLocalHost(), n);
                DatagramSocket datagramSocket = new DatagramSocket();
                try {
                    datagramSocket.send(datagramPacket);
                    Object var4_4 = null;
                    datagramSocket.close();
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    datagramSocket.close();
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static void initSocket() {
        if (socket != null) {
            socket.close();
        }
        int n = Settings.getDefault().getPort();
        try {
            socket = new DatagramSocket(n);
            Settings.getDefault().setActualPort0(n);
        }
        catch (SocketException socketException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_cannotBind", new Integer(n))));
            Settings.getDefault().setRunning(false);
            Settings.getDefault().setActualPort0(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Server.initSocket();
        DatagramPacket datagramPacket = new DatagramPacket(new byte[512], 512);
        Settings settings = Settings.getDefault();
        try {
            block23: {
                try {
                    block11: while (!stop && settings.isRunning()) {
                        Object object;
                        byte by;
                        boolean bl;
                        int n;
                        if (settings.getPort() != settings.getActualPort()) {
                            Server.initSocket();
                        }
                        if (!settings.isActualRunning()) {
                            settings.setActualRunning0(true);
                        }
                        datagramPacket.setLength(512);
                        socket.receive(datagramPacket);
                        if (settings.getAccess() == 0 && !datagramPacket.getAddress().equals(InetAddress.getLocalHost())) {
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_rejectHost", datagramPacket.getAddress())));
                            continue;
                        }
                        String string = new String(datagramPacket.getData(), datagramPacket.getOffset() + 1, datagramPacket.getLength() - 1);
                        int n2 = string.indexOf(64);
                        if (n2 == -1) {
                            n = -1;
                        } else {
                            try {
                                n = Integer.parseInt(string.substring(n2 + 1)) - 1;
                                string = string.substring(0, n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                TopManager.getDefault().notifyException((Throwable)numberFormatException);
                                n = -1;
                            }
                        }
                        switch ((char)datagramPacket.getData()[datagramPacket.getOffset()]) {
                            case 'Y': {
                                bl = true;
                                break;
                            }
                            case 'N': {
                                bl = false;
                                break;
                            }
                            case 'X': {
                                if (!stop) continue block11;
                                break block23;
                            }
                            default: {
                                Class clazz;
                                if (class$org$netbeans$modules$openfile$Server == null) {
                                    clazz = class$org$netbeans$modules$openfile$Server = Server.class$("org.netbeans.modules.openfile.Server");
                                    throw new IOException(NbBundle.getBundle((Class)clazz).getString("EXC_bad_lead_char"));
                                }
                                clazz = class$org$netbeans$modules$openfile$Server;
                                throw new IOException(NbBundle.getBundle((Class)clazz).getString("EXC_bad_lead_char"));
                            }
                        }
                        final File file = new File(string);
                        if (file.exists() && file.isFile()) {
                            by = 0;
                            object = datagramPacket.getAddress();
                            int n3 = datagramPacket.getPort();
                            int n4 = n;
                            new Thread(new Runnable((InetAddress)object, n3, n4){
                                private final /* synthetic */ InetAddress val$addr;
                                private final /* synthetic */ int val$port;
                                private final /* synthetic */ int val$_lineNumber;
                                {
                                    this.val$addr = inetAddress;
                                    this.val$port = n;
                                    this.val$_lineNumber = n2;
                                }

                                public void run() {
                                    OpenFile.open(file, bl, this.val$addr, this.val$port, this.val$_lineNumber);
                                }
                            }).start();
                        } else {
                            object = string;
                            new Thread(new Runnable((String)object){
                                private final /* synthetic */ String val$_fileName;
                                {
                                    this.val$_fileName = string;
                                }

                                public void run() {
                                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_fileNotFound", this.val$_fileName)));
                                }
                            }).start();
                            by = 1;
                        }
                        if (bl && by == 0) continue;
                        datagramPacket.getData()[0] = by;
                        datagramPacket.setLength(1);
                        socket.send(datagramPacket);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    settings.setActualRunning0(false);
                    settings.setRunning(false);
                    Object var13_15 = null;
                    if (socket != null) {
                        socket.close();
                    }
                    socket = null;
                    settings.setActualRunning0(false);
                    settings.setActualPort0(0);
                    return;
                }
            }
            Object var13_14 = null;
            if (socket != null) {
                socket.close();
            }
            socket = null;
            settings.setActualRunning0(false);
            settings.setActualPort0(0);
            return;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (socket != null) {
                socket.close();
            }
            socket = null;
            settings.setActualRunning0(false);
            settings.setActualPort0(0);
            throw throwable;
        }
    }

    static void waitFor(DataObject dataObject, InetAddress inetAddress, int n) {
        waitings.add(new Waiting(dataObject, inetAddress, n));
    }

    private static void shutDownWaitings() {
        Waiting[] waitingArray = waitings.toArray(new Waiting[waitings.size()]);
        int n = 0;
        while (n < waitingArray.length) {
            waitingArray[n].unWait((byte)2);
            ++n;
        }
        waitings.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        waitings = new HashSet();
    }

    private static class Waiting
    implements PropertyChangeListener,
    AncestorListener {
        private DataObject dataObject;
        private InetAddress address;
        private int port;
        private EditorCookie editorCookie;
        private JEditorPane observedPane;
        static /* synthetic */ Class class$org$openide$cookies$EditorCookie;
        static /* synthetic */ Class class$org$openide$windows$TopComponent;

        public Waiting(DataObject dataObject, InetAddress inetAddress, int n) {
            this.dataObject = dataObject;
            this.address = inetAddress;
            this.port = n;
            this.init();
        }

        private void init() {
            this.dataObject.addPropertyChangeListener((PropertyChangeListener)this);
            this.editorCookie = (EditorCookie)this.dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = Waiting.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
            if (this.editorCookie == null) {
                return;
            }
            JEditorPane[] jEditorPaneArray = this.editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
                return;
            }
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = Waiting.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent, jEditorPaneArray[0]);
            if (topComponent == null) {
                return;
            }
            topComponent.addAncestorListener(this);
        }

        private void clean() {
            this.dataObject.removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void unWait(byte by) {
            this.clean();
            waitings.remove(this);
            if (socket != null) {
                DatagramPacket datagramPacket = new DatagramPacket(new byte[]{by}, 1, this.address, this.port);
                try {
                    socket.send(datagramPacket);
                }
                catch (IOException iOException) {
                    TopManager.getDefault().notifyException((Throwable)iOException);
                }
            } else {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)SettingsBeanInfo.getString("MSG_serverNotRunningWhenSaved", this.dataObject.getName())));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.dataObject != propertyChangeEvent.getSource()) {
                return;
            }
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                if (!this.dataObject.isValid()) {
                    this.unWait((byte)1);
                }
            } else if ("modified".equals(propertyChangeEvent.getPropertyName()) && !this.dataObject.isModified()) {
                this.unWait((byte)0);
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            JEditorPane[] jEditorPaneArray = this.editorCookie.getOpenedPanes();
            if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
                this.unWait((byte)0);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

