/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projects.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.projects.content.HandlerDiffSet;
import org.netbeans.modules.projects.content.HandlerObjects;
import org.netbeans.modules.projects.content.XMLProjectContent;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Utilities;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class XMLSupport {
    public static final String EMPTY_STRING = "";
    public static final String FMT_XML_HEADER = "<?xml version=\"1.0\"?>";
    public static final String FMT_OBJECTS_START = "<{0} version=\"1.1\">";
    public static final String FMT_OBJECTS_END = "</{0}>";
    public static final String ELEMENT_CONTROL_PANEL = "control-panel";
    public static final String ELEMENT_MODULES = "modules";
    public static final String ELEMENT_LOADERS = "loaders";

    private XMLSupport() {
    }

    static String encodeToProperXML(String string) {
        if (string.indexOf(38) != -1) {
            string = Utilities.replaceString((String)string, (String)"&", (String)"&amp;");
        }
        if (string.indexOf(60) != -1) {
            string = Utilities.replaceString((String)string, (String)"<", (String)"&lt;");
        }
        if (string.indexOf(62) != -1) {
            string = Utilities.replaceString((String)string, (String)">", (String)"&gt;");
        }
        if (string.indexOf(39) != -1) {
            string = Utilities.replaceString((String)string, (String)"'", (String)"&apos;");
        }
        if (string.indexOf(34) != -1) {
            string = Utilities.replaceString((String)string, (String)"\"", (String)"&quot;");
        }
        if (string.indexOf(10) != -1) {
            string = Utilities.replaceString((String)string, (String)"\n", (String)"&#xa;");
        }
        if (string.indexOf(9) != -1) {
            string = Utilities.replaceString((String)string, (String)"\t", (String)"&#x9;");
        }
        return string;
    }

    static Object decodeValue(String string) throws Throwable {
        if (string == null || string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        char[] cArray2 = new char[4];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (',' == cArray[n3]) {
                byArray[n2++] = XMLSupport.parseByte(cArray2, n);
                n = 0;
            } else {
                cArray2[n++] = cArray[n3];
            }
            ++n3;
        }
        byArray[n2++] = XMLSupport.parseByte(cArray2, n);
        return XMLSupport.deserializeValue(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object deserializeValue(byte[] byArray) throws Throwable {
        Object object;
        if (byArray == null) {
            throw new NullPointerException();
        }
        ObjectInputStream objectInputStream = null;
        try {
            Object object2;
            objectInputStream = new NbObjectInputStream((InputStream)new ByteArrayInputStream(byArray, 0, byArray.length));
            object = object2 = objectInputStream.readObject();
            Object var5_4 = null;
            if (objectInputStream == null) return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (objectInputStream == null) throw throwable;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        return object;
    }

    static byte parseByte(char[] cArray, int n) throws NumberFormatException {
        int n2 = 0;
        boolean bl = false;
        if (cArray[0] == '-') {
            bl = true;
            ++n2;
        }
        int n3 = 0;
        while (n2 < n) {
            int n4 = cArray[n2] - 48;
            if (n4 < 0 || n4 > 9) {
                throw new NumberFormatException();
            }
            n3 *= 10;
            n3 += n4;
            ++n2;
        }
        if (bl) {
            n3 = -n3;
        }
        if (n3 < -128 || n3 > 127) {
            throw new NumberFormatException();
        }
        return (byte)n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] serializeValue(Object object) throws Throwable {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        NbObjectOutputStream nbObjectOutputStream = null;
        try {
            nbObjectOutputStream = new NbObjectOutputStream((OutputStream)byteArrayOutputStream);
            nbObjectOutputStream.writeObject(object);
            Object var4_3 = null;
            if (nbObjectOutputStream == null) return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (nbObjectOutputStream == null) throw throwable;
            nbObjectOutputStream.close();
            throw throwable;
        }
        nbObjectOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    static String encodeValue(Object object) throws Throwable {
        if (object == null) {
            return null;
        }
        byte[] byArray = XMLSupport.serializeValue(object);
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 4 + 2);
        int n = 0;
        while (n < byArray.length - 1) {
            stringBuffer.append(byArray[n]).append(',');
            ++n;
        }
        stringBuffer.append(byArray[byArray.length - 1]);
        return stringBuffer.toString();
    }

    public static String encodeStrings(List list) {
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append(XMLSupport.encodeToProperXML((String)iterator.next()));
        }
        return stringBuffer.toString();
    }

    public static List decodeStrings(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList;
    }

    public static void saveObjects(Writer writer, Map map, String string) {
        Object[] objectArray = new Object[]{string};
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println(FMT_XML_HEADER);
        printWriter.println(MessageFormat.format(FMT_OBJECTS_START, objectArray));
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)map.get(string2);
            if (string3 == null) continue;
            printWriter.print("  <object name=\"");
            printWriter.print(XMLSupport.encodeToProperXML(string2));
            printWriter.print("\" value=\"");
            printWriter.print(string3);
            printWriter.println("\"/>");
        }
        printWriter.println(MessageFormat.format(FMT_OBJECTS_END, objectArray));
        printWriter.flush();
    }

    public static Map loadObjects(Reader reader, Map map, String string) throws IOException, SAXException {
        Parser parser = XMLDataObject.createParser();
        HandlerObjects handlerObjects = new HandlerObjects(map, string);
        parser.setDocumentHandler(handlerObjects);
        parser.parse(new InputSource(reader));
        return map;
    }

    public static void loadDiffSet(Reader reader, XMLProjectContent.XMLDiffSet xMLDiffSet) throws IOException, SAXException {
        Parser parser = XMLDataObject.createParser();
        HandlerDiffSet handlerDiffSet = new HandlerDiffSet(xMLDiffSet);
        parser.setDocumentHandler(handlerDiffSet);
        parser.parse(new InputSource(reader));
    }

    public static void saveDiffSet(Writer writer, XMLProjectContent.XMLDiffSet xMLDiffSet) throws IOException {
        String string;
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println(FMT_XML_HEADER);
        printWriter.println("<diff-set clear=\"" + xMLDiffSet.isClear() + "\" version=\"" + "1.1" + "\">");
        Iterator iterator = xMLDiffSet.addedItems().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            printWriter.print("  <add name=\"");
            printWriter.print(XMLSupport.encodeToProperXML(string));
            printWriter.print("\" value=\"");
            printWriter.print(xMLDiffSet.addedRawItem(string));
            printWriter.println("\"/>");
        }
        iterator = xMLDiffSet.removedItems().iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            printWriter.print("  <remove name=\"");
            printWriter.print(XMLSupport.encodeToProperXML(string));
            printWriter.println("\"/>");
        }
        printWriter.println("</diff-set>");
    }

    public static boolean isNew(String string, String string2) throws NumberFormatException {
        if (string == null || string.length() < 1) {
            throw new NumberFormatException("Empty version string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".", true);
        while (stringTokenizer.hasMoreTokens() || stringTokenizer2.hasMoreTokens()) {
            int n;
            int n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
            if (n2 < (n = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 0)) {
                throw new IllegalArgumentException("Specified version is older than the projecVersion");
            }
            if (n2 > n) {
                return true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (!stringTokenizer2.hasMoreTokens()) continue;
            stringTokenizer2.nextToken();
        }
        return false;
    }
}

